package com.equo.middleware.provider;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

import com.equo.middleware.api.IMiddlewareService;
import com.equo.middleware.api.handler.IResponseHandler;
import com.equo.middleware.api.handler.ResourceHandler;

/**
 * Simple {@link IMiddlewareService} implementation that only stores the added
 * {@link ResourceHandler}s.
 */
@Component
public class MiddlewareServiceImpl implements IMiddlewareService {

  @Reference
  private MiddlewareCollectionManager middlewareCollectionManager;
  private boolean blockByDefault;

  @Override
  public void addResourceHandler(String schemeName, String domainName,
      IResponseHandler responseHandler) {
    ResourceHandler resourceHandler = new ResourceHandler(schemeName, domainName, responseHandler);
    middlewareCollectionManager.addResourceHandler(resourceHandler);
  }

  @Override
  public void removeResourceHandler(String schemeName, String domainName) {
    middlewareCollectionManager.removeResourceHandler(schemeName, domainName);
  }

  public boolean shouldBlockByDefault() {
    return blockByDefault;
  }

  @Override
  public void blockByDefault(boolean block) {
    blockByDefault = block;
  }

  @Override
  public void addAllowed(String... domains) {
    for (String domain : domains) {
      middlewareCollectionManager.addAllowedDomain(domain);
    }
  }

  @Override
  public void removeAllowed(String... domains) {
    for (String domain : domains) {
      middlewareCollectionManager.removeAllowedDomain(domain);
    }
  }

}
