package com.equo.middleware.provider;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.osgi.service.component.annotations.Component;

import com.equo.middleware.api.handler.ResourceHandler;

/**
 * Service that holds the actual references to the added resource handlers. It's
 * an implementation detail to avoid OSGi instantiation issues and static
 * structures.
 */
@Component(service = MiddlewareCollectionManager.class)
public class MiddlewareCollectionManager {

  private Map<String, ResourceHandler> resourceHandlers = new HashMap<String, ResourceHandler>();
  private List<String> allowedDomains = new ArrayList<>();

  public void addResourceHandler(ResourceHandler resourceHandler) {
    String key = resourceHandler.getSchemeName() + resourceHandler.getDomainName();
    this.resourceHandlers.put(key, resourceHandler);
  }

  public void removeResourceHandler(String schemeName, String domainName) {
    String key = schemeName + domainName;
    this.resourceHandlers.remove(key);
  }

  public Map<String, ResourceHandler> getResourceHandlers() {
    return resourceHandlers;
  }

  public void addAllowedDomain(String allowedDomain) {
    allowedDomains.add(allowedDomain);
  }

  public void removeAllowedDomain(String allowedDomain) {
    allowedDomains.remove(allowedDomain);
  }

  public List<String> getAllowedDomains() {
    return allowedDomains;
  }
}
