package com.equo.middleware.cef.provider.media;

import java.io.IOException;
import java.io.InputStream;
import java.net.FileNameMap;
import java.util.Properties;

/**
 * FileNameMap implementation containing some of the common content-types used
 * on the web.
 */
public class WebCommonsFileNameMap implements FileNameMap {

  private FileNameMap previous;
  private Properties contentTypesMap;

  public WebCommonsFileNameMap(FileNameMap previous) {
    this.previous = previous;
  }

  @Override
  public String getContentTypeFor(String fileName) {
    String contentType = null;
    if (previous != null) {
      contentType = previous.getContentTypeFor(fileName);
    }
    if (contentType == null) {
      if (contentTypesMap == null) {
        initializeContentTypesMap();
      }
      String ext = "";

      int i = fileName.lastIndexOf('#');

      if (i > 0) {
        fileName = fileName.substring(0, i - 1);
      }

      int lastDot = fileName.lastIndexOf('.');
      i = lastDot;
      i = Math.max(i, fileName.lastIndexOf('/'));
      i = Math.max(i, fileName.lastIndexOf('?'));

      if (i != -1) {
        if (fileName.charAt(i) == '.') {
          ext = fileName.substring(i).toLowerCase();
        } else if (fileName.charAt(i) == '?') {
          ext = fileName.substring(lastDot, i);
        }
      }

      contentType = contentTypesMap.getProperty(ext);
    }

    return contentType;
  }

  private void initializeContentTypesMap() {
    this.contentTypesMap = new Properties();

    try (InputStream is =
        getClass().getClassLoader().getResourceAsStream("content-types.properties")) {
      contentTypesMap.load(is);
    } catch (IOException e) {
      // Shouldn't be reachable, nothing to do here.
    }
  }
}
