package com.equo.middleware.cef.provider.handler;

import java.net.URLStreamHandler;

/**
 * Generic handler for the different OSGi and Eclipse protocols, should work for
 * most schemes handled by {@link URLStreamHandler}.
 */
public class PlatformSchemeResponseHandler extends DefaultSchemesResponseHandler {

  @Override
  protected String processUrl(String url) {
    if (url.indexOf("//") != -1) {
      url = url.replaceFirst("//", "/");
    }
    return url;
  }

}
