package com.equo.middleware.cef.provider.handler;

import static com.equo.middleware.api.handler.IResponseConstants.CONTENT_TYPE_HEADER;

import java.io.InputStream;
import java.net.URLConnection;
import java.util.Map;

import com.equo.chromium.swt.internal.spi.SchemeHandler;
import com.equo.middleware.api.handler.IResponseHandler;
import com.equo.middleware.api.resource.Request;

/**
 * SchemeHandler implementation that delegates to the given
 * {@link IResponseHandler}.
 */
@SuppressWarnings("restriction")
public class DelegatingSchemeHandler implements SchemeHandler {

  private IResponseHandler responseHandler;
  private Request request;

  public DelegatingSchemeHandler(IResponseHandler responseHandler) {
    this.responseHandler = responseHandler;
  }

  @Override
  public boolean processRequest(String url, String method, Map<String, String> requestHeaders) {
    request = Request.create(url, method, requestHeaders);
    return responseHandler.shouldProcessRequest(request);
  }

  @Override
  public InputStream getResponseData(Map<String, String> responseHeaders) {
    InputStream is = responseHandler.getResponseData(request, responseHeaders);
    if (responseHeaders.get(CONTENT_TYPE_HEADER) == null) {
      String contentType = URLConnection.guessContentTypeFromName(request.getUrl());
      if (contentType != null) {
        responseHeaders.put(CONTENT_TYPE_HEADER, contentType);
      }
    }
    return is;
  }

}
