package com.equo.middleware.cef.provider.handler;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLStreamHandler;
import java.util.Map;

import com.equo.middleware.api.handler.IResponseHandler;
import com.equo.middleware.api.resource.Request;

/**
 * Generic handler for the different OSGi and Eclipse protocols, should work for
 * most schemes handled by {@link URLStreamHandler}.
 */
public class DefaultSchemesResponseHandler implements IResponseHandler {

  protected String processUrl(String url) {
    return url;
  }

  @Override
  public InputStream getResponseData(Request request, Map<String, String> headers) {
    try {
      String urlString = processUrl(request.getUrl());
      URL url = new URL(urlString);
      return url.openStream();
    } catch (IOException e) {
      return null;
    }
  }

}
