# Script to launch the app, if not running, and call with a localhost url to navigate to a particular content
# Copyright ionesoft GmbH
# Version 1.1, 29.07.2015, Treating application url with spaces

param($appUrl)

# App specific definitions 
# appUrl is the launch string, also used with other platforms

$appFolder = Split-Path $MyInvocation.MyCommand.Path
$appPath = $appFolder + "/beook.exe";
$port = "7212";

# Script, do not change

# appUrl contains the application url scheme. It will be intercepted by the Activator from the command line

# Replace space in url
$appUrl = $appUrl.Replace(" ", "%20");

# localUrl contains localhost and port. It will be intercepted by the embedded http server
$localUrl = "http://localhost:" + $port + "/" + $appUrl;

# Arguments for launching the app, including the url to navigate. Does not have a http://localhost prefix, as it is handled from the command line
$spArgs = @{
   "FilePath" = "$appPath"
   "ArgumentList" = "$appUrl"
   "NoNewWindow" = $true
   "Wait" = $false
}

# Invoke the url on the app                              
function callUrl($url) {
    $request = [System.Net.HttpWebRequest]::Create($url);
    $response = $request.GetResponse();
    $reqstream = $response.GetResponseStream();
    $sr = new-object System.IO.StreamReader $reqstream;
    $result = $sr.ReadToEnd();
    Write-Host $result;
}

# Launch the app
function startApp() {
   Start-Process @spArgs 
}

# Try to invoke the targetUrl, on exception launch the app first
try {
   callUrl($localUrl);
} catch {
    # Write-host -ForegroundColor Red $_.Exception.Message
    Write-Host "App is not running, starting ...";
    startApp;
}