var currentAnswerText = null;
var currentQuestionReference = null;
var currentUrl = null;
var usageInfoDialogText;

// Event is sent by outer html to show the question and answer. Has to use events due to security restrictions with iFrames loading from different sources (localhost versus setText)
window.addEventListener('message', receiver, false);

$(window).ready(function() {
	$('#usage_info').on('click', function() {
		if (usageInfoDialogText != undefined) {
			alert(usageInfoDialogText);
		}
	});
	
	// add stylings for inlaying editor e.g. in annotation context (having noteContentDrawingText and nEditorLower element)
	if ($('.noteContentTypeDrawingText').size() > 0 && $('.nEditorLower').size() > 0) {
		
		setTimeout(function() {
			adaptHeightForAbsoluteEditorContent();
		}, 100);
		
		// also activate resize listener!
		$(window).resize(function() {
			adaptHeightForAbsoluteEditorContent();
		});
	}
})

function adaptHeightForAbsoluteEditorContent() {
	var height = $('.nEditorLower').height();
	$('#svg_editor').css({'position':'absolute', 'width':'100%', 'height':height});
}

function receiver(e) {
	 
	try {
		var s = e.data.split('#');
		
		var questionReference = s[0];
		var url = s[1];
		var answerText = "";
		for (var i = 2; i < s.length; i++) {
			answerText = answerText + s[i]
			if (i < s.length - 1) {
				answerText = answerText + '#';
			}
		}

		loadSvg(questionReference, answerText, url);			
	} catch (ex) {
//			alert(ex.message)
	}
}


// Return the content of the dom tree
function getContent(questionReference) {
	return svgEditor.canvas.getSvgString();
}

function setupEditor() {
	// Disable the svg standard button
	var mainButton = document.getElementById('main_button');
	mainButton.style.display = 'none';
}

function loadSvg(questionReference, answerText, url) {
	try {
		currentAnswerText = answerText
		currentQuestionReference = questionReference;
		currentUrl = url;
		//alert("loadSvg with: " + answerText)
		svgEditor.loadFromString(answerText);
		
//		svgCanvas.setSvgString(answerText);
		setBackgroundImage(questionReference, url);
        
		setTimeout(function() {
			svgEditor.canvas.zoomChanged('', 'canvas')
		}, 320); // trigger zoom only works when image is loaded, so wait a little bit

		// possibility to use dbl click on zoom if needed on any platform
//        if (svgEditor.canvas.getZoom() > 1) {
//        	// setZoom() does not work, instead trigger double click on zoom tool
//        	$('#tool_zoom').dblclick();
//        }
        $('#tool_fhpath').click(); // activate directly pencil
	} catch (e) {
		// ignore. Might be called when webView is not finished
	}
}

function setBackgroundImage(questionReference, url) {
	try {
		if (url != null || url != "") {
			svgEditor.canvas.setBackground('#FFF', url);
		}
	} catch (e) {
		// ignore. Might be called when webView is not finished
		// alert(e.message);
	}
}

function saveSvg() {
	try {
		currentAnswerText = svgEditor.canvas.getSvgString();

		// Replace % with %25, otherwise URLDecoder may not decode
		currentAnswerText = currentAnswerText.replace(/%/g, '%25');

		document.location = "http://localhost/saveExercise/" + currentQuestionReference + "/answer/" + currentAnswerText;
	} catch(e) {
		//alert(e.message)
	}
}


function setUsageInfoDialogText(text) {
	usageInfoDialogText = text;
}
