// Return the content of the dom tree
function getContent(questionReference) {
    var svg = svgCanvas.getSvgString();
    svg = removeBackgroundLayer(svg);
    svg = escapeAndReplaceSingleQuotesInSVG(svg);
	return svg;
}
        
function loadSvg(questionReference, answerText, url) {
    try {
        // empty answer text will get initialized by a white background, that covers the backgroundImage. Therefore initialize it here
        if (answerText == null || answerText == '') {
            answerText = '<svg width="800" height="600" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns="http://www.w3.org/2000/svg"><g><title>Layer 1</title></g></svg>';
        }
         
        svgCanvas.setSvgString(answerText);
	    setBackgroundImage(questionReference, url);
         
        setupEditor();
         
    } catch (ex) {
        return "ERROR: " + ex.message;
    }
}
 
function setBackgroundImage(questionReference, url) {
    try {
        if (url != "") {
            svgCanvas.setBackground('#FFF', url);
        }
    } catch (e) {
        // ignore. Might be called when webView is not finished
        //alert('setBackgroundImage: ' + e.message)
    }  
}

function setupEditor() {
    try {
         $("#canvas_panel").hide();
    } catch (e) {
        // alert('setupEditor: ' + e.message);
    }
}

       
function removeBackgroundLayer(svg) {
	var svgNode = $('' + svg + '');
    $(svgNode).find('#canvas_background').closest('g').remove();
   	// use temporary parent to get text of DOM Node
	// see: http://stackoverflow.com/questions/1750815/get-the-string-representation-of-a-dom-node
	var tmp = document.createElement("div"); 
	tmp.appendChild(svgNode[0]);
    return tmp.innerHTML;
}
       
// handle single quotes correctly
function escapeAndReplaceSingleQuotesInSVG(svg) {
	var regex = />.*?</g; // pattern matches all Texts between > < (so no attributes are touched)
    var matches = svg.match(regex);
    if (matches != null) {
    	for (var i = 0; i < matches.length; i++) {
        	var replaced = matches[i].replace(/'/g, "&apos;");
            svg = svg.replace(matches[i], replaced);
        }
    }
    svg = svg.replace(/'/g, '"'); // replace single quotes on attributes
    return svg;
}