var lc = null;
var backgroundImage = null;
var backgroundImageUrl = null;
var backgroundImageScale = null;
var backgroundDefaultColor = '#f6f5f6';
var defaultWhiteColor = '#fff';
var questionReference = null;
var strokeWidths = [2,5,10,30,50,100];
var ilpSelectedShapeObject;
var ilpSelectedShapeLc;

$(document).ready(function() {
	initILPListeners();
});

function initILPListeners() {
    $(document).on("selectShape:inactive", function() {
    	$('.ilp-delete-button').remove();
    });
    $(document).on("selectShape:onUp", function() {
    	if ($('.ilp-delete-button').size() > 0) {
    		return;
    	}
    	var button = getDeleteButton();
    	$(button).on('click', removeSelectedShape);
    	$('.horz-toolbar').append(button);
    });
}

/* Called when hitting the edit button above the frame */
function setupEditor(questionReference, language) {
    try {
        if (language === 'de') {
            LC.localize({"Enter text here":"Text eingeben", "Click and hold to place text." : "Position anklicken um Text einzufügen.", "Size: " : "Grösse:", "Clear" : "Löschen", "background" : "Hintergrund", "stroke" : "Linie", "fill" : "füllen", "italic" : "kursiv", "bold" : "fett" });
        } else if (language === 'fr') {
            LC.localize({"Enter text here":"Saisir le texte", "Click and hold to place text." : "Cliquez sur l'emplacement pour insérer le texte.", "Size: " : "taille:", "Clear" : "effacer", "background" : "fond", "stroke" : "ligne", "fill" : "remplir", "italic" : "italique", "bold" : "audacieux" });
        } else if (language === 'it') {
            LC.localize({"Enter text here":"Inserisci il testo", "Click and hold to place text." : "Clicca sul percorso per inserire il testo.", "Size: " : "dimensione:", "Clear" : "elimina", "background" : "sfondo", "stroke" : "linea", "fill" : "riempire", "italic" : "corsivo", "bold" : "audace" });
        }
        // no backgroundshape if no backgroundImage is set
        if (backgroundImage === null) {
            this.lc = LC.init(
                document.getElementsByClassName('ilp-literally')[0],
           		{
            		backgroundColor: backgroundDefaultColor,
                	imageURLPrefix: literallyBasicImageUrl,
                              tools: [LC.tools.Pencil,LC.tools.Line,LC.tools.Rectangle,LC.tools.Ellipse,LC.tools.Polygon,LC.tools.Text,LC.tools.Pan,LC.tools.SelectShape], // LC.tools.Eraser does not work in svg preview

    				strokeWidths: strokeWidths,
    				defaultStrokeWidth: 10        
                 }
            );
         } else {
            this.lc = LC.init(
                document.getElementsByClassName('ilp-literally')[0],
           		{
            		backgroundColor: backgroundDefaultColor,
                	imageURLPrefix: literallyBasicImageUrl,
                    tools: [LC.tools.Pencil,LC.tools.Line,LC.tools.Rectangle,LC.tools.Ellipse,LC.tools.Polygon,LC.tools.Text,LC.tools.Pan,LC.tools.SelectShape],
                    backgroundShapes: [
    					LC.createShape('Image', {image: backgroundImage, x: 0, y: 0})
    				],
    				strokeWidths: strokeWidths,
    				defaultStrokeWidth: 10        
                 }
             );
         } 
    } catch (ex) {                  
         // alert("Could not setupEditor: " + ex.message);
    }
    populateMarkerBar();
    adjustStrokeWidthIcons();
    improveUX();
}

// getting combined return: json for editing, svg for preview
function getContent(questionReference) {
    try {
    	assureTextElementsAreFixed();
    	var svg = getContentSVG();
    	var json = getContentJSON();
        var jsonComment = "<!-- lc=" + json + " lc --></svg>";
        var svgJson = svg.replace("</svg>", jsonComment);
        svgJson = setSizeAsImage(svgJson, backgroundImage); // newly set for image annotation
        svgJson = setViewBoxAsImage(svgJson, backgroundImage); // newly set for image annotation
        svgJson = removeBackgroundImages(svgJson);
        svgJson = removeBackgroundShapesJson(svgJson);
        svgJson = removeBackgroundRectangleSVG(svgJson);
        svgJson = resetTransformG(svgJson);
        return svgJson;
    } catch (ex) {
    	return "ERROR: " + ex.message;
    }
}

function getContentJSON() {
	var json;
	try {
		json = JSON.stringify(this.lc.getSnapshot());
	} catch(err) {
    	// array with permitted properties (whitelist), needed for Android <= 4.4. read documentation Entwickeln_LiterallyCanvas.docx
    	var properties = ["colors","primary","secondary","background","position","x","y","x1","x2","y1","y2","v","scale","shapes","className","data","width","height","strokeWidth","strokeColor","fillColor","id","backgroundShapes","imageSrc","scale","imageSize","tailSize","order","color","smooth","pointCoordinatePairs","smoothedPointCoordinatePairs","pointSize","pointColor","font","forcedHeight","forcedWidth","text","capStyle","dash","endCapShapes","isClosed"];
		json = JSON.stringify(this.lc.getSnapshot(), properties);	
	} finally {
    	json = escapeSingleQuotesInJSON(json);
    	return json;
    }	
}

function getContentSVG() {
		 var svg = LC.renderSnapshotToSVG(this.lc.getSnapshot());
		 svg = correctNegativeValuesInSVG(svg);
		 svg = escapeAndReplaceSingleQuotesInSVG(svg);
		 return svg;
}

// single quotes only appear in Text insert by user, 
// so a simple replace is enough for json
function escapeSingleQuotesInJSON(json) {
    var json = json.replace(/'/g, "&apos;");
	return json;
}

function unescapeSingleQuotesInJSON(json) {
	var json = json.replace(/&apos;/g, "'");
    	return json;
    }
   
    // all attributes are given in single quotes
// so need to replace first single quotes in text and after replace single quotes on attributes
function escapeAndReplaceSingleQuotesInSVG(svg) {
	var regex = />.*?</g; // pattern matches all Texts between > < (so no attributes are touched)
	var matches = svg.match(regex);
    if (matches != null) {
        for (var i = 0; i < matches.length; i++) {
            var replaced = matches[i].replace(/'/g, "&apos;");
            svg = svg.replace(matches[i], replaced);
        }
    }
	svg = svg.replace(/'/g, '"'); // replace single quotes on attributes
	return svg;
}

function unescapeNewLineCharactersForSketchpad(text) {
	return text.replace(/===!newline!===/g, '\\n');
}

function correctNegativeValuesInSVG(svg) {
	var svgNode = $('' + svg + '');
	$(svgNode).find('rect').each(function(i, ele) {
		ele = correctNegativeValuesFromRect($(ele));
	});
	$(svgNode).find('ellipse').each(function(i, ele) {
		ele = correctNegativeValuesFromEllipse($(ele));
	});

	// use temporary parent to get text of DOM Node
	// see: http://stackoverflow.com/questions/1750815/get-the-string-representation-of-a-dom-node
	var tmp = document.createElement("div"); 
	tmp.appendChild(svgNode[0]);
	return tmp.innerHTML;
}

function correctNegativeValuesFromRect(rect) {
	if ($(rect).attr('width') < 0) {
		var newWidth = $(rect).attr('width') * (-1);
		$(rect).attr('width', newWidth);
		var newX = $(rect).attr('x') - newWidth;
		$(rect).attr('x', newX);
	}
	if ($(rect).attr('height') < 0) {
		var newHeight = $(rect).attr('height') * (-1);
		$(rect).attr('height', newHeight);
		var newY = $(rect).attr('y') - newHeight;
		$(rect).attr('y', newY);
	}
	return rect;
}

function correctNegativeValuesFromEllipse(ellipse) {
	if ($(ellipse).attr('rx') < 0) {
		var newRX = $(ellipse).attr('rx') * (-1);
		$(ellipse).attr('rx', newRX);
	}
	if ($(ellipse).attr('ry') < 0) {
		var newRY = $(ellipse).attr('ry') * (-1);
		$(ellipse).attr('ry', newRY);
	}
	return ellipse;
}

function setSizeAsImage(svgJson, image) {
	if (image !== null) {
    	var imageWidth = image.naturalWidth;
    	var imageHeight = image.naturalHeight;
    	var regexWidth = /(<svg [\w\d=:\'\"\.\s\/]*width=[\"|\'])[\d\.]+([\"|\'])/g;
    	var regexHeight = /(<svg [\w\d=:\'\"\.\s\/]*height=[\"|\'])[\d\.]+([\"|\'])/g;
    	svgJson = svgJson.replace(regexWidth, '$1' + imageWidth + '$2');
    	svgJson = svgJson.replace(regexHeight, '$1' + imageHeight + '$2');
	}
	return svgJson;
}

function setViewBoxAsImage(svgJson, image) {
	if (image !== null) {
    	var imageWidth = image.naturalWidth;
    	var imageHeight = image.naturalHeight;
    	var viewBoxCoords = "0 0 " + imageWidth + " " + imageHeight;
    	var regexViewBox = /(<svg [\w\d=:\'\"\.\s\/]*viewBox=[\"|\'])[\d\.\s]+([\"|\'])/g;
    	svgJson = svgJson.replace(regexViewBox, '$1' + viewBoxCoords + '$2');
	}
	return svgJson;
}

function loadSketch(questionReference, answerText, url, scale) {
	answerText = unescapeNewLineCharactersForSketchpad(answerText);
	answerText = unescapeSingleQuotesInJSON(answerText);
    try {
        this.lc.loadSnapshot(JSON.parse(answerText));
        scaleCanvas(scale);
        this.lc.setColor('background', backgroundDefaultColor);
        centerPan(); // try at least, often too early, so default 0,30 is set
    } catch (ex) {
        return "ERROR: " + ex.message;
    }
}

function removeBackgroundImages(svgJson) {
	// <image .*localhost.*?(<\/image>|\/>) // match image tag in svg that has a localhost link
	svgJson = removeSVGImages(svgJson);
	return svgJson;
}

function removeSVGImages(svgJson) {
	var regex = /<image .*localhost.*?(<\/image>|\/>)/g;
	svgJson = svgJson.replace(regex, "");
	return svgJson;
}

function removeBackgroundShapesJson(svgJson) {
    // ,?\\["|']backgroundShapes\\["|']:\[.*localhost.*?] // match background shapes coming from localhost link, check with escaped and unescaped quotes
	var regex = /,?\\?[\"|\']backgroundShapes\\?[\"|\']:\[.*localhost.*?]/g;
	svgJson = svgJson.replace(regex, "");
	return svgJson;
}

function removeBackgroundRectangleSVG(svgJson) {
	svgJsonNode = $('' + svgJson + '');
	potentialBackgroundRect = $(svgJsonNode).find('rect').first();
	// test on position (0|0) and color (backgroundDefaultColor)
	if (isBackgroundRect(potentialBackgroundRect))  {
		var regex = /<rect .*?(\/>|<\/rect>)/; // not global g!
		svgJson = svgJson.replace(regex, "");
	}
	return svgJson;
}

function isBackgroundRect(rect) {
	if (rect == undefined) {
		return false;
	}
	if ($(rect).attr('x') == 0
		&& $(rect).attr('y') == 0
		&& ($(rect).attr('fill').toLowerCase().localeCompare(backgroundDefaultColor.toLowerCase()) == 0
			|| $(rect).attr('fill').toLowerCase().localeCompare(defaultWhiteColor.toLowerCase()) == 0)) {
		return true;
	} else {
		return false;
	}		
}

function resetTransformG(svgJson) {
	var regex = /(<g [.]*transform=[\"|\'].*translate\()[\d, ]+(\)[\w\d\s\(\)\.,;]*[\"|\'])/g;
	svgJson = svgJson.replace(regex, "$1 0,0 $2");
	return svgJson;
}

function setBackgroundImage(questionReference, url, scale) {
    try {
        if (url != "") {
            backgroundImage = new Image();
            backgroundImage.src = '';
            backgroundImage.src = url;
        }
        
        backgroundImageScale = parseFloat(scale);
        // scaleCanvas(scale);
    } catch (ex) {
        // alert("Could not load image: " + url + ". Reason: " + e.message);
        // ignore. Might be called when webView is not finished
    }
}

function scaleCanvas(scale) {
    this.lc.setZoom(scale);
}
                                    
function centerPan() {
     var x = 0;
     var y = 30;
     if (backgroundImage != undefined && backgroundImage.naturalWidth != 0) {
          x = ($(document).width() - (backgroundImage.naturalWidth * backgroundImageScale)) / 2 + 60;
          y = ($(document).height() - (backgroundImage.naturalHeight * backgroundImageScale)) / 2 + 40;
     }
     this.lc.setPan(x, y);
}

function assureTextElementsAreFixed() {
	// click on pencil to be sure, text elements are closed
	if ($( ".lc-pick-tool[title='Text']" ).hasClass("selected")) {
		$( ".lc-pick-tool[title='Text']" ).trigger("click");	
	}	
}

/**
 * Delete button with a predefined trash bin as svg.
 */
function getDeleteButton() {
	var button = $.parseHTML('<div class="square-toolbar-button ilp-delete-button"><svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 78 78"><title>delete</title><path d="M15.55,23.21C37.27,5.82,50,19.13,62.38,24.47a.21.21,0,0,1-.14.39C41.56,20.12,28,16,15.92,23.78,15.57,24,15.22,23.47,15.55,23.21Z" fill="#4f4f4f"/><path d="M61,28.53c-16.6-3.71-33.71-7.87-43.75-.89l5,41.45H56.08Z" fill="#4f4f4f"/><path d="M28.5,15.89c2.4-9.44,15.25-9.11,17.49.89l-4.21-1c-1.06-3.47-7.68-3.53-8.77-.27Z" fill="#4f4f4f"/><rect x="12.7" y="31.47" width="9.79" height="3.79" rx="1.4" ry="1.4" fill="#4f4f4f"/><rect x="56.04" y="31.47" width="9.79" height="3.79" rx="1.4" ry="1.4" fill="#4f4f4f"/></svg></div>');
	return button;
}

/**
 * Remove selected shape only when a shape was already selected and repaints main layer.
 * It does not really remove the shape but sets a hight/width of 0.
 */
function removeSelectedShape() {
	if (typeof ilpSelectedShapeObject == 'undefined' || typeof ilpSelectedShapeObject.selectedShape == 'undefined' || typeof ilpSelectedShapeLc == 'undefined') {
		return;
	}
	
	// on every object
	ilpSelectedShapeObject.selectedShape.height = 0;
	ilpSelectedShapeObject.selectedShape.width = 0;
	
	// it it is a linePath (pencil drawn line)
	if (ilpSelectedShapeObject.selectedShape.className == "LinePath") {
		ilpSelectedShapeObject.selectedShape.smoothedPoints = [];
		ilpSelectedShapeObject.selectedShape.tail = [];
	}
	
	// if it is a line
	if (ilpSelectedShapeObject.selectedShape.className == "Line") {
		ilpSelectedShapeObject.selectedShape.x1 = -100;
		ilpSelectedShapeObject.selectedShape.y1 = -100;
		ilpSelectedShapeObject.selectedShape.x2 = -100;
		ilpSelectedShapeObject.selectedShape.y2 = -100;
	}
	
	// if it is a polygon
	if (ilpSelectedShapeObject.selectedShape.className == "Polygon") {
		ilpSelectedShapeObject.selectedShape.points = [{"color":"hsla(0, 0%, 0%, 0)","id":"ilp","size":0,"x":0,"y":0}];
		ilpSelectedShapeObject.selectedShape.isClosed = false;
	}
	
	// it it is a text
	if (ilpSelectedShapeObject.selectedShape.className == "Text") {		
		ilpSelectedShapeObject.selectedShape.v = 0;
		ilpSelectedShapeObject.selectedShape.setText("");
	}
	
	ilpSelectedShapeLc.repaintLayer('main');
}

var updateSVG = function() {
	if (!lc) return;
	$('.svg-container')[0].innerHTML = lc.getSVGString();
}

// Called when switching away. Save the content of the open editor in the dom tree
function saveEditor(questionReference) {
    // Not needed
}

// Override these defaults to hide left and bottom Literally Canvas toolbars
function hideTools() {
    /*
     try {
     $('.lc-drawing').css({
     left:0px,
     bottom:0px
     });
     $('.lc-picker').css({
     z-index: -1
     });
     $('.lc-options').css({
     z-index:-2
     });
     } catch (ex) {
     alert("Could not hide tools: " + ex.message)
     }
     */
    
}


// Predefined Markers/Pencil trigger functions

var hslaRtransp = "hsla(349, 85%, 60%, 0.4)";
var hslaRopaque = "hsla(349, 85%, 60%, 1.0)";
var hslaGtransp = "hsla(121, 81%, 53%, 0.4)";
var hslaGopaque = "hsla(121, 81%, 53%, 1.0)";
var hslaBtransp = "hsla(215, 91%, 60%, 0.4)";
var hslaBopaque = "hsla(215, 91%, 60%, 1.0)";
var hslaYtransp = "hsla(59, 100%, 60%, 0.4)";
var hslaYopaque = "hsla(59, 100%, 60%, 1.0)";
var hslaEmpty = "hsla(0, 0%, 0%, 0.0)";
var hslaBlack = "hsla(0, 100%, 0%, 1.0)";

var strokeWidthThin = 5; // this values must exist in strokeWidth-Array in init()
var strokeWidthFat = 30; // this values must exist in strokeWidth-Array in init()

var markers = [{
	icon: "marker-r",
	primaryColor: hslaRtransp,
	secondaryColor: hslaRtransp,
	strokeWidth: strokeWidthFat
},{
   	icon: "marker-g",
	primaryColor: hslaGtransp,
	secondaryColor: hslaGtransp,
	strokeWidth: strokeWidthFat
},{
   	icon: "marker-b",
	primaryColor: hslaBtransp,
	secondaryColor: hslaBtransp,
	strokeWidth: strokeWidthFat
},{
   	icon: "marker-y",
	primaryColor: hslaYtransp,
	secondaryColor: hslaYtransp,
	strokeWidth: strokeWidthFat
},{
   	icon: "pencil-r",
	primaryColor: hslaRopaque,
	secondaryColor: hslaEmpty,
	strokeWidth: strokeWidthThin
},{
   	icon: "pencil-g",
	primaryColor: hslaGopaque,
	secondaryColor: hslaEmpty,
	strokeWidth: strokeWidthThin
},{
   	icon: "pencil-b",
	primaryColor: hslaBopaque,
	secondaryColor: hslaEmpty,
	strokeWidth: strokeWidthThin
},{
   	icon: "pencil-y",
	primaryColor: hslaYopaque,
	secondaryColor: hslaEmpty,
	strokeWidth: strokeWidthThin
}];

function activatePencilWithProperties(primaryColor, secondaryColor, strokeWidth) {
	$( ".lc-pick-tool[title='Pencil']" ).trigger( "click" ); // click on pencil
	lc.setColor('secondary', secondaryColor);
	lc.setColor('primary', primaryColor);
	var horzToolbar = $('.horz-toolbar').first();
	var dataReactId = $(horzToolbar).children('div').first().attr('data-reactid');
	setTimeout(function() {$('*[data-reactid="' + dataReactId + '.$' + strokeWidth + '"]').first().children().first().trigger('click');}, 100); // click on concerning strokeWidth button
}

function populateMarkerBar() {
	var markerBar = $('<div id="markerbar">');
	$(markers).each(function(i,ele) {
		tool = createMarkerButton(ele);
		$(markerBar).append(tool);
	});
	$(markerBar).insertBefore($('.lc-color-pickers').first());
	$(markerBar).parent().css('margin-top','200px');
	$('.lc-pick-tool').on('click', function() {setSelectionBorder($(this));});
}
 
 function createMarkerButton(marker) {
 	var iconUrl = "url(" + literallyBasicImageUrl + "/" + marker.icon + ".png)";
	var button = $('<div>');
	$(button).addClass('lc-pick-tool toolbar-button thin-button marker');
	$(button).css('background-image', iconUrl);
	$(button).attr('title', "Marker");
	$(button).on('click', function() {activatePencilWithProperties(marker.primaryColor, marker.secondaryColor, marker.strokeWidth);});
	return button;	 	
}   

// set a selection border on marker buttons to show which one is selected when active
function setSelectionBorder(ele) {	 		
	$('.marker-selection-border').each(function(i,element) {
		$(element).removeClass('marker-selection-border');
	});	 		
	if (ele !== 'undefined' && $(ele).hasClass('marker')) {	
 		$(ele).addClass('marker-selection-border');
 		}
 	}
 
 function adjustStrokeWidthIcons() {
 	var maxWidth = strokeWidths[strokeWidths.length-1];
 	var center = maxWidth / 2;
 	var viewBox = 'viewBox="0 0 ' + maxWidth + ' ' + maxWidth + '"';
	$('.square-toolbar-button').each(function(i, ele) {
		svg = $(ele).html();
		svg = svg.replace('<svg', '<svg ' + viewBox);
		svgNode = $('' + svg + '');
		$(svgNode).children().first().attr('cy', center);
		$(svgNode).children().first().attr('cx', center);
		$(ele).empty().append(svgNode);
	});
}

// global method for handlers and triggers for a better user experience
function improveUX() {
	initFontColorAlwaysBlack();
	initAdjustStrokeWidthIconsListener();
}
	 
function initFontColorAlwaysBlack() {
	$(".lc-pick-tool[title='Text']").on('click', function() {
		lc.setColor('primary', hslaBlack);
		lc.setColor('secondary', hslaEmpty); 
	});
}

function initAdjustStrokeWidthIconsListener() {
	$(".lc-pick-tool").on('click', function() {
		adjustStrokeWidthIcons();
		setTimeout(adjustStrokeWidthIcons, 20); // retry when buttons are not ready when event is triggered
		setTimeout(adjustStrokeWidthIcons, 300); // retry for really late arrivals; make both to hide it a maximum possible
	});
}