/* plugin.js for ilpsymbols
 * 
 * How to add new symbol insertion buttons to the toolbar:
 * 1) Set ILP_CKEditorEditableSymbols = [] with all the necessary symbols in bookAdditions.js.
 * 2) Check: are all symbols in this list?
 * '⇒','↑','↓','α','β','γ','δ','ε','η','Η','µ','π','ρ','σ','Σ','Δ','Ω','±','≙','√','Ø','°','λ','Λ','θ','ω','ψ','Φ','φ','ϱ','ϑ','ξ','Ξ','×','÷','∞','•'
 * If true: Fine, nothing else to do.
 * If not: Add icon to icons-list. Icon must be a .png, and the file must be in folder 'icons' with 16 x 16px, in folder 'icons/hidpi' with 32 x 32 px.
 * 3) Add command name parsing in ILP_GetCommandName function, to get the name of icon as command name. This name is also used for buttonName.

Version 1.0, 09.02.2016, Christian Heimann
Version 1.1, 09.03.2016, Christian Heimann, Adding automatisation. BookAdditions.js-definition needed.

*/

CKEDITOR.plugins.add( 'ilpsymbols', {
	// lang: 'de-ch,en,fr,it',
	icons: 'insertdefault,insertroot,insertmikro,insertdiameter,insertnotequal,insertpi,insertalpha,insertbeta,insertgamma,insertdelta,insertdeltamajor,insertepsilon,inserttheta,inserttheta2,insertlamda,insertlambdamajor,insertomega,insertomegamajor,insertrho,insertrho2,insertsigma,insertphi,insertphimajor,insertpsi,insertrightwardsdoublearrow,insertupwardsarrow,insertdownwardsarrow,insertplusminus,insertestimates,insertdegree,insertalmostequal,insertmultiplication,insertdivision,insertinfinity,insertxi,insertximajor,inserteta,insertetamajor,insertsigmamajor,insertbullet', // Add icon here, name as command name
	hidpi: true, // %REMOVE_LINE_CORE%
	init: function(editor) {

		var order = 0;

		var addInsertCommand = function(buttonName, buttonLabel, commandName, insertValue) {

			editor.addCommand(commandName, {
				exec: function(editor) {
					insertAtCursorPositionInElement(insertValue, lastFocusedElement);
				}
			});	

			editor.ui.addButton(buttonName, {
				label: buttonLabel,
				command: commandName,
				toolbar: 'others,' + (order += 10)
			});
			
		};

		// ILP_CKEditorEditableSymbols = []; // to set test values, all available symbols below:
		// ILP_CKEditorEditableSymbols = ['⇒','↑','↓','α','β','γ','δ','ε','µ','π','ρ','σ','Δ','Ω','±','≙','√','Ø'];
		// ILP_CKEditorEditableSymbols = ['°','λ','θ','ω','ψ','Φ','φ','ϱ','ϑ','×','÷','∞','•'];
		
		// Add new insert command here via CKEditorEditableSymbols array in bookAdditions.js
		if (typeof ILP_CKEditorEditableSymbols !== 'undefined' && ILP_CKEditorEditableSymbols.length > 0) {
			ILP_CKEditorEditableSymbols.forEach(ILP_CreateCommand);
		}
		
		function ILP_CreateCommand(element, index, array) {
			var buttonLabel = element;
			var commandName = ILP_GetCommandName(element);
			var insertValue = element;
			addInsertCommand(commandName, buttonLabel, commandName, insertValue);
		}
		
		// transform command names to avoid problems with special characters
		function ILP_GetCommandName(element) {
			var commandName = "insertdefault";
			if (element.indexOf("α") >= 0) {
				commandName = "insertalpha";
			} else if (element.indexOf("β") >= 0) {
				commandName = "insertbeta";
			} else if (element.indexOf("γ") >= 0) {
				commandName = "insertgamma";
			} else if (element.indexOf("δ") >= 0) {
				commandName = "insertdelta";
			} else if (element.indexOf("Λ") >= 0) {
				commandName = "insertdeltamajor";
			} else if (element.indexOf("η") >= 0) {
				commandName = "inserteta";
			} else if (element.indexOf("Η") >= 0) {
				commandName = "insertetamajor";
			} else if (element.indexOf("λ") >= 0) {
				commandName = "insertlamda";
			} else if (element.indexOf("Δ") >= 0) {
				commandName = "insertdeltamajor";
			} else if (element.indexOf("ε") >= 0) {
				commandName = "insertepsilon"; 
			} else if (element.indexOf("θ") >= 0) {
				commandName = "inserttheta";
			} else if (element.indexOf("ϑ") >= 0) {
				commandName = "inserttheta2";
			} else if (element.indexOf("ω") >= 0) {
				commandName = "insertomega";
			} else if (element.indexOf("Ω") >= 0) {
				commandName = "insertomegamajor";
			} else if (element.indexOf("π") >= 0) {
				commandName = "insertpi";
			} else if (element.indexOf("µ") >= 0) {
				commandName = "insertmikro";
			} else if (element.indexOf("ρ") >= 0) {
				commandName = "insertrho";
			} else if (element.indexOf("ϱ") >= 0) {
				commandName = "insertrho2";
			} else if (element.indexOf("σ") >= 0) {
				commandName = "insertsigma";
			} else if (element.indexOf("Σ") >= 0) {
				commandName = "insertsigmamajor";
			} else if (element.indexOf("φ") >= 0) {
				commandName = "insertphi";
			} else if (element.indexOf("Φ") >= 0) {
				commandName = "insertphimajor";
			} else if (element.indexOf("ψ") >= 0) {
				commandName = "insertpsi";
			} else if (element.indexOf("ξ") >= 0) {
				commandName = "insertxi";
			} else if (element.indexOf("Ξ") >= 0) {
				commandName = "insertximajor";
			} else if (element.indexOf("Ø") >= 0) {
				commandName = "insertdiameter";
			} else if (element.indexOf("√") >= 0) {
				commandName = "insertroot";
			} else if (element.indexOf("≠") >= 0) {
				commandName = "insertnotequal";
			} else if (element.indexOf("⇒") >= 0) {
				commandName = "insertrightwardsdoublearrow";
			} else if (element.indexOf("↑") >= 0) {
				commandName = "insertupwardsarrow";
			} else if (element.indexOf("↓") >= 0) {
				commandName = "insertdownwardsarrow";
			} else if (element.indexOf("±") >= 0) {
				commandName = "insertplusminus";
			} else if (element.indexOf("≙") >= 0) {
				commandName = "insertestimates";
			} else if (element.indexOf("°") >= 0) {
				commandName = "insertdegree";
			} else if (element.indexOf("≈") >= 0) {
				commandName = "insertalmostequal";
			} else if (element.indexOf("×") >= 0) {
				commandName = "insertmultiplication";
			} else if (element.indexOf("÷") >= 0) {
				commandName = "insertdivision";
			} else if (element.indexOf("∞") >= 0) {
				commandName = "insertinfinity";
			} else if (element.indexOf("•") >= 0) {
				commandName = "insertbullet";
			}
//			else if (element.indexOf("") >= 0) {
//				commandName = "";
//			}
			
			return commandName;
		}
	}

});		
