/* plugin.js for ilpstyles plugin
 * 
 * Adding style buttons to toolbar. This creates buttons that can be toggled (activated/desactivated).
 * While activated, font recieves the given attributes and is placed in given elements.
 * 
 * How to add a new (style) button to toolbar:
 * 1) Add icon to icons-list. Icon must be a .png, and the file must be in folder 'icons' with 16 x 16px, in folder 'icons/hidpi' with 32 x 32 px.
 * 2) Add new style element to contentForms object.
 * 3) Add new style definitions – the attributes the font should recieve. This is added to ckeditor corestyles.
 * 4) Add button command.

Version 1.0, 09.02.2016, Christian Heimann
 */

CKEDITOR.plugins.add( 'ilpstyles', {
	lang: 'de-ch,en,fr,it',
	icons: 'redcolorfont,greencolorfont', // icon-list
	hidpi: true,
	init: function( editor ) {
		var order = 0;
		// All buttons use the same code to register. So, to avoid
		// duplications, let's use this tool function.
		var addButtonCommand = function( buttonName, buttonLabel, commandName, styleDefiniton ) {
				// Disable the command if no definition is configured.
				if ( !styleDefiniton )
					return;

				var style = new CKEDITOR.style( styleDefiniton ),
					forms = contentForms[ commandName ];

				// Put the style as the most important form.
				forms.unshift( style );

				// Listen to contextual style activation.
				editor.attachStyleStateChange( style, function( state ) {
					!editor.readOnly && editor.getCommand( commandName ).setState( state );
				} );

				// Create the command that can be used to apply the style.
				editor.addCommand( commandName, new CKEDITOR.styleCommand( style, {
					contentForms: forms
				} ) );

				// Register the button, if the button plugin is loaded.
				if ( editor.ui.addButton ) {
					editor.ui.addButton( buttonName, {
						label: buttonLabel,
						command: commandName,
						toolbar: 'colors,' + ( order += 10 )
					} );
				}
			};

	    // Add new style element here; each one needs individual name (like 'red' and 'green').
		var contentForms = {
				redcolorfont: [
					'red'
				],

				greencolorfont: [
					'green'
				]

			},
			config = editor.config,
			lang = editor.lang.ilpstyles;

		// Add new button here
		addButtonCommand('RedColorFont', lang.redcolorfont, 'redcolorfont', config.coreStyles_redcolorfont);
		addButtonCommand('GreenColorFont', lang.greencolorfont, 'greencolorfont', config.coreStyles_greencolorfont);
	}
} );

// ILP Inline Styles. Add style definitions here

/**
 * The style definition that applies the ** ** style to the text.
 *
 * Read more in the [documentation](#!/guide/dev_basicstyles)
 * and see the [SDK sample](http://sdk.ckeditor.com/samples/basicstyles.html).
 *
 * Examples:
 *
 *		config.coreStyles_bold = { element: 'b', overrides: 'strong' };
 *
 *		config.coreStyles_bold = {
 *			element: 'span',
 *			attributes: { 'class': 'Bold' }
 *		};
 */
CKEDITOR.config.coreStyles_redcolorfont = { element: 'span', attributes: { 'style': 'color:red'} };
CKEDITOR.config.coreStyles_greencolorfont = { element: 'span', attributes: { 'style': 'color:green'} };

