/**
 * @license Copyright (c) 2003-2016, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or http://ckeditor.com/license
 */

CKEDITOR.editorConfig = function( config ) {
	config.toolbarGroups = [
		{ name: 'document', groups: [ 'mode', 'document', 'doctools' ] },
		{ name: 'clipboard', groups: [ 'clipboard', 'undo' ] },
		{ name: 'editing', groups: [ 'find', 'selection', 'spellchecker', 'editing' ] },
		{ name: 'forms', groups: [ 'forms' ] },
		{ name: 'basicstyles', groups: [ 'basicstyles', 'cleanup' ] },
		{ name: 'paragraph', groups: [ 'list', 'indent', 'blocks', 'align', 'bidi', 'paragraph' ] },
		{ name: 'links', groups: [ 'links' ] },
		{ name: 'insert', groups: [ 'insert' ] },
		{ name: 'styles', groups: [ 'styles' ] },
		{ name: 'colors', groups: [ 'colors' ] },
		{ name: 'tools', groups: [ 'tools' ] },
		{ name: 'others', groups: [ 'others' ] },
		{ name: 'about', groups: [ 'about' ] }
	];

	//config.removeButtons = 'Cut,Copy,Paste,Undo,Redo,Anchor';

	// Dialog windows are also simplified.
	config.removeDialogTabs = 'link:advanced';

	// define which content is allowed
	config.allowedContent = {
		$1: {
        	// Use the ability to specify elements as an object.
	        elements: CKEDITOR.dtd,
	        attributes: true,
	        styles: true,
	        classes: true
	    }
	};
	config.disallowedContent = 'script; *[on*]';

	// ILP ionesoft Plugins
	config.extraPlugins = 'ilpstyles,ilpsymbols';
	
	// prevent filling empty blocks (preventive)
	config.fillEmptyBlocks = false;
	config.skin = "moono-lisa";
	// prevent adding paragraph when core.styles used, which is not desired in 1 line entries
	// this config is deprecated but needed to make it work properly on xulrunner.
	// http://stackoverflow.com/questions/24283528/line-break-and-paragraph-has-doubled-itself-every-time-i-save-the-document-ckedi
	config.autoParagraph = false;

};