CKEDITOR.config.mathJaxLib = '//cdnjs.cloudflare.com/ajax/libs/mathjax/2.7.0/MathJax.js?config=TeX-AMS_HTML';
CKEDITOR.config.resize_enabled = false;
CKEDITOR.disableAutoInline = true;
CKEDITOR.config.removePlugins = 'autogrow';


function setupEditor(editorId, languageCode) {
	try {
		var instanceName = formatInstanceName(editorId);
		
		if (typeof CKEDITOR.instances[instanceName] != 'undefined') {
			return "ERROR: ckeditor instance already exists";
		}
		
		CKEDITOR.config.language = languageCode;
		
		CKEDITOR.replace(instanceName);
		
		// Do not modify css in html
		CKEDITOR.instances[instanceName].config.allowedContent = true;

		// Allow spell checking
		CKEDITOR.instances[instanceName].config.disableNativeSpellChecker = false;

		// Allows to press enter for text entry. Works much better on iPad
		CKEDITOR.instances[instanceName].config.enterMode = CKEDITOR.ENTER_BR;

		// Do not encode with entities. libxml2 will fail when &uuml; etc is used in xml content
		CKEDITOR.instances[instanceName].config.entities = false;
		
		// remove copy, cut, paste context menu: not working due to security restrictions
		// need timeout to set correctly else instance may not be ready
		setTimeout(function() {
			CKEDITOR.instances[instanceName].removeMenuItem('paste');
			CKEDITOR.instances[instanceName].removeMenuItem('copy');
			CKEDITOR.instances[instanceName].removeMenuItem('cut');
			CKEDITOR.instances[instanceName].removeMenuItem('bulletedlist'); // not working on Mac due to focus jump
		}, 700);

	} catch (ex) {
		return "ERROR: could not setupEditor: " + ex.message;
	}

}

// Called when switching away. Save the content of the open editor in the dom tree
function saveEditor(editorId) {
	var instanceName = formatInstanceName(editorId);

	try {
		CKEDITOR.instances[instanceName].save();
	} catch (ex) {
		return "ERROR: could not saveEditor: " + ex.message;
	}
}

// Return the content of the dom tree
function getContent(editorId) {
	var instanceName = formatInstanceName(editorId);

	try {
		var data = CKEDITOR.instances[instanceName].getData();
		return data;
	} catch (ex) {
		return;
	}
}

function formatInstanceName(editorId) {
	if (typeof editorId != 'undefined' && editorId.length > 0) {
		return 'richTextEditor-' + editorId;
	} else {
		return 'richTextEditorX';
	}
}