/**
 * @license Copyright (c) 2003-2017, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or http://ckeditor.com/license
 */
 
 
 /**** !!!!!!!!!!
 
 ionesoft changes
 
 23.03.2021, ds: ckeditor.plugins.link.dialogs/link.js, addded protocols beook, swissmem and ihk, see comment
 
 !!!!!! */
 

CKEDITOR.editorConfig = function( config ) {
	config.toolbarGroups = [
		{ name: 'basicstyles', groups: [ 'basicstyles', 'cleanup' ] },
		{ name: 'clipboard', groups: [ 'clipboard', 'undo' ] },
		{ name: 'editing', groups: [ 'find', 'selection', 'spellchecker', 'editing' ] },
		{ name: 'forms', groups: [ 'forms' ] },
		{ name: 'colors', groups: [ 'colors' ] },
		{ name: 'paragraph', groups: [ 'list', 'indent', 'blocks', 'align', 'bidi', 'paragraph' ] },
		{ name: 'links', groups: [ 'links' ] },
		{ name: 'document', groups: [ 'mode', 'document', 'doctools' ] },
		'/',
		{ name: 'styles', groups: [ 'styles' ] },
		{ name: 'insert', groups: [ 'insert' ] },
		//{ name: 'tools', groups: [ 'tools' ] },
		//{ name: 'others', groups: [ 'others' ] },
		//{ name: 'about', groups: [ 'about' ] }
	];
	
	//change format combo to show only h1-h3 headers and normal
	config.format_tags = 'h1;h2;h3;p';
	
	/* remove also cut, copy, paste (multiple) – they do not work. reason: browser security restrictions */
	config.removeButtons = 'Save,NewPage,Preview,Print,Templates,Cut,Copy,Paste,PasteText,PasteFromWord,Replace,Find,SelectAll,Scayt,Form,Checkbox,Radio,TextField,Textarea,Select,Button,ImageButton,HiddenField,CopyFormatting,RemoveFormat,Outdent,Indent,CreateDiv,BidiLtr,BidiRtl,Language,Anchor,Flash,HorizontalRule,Smiley,PageBreak,Iframe,BGColor,Maximize,ShowBlocks,About,Blockquote,Styles,Font,SpecialChar';
	config.allowedContent = true;
	config.skin = "moono-lisa";
//	config.extraPlugins = 'imagepaste';
//	config.extraPlugins = 'uploadImage';
//	config.extraPlugins = 'pastebase64';

	//add new plugin for resizing images
	config.extraPlugins = 'image2,tableresize';
	//remove unneeded plugins
	config.removePlugins = 'wordcount,mathjax,pagebreak';
};

/* hide dialog fields */
CKEDITOR.on('dialogDefinition', function(evt) {
	let dialogName = evt.data.name;
	let dialogDefinition = evt.data.definition;
	dialogDefinition.resizable = CKEDITOR.DIALOG_RESIZE_NONE;
	dialogDefinition.minHeight = 'auto';
	
	window.dialogDefinition = dialogDefinition;
	console.log(dialogName, dialogDefinition)
	if (dialogName == 'image2') {
		dialogDefinition.removeContents('Upload');
		
		let tab = dialogDefinition.getContents('info');
		tab.remove( 'alt' );
		tab.remove( 'width' );
		tab.remove( 'height' );
		tab.remove( 'lock' );
	}else if(dialogName == 'link') {
		dialogDefinition.onLoad = function () {
			
		}
		dialogDefinition.removeContents('target');
		dialogDefinition.removeContents('upload');
		dialogDefinition.removeContents('advanced');
		
		let tab = dialogDefinition.getContents('info');
		tab.remove('linkType'); // linkType not needed in link dialog, contains just url, email and anchor
		tab.remove('anchorOptions');
		tab.remove('emailOptions');
		tab.remove('browse');
	}else if(dialogName == 'youtube') {
		dialogDefinition.onLoad = function () {
			//remove an html element without an ID - there is no API for that....
			$(this.getElement().$).find('.cke_dialog_contents .cke_dialog_contents_body .cke_dialog_page_contents > table > tbody > tr:nth-child(2)').css({display: 'none'})
			
			this.getContentElement('youtubePlugin', 'txtEmbed').getElement().setStyle("display", "none");
			this.getContentElement("youtubePlugin", 'chkResponsive').getElement().setStyle("display", "none");
			this.getContentElement("youtubePlugin", 'chkNoEmbed').getElement().setStyle("display", "none");
			
			this.getContentElement("youtubePlugin", 'txtWidth').getElement().setStyle("display", "none");
			this.getContentElement("youtubePlugin", 'txtHeight').getElement().setStyle("display", "none");
			
			
			this.getContentElement("youtubePlugin", 'chkRelated').getElement().setStyle("display", "none");
			this.getContentElement("youtubePlugin", 'chkOlderCode').getElement().setStyle("display", "none");
			
			this.getContentElement("youtubePlugin", 'chkPrivacy').getElement().setStyle("display", "none");
			this.getContentElement("youtubePlugin", 'chkAutoplay').getElement().setStyle("display", "none");
			
			this.getContentElement("youtubePlugin", 'chkPrivacy').getElement().setStyle("display", "none");
			this.getContentElement("youtubePlugin", 'chkAutoplay').getElement().setStyle("display", "none");
			
			this.getContentElement("youtubePlugin", 'txtStartAt').getElement().setStyle("display", "none");
			this.getContentElement("youtubePlugin", 'chkControls').getElement().setStyle("display", "none");
        }
	}else if(dialogName == 'table') {
		let tab = dialogDefinition.getContents('info');
		tab.remove('selHeaders');
		tab.remove('txtBorder');
		tab.remove('cmbAlign');
		tab.remove('txtCellSpace');
		tab.remove('txtCellPad');
		tab.remove('txtHeight');
		tab.remove('txtWidth');
		tab.remove('txtSummary');
		
		//turn count cell and rows into a horizontal box
		tab.elements[0].children[0].type = 'hbox';
	}
});

/* remove items from contextual menu */
CKEDITOR.on('instanceReady', function(ck) {
	ck.editor.removeMenuItem('table');
	ck.editor.removeMenuItem('tablecellproperties');
});