package com.equo.middleware.api.resource;

import java.util.Map;

/**
 * Structure definition for a Request.
 */
public class Request {

  private Map<String, String> headers;
  private String url;
  private String method;

  /**
   * Creates and returns a new request with the given parameters.
   */
  public static Request create(String url, String method, Map<String, String> headers) {
    Request request = new Request();
    request.url = url;
    request.method = method;
    request.headers = headers;
    return request;
  }

  private Request() {
  }

  public String getUrl() {
    return url;
  }

  public String getMethod() {
    return method;
  }

  public Map<String, String> getHeaderMap() {
    return headers;
  }

}
