package com.equo.middleware.api.handler;

import java.io.InputStream;
import java.util.Map;

import com.equo.middleware.api.resource.Request;

/**
 * Functional interface to define custom responses.
 */
@FunctionalInterface
public interface IResponseHandler {

  public default boolean shouldProcessRequest(Request request) {
    return true;
  }

  /**
   * This method gets called when requests to any custom resource handler are
   * issued.
   * @param  request to respond to.
   * @param  headers map in which to set the needed response headers. See
   *                 {@link IResponseConstants}
   * @return         InputStream containing the response data
   */
  public InputStream getResponseData(Request request, Map<String, String> headers);

}
