package com.equo.middleware.api;

import com.equo.middleware.api.handler.IResponseHandler;

/**
 * Middleware Service API. Implementations should be able to provide custom
 * handling for custom and common schemes.
 */
public interface IMiddlewareService {

  public void addResourceHandler(String schemeName, String domainName,
      IResponseHandler responseHandler);

  public void removeResourceHandler(String schemeName, String domainName);

  public void blockByDefault(boolean block);

  public void addAllowed(String... domain);

  public void removeAllowed(String... domain);
}
