/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.rcp.config;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.co.b;
import ch.ionesoft.ilp.base.co.g;
import ch.ionesoft.ilp.base.co.h;
import ch.ionesoft.ilp.base.co.o;
import ch.ionesoft.ilp.base.co.p;
import ch.ionesoft.ilp.base.fo.s;
import ch.ionesoft.ilp.base.fo.w;
import ch.ionesoft.ilp.base.fo.z;
import ch.ionesoft.ilp.book.co.ILPBookHelper;
import ch.ionesoft.ilp.book.co.ILPBookRegistry;
import ch.ionesoft.ilp.book.co.ILPBookSettingsHelper;
import ch.ionesoft.ilp.book.co.ILPConfigurationManager;
import ch.ionesoft.ilp.book.co.ILPProfileManager;
import ch.ionesoft.ilp.book.mo.ILPCourseDef;
import ch.ionesoft.ilp.book.mo.ILPExercise;
import ch.ionesoft.ilp.book.mo.ILPIssueDef;
import ch.ionesoft.ilp.book.mo.ILPNote;
import ch.ionesoft.ilp.book.mo.ILPQuestion;
import ch.ionesoft.ilp.book.mo.ILPTopic;
import ch.ionesoft.ilp.book.pe.f;
import ch.ionesoft.ilp.book.pe.j;
import ch.ionesoft.ilp.book.search.i;
import ch.ionesoft.ilp.co.ILPViewRegistry;
import ch.ionesoft.ilp.co.a;
import ch.ionesoft.ilp.co.c;
import ch.ionesoft.ilp.rcp.application.handlers.SendProblemReportHandler;
import ch.ionesoft.ilp.rcp.application.handlers.UpdateHandler;
import ch.ionesoft.ilp.rcp.base.dialogs.B;
import ch.ionesoft.ilp.rcp.base.dialogs.J;
import ch.ionesoft.ilp.rcp.base.dialogs.K;
import ch.ionesoft.ilp.rcp.base.dialogs.e;
import ch.ionesoft.ilp.rcp.base.dialogs.h;
import ch.ionesoft.ilp.rcp.base.dialogs.x;
import ch.ionesoft.ilp.rcp.base.helper.RCPAppInitializer;
import ch.ionesoft.ilp.rcp.base.helper.RCPApplicationConfig;
import ch.ionesoft.ilp.rcp.base.helper.RCPCatalogPerspectiveBuilder;
import ch.ionesoft.ilp.rcp.base.helper.RCPPerspectiveHelper;
import ch.ionesoft.ilp.rcp.base.helper.RCPResourceHelper;
import ch.ionesoft.ilp.rcp.base.helper.RCPViewHelper;
import ch.ionesoft.ilp.rcp.config.RCPPerspectiveViewBuilder;
import ch.ionesoft.ilp.rcp.config.RCPSystemHelper;
import ch.ionesoft.ilp.vc.img.a;
import ch.ionesoft.ilp.view.ILPViewMediator;
import ch.ionesoft.ilp.view.d;
import jakarta.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.core.services.statusreporter.StatusReporter;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.services.EContextService;
import org.eclipse.e4.ui.services.IStylingEngine;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.IWindowCloseHandler;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class RCPViewMediator
extends ILPViewMediator
implements IWindowCloseHandler {
    public static final String MAIN_WINDOW_ID = "ch.ionesoft.ilp.rcp.application.trimmedWindow";
    private static final String WINDOW_POSITION_X = "window.position.x";
    private static final String WINDOW_POSITION_Y = "window.position.y";
    private static final String WINDOW_WIDTH = "window.width";
    private static final String WINDOW_HEIGHT = "window.height";
    private static final String WINDOW_MAXIMIZED = "window.maximized";
    private static ILogger logger = ILPLogManager.getLogger(RCPViewMediator.class);
    @Inject
    private MApplication application;
    @Inject
    private EModelService modelService;
    @Inject
    protected EPartService partService;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private IStylingEngine stylingEngine;
    @Inject
    IEclipseContext context;
    private Shell mainShell;

    @PostConstruct
    public void init(IEclipseContext iEclipseContext) {
        Object object;
        while (RCPAppInitializer.instance().isInitializationRunning()) {
            logger.a((Object)"Initialization still ongoing, waiting to initialize UI");
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        logger.b((Object)"Initializing RCPViewMediator ...");
        RCPSystemHelper.logRCPSystemConfig();
        if (!ILPProfileManager.instance().hasProfileWithEnvironment()) {
            object = new ILPConfigurationManager();
            object.synchronizeEnvironment();
        }
        object = (RCPViewHelper)ch.ionesoft.ilp.base.co.f.b().D();
        ((RCPViewHelper)((Object)object)).initializeHelper(this.getEventBroker());
        ILPViewRegistry.f().a((ILPViewMediator)this);
        ILPViewRegistry.f().a((a)new RCPPerspectiveHelper(this.application, this.modelService, this.partService, iEclipseContext));
        this.setPerspectiveBuilder(new RCPCatalogPerspectiveBuilder(MAIN_WINDOW_ID));
        boolean bl = ILPBookRegistry.instance().isFreshInstallation() || c.a().Z();
        try {
            if (f.a().N(ILPProfileManager.instance().getCurrentProfile().currentMandantId()).size() == 0) {
                bl = true;
            }
        }
        catch (j j2) {
            logger.d((Object)"Could not fetch loaded course size", (Throwable)j2);
        }
        this.configureViewHierarchyShowingPortal(bl);
        this.navigateToHolder(bl);
        this.installCrashReporter(iEclipseContext, (RCPViewHelper)((Object)object));
        this.waitAndFinalizeStartupAfterUIShown(bl);
    }

    private void activateKeyBindings() {
        try {
            EContextService eContextService = (EContextService)this.context.get(EContextService.class);
            if (eContextService != null) {
                if (SystemUtils.IS_OS_WINDOWS) {
                    eContextService.activateContext("org.eclipse.ui.contexts.dialogAndWindow.win");
                } else if (SystemUtils.IS_OS_MAC) {
                    eContextService.activateContext("org.eclipse.ui.contexts.dialogAndWindow.mac");
                }
            }
        }
        catch (Exception exception) {
            logger.d((Object)"Could not activate keybindings for mac/windows", (Throwable)exception);
        }
    }

    private void waitAndFinalizeStartupAfterUIShown(boolean bl) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                logger.b((Object)"Waiting for UI startup");
                try {
                    int n2 = 15;
                    int n3 = 0;
                    while (n3 < 15) {
                        MWindow mWindow = RCPViewMediator.this.getMainWindow();
                        if (mWindow == null || mWindow.getContext() == null) {
                            Thread.sleep(500L);
                            ++n3;
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                logger.b((Object)"UI has started, continuing");
                if (g.a().w()) {
                    try {
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                MTrimBar mTrimBar = RCPViewMediator.this.getPerspectiveHelper().getTrim();
                                Composite composite = (Composite)mTrimBar.getWidget();
                                logger.b((Object)"Setting exam mode color");
                                composite.setBackground(RCPResourceHelper.asSWTColor(w.d((String)"lightblue")));
                            }
                        });
                    }
                    catch (Exception exception) {
                        logger.d((Object)"Could not set exam mode color", (Throwable)exception);
                    }
                }
                RCPViewMediator.this.activateKeyBindings();
                try {
                    RCPViewMediator.this.installWindowCloseHandler();
                    RCPViewMediator.this.restoreWindowState();
                }
                catch (Exception exception) {
                    logger.d((Object)"Could not install windowCloseHandler", (Throwable)exception);
                }
                RCPAppInitializer rCPAppInitializer = RCPAppInitializer.instance();
                rCPAppInitializer.finalizeStartupAfterUIShown();
                try {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (RCPApplicationConfig.instance().isRestartRequired()) {
                                String string = g.a().e();
                                RCPApplicationConfig.instance().restartIfRequired("message.eclipse.preferences.restart." + string);
                            }
                        }
                    });
                }
                catch (Exception exception) {
                    logger.d((Object)"Could not check restart", (Throwable)exception);
                }
                try {
                    RCPViewMediator.this.handleApplicationStartupUrl();
                }
                catch (Exception exception) {
                    logger.d((Object)"Could not handle application url", (Throwable)exception);
                }
                RCPViewMediator.this.configureAppTitle();
                try {
                    RCPViewMediator.this.checkForCrashes();
                }
                catch (Exception exception) {
                    logger.d((Object)"Could not check for crashes", (Throwable)exception);
                }
                try {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            RCPAppInitializer.instance().checkForApplicationUpdates();
                        }
                    });
                }
                catch (Exception exception) {
                    logger.d((Object)"Could not check for updates", (Throwable)exception);
                }
                ILPBookHelper.checkClockTime();
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    private void navigateToHolder(boolean bl) {
        boolean bl2 = b.b().a("ILPView.startup.jump.to.portal", false);
        if (bl || bl2) {
            this.navigateToWelcomePage();
        } else {
            this.navigateToCurrentEBook();
        }
    }

    public void configureAppTitle() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                String string;
                String string2 = RCPSystemHelper.programVersionInBundle();
                String string3 = o.a().d("label.application.title");
                String string4 = string3 + " \u2013 " + string2;
                if (string3.contains("Swissmem")) {
                    try {
                        string4 = string3 + " \u2013 " + string2.substring(0, 3);
                    }
                    catch (Exception exception) {
                        logger.d((Object)("Cannot truncate app version for swissmem: " + string2), (Throwable)exception);
                    }
                }
                if (!g.a().Q().equals((Object)h.b.b)) {
                    string = g.a().Q().c();
                    string4 = string4 + string.charAt(0);
                    if (g.a().P().equals((Object)h.c.d)) {
                        string4 = string4 + " TEST";
                    } else if (g.a().P().equals((Object)h.c.c)) {
                        string4 = string4 + " INTEGRATION";
                    }
                }
                if (g.a().w()) {
                    string4 = "#### EXAM MODE ####      " + string4;
                }
                string = RCPViewMediator.this.getMainWindow();
                string.setLabel(string4);
            }
        });
    }

    private void installWindowCloseHandler() {
        MWindow mWindow = this.getMainWindow();
        if (mWindow != null && mWindow.getContext() != null) {
            mWindow.getContext().set(IWindowCloseHandler.class, (Object)this);
        } else {
            logger.d((Object)"Could not install window close handler. No main window found");
        }
    }

    public MWindow getMainWindow() {
        return (MWindow)this.modelService.find(MAIN_WINDOW_ID, (MUIElement)this.application);
    }

    public boolean close(MWindow mWindow) {
        this.saveWindowState();
        RCPApplicationConfig.instance().setShutdownRequested(true);
        this.getPerspectiveHelper().quitWorkbench();
        return true;
    }

    public void configureViewHierarchyShowingPortal(boolean bl) {
        logger.a((Object)"Confguring view hierarchy");
        RCPCatalogPerspectiveBuilder rCPCatalogPerspectiveBuilder = (RCPCatalogPerspectiveBuilder)ILPViewRegistry.f().g().getPerspectiveBuilder();
        RCPPerspectiveViewBuilder rCPPerspectiveViewBuilder = RCPApplicationConfig.instance().getPerspectiveViewBuilder();
        rCPPerspectiveViewBuilder.buildPerspectiveFromCatalog(rCPCatalogPerspectiveBuilder);
    }

    private void handleApplicationStartupUrl() {
        String[] stringArray = Platform.getCommandLineArgs();
        String[] stringArray2 = Platform.getApplicationArgs();
        logger.b((Object)("CommandlineArgs: " + ArrayUtils.toString((Object)stringArray)));
        logger.b((Object)("PlatformArgs: " + ArrayUtils.toString((Object)stringArray2)));
        if (stringArray.length == 1) {
            logger.b((Object)("Launching with arg[0] = " + stringArray[0]));
        }
        if (stringArray.length > 1) {
            String string = stringArray[1];
            logger.b((Object)("Command line: " + string));
            String string2 = ILPBookSettingsHelper.instance().applicationUrlSchemeComplete();
            if (string.startsWith(string2)) {
                this.handleApplicationUrl(string, true);
            }
        }
    }

    public void rcpHandleApplicationExit(Shell shell) {
        logger.b((Object)"RCP Application is stopping ...");
        try {
            IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

                public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                    iProgressMonitor.setTaskName(o.a().d("label.workspace.shutdown"));
                    ILPViewRegistry.f().g().handleApplicationExit();
                }
            };
            new ProgressMonitorDialog(shell).run(true, false, iRunnableWithProgress);
        }
        catch (InvocationTargetException invocationTargetException) {
            logger.d((Object)("Could not start progress dialog to shutdown app: " + String.valueOf(invocationTargetException)));
        }
        catch (InterruptedException interruptedException) {
            logger.d((Object)("Interrupted in shutdown app: " + String.valueOf(interruptedException)));
        }
    }

    private void saveWindowState() {
        try {
            MWindow mWindow = this.getMainWindow();
            p p2 = p.c();
            if (this.mainShell.getMaximized()) {
                p2.b(WINDOW_MAXIMIZED, Boolean.valueOf(true));
                logger.b((Object)"App was opened maximized. Store it, to open it next time maximized. ");
            } else {
                p2.b(WINDOW_MAXIMIZED, Boolean.valueOf(false));
                p2.a(WINDOW_POSITION_X, Integer.valueOf(mWindow.getX()));
                p2.a(WINDOW_POSITION_Y, Integer.valueOf(mWindow.getY()));
                p2.a(WINDOW_WIDTH, Integer.valueOf(mWindow.getWidth() < 100 ? 1024 : mWindow.getWidth()));
                p2.a(WINDOW_HEIGHT, Integer.valueOf(mWindow.getHeight() < 100 ? 768 : mWindow.getHeight()));
                logger.b((Object)("Saved window position to: " + mWindow.getX() + ", " + mWindow.getY() + ", " + mWindow.getWidth() + ", " + mWindow.getHeight()));
            }
            p2.g();
        }
        catch (Exception exception) {
            logger.d((Object)"Could not save window state", (Throwable)exception);
        }
    }

    private void restoreWindowState() {
        try {
            MWindow mWindow = this.getMainWindow();
            p p2 = p.c();
            if (p2.a(WINDOW_MAXIMIZED, Boolean.valueOf(false)).booleanValue()) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        RCPViewMediator.this.mainShell.setMaximized(true);
                    }
                });
                logger.b((Object)"Open app maximized. ");
            } else {
                int n2 = p2.a(WINDOW_POSITION_X, 1);
                int n3 = p2.a(WINDOW_POSITION_Y, 1);
                int n4 = p2.a(WINDOW_WIDTH, 1024);
                int n5 = p2.a(WINDOW_HEIGHT, 768);
                if (n4 < 100) {
                    n4 = 1024;
                }
                if (n5 < 100) {
                    n5 = 768;
                }
                if (n2 < 0 || n2 > mWindow.getWidth()) {
                    n2 = 0;
                }
                if (n3 < 0 || n3 > mWindow.getHeight()) {
                    n3 = 0;
                }
                mWindow.setX(n2);
                mWindow.setY(n3);
                mWindow.setWidth(n4);
                mWindow.setHeight(n5);
                logger.b((Object)("Restored window position to: " + n2 + ", " + n3 + ", " + n4 + ", " + n5));
            }
        }
        catch (Exception exception) {
            logger.d((Object)"Could not restore window state. ", (Throwable)exception);
        }
    }

    protected void shutdownServers() {
        RCPAppInitializer.instance().shutdownHttpServer();
    }

    private void installCrashReporter(IEclipseContext iEclipseContext, final RCPViewHelper rCPViewHelper) {
        iEclipseContext.set(StatusReporter.class, (Object)new StatusReporter(){

            public void report(IStatus iStatus, int n2, Object ... objectArray) {
                if (iStatus.getException() instanceof ch.ionesoft.ilp.base.ex.e) {
                    return;
                }
                if (iStatus.getException() instanceof NullPointerException && ExceptionUtils.getStackTrace((Throwable)iStatus.getException()).contains("at org.eclipse.swt.widgets.Control.internal_new_GC(Control.java:")) {
                    logger.a((Object)("Got know exception of Mac OS X El Capitan, ignoring: " + String.valueOf(iStatus.getException())));
                    return;
                }
                if (iStatus.getException() instanceof SWTException && iStatus.getException().getMessage().startsWith("Graphic is disposed")) {
                    logger.d((Object)("Got know exception of a disposed graphic, ignoring: " + String.valueOf(iStatus.getException())));
                    return;
                }
                if (iStatus.getException() instanceof SWTException && iStatus.getException().getMessage().startsWith("XPCOM error 0x80004002")) {
                    logger.d((Object)("Got know XULRunner exception, ignoring: " + String.valueOf(iStatus.getException())));
                    return;
                }
                StringBuffer stringBuffer = new StringBuffer();
                int n3 = 0;
                while (n3 < objectArray.length) {
                    stringBuffer.append(objectArray[n3]);
                    stringBuffer.append("\n\t");
                    ++n3;
                }
                logger.d((Object)("Internal error! Status:" + String.valueOf(iStatus) + ", information: " + String.valueOf(stringBuffer)), iStatus.getException());
                if (!(iStatus.getException() instanceof NullPointerException)) {
                    rCPViewHelper.displayWarningCode("message.internalError", new Object[0]);
                }
            }

            public IStatus newStatus(int n2, String string, Throwable throwable) {
                return new Status(n2, ch.ionesoft.ilp.base.co.f.b().c(), 1, string, throwable);
            }
        });
    }

    public void addCourseToTabbar(final ILPCourseDef iLPCourseDef, final boolean bl) {
        if (iLPCourseDef == null) {
            logger.c((Object)"Course is null, ignoring");
            return;
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                RCPCatalogPerspectiveBuilder rCPCatalogPerspectiveBuilder = (RCPCatalogPerspectiveBuilder)ILPViewRegistry.f().g().getPerspectiveBuilder();
                rCPCatalogPerspectiveBuilder.configurePerspectiveForCourse(iLPCourseDef, bl);
            }
        });
    }

    public void removeCourseFromTabbar(final ILPCourseDef iLPCourseDef) {
        this.runInUIThread(new Runnable(){

            @Override
            public void run() {
                RCPCatalogPerspectiveBuilder rCPCatalogPerspectiveBuilder = (RCPCatalogPerspectiveBuilder)ILPViewRegistry.f().g().getPerspectiveBuilder();
                rCPCatalogPerspectiveBuilder.removeCourse(iLPCourseDef, false);
            }
        });
    }

    public void navigateToDynamicWebView(final s s2) {
        if (g.a().w()) {
            logger.c((Object)("Navigation to web page: " + String.valueOf(s2) + " is disabled in exam mode"));
            return;
        }
        if (ILPBookSettingsHelper.instance().isOpenUrlsExternally()) {
            ch.ionesoft.ilp.base.co.f.b().I().openURLExternally(s2.a());
        } else {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    RCPViewMediator.this.getPerspectiveHelper().selectPerspectiveWithId("ch.ionesoft.ilp.rcp.application.perspective.WebPage");
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("urlRequest", s2);
                    RCPViewMediator.this.postEvent("loadWebPageRequest", hashMap);
                }
            });
            thread.start();
        }
    }

    private void navigateToWelcomePage() {
        List list = ILPProfileManager.instance().getAllProfiles();
        if (list == null || list.isEmpty()) {
            logger.b((Object)"Loading portal on version update");
            this.navigateToPortal();
        } else {
            logger.b((Object)"Loading dashboard on version update");
            this.navigateToDashboard(true);
        }
    }

    public void navigateToDashboard(boolean bl) {
        if (b.b().a("ILPView.dashboard.part.active", false)) {
            d d2 = this.holderForPerspectiveId("ch.ionesoft.ilp.rcp.application.perspective.Dashboard");
            if (d2 != null) {
                this.navigateToHolder(d2, bl);
            } else {
                logger.c((Object)"No holder found for perspectiveId: ch.ionesoft.ilp.rcp.application.perspective.Dashboard");
            }
        } else {
            this.navigateToPortal(bl);
        }
    }

    public void navigateToPortal() {
        this.navigateToPortal(false);
    }

    public void navigateToPortal(boolean bl) {
        ch.ionesoft.ilp.book.analytics.a.a().b("Portal ebook");
        d d2 = this.holderForPerspectiveId("ch.ionesoft.ilp.rcp.application.perspective.PortalCourse");
        if (d2 != null) {
            this.navigateToHolder(d2, bl);
        } else {
            logger.c((Object)"No holder found for perspectiveId: ch.ionesoft.ilp.rcp.application.perspective.PortalCourse");
        }
    }

    public void navigateToCourseDownloadOfCourse(ILPCourseDef iLPCourseDef) {
        HashMap<String, ILPCourseDef> hashMap = new HashMap<String, ILPCourseDef>();
        hashMap.put("course", iLPCourseDef);
        this.getEventBroker().post("requestCourseSelected", hashMap);
    }

    public void navigateToSharing() {
        d d2 = ILPViewRegistry.f().g().holderWithPerspectiveId("ch.ionesoft.ilp.rcp.application.perspective.SharingWebPage");
        ILPViewRegistry.f().g().navigateToHolder(d2);
    }

    public void navigateToGlobalSearch() {
        d d2 = ILPViewRegistry.f().g().holderWithPerspectiveId("ch.ionesoft.ilp.rcp.application.perspective.GlobalSearchWebPage");
        ILPViewRegistry.f().g().navigateToHolder(d2);
    }

    public void requestLoadTopic(ILPTopic iLPTopic, ILPTopic iLPTopic2, String string, i i2) {
        this.loadTopicFromPrevious(iLPTopic, iLPTopic2, string, i2);
    }

    public void navigateToHolderWithPerspectiveId(String string) {
        d d2 = this.holderForPerspectiveId(string);
        if (d2 != null) {
            if (d2.h()) {
                this.navigateToHolder(d2, true);
            } else {
                this.navigateToHolder(d2);
            }
        } else {
            logger.d((Object)("No holder found for perspectiveId: " + string));
            if (!"ch.ionesoft.ilp.rcp.application.perspective.PortalCourse".equals(string)) {
                this.navigateToPortal();
            }
        }
    }

    public String determinePerspectiveIdForHolder(d d2) {
        return RCPApplicationConfig.instance().getPerspectiveViewBuilder().determinePerspectiveForHolder(d2);
    }

    public void navigateToSettings() {
        this.getPerspectiveHelper().executeCommand("org.eclipse.ui.window.preferences");
    }

    public void navigateToScenarios() {
        ch.ionesoft.ilp.book.analytics.a.a().b("ScenarioLegacy");
        d d2 = ILPViewRegistry.f().g().holderWithPerspectiveId("ch.ionesoft.ilp.rcp.application.perspective.ScenarioWebPage");
        ILPViewRegistry.f().g().navigateToHolder(d2);
    }

    public void navigateToScenarioPlayer() {
        d d2 = ILPViewRegistry.f().g().holderWithPerspectiveId("ch.ionesoft.ilp.rcp.application.perspective.ScenarioPlayer");
        ILPViewRegistry.f().g().navigateToHolder(d2);
    }

    public void showMasterViewRecent() {
    }

    private void activateMasterViewPartWithIdInHolder(String string, d d2) {
        d d3 = d2;
        this.getPerspectiveHelper().selectPartWithId(d3.f(), string, "ch.ionesoft.ilp.rcp.application.partstack.master");
    }

    public void showMasterViewTOC(d d2) {
        String string = "ch.ionesoft.ilp.rcp.application.part.toc";
        this.activateMasterViewPartWithIdInHolder(string, d2);
    }

    public void showMasterViewBookmarks(d d2) {
        String string = "ch.ionesoft.ilp.rcp.application.part.bookmarks";
        this.activateMasterViewPartWithIdInHolder(string, d2);
    }

    public void showMasterViewSearch(d d2) {
        String string = "ch.ionesoft.ilp.rcp.application.part.search";
        this.activateMasterViewPartWithIdInHolder(string, d2);
    }

    public void showMasterViewSummary(d d2) {
        String string = "ch.ionesoft.ilp.rcp.application.part.summary";
        this.activateMasterViewPartWithIdInHolder(string, d2);
    }

    public void showMasterViewNotes(d d2) {
        String string = "ch.ionesoft.ilp.rcp.application.part.markers";
        this.activateMasterViewPartWithIdInHolder(string, d2);
    }

    public void showMasterViewExercices(d d2) {
        String string = "ch.ionesoft.ilp.rcp.application.part.exercises";
        this.activateMasterViewPartWithIdInHolder(string, d2);
    }

    public void showMasterViewResources(d d2) {
        String string = "ch.ionesoft.ilp.rcp.application.part.resources";
        this.activateMasterViewPartWithIdInHolder(string, d2);
    }

    public void showDetailViewEBook() {
        d d2 = ILPViewRegistry.f().g().currentEbookHolder();
        if (d2 != null) {
            this.getPerspectiveHelper().enableUIElementtWithId(d2.f(), "ch.ionesoft.ilp.rcp.application.part.exerciseviewer", false);
            this.getPerspectiveHelper().enableUIElementtWithId(d2.f(), "ch.ionesoft.ilp.rcp.application.part.resourceviewer", false);
            this.getPerspectiveHelper().enableUIElementtWithId(d2.f(), "ch.ionesoft.ilp.rcp.application.parts.notedetail", false);
            this.getPerspectiveHelper().enableUIElementtWithId(d2.f(), "ch.ionesoft.ilp.rcp.application.part.ebookviewer", true);
        }
    }

    public void showDetailViewExercises() {
        d d2 = ILPViewRegistry.f().g().currentEbookHolder();
        if (d2 != null) {
            this.getPerspectiveHelper().enableUIElementtWithId(d2.f(), "ch.ionesoft.ilp.rcp.application.part.ebookviewer", false);
            this.getPerspectiveHelper().enableUIElementtWithId(d2.f(), "ch.ionesoft.ilp.rcp.application.part.resourceviewer", false);
            this.getPerspectiveHelper().enableUIElementtWithId(d2.f(), "ch.ionesoft.ilp.rcp.application.parts.notedetail", false);
            this.getPerspectiveHelper().enableUIElementtWithId(d2.f(), "ch.ionesoft.ilp.rcp.application.part.exerciseviewer", true);
        }
    }

    public void showDetailViewResources() {
        d d2 = ILPViewRegistry.f().g().currentEbookHolder();
        if (d2 != null) {
            this.getPerspectiveHelper().enableUIElementtWithId(d2.f(), "ch.ionesoft.ilp.rcp.application.part.ebookviewer", false);
            this.getPerspectiveHelper().enableUIElementtWithId(d2.f(), "ch.ionesoft.ilp.rcp.application.part.exerciseviewer", false);
            this.getPerspectiveHelper().enableUIElementtWithId(d2.f(), "ch.ionesoft.ilp.rcp.application.parts.notedetail", false);
            this.getPerspectiveHelper().enableUIElementtWithId(d2.f(), "ch.ionesoft.ilp.rcp.application.part.resourceviewer", true);
        }
    }

    public void showDetailViewNotes() {
        d d2 = ILPViewRegistry.f().g().currentEbookHolder();
        if (d2 != null) {
            this.getPerspectiveHelper().enableUIElementtWithId(d2.f(), "ch.ionesoft.ilp.rcp.application.part.ebookviewer", false);
            this.getPerspectiveHelper().enableUIElementtWithId(d2.f(), "ch.ionesoft.ilp.rcp.application.part.exerciseviewer", false);
            this.getPerspectiveHelper().enableUIElementtWithId(d2.f(), "ch.ionesoft.ilp.rcp.application.part.resourceviewer", false);
            this.getPerspectiveHelper().enableUIElementtWithId(d2.f(), "ch.ionesoft.ilp.rcp.application.parts.notedetail", true);
        }
    }

    public void maximizeCurrentMasterView() {
        try {
            MPartStack mPartStack;
            List list;
            d d2 = ILPViewRegistry.f().g().currentEbookHolder();
            if (d2 != null && (list = (mPartStack = this.getPerspectiveHelper().partStackWithId("ch.ionesoft.ilp.rcp.application.partstack.master", this.getPerspectiveHelper().perspectiveWithId(d2.f()))).getTags()).contains("Minimized")) {
                list.remove("Minimized");
                list.add("Maximized");
            }
        }
        catch (Exception exception) {
            logger.d((Object)"Could not maximize current masterView partStack", (Throwable)exception);
        }
    }

    public void hideCurrentMasterView() {
        d d2 = ILPViewRegistry.f().g().currentEbookHolder();
        if (d2 != null) {
            MPartStack mPartStack = this.getPerspectiveHelper().partStackWithId("ch.ionesoft.ilp.rcp.application.partstack.master", this.getPerspectiveHelper().perspectiveWithId(d2.f()));
            mPartStack.setVisible(false);
        }
    }

    public void refreshMasterViewController() {
    }

    public boolean postEvent(String string, Map<String, Object> map) {
        return this.getEventBroker().post(string, map);
    }

    public boolean sendEvent(String string, Map<String, Object> map) {
        return this.getEventBroker().send(string, map);
    }

    public void sendProblemFeedback() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                SendProblemReportHandler sendProblemReportHandler = new SendProblemReportHandler();
                Display display = Display.getDefault();
                Shell shell = display.getActiveShell();
                if (shell == null) {
                    shell = new Shell(display);
                }
                sendProblemReportHandler.sendProblemReport(shell);
            }
        });
    }

    public IStylingEngine getStylingEngine() {
        return this.stylingEngine;
    }

    public void setStylingEngine(IStylingEngine iStylingEngine) {
        this.stylingEngine = iStylingEngine;
    }

    public void showPictureFromPath(String string, String string2) {
        if (string != null && string.length() > 0) {
            try {
                z z2 = z.a((String)string);
                if (z2 != null) {
                    this.showPictureFromImage(z2, string2);
                } else {
                    Program.launch((String)string);
                }
            }
            catch (SWTException sWTException) {
                Program.launch((String)string);
            }
        }
    }

    public void showPictureFromImage(z z2, String string) {
        if (z2 != null) {
            Display display = Display.getCurrent();
            Shell shell = new Shell(display);
            x x2 = new x(shell, z2, string, true);
            x2.d(false);
            x2.open();
        }
    }

    public void showPictureFromImage(z z2, String string, String string2) {
        if (z2 != null) {
            Display display = Display.getCurrent();
            Shell shell = new Shell(display);
            x x2 = new x(shell, z2, string, true);
            ILPNote iLPNote = new ILPNote();
            iLPNote.setText(string2);
            x2.m().a(iLPNote);
            x2.d(false);
            x2.open();
        }
    }

    public void showPictureFromImage(z z2, String string, String string2, ILPTopic iLPTopic, boolean bl) {
        this.showPictureFromImage(z2, string, string2, iLPTopic, bl, null);
    }

    public void showPictureFromImage(z z2, String string, String string2, ILPTopic iLPTopic, boolean bl, a.a a2) {
        block5: {
            if (z2 != null) {
                Display display = Display.getCurrent();
                Shell shell = new Shell(display);
                x x2 = new x(shell, z2, string, string2, iLPTopic, true, a2);
                if (bl) {
                    x2.d("");
                    x2.d(b.b().a("ILPView.image.annotation", false));
                }
                if (c.a().P() && a2 == a.a.a || a2 == a.a.e) {
                    x2.b("ie");
                }
                try {
                    x2.open();
                }
                catch (Exception exception) {
                    if (exception instanceof NullPointerException) break block5;
                    logger.c((Object)("Could not open image annotation view controller " + String.valueOf(exception)), (Throwable)exception);
                }
            }
        }
    }

    public void showPictureFromImage(z z2, String string, String string2, ILPExercise iLPExercise, boolean bl) {
        this.showPictureFromImage(z2, string, string2, iLPExercise, bl, null);
    }

    public void showPictureFromImage(z z2, String string, String string2, ILPExercise iLPExercise, boolean bl, a.a a2) {
        if (z2 != null) {
            Display display = Display.getCurrent();
            Shell shell = new Shell(display);
            x x2 = new x(shell, z2, string, string2, iLPExercise, true, a2);
            if (bl) {
                x2.d("");
                x2.d(b.b().a("ILPView.image.annotation", false));
            }
            x2.open();
        }
    }

    public void playMovie(URI uRI, String string) {
        String string2 = uRI.toString();
        J j2 = new J(Display.getCurrent());
        int n2 = 800;
        int n3 = 600;
        K k2 = new K(string, string2, n2, n3);
        j2.a(k2);
    }

    public void playAudio(URI uRI, String string) {
        String string2 = uRI.toString();
        h h2 = new h(Display.getCurrent());
        K k2 = new K(string, string2, 0, 0);
        h2.a(k2);
    }

    public void openInPopup(String string) {
        ch.ionesoft.ilp.rcp.base.dialogs.j j2 = new ch.ionesoft.ilp.rcp.base.dialogs.j(Display.getDefault().getActiveShell(), 1400, 900, false, false);
        j2.d(string);
        j2.open();
    }

    public void openQuizView(List<Integer> list, ILPCourseDef iLPCourseDef) {
        B b2 = new B(new Shell(), o.b((String)"label.quiz"), list, iLPCourseDef, 650, 650);
        b2.open();
        b2.v().a();
    }

    public void writeReview() {
        String string = ILPBookSettingsHelper.instance().reviewAppUrl();
        try {
            if (string.startsWith("mailto:")) {
                this.sendGeneralFeedback();
            } else {
                this.navigateToDynamicWebView(new s(string));
            }
        }
        catch (Exception exception) {
            logger.c((Object)("Could not write review: " + String.valueOf(exception)), (Throwable)exception);
        }
    }

    public void fullscreenEditorWithExercise_QuestionReference(ILPExercise iLPExercise, String string, ch.ionesoft.ilp.vc.s s2) throws j {
        ILPQuestion iLPQuestion = f.a().a(string, iLPExercise);
        e e2 = new e(Display.getCurrent().getActiveShell());
        e2.a(iLPQuestion);
        e2.a(s2);
        try {
            e2.open();
        }
        catch (Exception exception) {
            logger.c((Object)("Could not open anserDialog for exercise: " + String.valueOf(iLPExercise)), (Throwable)exception);
        }
    }

    public IEventBroker getEventBroker() {
        return this.eventBroker;
    }

    public void runInUIThread(Runnable runnable) {
        Display.getDefault().syncExec(runnable);
    }

    public void runInUIThread_afterDelay(final Runnable runnable, final int n2) {
        if (n2 > 0) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(n2);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    Display.getDefault().syncExec(runnable);
                }
            });
            thread.setDaemon(true);
            thread.start();
        } else {
            Display.getDefault().syncExec(runnable);
        }
    }

    protected void bringToFront() {
        if (Display.getCurrent().getActiveShell() != null) {
            Display.getCurrent().getActiveShell().forceFocus();
        }
    }

    public void changePresentationStyle_forIssue(ILPIssueDef iLPIssueDef) {
    }

    public RCPPerspectiveHelper getPerspectiveHelper() {
        return (RCPPerspectiveHelper)ILPViewRegistry.f().l();
    }

    public void runInBackgroundThread(final Runnable runnable, final Runnable runnable2, final Runnable runnable3) {
        if (runnable == null) {
            String string = "Could not start background thread, reason: doInBackground Runnable is null";
            logger.d((Object)string);
            throw new IllegalArgumentException(string);
        }
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (runnable2 != null) {
                    runnable2.run();
                }
                runnable.run();
                if (runnable3 != null) {
                    runnable3.run();
                }
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    public void runInBackgroundThread_afterDelay(final Runnable runnable, final int n2) {
        if (runnable == null) {
            String string = "Could not start background thread, reason: doInBackground Runnable is null";
            logger.d((Object)string);
            throw new IllegalArgumentException(string);
        }
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(n2);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                runnable.run();
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    public void updateTabBarOrder() {
        this.getPerspectiveHelper().updateTabBarOrder();
    }

    public void refreshLabels() {
    }

    public void refreshPortalIcon() {
        this.getPerspectiveHelper().refreshPortalIcon();
    }

    public Shell getMainShell() {
        return this.mainShell;
    }

    public void setMainShell(Shell shell) {
        this.mainShell = shell;
    }

    public void setupBottomNavigationController() {
    }

    public void showBottomNavigation() {
    }

    public void hideBottomNavigation() {
    }

    public void setupSegmentedTabMenuController() {
    }

    public void showHideNativeNavigationForPerspective(String string, d d2) {
    }

    public void addWakeLockFlag() {
    }

    public void clearWakeLockFlag() {
    }

    public boolean isOnboardingWizardActive() {
        return false;
    }

    public void updateScenarioToolItemVisibility() {
        this.runInUIThread(new Runnable(){

            @Override
            public void run() {
                try {
                    RCPPerspectiveViewBuilder rCPPerspectiveViewBuilder = RCPApplicationConfig.instance().getPerspectiveViewBuilder();
                    rCPPerspectiveViewBuilder.updateScenarioToolItemVisibility();
                }
                catch (Exception exception) {
                    logger.d((Object)"Could not update scenario toolItem visibility", (Throwable)exception);
                }
            }
        });
    }

    public void installAppUpdate(URL uRL, URL uRL2) {
        UpdateHandler updateHandler = new UpdateHandler();
        if (uRL != null) {
            updateHandler.installUpdateWithInstaller(uRL);
        }
        if (uRL2 != null) {
            updateHandler.installNewUpdatesUsingP2(Display.getCurrent().getActiveShell(), uRL2);
        }
    }
}

