/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.rcp.config;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.he.StringHelper;
import ch.ionesoft.ilp.base.he.SystemHelper;
import ch.ionesoft.ilp.book.co.ILPBookSettingsHelper;
import ch.ionesoft.ilp.co.c;
import java.io.File;
import java.net.URL;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;

public class RCPSystemHelper {
    private static String programVersionInBundle;
    private static ILogger logger;

    static {
        logger = ILPLogManager.getLogger(RCPSystemHelper.class);
    }

    public static String programVersionInBundle() {
        return programVersionInBundle;
    }

    public static void setProgramVersionInBundle(Bundle bundle) {
        String string = bundle.getVersion().toString();
        if ((string = string.replace(".qualifier", "")).length() > 8) {
            string = StringHelper.extractLeadingString_beforeLast((String)string, (String)".");
        }
        programVersionInBundle = string;
    }

    public static void updateProgramVersion() {
        SystemHelper.updateProgramVersion((String)RCPSystemHelper.programVersionInBundle());
    }

    public static void updateInstallationDate() {
        boolean bl = RCPSystemHelper.isUpdatedInstallation();
        SystemHelper.updateInstallationDate((boolean)bl);
    }

    public static boolean isVeryFirstInstallation() {
        return StringUtils.isBlank((CharSequence)SystemHelper.firstInstallationDateAsString());
    }

    public static boolean isFreshInstallation() {
        return StringUtils.isBlank((CharSequence)SystemHelper.firstInstallationDateAsString()) || !SystemHelper.programVersion().equals(RCPSystemHelper.programVersionInBundle());
    }

    public static boolean isUpdatedInstallation() {
        return StringUtils.isNotBlank((CharSequence)SystemHelper.firstInstallationDateAsString()) && !RCPSystemHelper.programVersionInBundle().equals(SystemHelper.programVersion());
    }

    public static String configureWorkspace(File file) {
        Location location = Platform.getInstanceLocation();
        try {
            location.set(new URL("file", null, file.toString()), false);
            SystemHelper.addToLogBuffer((String)("Configured workspace location to: " + String.valueOf(file)));
        }
        catch (Exception exception) {
            SystemHelper.addToLogBuffer((String)("Could not set workspace location to: " + String.valueOf(file)), (Exception)exception);
        }
        String string = Platform.getInstanceLocation().getURL().getFile();
        return string;
    }

    static void logRCPSystemConfig() {
        try {
            logger.b((Object)"RCP Device Settings:");
            logger.b((Object)String.format(Locale.ENGLISH, "Display bounds: %s", Display.getCurrent().getBounds()));
            logger.b((Object)String.format(Locale.ENGLISH, "Display device zoom: %d", DPIUtil.getDeviceZoom()));
            logger.b((Object)String.format(Locale.ENGLISH, "Display DPI: %s dpi", Display.getCurrent().getDPI()));
            logger.b((Object)String.format(Locale.ENGLISH, "Display touch enabled: %s", Display.getCurrent().getTouchEnabled() ? "true" : "false"));
            logger.b((Object)String.format(Locale.ENGLISH, "Current browser: %s", c.a().F()));
            logger.b((Object)String.format(Locale.ENGLISH, "Open videos externally: %s", c.a().U()));
            logger.b((Object)String.format(Locale.ENGLISH, "Open urls externally: %s", ILPBookSettingsHelper.instance().isOpenUrlsExternally()));
        }
        catch (Exception exception) {
            logger.d((Object)"Could not log rcp device settings", (Throwable)exception);
        }
    }
}

