/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.rcp.base.helper;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.co.b;
import ch.ionesoft.ilp.base.co.h;
import ch.ionesoft.ilp.base.he.DESEncrypter;
import ch.ionesoft.ilp.base.he.FileHelper;
import ch.ionesoft.ilp.base.he.SystemHelper;
import ch.ionesoft.ilp.book.cl.e;
import ch.ionesoft.ilp.book.cl.f;
import ch.ionesoft.ilp.book.co.ILPBookRegistry;
import ch.ionesoft.ilp.book.co.ILPBookSettingsHelper;
import ch.ionesoft.ilp.book.co.ILPBookTypes;
import ch.ionesoft.ilp.book.co.ILPProfile;
import ch.ionesoft.ilp.book.co.ILPProfileManager;
import ch.ionesoft.ilp.book.co.ILPWorkspace;
import ch.ionesoft.ilp.book.pe.g;
import ch.ionesoft.ilp.book.syn.d;
import ch.ionesoft.ilp.co.ILPViewRegistry;
import ch.ionesoft.ilp.rcp.base.helper.RCPApplicationConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;

public class RCPWorkspaceHelper {
    private static ILogger logger = ILPLogManager.getLogger(RCPWorkspaceHelper.class);
    private SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd_Hm");

    public void exportCurrentProfileTo(File file) {
        File file2 = h.l();
        this.exportProfileTo(file2, file);
    }

    public void exportProfileTo(File file, File file2) {
        if (file == null || file2 == null || StringUtils.isBlank((CharSequence)file.getAbsolutePath()) || StringUtils.isBlank((CharSequence)file2.getAbsolutePath()) || !file2.isDirectory() || file.equals(file2)) {
            ch.ionesoft.ilp.base.co.f.b().D().alertNoticeCodeAsync("message.workspace.path.invalid");
            return;
        }
        try {
            File file3;
            File file4;
            File file5;
            File file6;
            File[] fileArray = file2.listFiles();
            if (fileArray != null && fileArray.length > 0 && !ch.ionesoft.ilp.base.co.f.b().D().askCode("message.workspace.path.overwrite", new Object[]{"label.ok", "label.abort"})) {
                return;
            }
            File file7 = h.E();
            FileUtils.copyDirectoryToDirectory((File)file7, (File)file2);
            File file8 = h.P();
            if (file8.exists()) {
                FileUtils.copyDirectoryToDirectory((File)file8, (File)file2);
            }
            if ((file6 = h.F()).exists()) {
                FileUtils.copyDirectoryToDirectory((File)file6, (File)file2);
            }
            if ((file5 = h.m()).exists()) {
                FileUtils.copyFileToDirectory((File)file5, (File)file2);
            }
            File file9 = h.n();
            if (file5.exists()) {
                FileUtils.copyFileToDirectory((File)file9, (File)file2);
            }
            if ((file4 = h.I()).exists()) {
                FileUtils.copyDirectoryToDirectory((File)file4, (File)file2);
            }
            if ((file3 = h.J()).exists()) {
                FileUtils.copyDirectoryToDirectory((File)file3, (File)file2);
            }
            ch.ionesoft.ilp.base.co.f.b().D().alertNoticeCodeAsync("message.profile.backup.successful");
        }
        catch (Exception exception) {
            logger.d((Object)("Could not backup profile: " + String.valueOf(file) + " to: " + String.valueOf(file2)), (Throwable)exception);
            ch.ionesoft.ilp.base.co.f.b().D().alertNoticeCodeAsync("message.profile.backup.failed");
        }
    }

    public void restoreProfileFrom(File file) {
        if (!this.isValidBackupFolder(file)) {
            ch.ionesoft.ilp.base.co.f.b().D().alertNoticeCodeAsync("message.workspace.path.invalid");
            return;
        }
        String string = ILPProfileManager.instance().getNewProfileId();
        ILPWorkspace iLPWorkspace = ILPProfileManager.instance().getWorkspace();
        iLPWorkspace.addExistingProfileId(string);
        ILPProfileManager.instance().writeWorkspaceToJson(iLPWorkspace);
        File file2 = new File(h.k(), string);
        try {
            File[] fileArray;
            File[] fileArray2 = fileArray = file.listFiles();
            int n2 = fileArray.length;
            int n3 = 0;
            while (n3 < n2) {
                File file3 = fileArray2[n3];
                if (!file3.getName().equals(".profile.keystore")) {
                    if (file3.isFile()) {
                        FileUtils.copyFileToDirectory((File)file3, (File)file2);
                    } else {
                        FileUtils.copyDirectoryToDirectory((File)file3, (File)file2);
                    }
                }
                ++n3;
            }
            this.updateProfileJson(string);
            ch.ionesoft.ilp.base.co.f.b().D().alertNoticeCodeAsync("message.profile.restore.successful");
            if (ILPProfileManager.isInitialProfileActive()) {
                ILPViewRegistry.f().g().sendPortalClickedEvent();
            }
        }
        catch (IOException iOException) {
            logger.d((Object)("Could not restore profile backup to: " + String.valueOf(file2)), (Throwable)iOException);
            ch.ionesoft.ilp.base.co.f.b().D().alertWarningCode("message.profile.restore.failed", new Object[0]);
        }
    }

    private void updateProfileJson(String string) throws IOException {
        File file = h.c((String)string);
        ILPProfile iLPProfile = ILPProfile.parse((File)file);
        iLPProfile.setId(string);
        iLPProfile.setResynchConfig(true);
        iLPProfile.serializeIntoFile(file);
    }

    private boolean isValidBackupFolder(File file) {
        if (file != null && file.isDirectory()) {
            try {
                return FileUtils.directoryContains((File)file, (File)new File(file, "data")) && FileUtils.directoryContains((File)file, (File)new File(file, ".profile.json")) && FileUtils.directoryContains((File)file, (File)new File(file, ".profile.properties"));
            }
            catch (IOException iOException) {
                logger.d((Object)("Could not validate files from backup folder: " + String.valueOf(file)), (Throwable)iOException);
                return false;
            }
        }
        return false;
    }

    public void exportWorkspaceTo(String string) {
        if (!StringUtils.isBlank((CharSequence)string)) {
            try {
                File file;
                File file2 = h.A();
                File file3 = new File(string);
                logger.b((Object)("Exporting workspace from " + String.valueOf(file2) + " to " + String.valueOf(file3)));
                File[] fileArray = file3.listFiles();
                if (fileArray != null && fileArray.length > 0 && !ch.ionesoft.ilp.base.co.f.b().D().askCode("message.workspace.path.overwrite", new Object[]{"label.ok", "label.abort"})) {
                    return;
                }
                File file4 = new File(file2, "data");
                FileUtils.copyDirectoryToDirectory((File)file4, (File)file3);
                f f2 = ILPBookRegistry.instance().getCloudService();
                if (!f2.h()) {
                    File file5;
                    file = f2.k();
                    if (file.exists()) {
                        FileUtils.copyDirectoryToDirectory((File)file, (File)file3);
                    }
                    if ((file5 = f2.m()).exists()) {
                        FileUtils.copyDirectoryToDirectory((File)file5, (File)file3);
                    }
                }
                file = new File(file2, "User_Default.properties");
                FileUtils.copyFileToDirectory((File)file, (File)file3);
                ch.ionesoft.ilp.base.co.f.b().D().alertNoticeCodeAsync("label.workspace.export.successful");
            }
            catch (IOException iOException) {
                logger.d((Object)("Could not copy workspace, reason: " + iOException.getMessage()), (Throwable)iOException);
                ch.ionesoft.ilp.base.co.f.b().D().alertNoticeCodeAsync("label.workspace.export.failed");
            }
        } else {
            ch.ionesoft.ilp.base.co.f.b().D().alertNoticeCodeAsync("message.workspace.path.invalid");
        }
    }

    public void restoreWorkspaceFrom(String string) {
        File file = h.A();
        if (StringUtils.isBlank((CharSequence)string)) {
            ch.ionesoft.ilp.base.co.f.b().D().alertNoticeCodeAsync("message.workspace.path.invalid");
            return;
        }
        logger.b((Object)("Restoring workspace from " + string + " to " + String.valueOf(file)));
        File file2 = new File(string);
        if (!this.isExistingWorkspaceDir(string)) {
            ch.ionesoft.ilp.base.co.f.b().D().alertNoticeCodeAsync("message.workspace.path.no.data");
            return;
        }
        if (!ch.ionesoft.ilp.base.co.f.b().D().askCode("message.workspace.path.restore.overwrite", new Object[]{"label.ok", "label.abort"})) {
            return;
        }
        if (file2.getAbsolutePath().equals(file.getAbsolutePath())) {
            return;
        }
        try {
            g.a().c();
            FileUtils.copyDirectory((File)file2, (File)file);
            RCPApplicationConfig.instance().forceRestart();
        }
        catch (IOException iOException) {
            logger.d((Object)("Could not restore workspace, reason: " + iOException.getMessage()), (Throwable)iOException);
            ch.ionesoft.ilp.base.co.f.b().D().alertWarningCode("message.workspace.restore.failed", new Object[0]);
        }
    }

    public void moveWorkspace(String string) {
        if (StringUtils.isBlank((CharSequence)string)) {
            ch.ionesoft.ilp.base.co.f.b().D().alertNoticeCodeAsync("message.workspace.path.invalid");
            return;
        }
        File file = new File(ch.ionesoft.ilp.base.co.f.b().z());
        try {
            logger.b((Object)("Moving workspace from " + String.valueOf(file) + " to " + string));
            File file2 = FileHelper.convertToLocalFile((String)string);
            File[] fileArray = file2.listFiles();
            if (fileArray != null && fileArray.length > 0 && !ch.ionesoft.ilp.base.co.f.b().D().askCode("message.workspace.path.overwrite", new Object[]{"label.ok", "label.abort"})) {
                return;
            }
            g.a().c();
            logger.b((Object)("Copying all files from " + String.valueOf(file) + " to " + String.valueOf(file2)));
            FileUtils.copyDirectory((File)file, (File)file2);
            if (ch.ionesoft.ilp.base.co.f.b().D().askCode("label.workspace.delete", new Object[]{"label.yes", "label.no"})) {
                try {
                    LogManager.shutdown();
                    FileUtils.deleteDirectory((File)file);
                }
                catch (IOException iOException) {
                    logger.c((Object)("Could not delete all workspace files, reason: " + iOException.getMessage()), (Throwable)iOException);
                }
            }
            this.changeWorkspacePathAndRestart(string);
        }
        catch (IOException iOException) {
            logger.d((Object)("Could not copy workspace, reason: " + iOException.getMessage()));
            ch.ionesoft.ilp.base.co.f.b().D().alertNoticeCodeAsync("label.workspace.export.failed");
            RCPApplicationConfig.instance().forceRestart();
            return;
        }
    }

    private boolean isExistingWorkspaceDir(String string) {
        String string2 = b.b().s(ILPBookTypes.kApplicationConfigDatabaseFile);
        String string3 = File.separator + "data" + File.separator + string2;
        File file = new File(string + string3);
        return file.exists();
    }

    public void changeWorkspacePathAndRestart(String string) {
        if (ch.ionesoft.ilp.base.co.f.b().z().equals(string)) {
            return;
        }
        if (!this.isExistingWorkspaceDir(string) && !ch.ionesoft.ilp.base.co.f.b().D().askCode("message.workspace.path.no.data.proceed", new Object[]{"label.ok", "label.abort"})) {
            return;
        }
        ArrayList<String> arrayList = this.loadInstallationProperties();
        int n2 = 0;
        boolean bl = false;
        n2 = 0;
        while (n2 < arrayList.size()) {
            if (arrayList.get(n2).startsWith("workspaceDir")) {
                bl = true;
                break;
            }
            ++n2;
        }
        if (!bl) {
            arrayList.add("");
        }
        string = StringEscapeUtils.escapeJava((String)string);
        arrayList.set(n2, "workspaceDir = " + string);
        this.saveInstallationProperties(arrayList);
        RCPApplicationConfig.instance().forceRestart();
    }

    private ArrayList<String> loadInstallationProperties() {
        ArrayList arrayList = new ArrayList();
        String string = ch.ionesoft.ilp.base.co.f.b().P();
        try {
            File file = FileHelper.convertToLocalFile((String)string);
            if (file.exists()) {
                arrayList = (ArrayList)FileUtils.readLines((File)file, (String)"UTF-8");
            }
        }
        catch (IOException iOException) {
            logger.d((Object)("Could not read installation properties from " + string + ", reason: " + iOException.getMessage()));
        }
        return arrayList;
    }

    private void saveInstallationProperties(ArrayList<String> arrayList) {
        String string = ch.ionesoft.ilp.base.co.f.b().P();
        try {
            File file = FileHelper.convertToLocalFile((String)string);
            FileUtils.writeLines((File)file, arrayList);
        }
        catch (IOException iOException) {
            logger.d((Object)("Could not write installation properties to " + string + ", reason: " + iOException.getMessage()));
        }
    }

    public void exportCloudDataTo(File file) {
        File file2;
        Object object = b.b().t("ILPView.app.code");
        if ((file = new File(file, (String)(object = (String)object + "_export_" + this.format.format(new Date())))).exists()) {
            ch.ionesoft.ilp.base.co.f.b().D().alertNoticeCodeAsync("message.cloud.data.backup.alreadyExists");
            return;
        }
        if (h.P().exists()) {
            file2 = new File(file, "UserData");
            FileHelper.copyItemAtPath_targetPath((String)h.P().getAbsolutePath(), (String)file2.getAbsolutePath());
        }
        if (h.F().exists()) {
            file2 = new File(file, "synch");
            FileHelper.copyItemAtPath_targetPath((String)h.F().getAbsolutePath(), (String)file2.getAbsolutePath());
            Collection collection = FileUtils.listFiles((File)file2, null, (boolean)true);
            for (File file3 : collection) {
                try {
                    if (file3.getAbsolutePath().endsWith(".xml")) {
                        this.decryptXMLFile(file3);
                        continue;
                    }
                    logger.c((Object)("Filetype is not supported: " + file3.getName()));
                }
                catch (Exception exception) {
                    logger.d((Object)("Could not decrypt file: " + String.valueOf(file3) + ". Maybe it is not encrypted."), (Throwable)exception);
                }
            }
        }
        ch.ionesoft.ilp.base.co.f.b().D().alertNoticeCodeAsync("message.cloud.data.backup.successful");
    }

    public void importCloudDataTo(File file) {
        if (d.a().b()) {
            ch.ionesoft.ilp.base.co.f.b().D().alertWarningCode("message.cloud.synch.running", new Object[0]);
            return;
        }
        File file2 = new File(file, "UserData");
        File file3 = new File(file, "synch");
        if (!file2.exists() && !file3.exists()) {
            ch.ionesoft.ilp.base.co.f.b().D().alertNoticeCodeAsync("message.cloud.data.restore.notValid");
            return;
        }
        e.a((Date)new Date());
        if (h.P().exists()) {
            try {
                FileUtils.forceDelete((File)h.P());
            }
            catch (IOException iOException) {
                ch.ionesoft.ilp.base.co.f.b().D().alertNoticeCodeAsync("message.cloud.data.restore.error");
                logger.d((Object)"Could not delete userdata folder: ", (Throwable)iOException);
                return;
            }
        }
        if (file2.exists()) {
            FileHelper.copyItemAtPath_targetPath((String)file2.getAbsolutePath(), (String)h.P().getAbsolutePath());
        }
        if (h.F().exists()) {
            try {
                FileUtils.forceDelete((File)h.F());
            }
            catch (IOException iOException) {
                ch.ionesoft.ilp.base.co.f.b().D().alertNoticeCodeAsync("message.cloud.data.restore.error");
                logger.d((Object)"Could not delete synch folder: ", (Throwable)iOException);
                return;
            }
        }
        if (file3.exists()) {
            FileHelper.copyItemAtPath_targetPath((String)file3.getAbsolutePath(), (String)h.F().getAbsolutePath());
            Collection collection = FileUtils.listFiles((File)h.F(), null, (boolean)true);
            for (File file4 : collection) {
                try {
                    if (file4.getAbsolutePath().endsWith(".xml")) {
                        this.encryptXMLFile(file4);
                        continue;
                    }
                    logger.c((Object)("Filetype is not supported: " + file4.getName()));
                }
                catch (Exception exception) {
                    logger.d((Object)("Could not encrypt file: " + String.valueOf(file4)), (Throwable)exception);
                }
            }
        }
        d.a().c();
        d.a().a(true, false);
        ch.ionesoft.ilp.base.co.f.b().D().alertNoticeCodeAsync("message.cloud.data.restore.successful");
    }

    private void decryptXMLFile(File file) {
        File file2 = new File(file.getParentFile(), "old_" + file.getName());
        File file3 = new File(file.getAbsolutePath());
        file.renameTo(file2);
        InputStream inputStream = null;
        try {
            try {
                inputStream = new FileInputStream(file2);
                DESEncrypter dESEncrypter = ILPBookSettingsHelper.instance().cloudDESEncrypter();
                inputStream = dESEncrypter.wrapInputStreamDecrypt(inputStream);
                inputStream = new GZIPInputStream(inputStream);
                FileHelper.writeFile((File)file3, (BufferedReader)new BufferedReader(new InputStreamReader(inputStream)));
            }
            catch (Exception exception) {
                logger.d((Object)("Could not encrypt xml file: " + String.valueOf(file2)), (Throwable)exception);
                try {
                    inputStream.close();
                    file2.delete();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                inputStream.close();
                file2.delete();
            }
            catch (IOException iOException) {}
        }
    }

    private void encryptXMLFile(File file) {
        File file2 = new File(file.getParentFile(), "old_" + file.getName());
        File file3 = new File(file.getAbsolutePath());
        file.renameTo(file2);
        OutputStream outputStream = null;
        try {
            try {
                byte[] byArray = FileHelper.readFile((File)file2);
                DESEncrypter dESEncrypter = ILPBookSettingsHelper.instance().cloudDESEncrypter();
                outputStream = new FileOutputStream(file3);
                outputStream = dESEncrypter.wrapOutputStreamEncrypt(outputStream);
                outputStream = new GZIPOutputStream(outputStream);
                outputStream.write(byArray);
                outputStream.flush();
            }
            catch (Exception exception) {
                logger.d((Object)("Could not encrypt xml file: " + String.valueOf(file2)), (Throwable)exception);
                try {
                    outputStream.close();
                    file2.delete();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                outputStream.close();
                file2.delete();
            }
            catch (IOException iOException) {}
        }
    }

    public boolean copyLogFilesTo(File file) {
        try {
            String string = "beook_log_files.zip";
            File file2 = new File(h.i().getAbsolutePath());
            File file3 = new File(file, string);
            FileHelper.zipFiles(Arrays.asList(file2.listFiles()), (File)file3);
            ch.ionesoft.ilp.base.co.f.b().D().alertNoticeCodeAsync("message.workspace.export.log.files.successful");
        }
        catch (IOException iOException) {
            logger.d((Object)"Could not Zip and copy log files to desktop: ", (Throwable)iOException);
            return false;
        }
        return true;
    }

    public static File getDesktopFolder() {
        return new File(SystemHelper.userHomeDirectory(), "Desktop");
    }

    public static interface MoveWorkspaceCallback {
        public void workspaceMoved();
    }

    public class MoveWorkspaceRunnable
    implements Runnable {
        private MoveWorkspaceCallback callback;
        private File sourceFolder;

        public MoveWorkspaceRunnable(File file, MoveWorkspaceCallback moveWorkspaceCallback) {
            this.sourceFolder = file;
            this.callback = moveWorkspaceCallback;
        }

        @Override
        public void run() {
            try {
                LogManager.shutdown();
                FileUtils.deleteDirectory((File)this.sourceFolder);
            }
            catch (IOException iOException) {
                logger.c((Object)("Could not delete all workspace files, reason: " + iOException.getMessage()), (Throwable)iOException);
            }
            this.callback.workspaceMoved();
        }
    }
}

