/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.rcp.base.helper;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.co.b;
import ch.ionesoft.ilp.base.co.p;
import ch.ionesoft.ilp.book.mo.IAMessage;
import ch.ionesoft.ilp.book.mo.ILPCourseDef;
import ch.ionesoft.ilp.book.msg.m;
import ch.ionesoft.ilp.book.pe.f;
import ch.ionesoft.ilp.book.pe.j;
import ch.ionesoft.ilp.co.ILPViewRegistry;
import ch.ionesoft.ilp.co.a;
import ch.ionesoft.ilp.rcp.base.d;
import ch.ionesoft.ilp.rcp.base.helper.RCPCatalogPerspectiveBuilder;
import com.nimbusds.oauth2.sdk.util.StringUtils;
import jakarta.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.SystemUtils;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.MCommandsFactory;
import org.eclipse.e4.ui.model.application.commands.MHandler;
import org.eclipse.e4.ui.model.application.commands.MParameter;
import org.eclipse.e4.ui.model.application.commands.impl.CommandsFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.SideValue;
import org.eclipse.e4.ui.model.application.ui.advanced.MAdvancedFactory;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.basic.MBasicFactory;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.ItemType;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuFactory;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarElement;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarSeparator;
import org.eclipse.e4.ui.model.application.ui.menu.MToolItem;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class RCPPerspectiveHelper
extends a {
    private static final String TABBAR_TOOLBAR_ID = "toolbar:org.eclipse.ui.main.toolbar.tabBar";
    private static final String APPLICATION_MODEL = "Application.e4xmi";
    private static ILogger logger = ILPLogManager.getLogger(RCPPerspectiveHelper.class);
    @Inject
    private MApplication application;
    @Inject
    private EModelService modelService;
    @Inject
    protected EPartService partService;
    @Inject
    IEclipseContext context;
    ch.ionesoft.ilp.view.d portalHolder;
    public static String portalPerspectiveId = "ch.ionesoft.ilp.rcp.application.beook.handledtoolitem.Portal";

    public RCPPerspectiveHelper(MApplication mApplication, EModelService eModelService, EPartService ePartService, IEclipseContext iEclipseContext) {
        this.initializeHelper(mApplication, eModelService, ePartService, iEclipseContext);
    }

    private void initializeHelper(MApplication mApplication, EModelService eModelService, EPartService ePartService, IEclipseContext iEclipseContext) {
        this.application = mApplication;
        this.setModelService(eModelService);
        this.partService = ePartService;
        this.context = iEclipseContext;
    }

    public MApplication getApplication() {
        return this.application;
    }

    MPerspective createPerspective(String string, String string2) {
        MPerspectiveStack mPerspectiveStack = this.getPerspectiveStack(string2);
        MPerspective mPerspective = MAdvancedFactory.INSTANCE.createPerspective();
        mPerspective.setElementId(string);
        mPerspectiveStack.getChildren().add(mPerspective);
        return mPerspective;
    }

    private MPerspectiveStack getPerspectiveStack(String string) {
        MWindow mWindow = this.getMainWindow(string);
        List list = this.getModelService().findElements((MUIElement)mWindow, null, MPerspectiveStack.class, null);
        if (list.size() > 0) {
            return (MPerspectiveStack)list.get(0);
        }
        return null;
    }

    public MWindow getMainWindow(String string) {
        return (MWindow)this.getModelService().find(string, (MUIElement)this.application);
    }

    public MTrimBar getTrim() {
        MTrimmedWindow mTrimmedWindow = (MTrimmedWindow)this.application.getChildren().get(0);
        return this.getModelService().getTrim(mTrimmedWindow, SideValue.LEFT);
    }

    public boolean hasElementWithId(String string) {
        if (this.getModelService() != null && this.application != null) {
            MUIElement mUIElement = this.getModelService().find(string, (MUIElement)this.application);
            return mUIElement != null;
        }
        return false;
    }

    public MPerspective perspectiveWithId(String string) {
        if (this.getModelService() != null && this.application != null) {
            MUIElement mUIElement = this.getModelService().find(string, (MUIElement)this.application);
            if (mUIElement == null) {
                logger.c((Object)("No perspective found with id: " + string));
                return null;
            }
            MPerspective mPerspective = this.getModelService().getPerspectiveFor(mUIElement);
            return mPerspective;
        }
        return null;
    }

    public void selectPerspectiveWithId(String string) {
        try {
            Object object;
            Object object2;
            ILPViewRegistry.f().a(string);
            MPerspective mPerspective = this.perspectiveWithId(string);
            if (mPerspective != null) {
                object2 = ((EObject)mPerspective).eContainer();
                if (object2 instanceof MPerspectiveStack && (object = (MPerspectiveStack)object2) != null) {
                    object.setSelectedElement((MUIElement)mPerspective);
                }
            } else {
                logger.c((Object)("No perspective found with id: " + string));
            }
            this.deselectAllTabbarItems();
            object2 = (String)mPerspective.getProperties().get("courseId");
            object = (String)mPerspective.getProperties().get("courseReference");
            String string2 = object2 != null ? (String)object2 + "_" + (String)object : (String)mPerspective.getProperties().get("elementId");
            String string3 = ch.ionesoft.ilp.base.co.f.b().c() + ".handledtoolitem." + string2;
            this.selectTabbarToolItem(string3);
            this.sendAnalyticsLog(string, (String)object2, (String)object);
            if (string.equals("ch.ionesoft.ilp.rcp.application.perspective.Dashboard")) {
                ILPViewRegistry.f().g().postEvent("dashboardOnFocus", new HashMap());
            }
        }
        catch (Exception exception) {
            logger.d((Object)("Could not select perspective with id: " + string), (Throwable)exception);
        }
    }

    private void sendAnalyticsLog(String string, String string2, String string3) {
        if (string.equals("ch.ionesoft.ilp.rcp.application.perspective.WebPage")) {
            ch.ionesoft.ilp.book.analytics.a.a().b("Webbrowser");
            return;
        }
        if (string.equals("ch.ionesoft.ilp.rcp.application.perspective.GlobalSearchWebPage")) {
            ch.ionesoft.ilp.book.analytics.a.a().b("GlobalSearch");
            return;
        }
    }

    MPartSashContainer createPartSashContainer(MPerspective mPerspective, String string) {
        MPartSashContainer mPartSashContainer = MBasicFactory.INSTANCE.createPartSashContainer();
        mPartSashContainer.setElementId(string);
        mPartSashContainer.setHorizontal(true);
        mPerspective.getChildren().add(mPartSashContainer);
        return mPartSashContainer;
    }

    MPartStack createPartStack(MPartSashContainer mPartSashContainer, String string) {
        MPartStack mPartStack = MBasicFactory.INSTANCE.createPartStack();
        mPartStack.setElementId(string);
        mPartSashContainer.getChildren().add(mPartStack);
        return mPartStack;
    }

    public MPartStack partStackWithId(String string, MPerspective mPerspective) {
        if (this.getModelService() != null && this.application != null) {
            MUIElement mUIElement = this.getModelService().find(string, (MUIElement)mPerspective);
            if (mUIElement == null) {
                logger.c((Object)("No partStack found with id: " + string + " in perspective: " + mPerspective.getElementId()));
            }
            if (mUIElement instanceof MPartStack) {
                return (MPartStack)mUIElement;
            }
            logger.c((Object)("Element mit id " + string + " in perspective: " + mPerspective.getElementId() + " is not a MPartStack: " + (mUIElement != null ? mUIElement.getClass().getName() : null)));
            return null;
        }
        return null;
    }

    MPart createPart(MElementContainer mElementContainer, String string, String string2, String string3, String string4, String string5) {
        MPart mPart = MBasicFactory.INSTANCE.createPart();
        mPart.setElementId(string);
        mPart.setTooltip(string2);
        if (string3 != null) {
            string3 = string3.replace("\\", "/");
            mPart.setIconURI(string3);
            mPart.getProperties().put("iconOn", string3);
        }
        if (string4 != null) {
            string4 = string4.replace("\\", "/");
            mPart.setIconURI(string4);
            mPart.getProperties().put("iconOff", string4);
        }
        mPart.setContributionURI(string5);
        mElementContainer.getChildren().add(mPart);
        return mPart;
    }

    private MPart partWithId(String string, MPerspective mPerspective) {
        MUIElement mUIElement = this.getModelService().find(string, (MUIElement)mPerspective);
        return (MPart)mUIElement;
    }

    public MPart partWithId(String string, String string2) {
        MPerspective mPerspective = this.perspectiveWithId(string2);
        MUIElement mUIElement = this.getModelService().find(string, (MUIElement)mPerspective);
        return (MPart)mUIElement;
    }

    public MPart partWithId(String string) {
        Bundle bundle = FrameworkUtil.getBundle(EPartService.class);
        BundleContext bundleContext = bundle.getBundleContext();
        IEclipseContext iEclipseContext = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
        EPartService ePartService = (EPartService)iEclipseContext.get(EPartService.class.getName());
        try {
            MPart mPart = ePartService.findPart(string);
            return mPart;
        }
        catch (IllegalStateException illegalStateException) {
            return null;
        }
    }

    private MUIElement uiElementWithId(String string, MPerspective mPerspective) {
        MUIElement mUIElement = this.getModelService().find(string, (MUIElement)mPerspective);
        return mUIElement;
    }

    MHandledToolItem createTabbarItem(String string, List<MParameter> list, String string2, String string3, MCommand mCommand, int n2, boolean bl) {
        if (string3 != null) {
            string3 = string3.replace("\\", "/");
        }
        MToolBar mToolBar = (MToolBar)this.getModelService().find(TABBAR_TOOLBAR_ID, (MUIElement)this.application);
        MHandledToolItem mHandledToolItem = MMenuFactory.INSTANCE.createHandledToolItem();
        mHandledToolItem.setElementId(ch.ionesoft.ilp.base.co.f.b().c() + ".handledtoolitem." + string);
        mHandledToolItem.setContributorURI("platform:/plugin/" + ch.ionesoft.ilp.base.co.f.b().c());
        mHandledToolItem.setTooltip(string2);
        if (StringUtils.isNotBlank((CharSequence)string3)) {
            mHandledToolItem.setIconURI(string3);
        } else {
            mHandledToolItem.setLabel(string2);
        }
        if (list != null) {
            mHandledToolItem.getParameters().addAll(list);
        }
        mHandledToolItem.setCommand(mCommand);
        mHandledToolItem.setEnabled(true);
        mHandledToolItem.setVisible(bl);
        mHandledToolItem.setToBeRendered(true);
        mHandledToolItem.setType(ItemType.PUSH);
        if (n2 > mToolBar.getChildren().size() - 1) {
            mToolBar.getChildren().add(mHandledToolItem);
        } else {
            mToolBar.getChildren().add(n2, mHandledToolItem);
        }
        mToolBar.setToBeRendered(true);
        return mHandledToolItem;
    }

    MHandledToolItem createFillerTabbarItemWithImage(String string) {
        if (string != null) {
            string = string.replace("\\", "/");
        }
        MToolBar mToolBar = (MToolBar)this.getModelService().find(TABBAR_TOOLBAR_ID, (MUIElement)this.application);
        MHandledToolItem mHandledToolItem = MMenuFactory.INSTANCE.createHandledToolItem();
        mHandledToolItem.setElementId("");
        mHandledToolItem.setContributorURI("platform:/plugin/" + ch.ionesoft.ilp.base.co.f.b().c());
        mHandledToolItem.setTooltip("");
        mHandledToolItem.setIconURI(string);
        mHandledToolItem.setEnabled(false);
        mHandledToolItem.setVisible(true);
        mHandledToolItem.setToBeRendered(true);
        mHandledToolItem.setType(ItemType.PUSH);
        mToolBar.getChildren().add(mHandledToolItem);
        mToolBar.setToBeRendered(true);
        return mHandledToolItem;
    }

    void removeToolbarItem(String string) {
        List<MToolItem> list = this.getTabbarItems(string);
        if (!list.isEmpty()) {
            for (MToolItem mToolItem : list) {
                mToolItem.setVisible(false);
            }
        }
    }

    MToolItem getTabbarItem(String string) {
        MToolBar mToolBar = (MToolBar)this.getModelService().find(TABBAR_TOOLBAR_ID, (MUIElement)this.application);
        MToolItem mToolItem = (MToolItem)this.getModelService().find(ch.ionesoft.ilp.base.co.f.b().c() + ".handledtoolitem." + string, (MUIElement)mToolBar);
        return mToolItem;
    }

    private List<MToolItem> getTabbarItems(String string) {
        MToolBar mToolBar = (MToolBar)this.getModelService().find(TABBAR_TOOLBAR_ID, (MUIElement)this.application);
        String string2 = ch.ionesoft.ilp.base.co.f.b().c() + ".handledtoolitem." + string;
        List list = this.getModelService().findElements((MUIElement)mToolBar, string2, MUIElement.class, null);
        ArrayList<MToolItem> arrayList = new ArrayList<MToolItem>();
        for (MUIElement mUIElement : list) {
            arrayList.add((MToolItem)mUIElement);
        }
        return arrayList;
    }

    public void changeVisibilityOfToolItem(String string, boolean bl) {
        MToolBar mToolBar = (MToolBar)this.getModelService().find(TABBAR_TOOLBAR_ID, (MUIElement)this.application);
        MToolItem mToolItem = (MToolItem)this.getModelService().find(ch.ionesoft.ilp.base.co.f.b().c() + ".handledtoolitem." + string, (MUIElement)mToolBar);
        if (mToolItem != null) {
            mToolItem.setVisible(bl);
        }
    }

    public void updateTabBarOrder() {
        List list;
        try {
            list = f.a().l();
        }
        catch (j j2) {
            logger.c((Object)"Could not fetch courses ordered by tab. Keep sequence, no update of order in tabbar.");
            return;
        }
        this.clearCoursesAndPortalFromTabbar();
        RCPCatalogPerspectiveBuilder rCPCatalogPerspectiveBuilder = (RCPCatalogPerspectiveBuilder)ILPViewRegistry.f().g().getPerspectiveBuilder();
        if (b.b().a("ILPView.dashboard.part.active", false)) {
            rCPCatalogPerspectiveBuilder.configurePerspectiveForDashboard();
        } else {
            rCPCatalogPerspectiveBuilder.configurePerspectiveForPortal();
        }
        int n2 = 2;
        for (ILPCourseDef iLPCourseDef : list) {
            if (iLPCourseDef.getTabOrder() == null || iLPCourseDef.getTabOrder() < 0) continue;
            String string = RCPPerspectiveHelper.perspectiveIdForCourse((ILPCourseDef)iLPCourseDef);
            MPerspective mPerspective = this.perspectiveWithId(string);
            rCPCatalogPerspectiveBuilder.createPerspectiveTabBarHolderAndTabItemForCourse(iLPCourseDef, n2, mPerspective, true);
            ++n2;
        }
    }

    public void refreshPortalIcon() {
    }

    private void clearCoursesAndPortalFromTabbar() {
        MToolBar mToolBar = (MToolBar)this.getModelService().find(TABBAR_TOOLBAR_ID, (MUIElement)this.application);
        MToolBarElement[] mToolBarElementArray = (MToolBarElement[])mToolBar.getChildren().toArray();
        ArrayList<MToolBarElement> arrayList = new ArrayList<MToolBarElement>();
        MToolBarElement[] mToolBarElementArray2 = mToolBarElementArray;
        int n2 = mToolBarElementArray.length;
        int n3 = 0;
        while (n3 < n2) {
            MToolBarElement mToolBarElement = mToolBarElementArray2[n3];
            String string = mToolBarElement.getElementId();
            if (!(string == null || string.endsWith("handledtoolitem.WebPage") || string.endsWith("handledtoolitem.GlobalSearchWebPage") || string.endsWith("handledtoolitem.SharingWebPage") || string.endsWith("handledtoolitem.ScenarioWebPage"))) {
                arrayList.add(mToolBarElement);
                mToolBarElement.setToBeRendered(false);
            }
            ++n3;
        }
        for (MToolBarElement mToolBarElement : arrayList) {
            mToolBar.getChildren().remove(mToolBarElement);
        }
    }

    void clearTabbar() {
        MToolBarElement[] mToolBarElementArray;
        MToolBar mToolBar = (MToolBar)this.getModelService().find(TABBAR_TOOLBAR_ID, (MUIElement)this.application);
        MToolBarElement[] mToolBarElementArray2 = mToolBarElementArray = (MToolBarElement[])mToolBar.getChildren().toArray();
        int n2 = mToolBarElementArray.length;
        int n3 = 0;
        while (n3 < n2) {
            MToolBarElement mToolBarElement = mToolBarElementArray2[n3];
            mToolBarElement.setParent(null);
            mToolBarElement.setToBeRendered(false);
            mToolBarElement.setVisible(false);
            ++n3;
        }
        for (MToolBarElement mToolBarElement : mToolBar.getChildren()) {
            mToolBar.getChildren().remove(mToolBarElement);
        }
        mToolBar.getChildren().clear();
    }

    public void createTabbarSeparator() {
        MToolBar mToolBar = (MToolBar)this.getModelService().find(TABBAR_TOOLBAR_ID, (MUIElement)this.application);
        MToolBarSeparator mToolBarSeparator = MMenuFactory.INSTANCE.createToolBarSeparator();
        mToolBar.getChildren().add(mToolBarSeparator);
    }

    private MHandledToolItem toolItemWithId(String string, String string2) {
        MToolBar mToolBar = (MToolBar)this.getModelService().find(string2, (MUIElement)this.application);
        for (MUIElement mUIElement : mToolBar.getChildren()) {
            if (!string.equals(mUIElement.getElementId()) || !(mUIElement instanceof MHandledToolItem)) continue;
            MHandledToolItem mHandledToolItem = (MHandledToolItem)mUIElement;
            return mHandledToolItem;
        }
        return null;
    }

    public void deselectAllTabbarItems() {
        this.deselectAllToolItems(TABBAR_TOOLBAR_ID);
    }

    private void deselectAllToolItems(String string) {
        MToolBar mToolBar = (MToolBar)this.getModelService().find(string, (MUIElement)this.application);
        for (MUIElement mUIElement : mToolBar.getChildren()) {
            if (!(mUIElement instanceof MHandledToolItem)) continue;
            MHandledToolItem mHandledToolItem = (MHandledToolItem)mUIElement;
            String string2 = null;
            string2 = this.portalHolder != null && this.portalHolder.j() && portalPerspectiveId.equals(mHandledToolItem.getElementId()) && this.hasUnreadMessages() ? this.getParameterWithId(mHandledToolItem.getParameters(), "ch.ionesoft.ilp.rcp.application.parameter.iconURI.unread.deselected") : this.getParameterWithId(mHandledToolItem.getParameters(), "ch.ionesoft.ilp.rcp.application.parameter.iconURI.deselected");
            if (string2 == null) continue;
            mHandledToolItem.setIconURI(string2);
        }
    }

    private void selectTabbarToolItem(String string) {
        MHandledToolItem mHandledToolItem = this.toolItemWithId(string, TABBAR_TOOLBAR_ID);
        if (mHandledToolItem == null) {
            return;
        }
        String string2 = null;
        string2 = this.portalHolder != null && this.portalHolder.j() && portalPerspectiveId.equals(mHandledToolItem.getElementId()) && this.hasUnreadMessages() ? this.getParameterWithId(mHandledToolItem.getParameters(), "ch.ionesoft.ilp.rcp.application.parameter.iconURI.unread.selected") : this.getParameterWithId(mHandledToolItem.getParameters(), "ch.ionesoft.ilp.rcp.application.parameter.iconURI.selected");
        if (string2 != null) {
            mHandledToolItem.setIconURI(string2);
        }
    }

    private void selectMasterViewPart(MPart mPart) {
        RCPCatalogPerspectiveBuilder rCPCatalogPerspectiveBuilder = (RCPCatalogPerspectiveBuilder)ILPViewRegistry.f().g().getPerspectiveBuilder();
        rCPCatalogPerspectiveBuilder.turnMasterViewStackIconsOff();
        if (mPart != null) {
            try {
                if (this.isWindowActive()) {
                    this.partService.bringToTop(mPart);
                }
            }
            catch (Exception exception) {
                logger.c((Object)("Could not bring part " + mPart.getElementId() + " to top. " + String.valueOf(exception)));
            }
            this.turnMasterViewPartIconOn(mPart.getElementId());
        }
    }

    void turnMasterViewPartIconOff(String string) {
    }

    public void turnMasterViewPartIconOn(String string) {
    }

    public void selectPartWithId(String string, String string2, String string3) {
        MPerspective mPerspective = this.perspectiveWithId(string);
        if (mPerspective != null) {
            this.focusOn((MUIElement)mPerspective);
            EObject eObject = ((EObject)mPerspective).eContainer();
            if (eObject instanceof MPerspectiveStack) {
                MPart mPart = this.partWithId(string2, mPerspective);
                this.selectMasterViewPart(mPart);
            }
        } else {
            logger.c((Object)("No perspective found with id: " + string));
        }
    }

    private void focusOn(MUIElement mUIElement) {
        try {
            if (mUIElement != null && mUIElement.getWidget() != null) {
                ((Control)mUIElement.getWidget()).forceFocus();
            }
        }
        catch (Exception exception) {
            logger.c((Object)("Could not focus on element: " + mUIElement.getElementId() + ". " + exception.getLocalizedMessage()));
        }
    }

    public boolean isWindowActive() {
        return this.application.getContext().getActiveChild() != null && this.application.getContext().getActiveChild().get(EPartService.class) != null && this.application.getContext().getActiveChild().get(EPartService.class) != this.partService;
    }

    public MUIElement enableUIElementtWithId(String string, String string2, boolean bl) {
        MPerspective mPerspective = this.perspectiveWithId(string);
        if (mPerspective != null) {
            MUIElement mUIElement;
            EObject eObject = ((EObject)mPerspective).eContainer();
            if (eObject instanceof MPerspectiveStack && (mUIElement = this.uiElementWithId(string2, mPerspective)) != null) {
                mUIElement.setVisible(bl);
                mUIElement.setOnTop(bl);
                return mUIElement;
            }
        } else {
            logger.c((Object)("No perspective found with id: " + string));
        }
        return null;
    }

    MParameter createParameter(String string, String string2, String string3) {
        MParameter mParameter = CommandsFactoryImpl.eINSTANCE.createParameter();
        mParameter.setElementId(string);
        mParameter.setName(string2);
        mParameter.setValue(string3);
        mParameter.setContributorURI("platform:/plugin/" + ch.ionesoft.ilp.base.co.f.b().c());
        return mParameter;
    }

    private String getParameterWithId(List<MParameter> list, String string) {
        for (MParameter mParameter : list) {
            if (!mParameter.getElementId().equals(string)) continue;
            return mParameter.getValue();
        }
        return null;
    }

    public MCommand createCommand(String string, String string2, String string3, String string4) {
        MCommand mCommand = MCommandsFactory.INSTANCE.createCommand();
        mCommand.setCommandName(string2);
        mCommand.setElementId(string);
        this.application.getCommands().add(mCommand);
        MHandler mHandler = MCommandsFactory.INSTANCE.createHandler();
        mHandler.setCommand(mCommand);
        String string5 = "";
        mHandler.setContributionURI("bundleclass://" + string4 + "/" + string3);
        mHandler.setElementId(string4 + ".handler." + string2);
        this.application.getHandlers().add(mHandler);
        return mCommand;
    }

    MCommand getCommandById(String string) {
        List list = this.application.getCommands();
        if (list != null) {
            for (MCommand mCommand : list) {
                if (!string.equals(mCommand.getElementId())) continue;
                return mCommand;
            }
        }
        return null;
    }

    public void executeCommand(String string) {
        try {
            if (this.context == null) {
                logger.c((Object)("Context is null, cannot execute command: " + string));
                return;
            }
            ECommandService eCommandService = (ECommandService)this.context.get(ECommandService.class);
            EHandlerService eHandlerService = (EHandlerService)this.context.get(EHandlerService.class);
            if (eCommandService != null) {
                ParameterizedCommand parameterizedCommand = eCommandService.createCommand(string, null);
                Object object = eHandlerService.executeHandler(parameterizedCommand);
            } else {
                logger.d((Object)("Could not execute command: " + string + " due to commandService is null"));
            }
        }
        catch (Exception exception) {
            logger.d((Object)("Could not execute command: " + string), (Throwable)exception);
        }
    }

    public d createBrowser(Composite composite, final String string) {
        try {
            d d2 = d.a(composite, 0, string);
            if (d2.a()) {
                d2.a((SWTEventListener)new OpenWindowListener(){

                    public void open(WindowEvent windowEvent) {
                        if (!windowEvent.required) {
                            return;
                        }
                        Shell shell = new Shell(windowEvent.display);
                        shell.setText("New Window");
                        shell.setLayout((Layout)new FillLayout());
                        d d2 = RCPPerspectiveHelper.this.createBrowser((Composite)shell, string);
                        windowEvent.browser = d2.c();
                    }
                });
            } else {
                d2.d().handleOpenWindowEvents(string);
            }
            d2.a(new VisibilityWindowListener(){

                public void hide(WindowEvent windowEvent) {
                    d d2 = new d(windowEvent.widget);
                    Shell shell = d2.ad();
                    shell.setVisible(false);
                }

                public void show(WindowEvent windowEvent) {
                    d d2 = new d(windowEvent.widget);
                    Shell shell = d2.ad();
                    if (windowEvent.location != null) {
                        shell.setLocation(windowEvent.location);
                    }
                    if (windowEvent.size != null) {
                        Point point = windowEvent.size;
                        shell.setSize(shell.computeSize(point.x, point.y));
                    }
                    if (!(windowEvent.addressBar || windowEvent.menuBar || windowEvent.statusBar)) {
                        boolean cfr_ignored_0 = windowEvent.toolBar;
                    }
                    shell.open();
                }
            });
            d2.a(new CloseWindowListener(){

                public void close(WindowEvent windowEvent) {
                    d d2;
                    if (SystemUtils.IS_OS_MAC && !(d2 = new d(windowEvent.widget)).I()) {
                        Shell shell = d2.ad();
                        shell.close();
                    }
                }
            });
            return d2;
        }
        catch (SWTError sWTError) {
            logger.d((Object)("Could not instantitate browser with type: " + p.a().c("browserType") + ". Reason: " + sWTError.getMessage()), (Throwable)sWTError);
            ch.ionesoft.ilp.base.co.f.b().D().alertNoticeCode("message.browser.failed", new Object[0]);
            return null;
        }
    }

    public void saveApplicationModel() {
        ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
        URI uRI = URI.createPlatformResourceURI((String)(ch.ionesoft.ilp.base.co.f.b().c() + "/Application.e4xmi"), (boolean)true);
        Resource resource = resourceSetImpl.createResource(uRI);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("ENCODING", "UTF-8");
        try {
            resource.save(hashMap);
        }
        catch (IOException iOException) {
            logger.c((Object)("Could not save application model: " + iOException.getMessage()), (Throwable)iOException);
        }
    }

    void restartWorkbench() {
        try {
            this.executeCommand("ch.ionesoft.ilp.rcp.application.command.restartWorkbench");
        }
        catch (Exception exception) {
            logger.d((Object)("Could not invoke restartWorkbench command: " + exception.getMessage()), (Throwable)exception);
        }
    }

    public void quitWorkbench() {
        try {
            this.executeCommand("org.eclipse.ui.file.exit");
        }
        catch (Exception exception) {
            logger.d((Object)("Could not invoke quitWorkbench command: " + exception.getMessage()), (Throwable)exception);
        }
    }

    public void releaseHelper() {
    }

    public EModelService getModelService() {
        return this.modelService;
    }

    public void setModelService(EModelService eModelService) {
        this.modelService = eModelService;
    }

    public void disableSidebar(boolean bl) {
        MToolBar mToolBar = (MToolBar)this.getModelService().find(TABBAR_TOOLBAR_ID, (MUIElement)this.application);
        List list = mToolBar.getChildren();
        for (MToolBarElement mToolBarElement : list) {
            if (bl) {
                if (portalPerspectiveId.equals(mToolBarElement.getElementId())) continue;
                mToolBarElement.setVisible(false);
                continue;
            }
            mToolBarElement.setVisible(false);
        }
    }

    public void enableSidebar() {
        MToolBar mToolBar = (MToolBar)this.getModelService().find(TABBAR_TOOLBAR_ID, (MUIElement)this.application);
        mToolBar.setVisible(true);
        List list = mToolBar.getChildren();
        for (MToolBarElement mToolBarElement : list) {
            mToolBarElement.setVisible(true);
        }
    }

    public void setPortalHolder(ch.ionesoft.ilp.view.d d2) {
        this.portalHolder = d2;
    }

    public void checkForUnreadNotifications() {
        try {
            List<Integer> list = Arrays.asList(m.e.a(), m.f.a(), m.g.a(), m.h.a(), m.i.a(), m.j.a());
            long l2 = f.a().a(IAMessage.PresentationStatus.PRESENTATION_STATUS_UNREAD, list);
            if (l2 > 0L) {
                this.setHasUnreadMessages(true);
                return;
            }
        }
        catch (Exception exception) {
            logger.d((Object)"Could not check number of unread notifications in db", (Throwable)exception);
        }
        this.setHasUnreadMessages(false);
    }

    public void updatePoralIcon(boolean bl) {
        try {
            if (!this.portalHolder.j()) {
                return;
            }
            bl = "ch.ionesoft.ilp.rcp.application.perspective.PortalCourse".equals(ILPViewRegistry.f().j());
            MHandledToolItem mHandledToolItem = this.toolItemWithId(portalPerspectiveId, TABBAR_TOOLBAR_ID);
            if (mHandledToolItem == null) {
                return;
            }
            String string = "";
            string = this.hasUnreadMessages() ? (bl ? this.getParameterWithId(mHandledToolItem.getParameters(), "ch.ionesoft.ilp.rcp.application.parameter.iconURI.unread.selected") : this.getParameterWithId(mHandledToolItem.getParameters(), "ch.ionesoft.ilp.rcp.application.parameter.iconURI.unread.deselected")) : (bl ? this.getParameterWithId(mHandledToolItem.getParameters(), "ch.ionesoft.ilp.rcp.application.parameter.iconURI.selected") : this.getParameterWithId(mHandledToolItem.getParameters(), "ch.ionesoft.ilp.rcp.application.parameter.iconURI.deselected"));
            if (string != null) {
                mHandledToolItem.setIconURI(string);
            }
        }
        catch (Exception exception) {
            logger.d((Object)"Could not update portalIcon", (Throwable)exception);
        }
    }
}

