/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.rcp.base.helper;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.co.f;
import ch.ionesoft.ilp.book.co.ILPProfileManager;
import ch.ionesoft.ilp.book.pe.g;
import ch.ionesoft.ilp.co.ILPViewRegistry;
import ch.ionesoft.ilp.rcp.base.a;
import ch.ionesoft.ilp.rcp.base.b;
import ch.ionesoft.ilp.rcp.base.ca.c;
import ch.ionesoft.ilp.rcp.base.dialogs.s;
import ch.ionesoft.ilp.rcp.base.helper.RCPPerspectiveHelper;
import ch.ionesoft.ilp.rcp.config.RCPPerspectiveViewBuilder;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Font;
import org.osgi.framework.BundleContext;

public class RCPApplicationConfig {
    private static ILogger logger = ILPLogManager.getLogger(RCPApplicationConfig.class);
    private static RCPApplicationConfig sharedInstance = new RCPApplicationConfig();
    private boolean restartRequired;
    private boolean shutdownRequested;
    private IPreferenceStore preferencesStore;
    private BundleContext bundleContext;
    private a masterViewBuilder;
    private a detailViewBuilder;
    private a portalViewBuilder;
    private s dialogViewBuilder;
    private RCPPerspectiveViewBuilder perspectiveViewBuilder;
    private c resourceLoadingCache = new c();
    private b angularWebSocketAdapter;

    public static RCPApplicationConfig instance() {
        return sharedInstance;
    }

    public Font getMasterViewToolbarFont() {
        String string = SystemUtils.IS_OS_WINDOWS ? "Tahoma" : "Lucida Grande";
        int n2 = SystemUtils.IS_OS_WINDOWS ? 11 : 12;
        return org.eclipse.wb.swt.b.a(string, n2, 0);
    }

    public Font getMasterViewIssueTitleLabelFont() {
        String string = SystemUtils.IS_OS_WINDOWS ? "Tahoma" : "Lucida Grande";
        int n2 = SystemUtils.IS_OS_WINDOWS ? 11 : 12;
        return org.eclipse.wb.swt.b.a(string, n2, 0);
    }

    public Font getMasterViewCourseEditionLabelFont() {
        String string = SystemUtils.IS_OS_WINDOWS ? "Tahoma" : "Lucida Grande";
        int n2 = SystemUtils.IS_OS_WINDOWS ? 9 : 10;
        return org.eclipse.wb.swt.b.a(string, n2, 0);
    }

    public Font getMasterViewCourseTitleLabelFont() {
        String string = SystemUtils.IS_OS_WINDOWS ? "Tahoma" : "Lucida Grande";
        int n2 = SystemUtils.IS_OS_WINDOWS ? 11 : 12;
        return org.eclipse.wb.swt.b.a(string, n2, 1);
    }

    public Font getSearchViewTitleCellFont() {
        String string = SystemUtils.IS_OS_WINDOWS ? "Tahoma" : "Lucida Grande";
        int n2 = SystemUtils.IS_OS_WINDOWS ? 11 : 12;
        return org.eclipse.wb.swt.b.a(string, n2, 1);
    }

    public Font getSearchViewTextCellFont() {
        String string = SystemUtils.IS_OS_WINDOWS ? "Tahoma" : "Lucida Grande";
        int n2 = SystemUtils.IS_OS_WINDOWS ? 10 : 10;
        return org.eclipse.wb.swt.b.a(string, n2, 0);
    }

    public Font getExerciseViewTextCellFont() {
        String string = SystemUtils.IS_OS_WINDOWS ? "Tahoma" : "Lucida Grande";
        int n2 = SystemUtils.IS_OS_WINDOWS ? 11 : 12;
        return org.eclipse.wb.swt.b.a(string, n2, 0);
    }

    public Font getResourceViewTextCellFont() {
        String string = SystemUtils.IS_OS_WINDOWS ? "Tahoma" : "Lucida Grande";
        int n2 = SystemUtils.IS_OS_WINDOWS ? 11 : 12;
        return org.eclipse.wb.swt.b.a(string, n2, 0);
    }

    public Font getDialogTitleLabelFont() {
        String string = SystemUtils.IS_OS_WINDOWS ? "Tahoma" : "Lucida Grande";
        int n2 = SystemUtils.IS_OS_WINDOWS ? 12 : 13;
        return org.eclipse.wb.swt.b.a(string, n2, 1);
    }

    public Font getDialogTextLabelFont() {
        String string = SystemUtils.IS_OS_WINDOWS ? "Tahoma" : "Lucida Grande";
        int n2 = SystemUtils.IS_OS_WINDOWS ? 11 : 12;
        return org.eclipse.wb.swt.b.a(string, n2, 0);
    }

    private RCPPerspectiveHelper getPerspectiveHelper() {
        return (RCPPerspectiveHelper)ILPViewRegistry.f().l();
    }

    public static String courseIdForPerspective(MPerspective mPerspective) {
        String string = RCPApplicationConfig.getPropertyForPerspective(mPerspective, "courseId");
        return string;
    }

    public static String courseReferenceForPerspective(MPerspective mPerspective) {
        String string = RCPApplicationConfig.getPropertyForPerspective(mPerspective, "courseReference");
        return string;
    }

    public static int tocAutoExpandLevelForTopicsInPerspective(MPerspective mPerspective) {
        String string = RCPApplicationConfig.getPropertyForPerspective(mPerspective, "tocAutoExpandLevel");
        if (StringUtils.isNotBlank((CharSequence)string)) {
            return Integer.parseInt(string);
        }
        return 1;
    }

    public static int tocAutoExpandLevelForExercisesInPerspective(MPerspective mPerspective) {
        String string = RCPApplicationConfig.getPropertyForPerspective(mPerspective, "tocExerciseAutoExpandLevel");
        if (StringUtils.isNotBlank((CharSequence)string)) {
            return Integer.parseInt(string);
        }
        return RCPApplicationConfig.tocAutoExpandLevelForTopicsInPerspective(mPerspective);
    }

    public static String tocContentProviderForPerspective(MPerspective mPerspective) {
        return "ILPTopicTreeViewContentProvider";
    }

    public static String tocLabelProviderForPerspective(MPerspective mPerspective) {
        return "ILPTopicLabelProvider";
    }

    private static String getPropertyForPerspective(MPerspective mPerspective, String string) {
        return (String)mPerspective.getProperties().get(string);
    }

    public static boolean tocShowAccessPath(MPerspective mPerspective) {
        String string = RCPApplicationConfig.getPropertyForPerspective(mPerspective, "tocShowLabelAccessPath");
        return Boolean.parseBoolean(string);
    }

    public boolean isRestartRequired() {
        return this.restartRequired;
    }

    public void setRestartRequired(boolean bl) {
        this.restartRequired = bl;
    }

    public void restartIfRequired(String string) {
        if (this.isRestartRequired() && ILPProfileManager.instance().hasProfileWithEnvironment()) {
            this.restartRequired = false;
            if (f.b().D().askCode(string, new Object[0])) {
                this.restartApplication();
            }
        }
    }

    void restartApplication() {
        logger.b((Object)"Restarting application");
        ch.ionesoft.ilp.book.analytics.a.a().c();
        if (this.getPerspectiveHelper() != null) {
            this.getPerspectiveHelper().restartWorkbench();
        }
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    logger.b((Object)"Scheduled terminator in 15000ms");
                    Thread.sleep(15000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                g.a().c();
                System.exit(0);
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    public void forceRestart() {
        f.b().D().alertNoticeCodeAsync("label.workspace.forceRestart");
        this.restartApplication();
    }

    public IPreferenceStore getPreferencesStore() {
        return this.preferencesStore;
    }

    public void setPreferencesStore(IPreferenceStore iPreferenceStore) {
        this.preferencesStore = iPreferenceStore;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public a getPortalViewBuilder() {
        return this.portalViewBuilder;
    }

    public void setPortalViewBuilder(a a2) {
        this.portalViewBuilder = a2;
    }

    public a getMasterViewBuilder() {
        return this.masterViewBuilder;
    }

    public void setMasterViewBuilder(a a2) {
        this.masterViewBuilder = a2;
    }

    public a getDetailViewBuilder() {
        return this.detailViewBuilder;
    }

    public void setDetailViewBuilder(a a2) {
        this.detailViewBuilder = a2;
    }

    public s getDialogViewBuilder() {
        return this.dialogViewBuilder;
    }

    public void setDialogViewBuilder(s s2) {
        this.dialogViewBuilder = s2;
    }

    public RCPPerspectiveViewBuilder getPerspectiveViewBuilder() {
        return this.perspectiveViewBuilder;
    }

    public void setPerspectiveViewBuilder(RCPPerspectiveViewBuilder rCPPerspectiveViewBuilder) {
        this.perspectiveViewBuilder = rCPPerspectiveViewBuilder;
    }

    public c getResourceLoadingCache() {
        return this.resourceLoadingCache;
    }

    public b getAngularWebSocketAdapter() {
        return this.angularWebSocketAdapter;
    }

    public void setAngularWebSocketAdapter(b b2) {
        this.angularWebSocketAdapter = b2;
    }

    public boolean isShutdownRequested() {
        return this.shutdownRequested;
    }

    public void setShutdownRequested(boolean bl) {
        this.shutdownRequested = bl;
    }
}

