/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.rcp.application.preferences;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.co.f;
import ch.ionesoft.ilp.base.co.o;
import ch.ionesoft.ilp.base.he.StringHelper;
import ch.ionesoft.ilp.book.cl.g;
import ch.ionesoft.ilp.book.co.ILPBookHelper;
import ch.ionesoft.ilp.book.co.ILPBookRegistry;
import ch.ionesoft.ilp.book.co.ILPBookSettingsHelper;
import ch.ionesoft.ilp.book.co.ILPInitializer;
import ch.ionesoft.ilp.book.co.ILPProfileManager;
import ch.ionesoft.ilp.book.msg.q;
import ch.ionesoft.ilp.book.syn.d;
import ch.ionesoft.ilp.rcp.base.helper.RCPApplicationConfig;
import ch.ionesoft.ilp.rcp.base.helper.RCPWorkspaceHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Label;

public class SynchronizationPreferencePage
extends FieldEditorPreferencePage {
    private static ILogger logger = ILPLogManager.getLogger(SynchronizationPreferencePage.class);
    private RadioGroupFieldEditor cloudServiceGroup;
    RCPWorkspaceHelper workspaceHelper = new RCPWorkspaceHelper();
    private Label cloudRootDirLabel;
    private g.a previousCloudService;

    public SynchronizationPreferencePage() {
        super(1);
        this.setPreferenceStore(RCPApplicationConfig.instance().getPreferencesStore());
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(o.a().d("label.synchronization.settings.description"));
        stringBuffer.append("\n\n" + o.a().d("ALL_CLOUD_FOOTER"));
        this.setDescription(stringBuffer.toString());
        this.noDefaultAndApplyButton();
        this.previousCloudService = ILPBookSettingsHelper.instance().getCloudServiceType();
    }

    public void createFieldEditors() {
        GridData gridData = new GridData(4, 4, true, false);
        gridData.horizontalSpan = 3;
        GridData gridData2 = new GridData(131072, 4, true, false);
        gridData2.horizontalSpan = 3;
        boolean bl = ILPBookSettingsHelper.instance().supportsAnyCloud();
        if (bl) {
            String[][] stringArray;
            List list = ILPBookSettingsHelper.instance().supportedCloudServices(true);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                stringArray = (String[][])iterator.next();
                if (stringArray != g.a.b) continue;
                iterator.remove();
            }
            stringArray = new String[list.size()][2];
            int n2 = 0;
            for (g.a a2 : list) {
                try {
                    stringArray[n2][0] = a2.a();
                    stringArray[n2][1] = a2.name();
                    ++n2;
                }
                catch (Exception exception) {
                    logger.d((Object)("Undefined cloud service: " + String.valueOf(a2)));
                }
            }
            this.cloudServiceGroup = new RadioGroupFieldEditor("cloud.service.linked", "\n" + o.a().d("CLOUD_SERVICES"), 1, stringArray, this.getFieldEditorParent(), true);
            this.addField((FieldEditor)this.cloudServiceGroup);
        }
        this.addField((FieldEditor)new RadioGroupFieldEditor("ebook.synchronize", "\n" + o.a().d("CLOUD_SYNCINTERVAL_TITLE"), 1, (String[][])new String[][]{{o.a().d("EBOOK_SYNCHRONIZE_ON_LEAVE"), "EBOOK_SYNCHRONIZE_ON_LEAVE"}, {o.a().d("EBOOK_SYNCHRONIZE_MANUALLY"), "EBOOK_SYNCHRONIZE_MANUALLY"}}, this.getFieldEditorParent(), true));
        this.addField((FieldEditor)new BooleanFieldEditor("cloud.sync.media", o.a().d("label.copyMediaToCloud"), this.getFieldEditorParent()));
    }

    public boolean performOk() {
        this.performApply();
        boolean bl = super.performOk();
        return bl;
    }

    protected void performApply() {
        if (this.cloudServiceGroup != null) {
            Object object;
            this.cloudServiceGroup.store();
            String string = this.cloudServiceGroup.getPreferenceStore().getString("cloud.service.linked");
            g.a a2 = g.a.valueOf((String)string);
            ArrayList arrayList = new ArrayList();
            if (!ILPBookHelper.isCloudAllowedForReason((g.a)a2, arrayList)) {
                logger.b((Object)("Disabling cloud due to: " + StringHelper.convertArrayToSeparatedString_separator(arrayList, (String)",")));
                ILPBookSettingsHelper.instance().setCloudServiceType(g.a.a);
                ILPProfileManager.instance().getCurrentProfile().setUseCloud(Boolean.valueOf(false));
                ILPProfileManager.instance().saveCurrentProfile();
                q.a().c();
                if (arrayList.size() > 0) {
                    object = (String)arrayList.get(0);
                    f.b().D().say((String)object, new Object[]{o.a().d("label.ok")});
                }
            } else {
                ILPBookSettingsHelper.instance().setCloudServiceType(a2);
                logger.b((Object)("Enabling cloud to: " + String.valueOf(a2)));
                object = ch.ionesoft.ilp.rcp.base.cl.d.a().a(a2, this.getShell());
                this.applyCloudRootDir((File)object);
                logger.b((Object)("Set Cloud Root Dir to: " + ILPBookSettingsHelper.instance().getCloudRootDirectory()));
                ILPProfileManager.instance().getCurrentProfile().setUseCloud(Boolean.valueOf(true));
                ILPProfileManager.instance().saveCurrentProfile();
                ILPBookRegistry.instance().getCloudService().a();
                ILPInitializer.instance().initializeSharingAndSynchronizeGroups();
                this.synchronizeCloud();
                q.a().b();
            }
            object = RCPApplicationConfig.instance().getPreferencesStore();
            object.setValue("cloud.service.linked", ILPBookSettingsHelper.instance().getCloudServiceType().name());
        }
    }

    protected void applyCloudRootDir(File file) {
        if (file != null) {
            ILPBookSettingsHelper.instance().setCloudRootDirectory(file.getAbsolutePath());
            if (this.cloudRootDirLabel != null) {
                this.cloudRootDirLabel.setText(file.getAbsolutePath());
            }
        } else if (this.cloudRootDirLabel != null) {
            this.cloudRootDirLabel.setText("");
        }
        if (this.cloudRootDirLabel != null) {
            this.cloudRootDirLabel.getParent().layout();
        }
    }

    protected void synchronizeCloud() {
        g.a a2 = ILPBookSettingsHelper.instance().getCloudServiceType();
        if (this.previousCloudService != a2) {
            d.a().c();
        }
        if (a2 != g.a.a) {
            if (this.previousCloudService != a2) {
                f.b().D().alertNoticeCode("message.cloud.linked.successfully", new Object[0]);
                d.a().a(false, false);
            }
        } else if (this.previousCloudService != g.a.a && a2 == g.a.a) {
            f.b().D().alertNoticeCode("message.cloud.unlinked.successfully", new Object[0]);
        }
    }

    public String init(String string) {
        return "";
    }
}

