/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.rcp.application.listeners;

import java.util.Map;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class DropdownSelectionListener
extends SelectionAdapter
implements MouseListener {
    private Widget dropdown;
    private Menu menu;
    private Menu subMenu;
    private DropdownSelectionDelegate delegate;

    public DropdownSelectionListener(Widget widget, DropdownSelectionDelegate dropdownSelectionDelegate) {
        this.dropdown = widget;
        this.delegate = dropdownSelectionDelegate;
        Shell shell = null;
        if (widget instanceof Control) {
            shell = ((Control)widget).getShell();
        } else if (widget instanceof ToolItem) {
            shell = ((ToolItem)widget).getParent().getShell();
        }
        this.menu = new Menu((Control)shell);
    }

    public void clearItems() {
        MenuItem[] menuItemArray = this.menu.getItems();
        int n2 = menuItemArray.length;
        int n3 = 0;
        while (n3 < n2) {
            MenuItem menuItem = menuItemArray[n3];
            menuItem.dispose();
            ++n3;
        }
    }

    public void add(String string, String string2) {
        this.add(string, string2, null);
    }

    public void add(String string, String string2, Map<String, Object> map) {
        this.add(string, string2, map, this.menu);
    }

    private void add(String string, final String string2, final Map<String, Object> map, Menu menu) {
        MenuItem menuItem = new MenuItem(menu, 0);
        menuItem.setText(string);
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Item item;
                MenuItem menuItem = (MenuItem)selectionEvent.widget;
                if (DropdownSelectionListener.this.dropdown instanceof Item && (item = (Item)DropdownSelectionListener.this.dropdown).getImage() == null) {
                    ((Item)DropdownSelectionListener.this.dropdown).setText(menuItem.getText());
                }
                if (DropdownSelectionListener.this.delegate != null) {
                    DropdownSelectionListener.this.delegate.selectedCommand(DropdownSelectionListener.this, string2, map);
                }
            }
        });
    }

    public void createSubMenu(String string) {
        MenuItem menuItem = new MenuItem(this.menu, 64);
        menuItem.setText(string);
        Menu menu = new Menu(menuItem);
        menuItem.setMenu(menu);
        this.subMenu = menu;
    }

    public void addToSubMenu(String string, String string2) {
        this.addToSubMenu(string, string2, null);
    }

    public void addToSubMenu(String string, String string2, Map<String, Object> map) {
        if (this.subMenu != null) {
            this.add(string, string2, map, this.subMenu);
        }
    }

    public void enableItem(String string, boolean bl) {
        MenuItem[] menuItemArray = this.menu.getItems();
        int n2 = menuItemArray.length;
        int n3 = 0;
        while (n3 < n2) {
            MenuItem menuItem = menuItemArray[n3];
            if (menuItem.getText().equals(string)) {
                menuItem.setEnabled(bl);
            }
            ++n3;
        }
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        ToolBar toolBar;
        Rectangle rectangle;
        ToolItem toolItem;
        if (selectionEvent.widget instanceof ToolItem) {
            toolItem = (ToolItem)selectionEvent.widget;
            rectangle = toolItem.getBounds();
            toolBar = toolItem.getParent();
        } else if (selectionEvent.widget instanceof Button) {
            toolItem = (Button)selectionEvent.widget;
            rectangle = toolItem.getBounds();
            toolBar = toolItem.getParent();
        } else {
            throw new IllegalArgumentException("DropdownSelectionListener does not work with widgets of class: " + String.valueOf(selectionEvent.widget));
        }
        toolItem = toolBar.toDisplay(new Point(rectangle.x, rectangle.y));
        this.menu.setLocation(toolItem.x, toolItem.y + rectangle.height);
        this.menu.setVisible(true);
    }

    public void mouseDoubleClick(MouseEvent mouseEvent) {
    }

    public void mouseDown(MouseEvent mouseEvent) {
    }

    public void mouseUp(MouseEvent mouseEvent) {
        Control control = (Control)mouseEvent.widget;
        Rectangle rectangle = control.getBounds();
        Point point = control.getParent().toDisplay(new Point(rectangle.x, rectangle.y));
        this.menu.setLocation(point.x, point.y + rectangle.height);
        this.menu.setVisible(true);
    }

    public static interface DropdownSelectionDelegate {
        public void selectedCommand(DropdownSelectionListener var1, String var2, Map<String, Object> var3);
    }
}

