/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.rcp.application.handlers;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILPUpdateConfiguration;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.co.f;
import ch.ionesoft.ilp.base.fo.x;
import ch.ionesoft.ilp.base.he.FileHelper;
import ch.ionesoft.ilp.base.he.Helper;
import ch.ionesoft.ilp.base.he.ProxyConfigurator;
import ch.ionesoft.ilp.base.he.ResourceHelper;
import ch.ionesoft.ilp.base.he.SystemHelper;
import ch.ionesoft.ilp.book.he.b;
import ch.ionesoft.ilp.book.msg.A;
import ch.ionesoft.ilp.book.pe.g;
import ch.ionesoft.ilp.book.scenario.ILPScenarioManager;
import ch.ionesoft.ilp.rcp.base.dialogs.j;
import ch.ionesoft.ilp.rcp.base.helper.P2Util;
import ch.ionesoft.ilp.rcp.base.helper.RCPAppInitializer;
import ch.ionesoft.ilp.rcp.base.helper.RCPApplicationConfig;
import jakarta.inject.Named;
import java.awt.Desktop;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Locale;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.MContribution;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.workbench.IWorkbench;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.BundleContext;

public class UpdateHandler {
    private static final int DIALOG_WIDTH = 500;
    private static final int DIALOG_HEIGHT = 400;
    private static ILogger logger = ILPLogManager.getLogger(UpdateHandler.class);
    private IStatus status;
    private IWorkbench workbench;

    @CanExecute
    public boolean canExecute(@Named(value="e4ActivePart") MDirtyable mDirtyable) {
        try {
            return !ILPScenarioManager.getInstance().isETestingMode();
        }
        catch (Exception exception) {
            return true;
        }
    }

    @Execute
    public void execute(IWorkbench iWorkbench, IEclipseContext iEclipseContext, @Named(value="activeShell") Shell shell, @Named(value="e4ActivePart") MContribution mContribution) throws InvocationTargetException, InterruptedException {
        this.workbench = iWorkbench;
        if (!x.a().a(false)) {
            f.b().D().sayCode("message.network.notAvailable", new Object[0]);
            return;
        }
        this.checkForUpdates(true, false);
    }

    public void installNewUpdatesUsingP2(Shell shell, final URL uRL) {
        final String string = f.b().c();
        logger.b((Object)"Starting UpdateHandler");
        final IProvisioningAgent iProvisioningAgent = (IProvisioningAgent)ServiceHelper.getService((BundleContext)RCPApplicationConfig.instance().getBundleContext(), (String)IProvisioningAgent.SERVICE_NAME);
        if (iProvisioningAgent == null) {
            logger.c((Object)"No provisioning agent found. This application is not set up for updates.");
        }
        ProxyConfigurator proxyConfigurator = new ProxyConfigurator();
        proxyConfigurator.configureSystemProperties();
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                try {
                    URI uRI = uRL.toURI();
                    logger.b((Object)"Try to install p2 update");
                    if (x.a().a(false)) {
                        logger.b((Object)"internet bill paid");
                        UpdateHandler.this.status = P2Util.checkForUpdates(iProvisioningAgent, iProgressMonitor, uRI);
                    } else {
                        UpdateHandler.this.status = new Status(2, string, "message.eclipse.update.noNetwork");
                    }
                }
                catch (OperationCanceledException operationCanceledException) {
                    logger.b((Object)"User cancelled update");
                    UpdateHandler.this.status = new Status(2, string, "message.eclipse.update.cancelled");
                }
                catch (URISyntaxException uRISyntaxException) {
                    logger.d((Object)("Could not get update site URL: " + String.valueOf(uRL)), (Throwable)uRISyntaxException);
                }
            }
        };
        try {
            new ProgressMonitorDialog(null).run(true, true, iRunnableWithProgress);
        }
        catch (InvocationTargetException invocationTargetException) {
            logger.d((Object)"Could not start Update", (Throwable)invocationTargetException);
            this.status = new Status(4, string, "message.eclipse.update.failed");
        }
        catch (InterruptedException interruptedException) {
            logger.a((Object)"Interrupted while updating", (Throwable)interruptedException);
            this.status = new Status(4, string, "message.eclipse.update.failed");
        }
        if (this.status.getSeverity() == 4 || this.status.getSeverity() == 2) {
            this.printIStatus(this.status);
            f.b().D().alertNoticeCode(this.status.getMessage(), new Object[0]);
        } else if (this.status.getCode() == 10000) {
            f.b().D().alertNoticeCode("message.eclipse.update.nothingToUpdate", new Object[0]);
        } else {
            this.printIStatus(this.status);
            RCPApplicationConfig.instance().setRestartRequired(true);
            RCPApplicationConfig.instance().restartIfRequired("message.eclipse.restart");
        }
        logger.b((Object)("Update run with status: " + this.status.getMessage()));
    }

    private void printIStatus(IStatus iStatus) {
        logger.d((Object)"----------------------------------------------");
        logger.d((Object)("UpdateStatus NOK : " + iStatus.getMessage()));
        logger.d((Object)("Code: " + iStatus.getCode()));
        logger.d((Object)("Plugin: " + iStatus.getPlugin()));
        logger.d((Object)"----------------------------------------------");
        if (iStatus.getException() != null) {
            logger.d((Object)"Error", iStatus.getException());
        }
        if (iStatus.isMultiStatus()) {
            int n2 = 0;
            while (n2 < iStatus.getChildren().length) {
                this.printIStatus(iStatus.getChildren()[n2]);
                ++n2;
            }
        }
    }

    public void checkForUpdates(boolean bl, boolean bl2) {
        block15: {
            String string = SystemHelper.programVersion();
            URL uRL = null;
            try {
                if (!x.a().a(false)) {
                    logger.c((Object)"No network available to check for updates");
                    if (bl) {
                        f.b().D().sayCode("message.network.notAvailable", new Object[0]);
                    }
                    return;
                }
                logger.b((Object)("Checking for application updates with version: " + string));
                String string2 = ch.ionesoft.ilp.base.co.g.a().e();
                String string3 = RCPAppInitializer.instance().getUpdateInfoURLTemplate();
                String string4 = String.format(Locale.ENGLISH, string3, string);
                uRL = new URL(string4);
                File file = File.createTempFile("updateInfo", "xml");
                b b2 = new b();
                int n2 = 5;
                b2.a(uRL, file.toString(), null, n2);
                if (b2.d() == 404) {
                    logger.b((Object)"Nothing to update");
                    if (bl) {
                        f.b().D().alertNoticeCode("message.eclipse.update.nothingToUpdate", new Object[0]);
                    }
                    return;
                }
                if (b2.d() != 0) {
                    logger.c((Object)("Checking for update failed: " + b2.d() + ", " + b2.c()));
                    if (bl) {
                        f.b().D().alertNoticeCode("message.eclipse.update.failed", new Object[0]);
                    }
                    return;
                }
                String string5 = FileHelper.contentsOfFile((File)file);
                if (!string5.startsWith("<?xml")) {
                    logger.c((Object)"Could not fetch update file, might not exist or being blocked");
                    if (bl) {
                        f.b().D().alertNoticeCode("message.eclipse.update.nothingToUpdate", new Object[0]);
                    }
                    return;
                }
                string5 = new ILPUpdateConfiguration(string2);
                string5.a(file);
                FileUtils.deleteQuietly((File)file);
                if (bl2 && string5.j()) {
                    return;
                }
                this.registerUpdateNews((ILPUpdateConfiguration)string5);
                j j2 = new j(Display.getCurrent().getActiveShell(), 500, 400, false, true);
                j2.c(false);
                j2.d(false);
                j2.e(true);
                j2.b(true);
                j2.e("label.install");
                j2.f("label.install.later");
                j2.f(true);
                String string6 = string5.a();
                j2.a(string6, "");
                int n3 = j2.open();
                if (n3 == 32) {
                    logger.b((Object)"Updates found, user accepted to install ...");
                    if (string5.c()) {
                        logger.b((Object)"Installing using p2");
                        this.installNewUpdatesUsingP2(Display.getCurrent().getActiveShell(), string5.e());
                    } else {
                        this.installUpdateWithInstaller(string5.f());
                    }
                } else {
                    logger.b((Object)"Updates found, user declined to install");
                }
            }
            catch (Exception exception) {
                logger.d((Object)("Could not check for updates for file: " + String.valueOf(uRL)), (Throwable)exception);
                if (!bl) break block15;
                f.b().D().alertNoticeCode("message.eclipse.update.failed", new Object[0]);
            }
        }
    }

    public void installUpdateWithInstaller(URL uRL) {
        if (f.b().D().confirmCode("message.eclipse.update.closeForInstall", new Object[0])) {
            logger.b((Object)"Installing using installer");
            logger.b((Object)"Shuting down database");
            g.a().c();
            logger.b((Object)"Shuting down http server");
            RCPAppInitializer.instance().shutdownHttpServer();
            logger.b((Object)"Closing workbench");
            SystemHelper.flushAllLogs();
            String string = uRL.toString();
            if (string.endsWith(".html")) {
                this.openInstaller(uRL);
                return;
            }
            try {
                final File file = new File(SystemHelper.userHomeDirectory(), "Downloads/" + FilenameUtils.getName((String)string));
                if (file.exists()) {
                    file.delete();
                }
                file.getParentFile().mkdirs();
                f.b().I().downloadExchangeFile(uRL, file, new ResourceHelper.Abortable(){

                    public void successful() {
                        try {
                            UpdateHandler.this.openInstaller(file.toURL());
                        }
                        catch (MalformedURLException malformedURLException) {
                            // empty catch block
                        }
                        if (UpdateHandler.this.workbench != null) {
                            if (UpdateHandler.this.workbench.close()) {
                                System.exit(0);
                            }
                        } else {
                            System.exit(0);
                        }
                    }

                    public void reset() {
                    }

                    public void failed() {
                    }

                    public void abort() {
                        logger.b((Object)"User aborted download installer.");
                    }
                });
            }
            catch (Exception exception) {
                logger.d((Object)("Could not downlad and install new beook version from: " + String.valueOf(uRL)));
                this.openInstaller(uRL);
            }
        } else {
            logger.b((Object)"User declined to stop and install");
        }
    }

    private void openInstaller(URL uRL) {
        Desktop desktop = Desktop.getDesktop();
        try {
            desktop.browse(uRL.toURI());
        }
        catch (Exception exception) {
            Helper.logActionText_withException((String)("Could not open file externally: " + String.valueOf(uRL)), (Throwable)exception);
        }
    }

    private void registerUpdateNews(ILPUpdateConfiguration iLPUpdateConfiguration) {
        try {
            A.a().a(iLPUpdateConfiguration.g(), iLPUpdateConfiguration.k(), iLPUpdateConfiguration.l(), iLPUpdateConfiguration.b(), iLPUpdateConfiguration.f(), iLPUpdateConfiguration.e());
        }
        catch (Exception exception) {
            logger.d((Object)"Could not register update news", (Throwable)exception);
        }
    }
}

