/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.rcp.application.handlers;

import ch.ionesoft.ilp.base.co.g;
import ch.ionesoft.ilp.book.scenario.ILPScenarioManager;
import ch.ionesoft.ilp.rcp.application.preferences.ILPAbstractPreferenceInitializer;
import ch.ionesoft.ilp.rcp.base.helper.RCPApplicationConfig;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class ShowPreferencesDialogHandler {
    public static final String PREFS_PAGE_XP = "org.eclipse.ui.preferencePages";
    protected static final String ELMT_PAGE = "page";
    protected static final String ATTR_ID = "id";
    protected static final String ATTR_CATEGORY = "category";
    protected static final String ATTR_CLASS = "class";
    protected static final String ATTR_NAME = "name";
    protected static String filterPreferencesByPackageName = "ch.ionesoft.ilp";
    @Inject
    @Named(value="activeShell")
    protected Shell shell;
    @Inject
    protected IEclipseContext context;
    @Inject
    protected Logger logger;
    @Inject
    protected IExtensionRegistry registry;

    @Execute
    public void execute(MApplication mApplication) {
        PreferenceManager preferenceManager = this.configurePreferences();
        PreferenceDialog preferenceDialog = new PreferenceDialog(this.shell, preferenceManager);
        IPreferenceStore iPreferenceStore = RCPApplicationConfig.instance().getPreferencesStore();
        if (iPreferenceStore != null) {
            preferenceDialog.setPreferenceStore(iPreferenceStore);
        }
        preferenceDialog.create();
        preferenceDialog.getTreeViewer().setComparator(new ViewerComparator());
        preferenceDialog.getTreeViewer().expandAll();
        preferenceDialog.open();
        RCPApplicationConfig.instance().restartIfRequired("message.eclipse.preferences.restart." + g.a().e());
    }

    private PreferenceManager configurePreferences() {
        ILPAbstractPreferenceInitializer iLPAbstractPreferenceInitializer = new ILPAbstractPreferenceInitializer();
        iLPAbstractPreferenceInitializer.initializeDefaultPreferences();
        PreferenceManager preferenceManager = new PreferenceManager();
        IContributionFactory iContributionFactory = (IContributionFactory)this.context.get(IContributionFactory.class);
        IConfigurationElement[] iConfigurationElementArray = this.registry.getConfigurationElementsFor(PREFS_PAGE_XP);
        int n2 = iConfigurationElementArray.length;
        int n3 = 0;
        while (n3 < n2) {
            block15: {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[n3];
                if (!iConfigurationElement.getName().equals(ELMT_PAGE)) {
                    this.logger.warn("unexpected element: {0}", (Object)iConfigurationElement.getName());
                } else if (this.isEmpty(iConfigurationElement.getAttribute(ATTR_ID)) || this.isEmpty(iConfigurationElement.getAttribute(ATTR_NAME))) {
                    this.logger.warn("missing id and/or name: {}", (Object)iConfigurationElement.getNamespaceIdentifier());
                } else {
                    IPreferenceNode iPreferenceNode;
                    PreferenceNode preferenceNode = null;
                    if (iConfigurationElement.getAttribute(ATTR_CLASS) != null) {
                        iPreferenceNode = null;
                        try {
                            String string = this.getClassURI(iConfigurationElement.getNamespaceIdentifier(), iConfigurationElement.getAttribute(ATTR_CLASS));
                            if (!string.contains(filterPreferencesByPackageName)) break block15;
                            Object object = iContributionFactory.create(string, this.context);
                            if (!(object instanceof IPreferencePage)) {
                                this.logger.error("Expected instance of IPreferencePage: {0}", (Object)iConfigurationElement.getAttribute(ATTR_CLASS));
                                break block15;
                            }
                            iPreferenceNode = (IPreferencePage)object;
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            this.logger.error((Throwable)classNotFoundException);
                            break block15;
                        }
                        ContextInjectionFactory.inject((Object)iPreferenceNode, (IEclipseContext)this.context);
                        if ((iPreferenceNode.getTitle() == null || iPreferenceNode.getTitle().isEmpty()) && iConfigurationElement.getAttribute(ATTR_NAME) != null) {
                            iPreferenceNode.setTitle(iConfigurationElement.getAttribute(ATTR_NAME));
                        }
                        preferenceNode = new PreferenceNode(iConfigurationElement.getAttribute(ATTR_ID), (IPreferencePage)iPreferenceNode);
                    } else {
                        preferenceNode = new PreferenceNode(iConfigurationElement.getAttribute(ATTR_ID), (IPreferencePage)new EmptyPreferencePage(iConfigurationElement.getAttribute(ATTR_NAME)));
                    }
                    if (this.isEmpty(iConfigurationElement.getAttribute(ATTR_CATEGORY))) {
                        preferenceManager.addToRoot((IPreferenceNode)preferenceNode);
                    } else {
                        iPreferenceNode = this.findNode(preferenceManager, iConfigurationElement.getAttribute(ATTR_CATEGORY));
                        if (iPreferenceNode == null) {
                            preferenceManager.addToRoot((IPreferenceNode)preferenceNode);
                        } else {
                            iPreferenceNode.add((IPreferenceNode)preferenceNode);
                        }
                    }
                }
            }
            ++n3;
        }
        return preferenceManager;
    }

    private IPreferenceNode findNode(PreferenceManager preferenceManager, String string) {
        for (Object e2 : preferenceManager.getElements(1)) {
            if (!(e2 instanceof IPreferenceNode) || !((IPreferenceNode)e2).getId().equals(string)) continue;
            return (IPreferenceNode)e2;
        }
        return null;
    }

    private String getClassURI(String string, String string2) throws ClassNotFoundException {
        if (string2.startsWith("platform:")) {
            return string2;
        }
        return "platform:/plugin/" + string + "/" + string2;
    }

    private boolean isEmpty(String string) {
        return string == null || string.trim().isEmpty();
    }

    @CanExecute
    public boolean canExecute(@Named(value="e4ActivePart") MDirtyable mDirtyable) {
        try {
            return !ILPScenarioManager.getInstance().isETestingMode();
        }
        catch (Exception exception) {
            return true;
        }
    }

    static class EmptyPreferencePage
    extends PreferencePage {
        public EmptyPreferencePage(String string) {
            this.setTitle(string);
            this.noDefaultAndApplyButton();
        }

        protected Control createContents(Composite composite) {
            return new Label(composite, 0);
        }
    }
}

