/*
 * Decompiled with CFR 0.152.
 */
package org.cef;

import java.lang.reflect.InvocationTargetException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.cef.CefClient;
import org.cef.CefClientSwt;
import org.cef.WindowingToolkit;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;

public class CefAppSwt
implements WindowingToolkit {
    private Timer timer;
    private Runnable loop;
    private Display display = Display.getDefault();
    private boolean enabled = true;
    private boolean external_message_pump;
    private int loopTime;
    private ExecutorService executor = Executors.newSingleThreadExecutor(r -> {
        Thread thread = new Thread(r, "chromium-EDT");
        thread.setDaemon(true);
        return thread;
    });

    public CefAppSwt(int loopTime, boolean external_message_pump) {
        this.loopTime = loopTime;
        this.external_message_pump = external_message_pump;
    }

    public CefAppSwt(boolean external_message_pump) {
        this(33, external_message_pump);
    }

    @Override
    public CefClient createClient() {
        return new CefClientSwt();
    }

    @Override
    public boolean isEDT() {
        return Display.getCurrent() != null;
    }

    @Override
    public void runInEDT(Runnable r) {
        this.executor.execute(() -> {
            Class<Device> clazz = Device.class;
            synchronized (Device.class) {
                if (!this.display.isDisposed()) {
                    this.display.asyncExec(r);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        });
    }

    @Override
    public void runInEDTAndWait(Runnable r) throws InterruptedException, InvocationTargetException {
        this.display.syncExec(r);
    }

    @Override
    public void stopMessageLoopTimer() {
        if (this.loop != null && !this.display.isDisposed()) {
            this.display.timerExec(-1, this.loop);
            this.loop = null;
        }
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    @Override
    public void startMessageLoopTimer(int ms, final Runnable run) {
        if (this.external_message_pump) {
            if (!this.display.isDisposed()) {
                this.loop = run;
                this.display.timerExec(ms, run);
            }
        } else if (this.timer == null && ms != -1) {
            this.timer = new Timer(true);
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    if (!CefAppSwt.this.display.isDisposed()) {
                        CefAppSwt.this.display.syncExec(run);
                    }
                }
            };
            this.timer.scheduleAtFixedRate(task, ms, (long)ms);
        } else if (ms == -1 && !this.display.isDisposed()) {
            this.display.syncExec(run);
        }
    }

    @Override
    public void shutdown(Runnable runnable) {
        this.executor.shutdown();
        runnable.run();
    }

    public void toggle() {
        this.enabled = !this.enabled;
    }

    @Override
    public int getLoopTime() {
        return this.loopTime;
    }
}

