/*
 * Decompiled with CFR 0.152.
 */
package com.equo.chromium.swt.internal.spi;

import com.equo.chromium.swt.internal.spi.SchemeHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.cef.callback.CefCallback;
import org.cef.handler.CefResourceHandler;
import org.cef.misc.IntRef;
import org.cef.misc.StringRef;
import org.cef.network.CefRequest;
import org.cef.network.CefResponse;

public class DelegatingCefResourceHandler
implements CefResourceHandler {
    private InputStream responseData;
    private Boolean processRequest;
    private final SchemeHandler schemeHandler;

    public DelegatingCefResourceHandler(SchemeHandler schemeHandler) {
        this.schemeHandler = schemeHandler;
    }

    @Override
    public boolean processRequest(CefRequest request, CefCallback callback) {
        boolean shouldProcessRequest;
        if (this.processRequest == null) {
            HashMap<String, String> headers = new HashMap<String, String>();
            request.getHeaderMap(headers);
            boolean shouldProcessRequest2 = this.schemeHandler.processRequest(request.getURL(), request.getMethod(), headers);
            this.processRequest = shouldProcessRequest2;
        }
        if ((shouldProcessRequest = this.processRequest.booleanValue()) && callback != null) {
            callback.Continue();
        }
        return shouldProcessRequest;
    }

    @Override
    public void getResponseHeaders(CefResponse response, IntRef responseLength, StringRef redirectUrl) {
        HashMap<String, String> responseHeaders = new HashMap<String, String>();
        response.getHeaderMap(responseHeaders);
        this.responseData = this.schemeHandler.getResponseData(responseHeaders);
        if (this.responseData == null) {
            response.setStatus(404);
        } else {
            String contentType = (String)responseHeaders.remove("Content-Type");
            if (contentType != null) {
                response.setMimeType(contentType);
            }
            response.setHeaderMap(responseHeaders);
            response.setStatus(200);
        }
    }

    @Override
    public boolean readResponse(byte[] dataOut, int bytesToRead, IntRef bytesRead, CefCallback callback) {
        int bytesReadPrim;
        block4: {
            if (this.responseData == null) {
                return false;
            }
            try {
                bytesReadPrim = this.responseData.read(dataOut, 0, bytesToRead);
                if (bytesReadPrim != -1) break block4;
                this.cancel();
                return false;
            }
            catch (IOException e) {
                e.printStackTrace();
                this.cancel();
                bytesRead.set(0);
                return false;
            }
        }
        bytesRead.set(bytesReadPrim);
        return true;
    }

    @Override
    public void cancel() {
        try {
            try {
                if (this.responseData != null) {
                    this.responseData.close();
                }
            }
            catch (IOException iOException) {
                this.responseData = null;
            }
        }
        finally {
            this.responseData = null;
        }
    }
}

