/*
 * Decompiled with CFR 0.152.
 */
package com.equo.chromium.swt.internal;

import com.equo.chromium.internal.Utils;
import com.equo.chromium.swt.internal.Chromium;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.cef.CefApp;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.callback.CefSchemeHandlerFactory;
import org.cef.handler.CefResourceHandler;
import org.cef.network.CefRequest;
import org.eclipse.swt.widgets.Display;

public class SWTEngine {
    public static void initCef(AtomicBoolean closing, AtomicBoolean shuttingDown, Runnable shutdownRunnable) {
        Display.getDefault().addListener(21, e -> closing.set(true));
        Display.getDefault().disposeExec(() -> {
            if (shuttingDown.get()) {
                return;
            }
            if (!Utils.isMac() || !closing.get()) {
                shuttingDown.set(true);
                shutdownRunnable.run();
            }
        });
    }

    public static void onContextInitialized(CefApp app) {
        SWTEngine.registerBrowserFunctions(app);
    }

    public static void registerBrowserFunctions(CefApp app) {
        app.registerSchemeHandlerFactory("https", "functions", new CefSchemeHandlerFactory(){

            @Override
            public CefResourceHandler create(CefBrowser browser, CefFrame frame, String schemeName, CefRequest request) {
                if (!browser.isPopup()) {
                    if (this.isPartial(request)) {
                        return Chromium.getChromium((CefBrowser)browser).functionsResourceHandler.peek();
                    }
                    return Chromium.getChromium(browser).createFunctionResourceHandler();
                }
                return null;
            }

            protected boolean isPartial(CefRequest request) {
                try {
                    URI url = new URI(request.getURL());
                    return url.getFragment() != null;
                }
                catch (URISyntaxException e) {
                    return false;
                }
            }
        });
    }
}

