/*
 * Decompiled with CFR 0.152.
 */
package com.equo.chromium.swt.internal;

import com.equo.chromium.swt.internal.Chromium;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FindDialog
extends Dialog {
    private static boolean isOpen = false;
    private static Point location = null;
    private Chromium.ExtraApi extraApi;

    public FindDialog(Chromium.ExtraApi extraApi, Shell shell) {
        super(shell);
        this.extraApi = extraApi;
    }

    public void open() {
        Shell parent = this.getParent();
        final Shell shell = new Shell(parent, 3296);
        shell.setText("Text search");
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        shell.setLayout((Layout)layout);
        final Text find = new Text((Composite)shell, 2052);
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        find.setLayoutData((Object)gridData);
        Group direction = new Group((Composite)shell, 0);
        direction.setText("Direction");
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        shell.setLayout((Layout)gridLayout);
        gridData = new GridData(256);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        direction.setLayout((Layout)gridLayout);
        gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        direction.setLayoutData((Object)gridData);
        final Button forward = new Button((Composite)direction, 32);
        final Button backward = new Button((Composite)direction, 32);
        forward.setText("Forward");
        forward.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button btn = (Button)event.getSource();
                if (backward.getSelection()) {
                    backward.setSelection(false);
                }
                btn.setSelection(true);
            }
        });
        forward.setSelection(true);
        backward.setText("Backward");
        backward.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button btn = (Button)event.getSource();
                if (forward.getSelection()) {
                    forward.setSelection(false);
                }
                btn.setSelection(true);
            }
        });
        final Button caseSensitive = new Button((Composite)shell, 32);
        caseSensitive.setText("Case sensitive");
        caseSensitive.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button btn = (Button)event.getSource();
                FindDialog.this.extraApi.find(null, forward.getSelection(), btn.getSelection());
                FindDialog.this.extraApi.find(find.getText(), forward.getSelection(), btn.getSelection());
            }
        });
        Composite bar = new Composite((Composite)shell, 0);
        bar.setLayoutData((Object)new GridData(0x1000008, 0x1000008, false, true, 2, 1));
        bar.setLayout((Layout)new GridLayout(2, true));
        Button closeButton = new Button(bar, 8);
        closeButton.setText("Close");
        closeButton.addListener(13, event -> shell.close());
        GridData closeData = new GridData(0x1000000, 0x1000008, false, false);
        closeData.widthHint = 80;
        closeButton.setLayoutData((Object)closeData);
        Button findButton = new Button(bar, 8);
        findButton.setText("Find");
        findButton.addListener(13, event -> {
            this.extraApi.find(find.getText(), forward.getSelection(), caseSensitive.getSelection());
            find.forceFocus();
        });
        GridData findData = new GridData(0x1000000, 0x1000008, false, false);
        findData.minimumWidth = -1;
        findData.widthHint = 80;
        findButton.setLayoutData((Object)findData);
        shell.addListener(21, event -> {
            isOpen = false;
            this.extraApi.find(null, forward.getSelection(), caseSensitive.getSelection());
        });
        ModifyListener inputListener = e -> {
            String search = find.getText();
            this.extraApi.find(search, forward.getSelection(), caseSensitive.getSelection());
        };
        find.addModifyListener(inputListener);
        find.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13) {
                    String search = find.getText();
                    FindDialog.this.extraApi.find(search, forward.getSelection(), caseSensitive.getSelection());
                }
            }
        });
        shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                location = shell.getLocation();
            }
        });
        if (location != null) {
            shell.setLocation(location);
        }
        find.forceFocus();
        shell.pack();
        isOpen = true;
        shell.open();
        shell.pack();
    }

    public static boolean isOpen() {
        return isOpen;
    }
}

