/*
 * Decompiled with CFR 0.152.
 */
package com.equo.chromium.swt.internal;

import com.equo.chromium.internal.Engine;
import com.equo.chromium.swt.BrowserFunction;
import com.equo.chromium.swt.internal.AbstractEval;
import com.equo.chromium.swt.internal.Chromium;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Random;
import java.util.Stack;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.cef.CefApp;
import org.cef.browser.CefBrowser;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Display;

public class EvalFileImpl
extends AbstractEval {
    private static final String EVAL_FILE_NAME = "equochromium";
    private CefBrowser cefBrowser;
    private Chromium chromium;
    private RandomAccessFile raf;
    private Stack<CompletableFuture<Object>> received = new Stack();
    private String id;

    public EvalFileImpl(Chromium chromium, CefBrowser cefBrowser) {
        this.chromium = chromium;
        this.cefBrowser = cefBrowser;
        this.id = Integer.toString(new Random().nextInt());
    }

    @Override
    public Object eval(String script, CompletableFuture<Boolean> created) throws InterruptedException, ExecutionException {
        Display display = Display.getCurrent();
        String eval = EvalFileImpl.getEvalFunction(this.id, script, "return req;");
        CompletableFuture received = this.received.push(new CompletableFuture());
        if (this.received.size() == 1) {
            created.thenRun(() -> {
                try {
                    CefApp.getInstance().doMessageLoopWork(-1L);
                    File file = this.createTmpFile();
                    this.startFileWatcher(display, file, this.id);
                    this.cefBrowser.sendEvalMessage(file.getAbsolutePath(), eval);
                }
                catch (IOException e) {
                    this.finish(display, null, (Object)new SWTException(e.getMessage()));
                }
            });
        } else {
            this.writeEvalMessage(eval);
        }
        this.awaitCondition(display, received, true);
        return received.get();
    }

    protected void writeEvalMessage(String eval) {
        String encodeEval = Chromium.encodeType(eval);
        try {
            this.raf.writeBytes(MsgType.Eval.str());
            this.raf.writeBytes("\n" + encodeEval + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void startFileWatcher(Display display, File file, String id) {
        Thread t = new Thread(() -> {
            long timeOut = System.currentTimeMillis() + 60000L;
            try {
                try {
                    Throwable throwable = null;
                    Object var7_8 = null;
                    try (RandomAccessFile raf = new RandomAccessFile(file, "rw");){
                        this.raf = raf;
                        while (!this.received.isEmpty()) {
                            block27: {
                                long offset = raf.getFilePointer();
                                String type = raf.readLine();
                                if (type != null) {
                                    String line = raf.readLine();
                                    if (line == null) {
                                        raf.seek(offset);
                                        continue;
                                    }
                                    try {
                                        Object[] payload = (Object[])EvalFileImpl.decodeType(line, type.equals(MsgType.BfCall.str()) ? 5 : 51);
                                        if (payload.length == 3) {
                                            Integer index = Integer.valueOf((String)payload[1]);
                                            String token = (String)payload[0];
                                            Object[] args = (Object[])payload[2];
                                            BrowserFunction browserFunction = (BrowserFunction)this.chromium.functions.get(index);
                                            if (browserFunction != null && browserFunction.token.equals(token)) {
                                                Engine.debug("eval calling function: " + browserFunction.getName());
                                                Chromium.asyncExec(() -> {
                                                    Object ret = null;
                                                    try {
                                                        ret = browserFunction.function(args);
                                                        String encodeType = Chromium.encodeType(ret);
                                                        raf.writeBytes(MsgType.BfRet.str());
                                                        raf.writeBytes("\n" + encodeType + "\n");
                                                    }
                                                    catch (Throwable e) {
                                                        try {
                                                            raf.writeBytes(MsgType.BfRetEx.str());
                                                            raf.writeBytes("\n" + e.toString() + "\n");
                                                        }
                                                        catch (IOException e1) {
                                                            e1.printStackTrace();
                                                        }
                                                    }
                                                });
                                            }
                                        } else if (payload.length == 2 && id.equals(payload[0])) {
                                            this.finish(display, file, payload[1]);
                                        }
                                    }
                                    catch (SWTException e1) {
                                        if (type.equals(MsgType.BfCall.str()) && e1.code == 5) {
                                            raf.writeBytes(MsgType.BfRetEx.str());
                                            raf.writeBytes("\n" + e1.toString() + "\n");
                                            break block27;
                                        }
                                        this.finish(display, file, (Object)e1);
                                    }
                                } else {
                                    Thread.sleep(30L);
                                }
                            }
                            if (System.currentTimeMillis() <= timeOut) continue;
                            this.finish(display, file, (Object)new SWTException("Evaluate timeout exception"));
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Throwable throwable) {
                    this.finish(display, file, throwable);
                    this.raf = null;
                    if (file.exists()) {
                        file.delete();
                    }
                }
            }
            finally {
                this.raf = null;
                if (file.exists()) {
                    file.delete();
                }
            }
        }, "eval");
        t.setDaemon(true);
        t.start();
    }

    private void finish(Display display, File file, Object decodeType) {
        if (file != null) {
            file.delete();
        }
        if (decodeType instanceof SWTException) {
            this.received.pop().completeExceptionally((SWTException)((Object)decodeType));
        } else {
            this.received.pop().complete(decodeType);
        }
        if (display != null) {
            display.wake();
        }
    }

    private File createTmpFile() throws IOException {
        Path dir = Paths.get(System.getProperty("java.io.tmpdir"), EVAL_FILE_NAME);
        try {
            Files.createDirectory(dir, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        File file = Files.createTempFile(dir, "eval", null, new FileAttribute[0]).toFile();
        return file;
    }

    private static enum MsgType {
        BfCall(5),
        BfRet(1),
        BfRetEx(3),
        Eval(2);

        private String type;

        private MsgType(int type) {
            this.type = String.valueOf(type);
        }

        String str() {
            return this.type;
        }
    }
}

