/*
 * Decompiled with CFR 0.152.
 */
package com.equo.chromium.internal;

import com.equo.chromium.ChromiumBrowser;
import com.equo.chromium.internal.Engine;
import com.equo.chromium.swt.internal.spi.CommRouterHandler;
import com.equo.chromium.swt.internal.spi.CommunicationManager;
import com.equo.chromium.swt.internal.spi.ScriptExtension;
import com.equo.chromium.utils.EventAction;
import com.equo.chromium.utils.EventType;
import com.equo.chromium.utils.PdfPrintSettings;
import com.github.cliftonlabs.json_simple.JsonException;
import com.github.cliftonlabs.json_simple.JsonObject;
import com.github.cliftonlabs.json_simple.Jsoner;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import org.cef.CefClient;
import org.cef.CefSettings;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.browser.CefMessageRouter;
import org.cef.browser.CefRequestContext;
import org.cef.callback.CefCallback;
import org.cef.callback.CefCompletionCallback;
import org.cef.callback.CefDevToolsMessageObserverAdapter;
import org.cef.callback.CefPdfPrintCallback;
import org.cef.callback.CefQueryCallback;
import org.cef.callback.CefStringVisitor;
import org.cef.handler.CefDisplayHandlerAdapter;
import org.cef.handler.CefFindHandler;
import org.cef.handler.CefLifeSpanHandlerAdapter;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefMessageRouterHandlerAdapter;
import org.cef.handler.CefPrintHandlerAdapter;
import org.cef.handler.CefRequestHandlerAdapter;
import org.cef.misc.CefPdfPrintSettings;
import org.cef.misc.Rectangle;
import org.cef.network.CefRequest;

public abstract class IndependentBrowser
implements ChromiumBrowser {
    private CefClient clientHandler;
    private CefBrowser browser;
    private CefRequestContext requestContext;
    private CompletableFuture<Boolean> created = new CompletableFuture();
    private boolean ignoreCertificateErrors = false;
    private List<ChromiumBrowser.ConsoleListener> consoleListeners = new ArrayList<ChromiumBrowser.ConsoleListener>();
    private String lastSearch = null;
    private static final String DATA_TEXT_URL = "data:text/html;base64,";
    private Map<EventType, List<EventAction>> subscribeEvents = new HashMap<EventType, List<EventAction>>();
    private Map<Long, ActionData> subscribeIndex = new HashMap<Long, ActionData>();
    private long eventId = 0L;
    private static ExecutorService executor = Executors.newSingleThreadExecutor(r -> {
        Thread thread = new Thread(r, "chromium-MessageRoute");
        thread.setDaemon(true);
        return thread;
    });
    private int messageId = 0;
    protected static EventAction eventActionOfAfterCreated = null;

    @Override
    public CompletableFuture<Boolean> isCreated() {
        return this.created;
    }

    protected CefBrowser getBrowser() {
        return this.browser;
    }

    protected void setBrowser(CefBrowser browser) {
        this.browser = browser;
    }

    protected CefClient getClientHandler() {
        return this.clientHandler;
    }

    protected void setClientHandler(CefClient clientHandler) {
        this.clientHandler = clientHandler;
    }

    protected void createClient() {
        this.clientHandler = Engine.createClient();
        this.clientHandler.addLifeSpanHandler(new CefLifeSpanHandlerAdapter(){

            @Override
            public void onAfterCreated(CefBrowser browser) {
                if (eventActionOfAfterCreated != null && !IndependentBrowser.this.created.isDone()) {
                    HashMap<String, Object> mapData = new HashMap<String, Object>();
                    mapData.put("chromium_instance", (ChromiumBrowser)browser.getReference());
                    eventActionOfAfterCreated.setJsonData(mapData);
                    eventActionOfAfterCreated.run();
                }
                IndependentBrowser.this.created.complete(true);
                IndependentBrowser.this.notifySubscribers(EventType.onAfterCreated);
            }
        });
        this.clientHandler.addRequestHandler(new CefRequestHandlerAdapter(){

            @Override
            public boolean onCertificateError(CefBrowser browser, CefLoadHandler.ErrorCode cert_error, String request_url, CefCallback callback) {
                if (IndependentBrowser.this.isIgnoreCertificateErrors()) {
                    callback.Continue();
                    return true;
                }
                if (IndependentBrowser.this.handleCertificateProperty()) {
                    return false;
                }
                callback.cancel();
                return true;
            }
        });
        this.clientHandler.addDisplayHandler(new CefDisplayHandlerAdapter(){

            @Override
            public boolean onConsoleMessage(CefBrowser browser, CefSettings.LogSeverity level, String message, String source, int line) {
                HashMap<String, Object> mapData = new HashMap<String, Object>();
                mapData.put("level", level.toString());
                mapData.put("message", message);
                mapData.put("source", source);
                mapData.put("line", line);
                IndependentBrowser.this.notifySubscribers(EventType.onConsoleMessage, mapData);
                return IndependentBrowser.this.onConsoleMessage(browser, level, message, source, line);
            }

            @Override
            public void onFullscreenModeChange(CefBrowser browser, boolean fullscreen) {
                if (fullscreen) {
                    IndependentBrowser.this.notifySubscribers(EventType.onFullScreenEntered);
                } else {
                    IndependentBrowser.this.notifySubscribers(EventType.onFullScreenExited);
                }
            }
        });
        this.clientHandler.addLoadHandler(new CefLoadHandler(){

            @Override
            public void onLoadingStateChange(CefBrowser browser, boolean isLoading, boolean canGoBack, boolean canGoForward) {
                IndependentBrowser.this.notifySubscribers(EventType.onLoadingStateChange);
            }

            @Override
            public void onLoadStart(CefBrowser browser, CefFrame frame, CefRequest.TransitionType transitionType) {
                IndependentBrowser.this.notifySubscribers(EventType.onLoadStart);
            }

            @Override
            public void onLoadError(CefBrowser browser, CefFrame frame, CefLoadHandler.ErrorCode errorCode, String errorText, String failedUrl) {
                IndependentBrowser.this.notifySubscribers(EventType.onLoadError);
            }

            @Override
            public void onLoadEnd(CefBrowser browser, final CefFrame frame, int httpStatusCode) {
                CefFrame parentFrame = frame.getParent();
                final boolean isMain = frame.isMain();
                final long parentId = parentFrame != null ? parentFrame.getIdentifier() : 0L;
                frame.getSource(new CefStringVisitor(){

                    @Override
                    public void visit(String source) {
                        String jsonSource = source.replaceAll("\"", "\\\\\"").replaceAll("\n", "\\\\n");
                        HashMap<String, Object> mapData = new HashMap<String, Object>();
                        mapData.put("isMain", isMain);
                        mapData.put("html", jsonSource);
                        mapData.put("name", frame.getName());
                        mapData.put("id", frame.getIdentifier());
                        mapData.put("parentId", parentId);
                        IndependentBrowser.this.notifySubscribers(EventType.onLoadEnd, mapData);
                    }
                });
            }
        });
        this.clientHandler.addFindHandler(new CefFindHandler(){

            @Override
            public void onFindResult(CefBrowser browser, int identifier, int count, Rectangle selectionRect, int activeMatchOrdinal, boolean finalUpdate) {
                if (finalUpdate) {
                    HashMap<String, Object> mapData = new HashMap<String, Object>();
                    mapData.put("count", count);
                    mapData.put("activeMatchOrdinal", activeMatchOrdinal);
                    IndependentBrowser.this.notifySubscribers(EventType.onFindResult, mapData);
                }
            }
        });
        this.clientHandler.addPrintHandler(new CefPrintHandlerAdapter(){});
        CommunicationManager commManager = CommunicationManager.get();
        if (commManager != null) {
            CefMessageRouter commRouter = CommRouterHandler.createRouter();
            commRouter.addHandler(new CommRouterHandler(commManager), true);
            this.clientHandler.addMessageRouter(commRouter);
        }
        if (!Boolean.getBoolean("chromium.disable_script_extensions")) {
            Iterator<ScriptExtension> scriptExtensions = ScriptExtension.get();
            scriptExtensions.forEachRemaining(scriptExtensionProvider -> {
                List<CefMessageRouter> routers = ScriptExtension.createRouter(scriptExtensionProvider.getScriptExtensions());
                routers.stream().forEach(router -> this.clientHandler.addMessageRouter((CefMessageRouter)router));
            });
        }
    }

    protected void notifySubscribers(EventType eventType) {
        this.notifySubscribers(eventType, new HashMap<String, Object>());
    }

    protected synchronized void notifySubscribers(EventType eventType, Map<String, Object> mapData) {
        this.subscribeEvents.computeIfAbsent(eventType, m -> new ArrayList()).forEach(e -> {
            e.setJsonData(mapData);
            CompletableFuture.runAsync(e);
        });
    }

    public static void subscribeOnAfterCreated(EventAction eventAction) {
        eventActionOfAfterCreated = eventAction;
    }

    public synchronized long subscribe(EventType eventType, EventAction action) {
        this.created.thenRun(() -> {
            this.subscribeEvents.computeIfAbsent(eventType, m -> new ArrayList()).add(action);
            this.subscribeIndex.put(this.eventId, new ActionData(eventType, action));
        });
        return this.eventId++;
    }

    public synchronized boolean unSubscribe(long idEvent) {
        this.created.thenRun(() -> {
            ActionData actionData = this.subscribeIndex.get(idEvent);
            if (actionData != null) {
                this.subscribeEvents.get((Object)actionData.eventType).remove(actionData.action);
                this.subscribeIndex.remove(idEvent);
            }
        });
        return false;
    }

    public synchronized void unSubscribeAll() {
        this.subscribeIndex.clear();
        this.subscribeEvents.clear();
    }

    protected CefRequestContext createRequestContext() {
        this.requestContext = this.isIgnoreCertificateErrors() ? CefRequestContext.createContext(null) : null;
        return this.requestContext;
    }

    protected CefRequestContext getRequestContext() {
        return this.requestContext;
    }

    protected boolean handleCertificateProperty() {
        String derpem = System.getProperty("chromium.ssl", "");
        if (!derpem.isEmpty()) {
            if (Files.isReadable(Paths.get(derpem, new String[0]))) {
                try {
                    byte[] derpemBytes = Files.readAllBytes(Paths.get(derpem, new String[0]));
                    System.setProperty("chromium.ssl.cert", new String(derpemBytes, "ASCII").replaceAll("\\r\\n", "\n"));
                }
                catch (IOException e) {
                    this.debugPrint("Failed to read file " + derpem);
                    e.printStackTrace();
                }
            } else {
                this.debugPrint("Cannot read file '" + derpem + "', trying as string");
                System.setProperty("chromium.ssl.cert", derpem.replaceAll("\\r\\n", "\n"));
            }
            return true;
        }
        return false;
    }

    private void debugPrint(String log) {
        Engine.debug(log, this.getBrowser());
    }

    protected boolean onConsoleMessage(CefBrowser browser, CefSettings.LogSeverity level, String message, String source, int line) {
        boolean prevent = false;
        for (ChromiumBrowser.ConsoleListener listener : this.consoleListeners) {
            if (!listener.message(level.ordinal(), message, source, line)) continue;
            prevent = true;
        }
        return prevent;
    }

    @Override
    public boolean setUrl(String url) {
        this.created.thenRun(() -> this.browser.loadURL(url));
        return true;
    }

    @Override
    public boolean setText(String html) {
        this.created.thenRun(() -> {
            String texturl = DATA_TEXT_URL + Base64.getEncoder().encodeToString(html.getBytes());
            this.browser.loadURL(texturl);
        });
        return true;
    }

    @Override
    public void find(String search, boolean forward, boolean matchCase) {
        if (search == null || search.isEmpty()) {
            this.getBrowser().stopFinding(true);
        } else {
            if (this.lastSearch != null && !this.lastSearch.contains(search)) {
                this.getBrowser().stopFinding(true);
            }
            this.getBrowser().find(search, forward, matchCase, true);
            this.lastSearch = search;
        }
    }

    @Override
    public void zoom(double zoomLevel) {
        this.getBrowser().setZoomLevel(zoomLevel);
        this.notifySubscribers(EventType.onZoomChanged);
    }

    @Override
    public double getZoom() {
        return this.getBrowser().getZoomLevel();
    }

    @Override
    public void executeJavacript(String script) {
        this.created.thenRun(() -> this.getBrowser().executeJavaScript(script, "", 0));
    }

    @Override
    public void addConsoleListener(ChromiumBrowser.ConsoleListener listener) {
        this.consoleListeners.add(listener);
    }

    @Override
    public void removeConsoleListener(ChromiumBrowser.ConsoleListener listener) {
        this.consoleListeners.remove(listener);
    }

    @Override
    public CompletableFuture<byte[]> captureScreenshot() {
        return this.captureScreenshot(0, 0, 0, 0, 1);
    }

    @Override
    public CompletableFuture<byte[]> captureScreenshot(int x, int y, int width, int height, int scale) {
        final CompletableFuture<byte[]> screenshotResult = new CompletableFuture<byte[]>();
        new CefDevToolsMessageObserverAdapter(this.getBrowser()){

            @Override
            public void onDevToolsMethodResult(CefBrowser cefBrowser, int messageId, boolean success, String result, int resultSize) {
                try {
                    try {
                        JsonObject json = (JsonObject)Jsoner.deserialize(result);
                        screenshotResult.complete(json.getOrDefault("data", "").getBytes(StandardCharsets.UTF_8));
                    }
                    catch (JsonException e) {
                        screenshotResult.complete("".getBytes(StandardCharsets.UTF_8));
                        this.dispose();
                    }
                }
                finally {
                    this.dispose();
                }
            }
        };
        JsonObject jsonMessage = new JsonObject();
        jsonMessage.put("id", 0);
        jsonMessage.put("method", "Page.captureScreenshot");
        JsonObject clip = new JsonObject();
        if (width > 0 && height > 0) {
            JsonObject viewport = new JsonObject();
            viewport.put("x", x);
            viewport.put("y", y);
            viewport.put("width", width);
            viewport.put("height", height);
            viewport.put("scale", scale);
            clip.put("clip", viewport);
            jsonMessage.put("params", clip);
        }
        String message = jsonMessage.toJson();
        this.getBrowser().sendDevToolsMessage(message, message.length());
        return screenshotResult;
    }

    @Override
    public void ignoreCertificateErrors(boolean enable) {
        this.ignoreCertificateErrors = enable;
        if (!enable && this.getBrowser() != null) {
            CefCompletionCallback callback = new CefCompletionCallback(){

                @Override
                public void onComplete() {
                    Engine.debug("certificate exceptions cleared");
                }
            };
            if (this.getRequestContext() == null) {
                CefRequestContext.getGlobalContext().clearCertificateExceptions(callback);
            } else {
                this.getRequestContext().clearCertificateExceptions(callback);
            }
        }
    }

    public boolean isIgnoreCertificateErrors() {
        return this.ignoreCertificateErrors;
    }

    @Override
    public List<Object> getErrors() {
        return new ArrayList<Object>();
    }

    @Override
    public boolean close() {
        this.getBrowser().setCloseAllowed();
        this.getBrowser().setReference(null);
        this.getBrowser().close(true);
        this.clientHandler.dispose();
        this.unSubscribeAll();
        executor.shutdown();
        return true;
    }

    @Override
    public Object getUIComponent() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isLoading() {
        return this.getBrowser().isLoading();
    }

    @Override
    public void goBack() {
        this.getBrowser().goBack();
    }

    @Override
    public void goForward() {
        this.getBrowser().goForward();
    }

    @Override
    public boolean canGoBack() {
        return this.getBrowser().canGoBack();
    }

    @Override
    public boolean canGoForward() {
        return this.getBrowser().canGoForward();
    }

    @Override
    public void reload() {
        this.getBrowser().reload();
    }

    @Override
    public void stop() {
        this.getBrowser().stopLoad();
    }

    @Override
    public CompletableFuture<String> text() {
        final CompletableFuture<String> result = new CompletableFuture<String>();
        this.getBrowser().getMainFrame().getSource(new CefStringVisitor(){

            @Override
            public void visit(String text) {
                result.complete(text);
            }
        });
        return result;
    }

    @Override
    public String getUrl() {
        return this.getBrowser().getURL();
    }

    public CompletableFuture<Object> sendDevToolsMessage(String devToolsMethod, List<Map.Entry<String, Object>> params, String wanted) {
        final CompletableFuture<Object> messageResult = new CompletableFuture<Object>();
        this.created.thenRun(() -> {
            final int id = this.messageId++;
            new CefDevToolsMessageObserverAdapter(this.getBrowser()){

                @Override
                public void onDevToolsMethodResult(CefBrowser cefBrowser, int messageId, boolean success, String result, int resultSize) {
                    try {
                        IndependentBrowser.this.debugPrint("onDevToolsMethodResult: " + result);
                        if (id != messageId) {
                            return;
                        }
                        try {
                            JsonObject json = (JsonObject)Jsoner.deserialize(result);
                            messageResult.complete(json.get("result"));
                        }
                        catch (JsonException e) {
                            messageResult.completeExceptionally(e.getCause());
                        }
                    }
                    finally {
                        this.dispose();
                    }
                }
            };
            JsonObject jsonMessage = new JsonObject();
            jsonMessage.put("id", id);
            jsonMessage.put("method", devToolsMethod);
            jsonMessage.put("params", this.createJsonObject(params));
            String devToolsMessage = jsonMessage.toJson();
            this.getBrowser().sendDevToolsMessage(devToolsMessage, devToolsMessage.length());
        });
        return messageResult;
    }

    private JsonObject createJsonObject(List<Map.Entry<String, Object>> params) {
        JsonObject jsonParams = new JsonObject();
        params.forEach(entry -> {
            Object value = entry.getValue();
            if (value == null) {
                jsonParams.put((String)entry.getKey(), value);
            } else if (value instanceof Integer) {
                jsonParams.put((String)entry.getKey(), (Integer)value);
            } else if (value instanceof String) {
                jsonParams.put((String)entry.getKey(), (String)value);
            } else if (value instanceof Boolean) {
                jsonParams.put((String)entry.getKey(), (Boolean)value);
            } else {
                boolean cfr_ignored_0 = value instanceof List;
            }
        });
        return jsonParams;
    }

    public void addMessageRoute(String queryFunctionName, String cancelQueryFunctionName, final Function<String, String> result) {
        this.isCreated().thenRun(() -> {
            CefMessageRouter.CefMessageRouterConfig config = new CefMessageRouter.CefMessageRouterConfig(queryFunctionName, cancelQueryFunctionName);
            CefMessageRouter messageRouter_ = CefMessageRouter.create(config);
            CefMessageRouterHandlerAdapter newHandler = new CefMessageRouterHandlerAdapter(){

                @Override
                public boolean onQuery(CefBrowser browser, CefFrame frame, long queryId, String request, boolean persistent, CefQueryCallback callback) {
                    try {
                        executor.submit(() -> callback.success((String)result.apply(request)));
                        return true;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return false;
                    }
                }
            };
            messageRouter_.addHandler(newHandler, false);
            this.getClientHandler().addMessageRouter(messageRouter_);
        });
    }

    @Override
    public void showDevTools() {
        this.isCreated().thenRun(() -> this.getBrowser().getDevTools().createImmediately());
    }

    @Override
    public CompletableFuture<Boolean> printToPdf(String path, PdfPrintSettings settings) {
        final CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        CefPdfPrintSettings pdfPrintSettings = new CefPdfPrintSettings();
        if (settings != null) {
            pdfPrintSettings.header_footer_enabled = settings.header_footer_enabled;
            pdfPrintSettings.header_footer_title = settings.header_footer_title;
            pdfPrintSettings.header_footer_url = settings.header_footer_url;
            pdfPrintSettings.landscape = settings.landscape;
            pdfPrintSettings.backgrounds_enabled = settings.backgrounds_enabled;
            if (settings.page_width >= 1000) {
                pdfPrintSettings.page_width = settings.page_width;
            }
            if (settings.page_height >= 1000) {
                pdfPrintSettings.page_height = settings.page_height;
            }
            pdfPrintSettings.selection_only = settings.selection_only;
            pdfPrintSettings.scale_factor = settings.scale_factor;
            pdfPrintSettings.margin_top = settings.margin_top;
            pdfPrintSettings.margin_right = settings.margin_right;
            pdfPrintSettings.margin_bottom = settings.margin_bottom;
            pdfPrintSettings.margin_left = settings.margin_left;
            if (settings.margin_type != null) {
                pdfPrintSettings.margin_type = CefPdfPrintSettings.MarginType.valueOf(settings.margin_type.name());
            }
        }
        this.isCreated().thenRun(() -> this.getBrowser().printToPDF(path, pdfPrintSettings, new CefPdfPrintCallback(){

            @Override
            public void onPdfPrintFinished(String path, boolean ok) {
                result.complete(ok);
            }
        }));
        return result;
    }

    @Override
    public CompletableFuture<Boolean> printToPdf(String path) {
        return this.printToPdf(path, null);
    }

    class ActionData {
        public EventType eventType;
        public Runnable action;

        public ActionData(EventType eventType, Runnable action) {
            this.eventType = eventType;
            this.action = action;
        }
    }
}

