/*
 * Decompiled with CFR 0.152.
 */
package com.equo.chromium.internal;

import com.equo.chromium.internal.ResourceExpander;
import com.equo.chromium.internal.Utils;
import com.equo.chromium.swt.internal.SWTEngine;
import com.equo.chromium.swt.internal.spi.DynamicCefSchemeHandlerFactory;
import com.equo.chromium.swt.internal.spi.SchemeDomainPair;
import com.equo.chromium.swt.internal.spi.SchemeHandler;
import com.equo.chromium.swt.internal.spi.SchemeHandlerManager;
import com.equo.chromium.swt.internal.spi.StaticCefSchemeHandlerFactory;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.cef.CefApp;
import org.cef.CefAppStandalone;
import org.cef.CefAppSwing;
import org.cef.CefAppSwt;
import org.cef.CefClient;
import org.cef.CefSettings;
import org.cef.OS;
import org.cef.SystemBootstrap;
import org.cef.WindowingToolkit;
import org.cef.browser.CefBrowser;
import org.cef.callback.CefSchemeRegistrar;
import org.cef.handler.CefAppHandlerAdapter;

public class Engine {
    private static final String CEFVERSION = "5249";
    private static final String SUBDIR = "chromium-5249";
    private static final String SCHEME_FILE = "file";
    private static Path libsPath;
    public static final boolean debug;
    private static AtomicBoolean shuttingDown;
    private static List<SchemeDomainPair> registeredSchemeData;
    private static CefApp app;
    public static final CompletableFuture<Boolean> ready;
    private static AtomicBoolean closing;
    private static boolean multiThreaded;

    static {
        Engine.loadLib();
        debug = Boolean.valueOf(System.getProperty("chromium.debug", "false"));
        shuttingDown = new AtomicBoolean();
        ready = new CompletableFuture();
        closing = new AtomicBoolean();
    }

    private static void loadLib() {
        if (OS.isLinux() && (multiThreaded = Boolean.getBoolean("chromium.multi_threaded_message_loop")) && Boolean.valueOf(System.getProperty("chromium.debug", "false")).booleanValue()) {
            System.out.println("J: multi_threaded_message_loop enabled");
        }
        libsPath = Engine.findLibsPath().resolve(SUBDIR);
        SystemBootstrap.setLoader(new SystemBootstrap.Loader(){

            @Override
            public void loadLibrary(String libname) {
                System.load(libsPath.resolve(System.mapLibraryName(libname)).toString());
            }
        });
        if (!Files.exists(libsPath, new LinkOption[0])) {
            throw new RuntimeException("Missing binaries for Equo Chromium Browser.");
        }
        boolean checkGtkInit = Engine.checkGtkInit();
        String[] args = Engine.getChromiumArgs(libsPath, Boolean.getBoolean("chromium.init_threads"), checkGtkInit);
        if (!CefApp.startup(args)) {
            if (checkGtkInit) {
                throw new RuntimeException("To run Chromium on Wayland, set env var GDK_BACKEND=x11 or call ChromiumBrowser.earlyInit() before creating a window");
            }
            throw new RuntimeException("Failed to load binaries for Equo Chromium Browser.");
        }
    }

    private static boolean checkGtkInit() {
        if (!OS.isLinux()) {
            return false;
        }
        String backend = System.getenv("GDK_BACKEND");
        String session = System.getenv("XDG_SESSION_TYPE");
        boolean checkGtkInit = "wayland".equals(session) && !"x11".equals(backend);
        return checkGtkInit;
    }

    private static Path findLibsPath() {
        String binariesBsn;
        block6: {
            String chromiumPath = System.getProperty("chromium.path", "");
            if (!chromiumPath.isEmpty() && Files.exists(Paths.get(chromiumPath, SUBDIR).toAbsolutePath(), new LinkOption[0])) {
                return Paths.get(chromiumPath, new String[0]).toAbsolutePath().normalize();
            }
            String arch = Engine.getArch();
            binariesBsn = "com.equo.chromium.cef." + Utils.getWindowing() + "." + Utils.getOS() + "." + arch;
            try {
                Class<?> fragmentClass = Class.forName("com.equo.chromium.ChromiumFragment");
                CodeSource codeSource = fragmentClass.getProtectionDomain().getCodeSource();
                if (codeSource == null) break block6;
                URI loc = Engine.toURI(codeSource.getLocation());
                Path fragment = Paths.get(loc).toAbsolutePath().normalize();
                try {
                    Path extractPath;
                    if (Files.isRegularFile(fragment, new LinkOption[0]) && (extractPath = ResourceExpander.extractFromJar(chromiumPath, arch, SUBDIR, fragmentClass)) != null) {
                        return extractPath;
                    }
                    Files.walkFileTree(fragment, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            ResourceExpander.setExecutable(file.toFile());
                            return super.visitFile(file, attrs);
                        }
                    });
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return fragment;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        throw new RuntimeException("plugin/jar '" + binariesBsn + "' is missing and system property 'chromium.path' is not correctly set.");
    }

    private static URI toURI(URL url) throws URISyntaxException, UnsupportedEncodingException {
        if (SCHEME_FILE.equals(url.getProtocol())) {
            String pathString = url.toExternalForm().substring(5);
            if (pathString.indexOf(47) != 0) {
                pathString = String.valueOf('/') + pathString;
            }
            return new URI(SCHEME_FILE, null, URLDecoder.decode(pathString, "UTF-8"), null);
        }
        try {
            return new URI(url.toExternalForm());
        }
        catch (URISyntaxException e) {
            return new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
        }
    }

    public static void initCEF() {
        Engine.initCEF(BrowserType.SWT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void initCEF(final BrowserType browserType) {
        Class<Engine> clazz = Engine.class;
        synchronized (Engine.class) {
            if (app == null) {
                CefSettings settings = new CefSettings();
                try {
                    settings.remote_debugging_port = Integer.parseInt(System.getProperty("chromium.debug_port", System.getProperty("chromium.remote_debugging_port", "0")));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                Path data = Paths.get(System.getProperty("chromium.home", System.getProperty("user.home")), ".equo");
                String cache = data.resolve("cefcache").toAbsolutePath().toString();
                settings.cache_path = System.getProperty("chromium.cache_path", cache);
                settings.log_file = System.getProperty("chromium.log_file", data.resolve("cef.log").toString());
                settings.log_severity = debug ? CefSettings.LogSeverity.LOGSEVERITY_INFO : CefSettings.LogSeverity.LOGSEVERITY_DISABLE;
                boolean external_message_pump = true;
                if (OS.isMacintosh()) {
                    settings.browser_subprocess_path = libsPath.resolve("equochro Helper.app/Contents/MacOS/equochro Helper").toString();
                    settings.resources_dir_path = libsPath.resolve("Chromium Embedded Framework.framework").resolve("Resources").toString();
                } else if (OS.isWindows()) {
                    settings.browser_subprocess_path = libsPath.resolve("equochro_helper.exe").toString();
                    settings.resources_dir_path = libsPath.toString();
                    settings.locales_dir_path = libsPath.resolve("locales").toString();
                    settings.multi_threaded_message_loop = System.getProperty("chromium.multi_threaded_message_loop") != null ? Boolean.getBoolean("chromium.multi_threaded_message_loop") : false;
                } else if (OS.isLinux()) {
                    settings.browser_subprocess_path = libsPath.resolve("equochro_helper").toString();
                    settings.resources_dir_path = libsPath.toString();
                    settings.locales_dir_path = libsPath.resolve("locales").toString();
                    settings.multi_threaded_message_loop = multiThreaded;
                    external_message_pump = false;
                }
                settings.external_message_pump = !settings.multi_threaded_message_loop && (System.getProperty("chromium.external_message_pump") != null ? Boolean.getBoolean("chromium.external_message_pump") : external_message_pump);
                String[] args = Engine.getChromiumArgs(libsPath, false, false);
                final SchemeHandlerManager schemeHandlerManager = SchemeHandlerManager.get();
                registeredSchemeData = schemeHandlerManager != null ? schemeHandlerManager.getRegisteredSchemes() : Collections.emptyList();
                WindowingToolkit windowToolkit = null;
                switch (browserType) {
                    case STANDALONE: {
                        windowToolkit = new CefAppStandalone();
                        settings.external_message_pump = false;
                        break;
                    }
                    case SWING: {
                        if (OS.isLinux()) {
                            System.loadLibrary("jawt");
                        }
                        windowToolkit = new CefAppSwing();
                        settings.external_message_pump = false;
                        settings.multi_threaded_message_loop = !OS.isMacintosh();
                        break;
                    }
                    default: {
                        int loopTime = !settings.external_message_pump && !registeredSchemeData.isEmpty() ? 5 : 33;
                        windowToolkit = new CefAppSwt(loopTime, settings.external_message_pump);
                    }
                }
                CefApp.setWindowingToolkit(windowToolkit);
                CefApp.addAppHandler(new CefAppHandlerAdapter(args){

                    @Override
                    public void onRegisterCustomSchemes(CefSchemeRegistrar registrar) {
                        if (!registeredSchemeData.isEmpty()) {
                            for (SchemeDomainPair schemeDomain : registeredSchemeData) {
                                String scheme = schemeDomain.getScheme();
                                registrar.addCustomScheme(scheme, true, false, false, true, true, false, true);
                            }
                        }
                    }

                    @Override
                    public void onScheduleMessagePumpWork(long delay_ms) {
                        if (shuttingDown.get()) {
                            Engine.debug("Ignoring onScheduleMessagePumpWork due shuttingDown");
                            return;
                        }
                        super.onScheduleMessagePumpWork(delay_ms);
                    }

                    @Override
                    public void onContextInitialized() {
                        if (!registeredSchemeData.isEmpty() && app != null) {
                            for (SchemeDomainPair schemeData : registeredSchemeData) {
                                SchemeHandler schemeHandler = schemeHandlerManager.getSchemeHandler(schemeData.getScheme(), schemeData.getDomain());
                                app.registerSchemeHandlerFactory(schemeData.getScheme(), schemeData.getDomain(), schemeHandler == null ? new DynamicCefSchemeHandlerFactory(schemeHandlerManager) : new StaticCefSchemeHandlerFactory(schemeHandlerManager, schemeData));
                            }
                        }
                        if (BrowserType.SWT.equals((Object)browserType)) {
                            SWTEngine.onContextInitialized(app);
                        }
                        ready.complete(true);
                    }

                    @Override
                    public boolean onBeforeTerminate() {
                        if (shuttingDown.get()) {
                            return false;
                        }
                        shuttingDown.set(true);
                        Engine.internalShutdown();
                        return true;
                    }
                });
                try {
                    app = CefApp.getInstance(settings);
                }
                catch (UnsatisfiedLinkError e) {
                    if ("gtk".equals(Utils.getWindowing()) && e.getMessage().contains("libgconf")) {
                        System.load(libsPath.resolve("libgconf-2.so.4").toString());
                        app = CefApp.getInstance(settings);
                    }
                    throw e;
                }
                if (BrowserType.SWT.equals((Object)browserType)) {
                    SWTEngine.initCef(closing, shuttingDown, () -> Engine.internalShutdown());
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    static String[] getChromiumArgs(Path libsPath, boolean addXInitThreads, boolean addGtkInitCheck) {
        ArrayList<String> args = new ArrayList<String>();
        String vmArg = System.getProperty("chromium.args", System.getProperty("swt.chromium.args"));
        if (vmArg != null) {
            String[] lines = vmArg.replace("\\;", "\\#$").split(";");
            Arrays.stream(lines).map(line -> line.replace("\\#$", ";")).forEach(l -> {
                boolean bl = args.add((String)l);
            });
        }
        if (OS.isLinux()) {
            args.add("--disable-gpu-compositing");
            if (addXInitThreads) {
                args.add("XInitThreads");
            }
            if (addGtkInitCheck) {
                args.add("GTKInitCheck");
            }
        } else if (OS.isMacintosh()) {
            args.add("--framework-dir-path=" + libsPath.resolve("Chromium Embedded Framework.framework"));
            args.add("--main-bundle-path=" + libsPath.resolve("equochro Helper.app"));
        }
        return args.toArray(new String[args.size()]);
    }

    private static void internalShutdown() {
        if (app == null) {
            return;
        }
        app.dispose();
        app = null;
    }

    public static <T extends CefClient> T createClient() {
        return app.createClient();
    }

    public static void startCefLoop() {
        app.runMessageLoop();
    }

    public static void quitCefLoop() {
        app.quitMessageLoop();
    }

    private static String getArch() {
        String osArch = System.getProperty("os.arch");
        if (osArch.equals("i386") || osArch.equals("i686")) {
            return "x86";
        }
        if (osArch.equals("amd64")) {
            return "x86_64";
        }
        return osArch;
    }

    public static void debug(String log) {
        if (debug) {
            System.out.println("J:" + log);
        }
    }

    public static void debug(String log, CefBrowser cefBrowser) {
        if (debug) {
            int identifier = cefBrowser != null ? cefBrowser.getIdentifier() : -1;
            System.out.println(String.valueOf(System.currentTimeMillis() / 1000L) + ":J" + identifier + ":" + Thread.currentThread().getName() + ":" + log);
        }
    }

    public static boolean isRegisteredProtocol(String url) {
        if (registeredSchemeData != null) {
            for (SchemeDomainPair schemeDomain : registeredSchemeData) {
                String scheme = schemeDomain.getScheme();
                if (!url.startsWith(scheme)) continue;
                return true;
            }
        }
        return false;
    }

    public static enum BrowserType {
        SWT,
        STANDALONE,
        SWING;

    }
}

