/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.co;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.co.b;
import ch.ionesoft.ilp.base.co.o;
import ch.ionesoft.ilp.base.ex.g;
import ch.ionesoft.ilp.base.ex.h;
import ch.ionesoft.ilp.base.he.SystemHelper;
import ch.ionesoft.ilp.book.analytics.a;
import ch.ionesoft.ilp.book.cl.f;
import ch.ionesoft.ilp.book.cl.j;
import ch.ionesoft.ilp.book.co.IAUserManager;
import ch.ionesoft.ilp.book.co.ILPAdvertisementController;
import ch.ionesoft.ilp.book.co.ILPBookRegistry;
import ch.ionesoft.ilp.book.co.ILPBookSettingsHelper;
import ch.ionesoft.ilp.book.co.ILPConfigurationManager;
import ch.ionesoft.ilp.book.co.ILPInitializer;
import ch.ionesoft.ilp.book.co.ILPLessonsManager;
import ch.ionesoft.ilp.book.co.ILPProfileManager;
import ch.ionesoft.ilp.book.msg.q;
import ch.ionesoft.ilp.book.syn.d;
import ch.ionesoft.ilp.co.AbstractAppSettingsHelper;
import ch.ionesoft.ilp.co.ILPViewRegistry;
import ch.ionesoft.ilp.co.c;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Locale;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.SystemConfiguration;
import org.apache.commons.lang3.StringUtils;

public abstract class ILPAbstractAppInitializer {
    private static ILogger logger = ILPLogManager.getLogger(ILPAbstractAppInitializer.class);
    public AbstractAppSettingsHelper appSettingsHelper;
    protected Class applicationConfigClass;

    public static void initLogger() {
        logger = ILPLogManager.getLogger(ILPAbstractAppInitializer.class);
    }

    public void startApplication() throws ConfigurationException, ch.ionesoft.ilp.base.ex.a, h {
        this.configureBaseSystem();
        this.copyWorkspaceFolderFromBundle();
        this.configureProfile();
        a.a().b("Start App");
        this.startServices();
        ILPInitializer.instance().finalizeDBMigration();
        this.configureUI();
        this.openUI();
    }

    protected void configureBaseSystem() throws ConfigurationException {
        logger.b((Object)"1. Configure base system");
        this.initializeWorkspace();
        this.initializeRegistry();
        this.initializeRegistryAdditional();
        this.initializeHelpers();
        this.initializeLocations();
        this.initializeLocalizableStrings();
        this.initializeLogger();
        this.initializeLanguage();
    }

    private void initializeRegistryAdditional() {
        ch.ionesoft.ilp.base.co.f.b().H(ILPBookRegistry.instance().getPlatformFactory().getScreenResolution());
    }

    protected abstract void initializeWorkspace();

    protected void initializeRegistry() {
        this.appSettingsHelper.initializeRegistryAndSettings();
        this.appSettingsHelper.initializeUserDefaults();
        this.appSettingsHelper.initializeViewFactories();
    }

    protected abstract void initializeHelpers();

    protected abstract void initializeLocations() throws ConfigurationException;

    protected abstract void initializeLogger();

    protected void configureProfile() {
        logger.b((Object)"2. Configuring profile");
        ILPProfileManager.instance().init();
    }

    protected abstract void startServices() throws ConfigurationException, ch.ionesoft.ilp.base.ex.a, h;

    protected void initializeLocations(URL uRL, File file) {
        ch.ionesoft.ilp.base.co.f.b().x(file.getAbsolutePath());
        ch.ionesoft.ilp.base.co.f.b().a(uRL);
    }

    protected void initializeLanguage() {
        String string = ch.ionesoft.ilp.base.co.g.a().e();
        Locale.setDefault(new Locale(string));
        logger.b((Object)("Setting language to: " + string));
    }

    protected void initializeLocalizableStrings() {
        String string = "ilpbaseLocalizable.strings";
        String string2 = "ilpbookLocalizable.strings";
        String string3 = "ilpIaLocalizable.strings";
        String string4 = "ilpviewLocalizable.strings";
        String string5 = "Root.strings";
        o.a().a(string, true, ch.ionesoft.ilp.base.co.g.class.getClassLoader(), "ch.ionesoft.ilp.base");
        o.a().a(string2, true, ILPBookSettingsHelper.class.getClassLoader(), "ch.ionesoft.ilp.book");
        o.a().a(string3, true, c.class.getClassLoader(), "ch.ionesoft.ilp.book");
        o.a().a(string4, true, c.class.getClassLoader(), "ch.ionesoft.ilp.config");
        o.a().a(string5, true, this.applicationConfigClass.getClassLoader(), ch.ionesoft.ilp.base.co.h.ar());
        this.initializeApplicationConfigLocalizableStrings();
    }

    protected void initializeApplicationConfigLocalizableStrings() {
        String string = b.b().s("ILPBase.application.localizedBundle");
        o.a().a(string, true, this.applicationConfigClass.getClassLoader(), ch.ionesoft.ilp.base.co.h.ar());
    }

    protected void configureUI() {
        logger.b((Object)"4. Configure UI");
    }

    protected void openUI() {
        logger.b((Object)"5. Present UI");
        this.initLoggingFactory();
    }

    protected abstract void initLoggingFactory();

    public void finalizeStartupAfterUIShown() {
        try {
            this.postConfigureAfterStartup();
            IAUserManager.askForSLA((boolean)false, (boolean)false);
            this.displayAppAlert();
            this.checkForContentUpdatesPresentAlways(false);
            this.runStartupDiagnosis();
        }
        catch (Exception exception) {
            logger.d((Object)"Could not finalize application after startup, reason: ", (Throwable)exception);
        }
    }

    protected abstract void copyWorkspaceFolderFromBundle();

    public void postConfigureAfterStartup() {
        logger.b((Object)"6. PostConfigure app");
        try {
            this.checkApplicationExeAndIniFiles();
        }
        catch (Exception exception) {
            logger.d((Object)"Could not check if {applicationName}.ini file exists", (Throwable)exception);
        }
        try {
            this.initializePreferences();
        }
        catch (Exception exception) {
            logger.d((Object)"Could not initialize preferences", (Throwable)exception);
        }
        try {
            this.synchronizeConfigurationFiles();
        }
        catch (Exception exception) {
            logger.d((Object)"Could not synchronize configuration files", (Throwable)exception);
        }
        try {
            if (!SystemHelper.isVeryFirstInstallation()) {
                ILPBookRegistry.instance().getAuthenticationService().l();
            }
        }
        catch (Exception exception) {
            logger.d((Object)"Could not handleAutoLogin", (Throwable)exception);
        }
        if (!ILPProfileManager.isInitialProfileActive() && ILPBookRegistry.instance().getAuthenticationService().h()) {
            try {
                ILPBookRegistry.instance().getCloudService().p();
            }
            catch (Exception exception) {
                logger.d((Object)"Could not updateCoursesProductsWithCloudData", (Throwable)exception);
            }
            try {
                j.a().d();
                this.synchronizeCloud();
                ch.ionesoft.ilp.book.sh.c.a().b(false);
            }
            catch (Exception exception) {
                logger.d((Object)"Could not synchronizeCloud or initializeSharingService", (Throwable)exception);
            }
        } else {
            logger.b((Object)"Skipping user dependent elements. Initial profile or not authenticated.");
        }
        q.a().b();
        q.a().d();
        ILPLessonsManager.getInstance().synchronizeTasks();
        ILPAdvertisementController.instance().downloadAdvertisementHTMLFile();
        try {
            this.finalizeApplicationStartup();
        }
        catch (Exception exception) {
            logger.d((Object)"Could not finalizeApplicationStartup", (Throwable)exception);
        }
        ch.ionesoft.ilp.base.co.f.b().ad();
        logger.b((Object)"Application initialized and ready to serve. Happy learning!");
    }

    protected abstract void checkApplicationExeAndIniFiles();

    protected abstract void initializePreferences();

    protected void finalizeApplicationStartup() {
    }

    protected void initializeCloudService() {
    }

    public void synchronizeConfigurationFiles() {
        ILPConfigurationManager iLPConfigurationManager = new ILPConfigurationManager();
        iLPConfigurationManager.synchronizeConfigurationFiles(false, false, true);
    }

    private void displayAppAlert() {
        final String string = ILPBookSettingsHelper.instance().getLocalizedAppAlertMessage();
        if (StringUtils.isNotBlank((CharSequence)string)) {
            ILPViewRegistry.f().g().runInUIThread(new Runnable(){

                @Override
                public void run() {
                    ch.ionesoft.ilp.base.co.f.b().D().alertWarning(string, new Object[0]);
                }
            });
        }
    }

    public void checkForContentUpdatesPresentAlways(boolean bl) {
        boolean bl2 = ILPInitializer.instance().checkForUpdates();
        if (bl2) {
            ch.ionesoft.ilp.base.co.f.b().D().displayNoticeCode("message.updates.available", new Object[0]);
        } else if (bl) {
            ch.ionesoft.ilp.base.co.f.b().D().displayNoticeCode("message.course.update.upToDate", new Object[0]);
        }
    }

    protected void postMigrateDatabaseData() {
    }

    protected void configureApplicationProperties(InputStream inputStream) {
        CompositeConfiguration compositeConfiguration = b.b().a();
        compositeConfiguration.addConfiguration((Configuration)new SystemConfiguration());
        try {
            try {
                PropertiesConfiguration propertiesConfiguration = new PropertiesConfiguration();
                propertiesConfiguration.load(inputStream);
                compositeConfiguration.addConfiguration((Configuration)propertiesConfiguration);
            }
            catch (Exception exception) {
                logger.d((Object)"Could not read application properties from stream", (Throwable)exception);
                throw new g("message.invalid.system.configuration");
            }
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                logger.d((Object)"Could not close stream", (Throwable)iOException);
            }
        }
    }

    protected abstract void runStartupDiagnosis();

    public void synchronizeCloud() {
        logger.b((Object)"Synchronizing cloud");
        try {
            f f2 = ILPBookRegistry.instance().getCloudService();
            if (f2.f()) {
                d.a().a(true, false);
            }
        }
        catch (Exception exception) {
            logger.d((Object)"Could not synchronize cloud", (Throwable)exception);
        }
    }
}

