/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.co;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.co.f;
import ch.ionesoft.ilp.base.co.g;
import ch.ionesoft.ilp.book.co.ILPBookSettingsHelper;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractAppSettingsHelper {
    private static final ILogger logger = ILPLogManager.getLogger(AbstractAppSettingsHelper.class);
    private static final boolean KEEP_REGISTERED_LICENSES = false;
    protected static final String CLUSTER_TYPE_VM_ARG = "cluster";
    protected static final String LOCAL_WIZARD_BASE_URL_ARG = "-localWizard";
    private static String LIMA_SERVER_RELATIVE_PATH = "/lima/v1";
    private static String OSC_SERVER_RELATIVE_PATH = "/osc/v1";
    private static String ATMA_SERVER_RELATIVE_PATH = "/atma";
    private static String GRES_SERVER_RELATIVE_PATH = "/gres";
    private static String LAG_SERVER_RELATIVE_PATH = "/lag";
    private static String IVS_SERVER_RELATIVE_PATH = "/ivs";
    private static String MSG_SERVER_RELATIVE_PATH = "/msg/v1";
    private static String DIT_SERVER_RELATIVE_PATH = "/dit";
    private static String LESSONS_SERVER_RELATIVE_PATH = "/beooklms";
    private static String UCS_SERVER_RELATIVE_PATH = "/ucs";
    private static String AUA_SERVER_RELATIVE_PATH = "/aua/v1";
    private static String AUA_SERVER_AUTH_ENDPOINT = "/authorize";
    private static String AUA_SERVER_TOKEN_ENDPOINT = "/token";
    private static String AUA_SERVER_REGISTER_ENDPOINT = "/register/client";
    protected Map<Object, Object> optionalProperties;

    public void initializeRegistryAndSettings() {
        logger.b((Object)"Initializing registry and settings");
        g.a().k(this.catalogEncryptionKey());
        ILPBookSettingsHelper iLPBookSettingsHelper = ILPBookSettingsHelper.instance();
        iLPBookSettingsHelper.setCloudEncryptionIV(this.cloudEncryptionIV());
        iLPBookSettingsHelper.setGlobalSharingEncryptionKey(this.globalSharingEncryptionKey());
        iLPBookSettingsHelper.setGlobalSharingEncryptionIV(this.globalSharingEncryptionIV());
        iLPBookSettingsHelper.setVeledesEtestingClientSecret(this.veledesEtestingClientSecret());
        iLPBookSettingsHelper.setMmtsEtestingApiKey(this.mmtsEtestingApiKey());
        f f2 = f.b();
        f2.b(this.getApplicationName());
        f2.a(this.getApplicationPluginId());
        f2.u(this.installationPropertiesEncryptionKey());
        f2.a(false);
        f2.t(this.trustStorePassword());
        f2.B(this.atmaBasicAuthenticationKey());
        f2.C(this.atmaBasicAuthenticationSecret());
    }

    public void initializeUserDefaults() {
        logger.b((Object)"Initializing user defaults");
    }

    public void initializeViewFactories() {
        logger.b((Object)"Initializing view factories");
    }

    protected void initializeAssetStageAndCluster(String string) {
        f f2 = f.b();
        f2.s(string);
        f2.g(this.clusterBaseUrl() + LIMA_SERVER_RELATIVE_PATH);
        f2.c(this.clusterBaseUrl() + ATMA_SERVER_RELATIVE_PATH);
        f2.d(this.clusterBaseUrl() + GRES_SERVER_RELATIVE_PATH);
        f2.e(this.clusterBaseUrl() + LAG_SERVER_RELATIVE_PATH);
        f2.f(this.clusterBaseUrl() + IVS_SERVER_RELATIVE_PATH);
        f2.h(this.clusterBaseUrl() + OSC_SERVER_RELATIVE_PATH);
        f2.i(this.clusterBaseUrl() + MSG_SERVER_RELATIVE_PATH);
        f2.j(this.initDitServer());
        f2.k(this.clusterBaseUrl() + LESSONS_SERVER_RELATIVE_PATH);
        f2.l(this.clusterBaseUrl() + UCS_SERVER_RELATIVE_PATH);
        f2.m(this.clusterBaseUrl() + AUA_SERVER_RELATIVE_PATH);
        f2.o(this.auaBaseUrl() + AUA_SERVER_AUTH_ENDPOINT);
        f2.p(this.auaBaseUrl() + AUA_SERVER_TOKEN_ENDPOINT);
        f2.n(this.auaBaseUrl() + AUA_SERVER_REGISTER_ENDPOINT);
        f2.q(this.auaClientId());
        f2.r(this.auaClientSecret());
        f2.F(this.assetEncryptionKey());
        f2.G(this.assetEncryptionIV());
        f2.e(this.isSkipLicenseVerification());
        f2.f(this.isSkipTokenVerification());
    }

    private String initDitServer() {
        String string = this.getLocalWizardBaseUrl();
        if (StringUtils.isBlank((CharSequence)string)) {
            return this.clusterBaseUrl() + DIT_SERVER_RELATIVE_PATH;
        }
        return string + DIT_SERVER_RELATIVE_PATH;
    }

    protected abstract String getLocalWizardBaseUrl();

    protected abstract String trustStorePassword();

    public abstract String getApplicationName();

    public abstract String getApplicationPluginId();

    protected abstract void determineClusterType();

    protected abstract String getReleaseSqmFile();

    protected abstract String getIntegrationSqmFile();

    protected abstract String getTestSqmFile();

    protected String catalogEncryptionKey() {
        return (String)this.optionalProperties.get("GLOBAL_CATALOG_ENCRYPTION_KEY");
    }

    protected String globalSharingEncryptionKey() {
        return (String)this.optionalProperties.get("GLOBAL_SHARING_ENCRYPTION_KEY");
    }

    protected String cloudEncryptionIV() {
        return (String)this.optionalProperties.get("GLOBAL_CLOUD_ENCTRYPTION_IV");
    }

    protected String globalSharingEncryptionIV() {
        return (String)this.optionalProperties.get("GLOBAL_SHARING_ENCRYPTION_IV");
    }

    protected String veledesEtestingClientSecret() {
        return (String)this.optionalProperties.get("VELEDES_ETESTING_CLIENT_SECRET");
    }

    protected String mmtsEtestingApiKey() {
        return (String)this.optionalProperties.get("MMTS_ETESTING_API_KEY");
    }

    protected String installationPropertiesEncryptionKey() {
        return (String)this.optionalProperties.get("INSTALLATION_PROPERTIES_ENCRYPTION_KEY");
    }

    protected String atmaBasicAuthenticationKey() {
        return (String)this.optionalProperties.get("ATMA_BASIC_AUTH_KEY");
    }

    protected String atmaBasicAuthenticationSecret() {
        return (String)this.optionalProperties.get("ATMA_BASIC_AUTH_SECRET");
    }

    private String clusterBaseUrl() {
        return (String)this.optionalProperties.get("CLUSTER_BASE_URL");
    }

    private String auaBaseUrl() {
        return (String)this.optionalProperties.get("AUA_BASE_URL");
    }

    private String auaClientId() {
        String string = (String)this.optionalProperties.get("AUA_CLIENT_ID");
        return string.trim();
    }

    private String auaClientSecret() {
        String string = (String)this.optionalProperties.get("AUA_CLIENT_SECRET");
        return string.trim();
    }

    private String assetEncryptionKey() {
        return (String)this.optionalProperties.get("ASSET_ENCRYPTION_KEY");
    }

    private String assetEncryptionIV() {
        return (String)this.optionalProperties.get("ASSET_ENCRYPTION_IV");
    }

    private boolean isSkipTokenVerification() {
        return Boolean.valueOf((String)this.optionalProperties.get("SKIP_TOKEN_VERIFICATION"));
    }

    private boolean isSkipLicenseVerification() {
        return Boolean.valueOf((String)this.optionalProperties.get("SKIP_LICENSE_VERIFICATION"));
    }
}

