/*
 * Decompiled with CFR 0.152.
 */
package org.rtf;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.stream.Collectors;
import org.rtf.RtfControlSymbol;
import org.rtf.RtfControlWord;
import org.rtf.RtfElement;
import org.rtf.RtfGroup;
import org.rtf.RtfParseException;
import org.rtf.RtfText;

public class RtfReader {
    private String rtf;
    private int pos;
    private int len;
    private char tchar;
    private RtfGroup group;
    public RtfGroup root = null;

    protected void getChar() {
        if (this.pos < this.rtf.length()) {
            this.tchar = this.rtf.charAt(this.pos++);
        }
    }

    protected int hexdec(String string) {
        return Integer.parseInt(string, 16);
    }

    protected boolean isDigit() {
        return this.tchar >= '0' && this.tchar <= '9';
    }

    protected boolean isLetter() {
        if (this.tchar >= 'A' && this.tchar <= 'Z') {
            return true;
        }
        return this.tchar >= 'a' && this.tchar <= 'z';
    }

    protected void parseStartGroup() {
        RtfGroup rtfGroup = new RtfGroup();
        if (this.group != null) {
            rtfGroup.parent = this.group;
        }
        if (this.root == null) {
            this.group = rtfGroup;
            this.root = rtfGroup;
        } else {
            this.group.children.add(rtfGroup);
            this.group = rtfGroup;
        }
    }

    protected void parseEndGroup() {
        this.group = this.group.parent;
    }

    protected void parseControlWord() {
        this.getChar();
        String string = "";
        while (this.isLetter()) {
            string = String.valueOf(string) + this.tchar;
            this.getChar();
        }
        int n2 = -1;
        boolean bl = false;
        if (this.tchar == '-') {
            this.getChar();
            bl = true;
        }
        while (this.isDigit()) {
            if (n2 == -1) {
                n2 = 0;
            }
            n2 = n2 * 10 + Integer.parseInt(String.valueOf(this.tchar));
            this.getChar();
        }
        if (n2 == -1) {
            n2 = 1;
        }
        if (bl) {
            n2 = -n2;
        }
        if (string.equals("u")) {
            if (this.tchar == ' ') {
                this.getChar();
            }
            if (this.tchar == '\\' && this.rtf.charAt(this.pos) == '\'') {
                this.pos += 3;
            }
            if (bl) {
                n2 += 65536;
            }
        } else if (this.tchar != ' ') {
            --this.pos;
        }
        RtfControlWord rtfControlWord = new RtfControlWord();
        rtfControlWord.word = string;
        rtfControlWord.parameter = n2;
        this.group.children.add(rtfControlWord);
    }

    protected void parseControlSymbol() {
        Object object;
        this.getChar();
        char c2 = this.tchar;
        int n2 = 0;
        if (c2 == '\'') {
            this.getChar();
            object = String.valueOf(this.tchar);
            this.getChar();
            String string = String.valueOf(this.tchar);
            n2 = this.hexdec(String.valueOf(object) + string);
        }
        object = new RtfControlSymbol();
        ((RtfControlSymbol)object).symbol = c2;
        ((RtfControlSymbol)object).parameter = n2;
        this.group.children.add((RtfElement)object);
    }

    protected void parseControl() {
        this.getChar();
        --this.pos;
        if (this.isLetter()) {
            this.parseControlWord();
        } else {
            this.parseControlSymbol();
        }
    }

    protected void parseText() throws RtfParseException {
        String string = "";
        boolean bl = false;
        do {
            bl = false;
            if (this.tchar == '\\') {
                this.getChar();
                switch (this.tchar) {
                    case '\\': 
                    case '{': 
                    case '}': {
                        break;
                    }
                    default: {
                        this.pos -= 2;
                        bl = true;
                        break;
                    }
                }
            } else if (this.tchar == '{' || this.tchar == '}') {
                --this.pos;
                bl = true;
            }
            if (bl) continue;
            string = String.valueOf(string) + this.tchar;
            this.getChar();
        } while (!bl && this.pos < this.len);
        RtfText rtfText = new RtfText();
        rtfText.text = string;
        if (this.group == null) {
            throw new RtfParseException("Invalid RTF file.");
        }
        this.group.children.add(rtfText);
    }

    public void parse(File file) throws RtfParseException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                this.parse(fileInputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            throw new RtfParseException(iOException.getMessage());
        }
    }

    public void parse(InputStream inputStream) throws RtfParseException {
        String string = new BufferedReader(new InputStreamReader(inputStream)).lines().collect(Collectors.joining("\n"));
        this.parse(string);
    }

    public void parse(String string) throws RtfParseException {
        this.rtf = string;
        this.pos = 0;
        this.len = this.rtf.length();
        this.group = null;
        this.root = null;
        while (this.pos < this.len) {
            this.getChar();
            if (this.tchar == '\n' || this.tchar == '\r') continue;
            switch (this.tchar) {
                case '{': {
                    this.parseStartGroup();
                    break;
                }
                case '}': {
                    this.parseEndGroup();
                    break;
                }
                case '\\': {
                    this.parseControl();
                    break;
                }
                default: {
                    this.parseText();
                }
            }
        }
    }
}

