/*
 * Decompiled with CFR 0.152.
 */
package org.rtf;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.rtf.RtfControlSymbol;
import org.rtf.RtfControlWord;
import org.rtf.RtfElement;
import org.rtf.RtfGroup;
import org.rtf.RtfState;
import org.rtf.RtfText;

public class RtfHtml {
    private String output;
    private Stack<RtfState> states;
    private RtfState state;
    private RtfState previousState;
    private Map<String, Boolean> openedTags;
    private List<String> fonttbl;
    private List<String> colortbl;
    private boolean newRootPar;

    public String format(RtfGroup rtfGroup) {
        return this.format(rtfGroup, false);
    }

    public String format(RtfGroup rtfGroup, boolean bl) {
        this.previousState = null;
        this.openedTags = new LinkedHashMap<String, Boolean>();
        this.openedTags.put("span", false);
        this.openedTags.put("p", true);
        this.states = new Stack();
        this.state = new RtfState();
        this.states.push(this.state);
        this.output = "<p>";
        this.newRootPar = true;
        this.formatGroup(rtfGroup);
        if (bl) {
            this.wrapTags();
        }
        return this.output;
    }

    protected void extractFontTable(List<RtfElement> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = list.size();
        int n3 = 1;
        while (n3 < n2) {
            if (list.get(n3) instanceof RtfGroup) {
                RtfGroup rtfGroup = (RtfGroup)list.get(n3);
                String string = "";
                List<RtfElement> list2 = rtfGroup.children;
                int n4 = 1;
                while (n4 < list2.size()) {
                    RtfElement rtfElement;
                    RtfElement rtfElement2 = list2.get(n4);
                    if (rtfElement2 instanceof RtfControlWord) {
                        rtfElement = (RtfControlWord)rtfElement2;
                        if (!rtfElement.word.equals("fnil")) {
                            if (rtfElement.word.equals("froman")) {
                                string = "Times,serif";
                            } else if (rtfElement.word.equals("fswiss")) {
                                string = "Helvetica,Swiss,sans-serif";
                            } else if (rtfElement.word.equals("fmodern")) {
                                string = "Courier,monospace";
                            } else if (rtfElement.word.equals("fscript")) {
                                string = "Cursive";
                            } else if (rtfElement.word.equals("fdecor")) {
                                string = "'ITC Zapf Chancery'";
                            } else if (rtfElement.word.equals("ftech")) {
                                string = "Symbol,Wingdings";
                            } else if (rtfElement.word.equals("fbidi")) {
                                string = "Miriam";
                            } else if (rtfElement.word.equals("fcharset") && rtfElement.parameter == 2) {
                                string = "Symbol";
                            }
                        }
                    }
                    if (rtfElement2 instanceof RtfText) {
                        rtfElement = (RtfText)rtfElement2;
                        String string2 = ((RtfText)rtfElement).text;
                        if (!";".equals(string2)) {
                            if (string2.endsWith(";")) {
                                string2 = string2.substring(0, string2.length() - 1);
                            }
                            if (!string.contains(string2)) {
                                if (string.length() > 0) {
                                    string = "," + string;
                                }
                                string = "'" + string2 + "'" + string;
                            }
                        }
                    }
                    ++n4;
                }
                arrayList.add(string);
            }
            ++n3;
        }
        this.fonttbl = arrayList;
    }

    protected void extractColorTable(List<RtfElement> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(null);
        int n2 = list.size();
        String string = "";
        int n3 = 2;
        while (n3 < n2) {
            if (list.get(n3) instanceof RtfControlWord) {
                int n4 = ((RtfControlWord)list.get((int)n3)).parameter;
                int n5 = ((RtfControlWord)list.get((int)(n3 + 1))).parameter;
                int n6 = ((RtfControlWord)list.get((int)(n3 + 2))).parameter;
                string = String.format("#%02x%02x%02x", n4, n5, n6);
                n3 += 2;
            } else if (list.get(n3) instanceof RtfText) {
                arrayList.add(string);
            }
            ++n3;
        }
        this.colortbl = arrayList;
    }

    protected void formatGroup(RtfGroup rtfGroup) {
        if (rtfGroup.getType().equals("fonttbl")) {
            this.extractFontTable(rtfGroup.children);
            return;
        }
        if (rtfGroup.getType().equals("colortbl")) {
            this.extractColorTable(rtfGroup.children);
            return;
        }
        if (rtfGroup.getType().equals("stylesheet")) {
            return;
        }
        if (rtfGroup.getType().equals("info")) {
            return;
        }
        if (rtfGroup.getType().length() >= 4 && rtfGroup.getType().substring(0, 4).equals("pict")) {
            return;
        }
        if (rtfGroup.isDestination()) {
            return;
        }
        this.state = (RtfState)this.state.clone();
        this.states.push(this.state);
        for (RtfElement rtfElement : rtfGroup.children) {
            if (rtfElement instanceof RtfGroup) {
                this.formatGroup((RtfGroup)rtfElement);
                continue;
            }
            if (rtfElement instanceof RtfControlWord) {
                this.formatControlWord((RtfControlWord)rtfElement);
                continue;
            }
            if (rtfElement instanceof RtfControlSymbol) {
                this.formatControlSymbol((RtfControlSymbol)rtfElement);
                continue;
            }
            if (!(rtfElement instanceof RtfText)) continue;
            this.formatText((RtfText)rtfElement);
        }
        this.states.pop();
        this.state = this.states.peek();
    }

    protected void formatControlWord(RtfControlWord rtfControlWord) {
        if (rtfControlWord.word.equals("plain") || rtfControlWord.word.equals("pard")) {
            this.state.reset();
        } else if (rtfControlWord.word.equals("f")) {
            this.state.font = rtfControlWord.parameter;
        } else if (rtfControlWord.word.equals("b")) {
            this.state.bold = rtfControlWord.parameter > 0;
        } else if (rtfControlWord.word.equals("i")) {
            this.state.italic = rtfControlWord.parameter > 0;
        } else if (rtfControlWord.word.equals("ul")) {
            this.state.underline = rtfControlWord.parameter > 0;
        } else if (rtfControlWord.word.equals("ulnone")) {
            this.state.underline = false;
        } else if (rtfControlWord.word.equals("strike")) {
            this.state.strike = rtfControlWord.parameter > 0;
        } else if (rtfControlWord.word.equals("v")) {
            this.state.hidden = rtfControlWord.parameter > 0;
        } else if (rtfControlWord.word.equals("fs")) {
            this.state.fontSize = (int)Math.ceil((double)rtfControlWord.parameter / 24.0 * 16.0);
        } else if (rtfControlWord.word.equals("dn")) {
            this.state.dnup = (int)Math.ceil((double)rtfControlWord.parameter / 24.0 * 16.0) * -1;
        } else if (rtfControlWord.word.equals("up")) {
            this.state.dnup = (int)Math.ceil((double)rtfControlWord.parameter / 24.0 * 16.0);
        } else if (rtfControlWord.word.equals("sub")) {
            this.state.subscript = true;
            this.state.superscript = false;
        } else if (rtfControlWord.word.equals("super")) {
            this.state.subscript = false;
            this.state.superscript = true;
        } else if (rtfControlWord.word.equals("nosupersub")) {
            this.state.subscript = false;
            this.state.superscript = false;
        } else if (rtfControlWord.word.equals("cf")) {
            this.state.textColor = rtfControlWord.parameter;
        } else if (rtfControlWord.word.equals("cb") || rtfControlWord.word.equals("chcbpat") || rtfControlWord.word.equals("highlight")) {
            this.state.background = rtfControlWord.parameter;
        } else if (rtfControlWord.word.equals("lquote")) {
            this.applyStyle("&lsquo;");
        } else if (rtfControlWord.word.equals("rquote")) {
            this.applyStyle("&rsquo;");
        } else if (rtfControlWord.word.equals("ldblquote")) {
            this.applyStyle("&ldquo;");
        } else if (rtfControlWord.word.equals("rdblquote")) {
            this.applyStyle("&rdquo;");
        } else if (rtfControlWord.word.equals("emdash")) {
            this.applyStyle("&mdash;");
        } else if (rtfControlWord.word.equals("endash")) {
            this.applyStyle("&ndash;");
        } else if (rtfControlWord.word.equals("emspace")) {
            this.applyStyle("&emsp;");
        } else if (rtfControlWord.word.equals("enspace")) {
            this.applyStyle("&ensp;");
        } else if (rtfControlWord.word.equals("tab")) {
            this.applyStyle("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        } else if (rtfControlWord.word.equals("line")) {
            this.applyStyle("<br>");
        } else if (rtfControlWord.word.equals("bullet")) {
            this.applyStyle("&bull;");
        } else if (rtfControlWord.word.equals("u")) {
            this.applyStyle("&#" + rtfControlWord.parameter + ";");
        } else if (rtfControlWord.word.equals("par") || rtfControlWord.word.equals("row")) {
            this.closeTags();
            this.output = String.valueOf(this.output) + "<p>";
            this.openedTags.put("p", true);
            this.newRootPar = true;
        }
    }

    protected void applyStyle(String string) {
        if (!this.state.equals(this.previousState) || this.newRootPar) {
            String string2 = "";
            if (this.state.font >= 0) {
                string2 = String.valueOf(string2) + "font-family:" + this.printFontFamily(this.state.font) + ";";
            }
            if (this.state.bold) {
                string2 = String.valueOf(string2) + "font-weight:bold;";
            }
            if (this.state.italic) {
                string2 = String.valueOf(string2) + "font-style:italic;";
            }
            if (this.state.underline) {
                string2 = String.valueOf(string2) + "text-decoration:underline;";
            }
            if (this.state.strike) {
                string2 = String.valueOf(string2) + "text-decoration:strikethrough;";
            }
            if (this.state.hidden) {
                string2 = String.valueOf(string2) + "display:none;";
            }
            if (this.state.fontSize != 0) {
                string2 = String.valueOf(string2) + "font-size:" + this.state.fontSize + "px;";
            }
            if (this.state.dnup != 0) {
                string2 = String.valueOf(string2) + this.calculateReducedFontSize() + "vertical-align:" + this.state.dnup + "px;";
            }
            if (this.state.subscript) {
                string2 = String.valueOf(string2) + this.calculateReducedFontSize() + "vertical-align:sub;";
            }
            if (this.state.superscript) {
                string2 = String.valueOf(string2) + this.calculateReducedFontSize() + "vertical-align:super;";
            }
            if (this.state.textColor != 0) {
                string2 = String.valueOf(string2) + "color:" + this.printColor(this.state.textColor) + ";";
            }
            if (this.state.background != 0) {
                string2 = String.valueOf(string2) + "background-color:" + this.printColor(this.state.background) + ";";
            }
            this.previousState = (RtfState)this.state.clone();
            this.closeTag("span");
            this.output = String.valueOf(this.output) + "<span style=\"" + string2 + "\">" + string;
            this.openedTags.put("span", true);
        } else {
            this.output = String.valueOf(this.output) + string;
        }
        this.newRootPar = false;
    }

    protected String calculateReducedFontSize() {
        String string;
        if (this.state.fontSize != 0) {
            int n2 = (int)Math.ceil((double)this.state.fontSize / 3.0 * 2.0);
            string = "font-size:" + n2 + "px;";
        } else {
            string = "font-size:smaller;";
        }
        return string;
    }

    protected String printFontFamily(int n2) {
        if (n2 >= 0 && n2 < this.fonttbl.size()) {
            return this.fonttbl.get(n2);
        }
        return "";
    }

    protected String printColor(int n2) {
        if (n2 >= 1 && n2 < this.colortbl.size()) {
            return this.colortbl.get(n2);
        }
        return "";
    }

    protected void closeTag(String string) {
        if (this.openedTags.get(string).booleanValue()) {
            this.output = String.valueOf(this.output) + "</" + string + ">";
            this.openedTags.put(string, false);
        }
    }

    protected void closeTags() {
        for (String string : this.openedTags.keySet()) {
            this.closeTag(string);
        }
    }

    protected void wrapTags() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n");
        stringBuilder.append("<html>\n");
        stringBuilder.append("  <head>\n");
        stringBuilder.append("    <meta content=\"text/html;charset=UTF-8\" http-equiv=\"content-type\"/>\n");
        stringBuilder.append("  </head>\n");
        stringBuilder.append("  <body>\n");
        stringBuilder.append(String.valueOf(this.output) + "\n");
        stringBuilder.append("  </body>\n");
        stringBuilder.append("</html>\n");
        this.output = stringBuilder.toString();
    }

    protected void formatControlSymbol(RtfControlSymbol rtfControlSymbol) {
        if (rtfControlSymbol.symbol == '\'') {
            this.applyStyle("&#" + rtfControlSymbol.parameter + ";");
        }
        if (rtfControlSymbol.symbol == '~') {
            this.output = String.valueOf(this.output) + "&nbsp;";
        }
    }

    protected void formatText(RtfText rtfText) {
        this.applyStyle(rtfText.text);
    }
}

