/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.base.he;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang3.StringUtils;

public class Zip {
    private static ILogger logger = ILPLogManager.getLogger(Zip.class);

    public boolean zipFolder(File file, File file2) {
        logger.b("Start to ZIP files");
        List<File> list = this.listFiles(file);
        File file3 = file2.getParentFile();
        FileOutputStream fileOutputStream = null;
        ZipOutputStream zipOutputStream = null;
        try {
            if (!file3.exists()) {
                file3.mkdirs();
            }
            fileOutputStream = new FileOutputStream(file2);
            zipOutputStream = new ZipOutputStream((OutputStream)fileOutputStream, Charset.forName("UTF-8"));
            byte[] byArray = new byte[1024];
            for (File file4 : list) {
                int n2;
                String string = file4.getAbsolutePath();
                String string2 = file.getAbsolutePath();
                string = StringUtils.removeStart((String)string, (String)string2);
                string = StringUtils.removeStart((String)string, (String)"\\");
                string = StringUtils.replace((String)string, (String)"\\", (String)"/");
                ZipEntry zipEntry = new ZipEntry(string);
                zipOutputStream.putNextEntry(zipEntry);
                FileInputStream fileInputStream = new FileInputStream(file4);
                while ((n2 = fileInputStream.read(byArray)) > 0) {
                    zipOutputStream.write(byArray, 0, n2);
                }
                fileInputStream.close();
                zipOutputStream.closeEntry();
            }
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            logger.d("Could not find file", fileNotFoundException);
            return false;
        }
        catch (Exception exception) {
            logger.d("Could not compress file, reason: " + exception);
            return false;
        }
        finally {
            try {
                zipOutputStream.closeEntry();
                zipOutputStream.close();
                logger.b("Saved ZIP File successfully to " + file2.getAbsolutePath());
            }
            catch (Exception exception) {
                logger.d("Could not close Zip output stream, reason: " + exception);
            }
        }
    }

    private List<File> listFiles(File file) {
        ArrayList<File> arrayList = new ArrayList<File>();
        Iterator iterator = FileUtils.iterateFiles((File)file, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.TRUE);
        while (iterator.hasNext()) {
            File file2 = (File)iterator.next();
            arrayList.add(file2);
        }
        return arrayList;
    }
}

