/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.base.he;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.co.o;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;

public abstract class ViewHelper {
    protected static ILogger logger = ILPLogManager.getLogger(ViewHelper.class);
    private String lastShownMessage = "";
    private DateTime lastShownMessageTime = DateTime.now();

    public static void initLogger() {
        logger = ILPLogManager.getLogger(ViewHelper.class);
    }

    protected boolean shouldShowMessagePossiblyAgain(String string) {
        if (string == null) {
            return false;
        }
        if (string.equals(this.lastShownMessage) && this.lastShownMessageTime.plus(2000L).isAfterNow()) {
            return false;
        }
        this.lastShownMessage = string;
        this.lastShownMessageTime = DateTime.now();
        return true;
    }

    public abstract void alertNoticeAsync(String var1, String var2);

    public void alertWarning(String string, Object ... objectArray) {
        String string2 = this.formatMessage(string, objectArray);
        this.showAlertView_titleCode(string2, "title.warning", true);
    }

    public void alertNotice(String string, Object ... objectArray) {
        String string2 = this.formatMessage(string, objectArray);
        this.showAlertView_titleCode(string2, "title.notice", false);
    }

    public void alertWarningCode(String string, Object ... objectArray) {
        String string2 = this.formatMessage(string, objectArray);
        this.showAlertView_titleCode(string2, "title.warning", true);
    }

    public void alertNoticeCode(String string, Object ... objectArray) {
        String string2 = this.formatMessage(string, objectArray);
        this.showAlertView_titleCode(string2, "title.notice", false);
    }

    public abstract void showAlertView_titleCode(String var1, String var2, boolean var3);

    public abstract void displayNotice_onView_delaySecs(String var1, Object var2, double var3);

    public abstract void displayNotice(String var1);

    public abstract void displayNoticeCode(String var1, Object ... var2);

    public abstract void displayWarningCode(String var1, Object ... var2);

    public abstract void displayWarning(String var1);

    public abstract void undisplayNotice(Object var1);

    public void say(String string, Object ... objectArray) {
        String string2 = this.formatMessage(string, objectArray);
        this.showAlertView_titleCode(string2, "", false);
    }

    public void sayCode(String string, Object ... objectArray) {
        String string2 = this.formatMessage(string, objectArray);
        this.showAlertView_titleCode(string2, "", false);
    }

    public boolean ask(String string, Object ... objectArray) {
        return this.askTitle(null, string, objectArray);
    }

    @Deprecated
    public boolean askCode(String string, Object ... objectArray) {
        return this.askTitleCode(null, string, objectArray);
    }

    public boolean askTitle(String string, String string2, Object ... objectArray) {
        return this.askTitleCode(string, string2, objectArray);
    }

    public abstract boolean askTitleCode(String var1, String var2, Object ... var3);

    public String askTextCode(String string, String string2) {
        return this.askText(o.a().d(string), o.a().d(string2));
    }

    public void askTextCodeAsync(String string, String string2, String string3, InputResultCallback inputResultCallback) {
        this.askTextAsync(o.a().d(string), o.a().d(string2), o.a().d(string3), inputResultCallback);
    }

    public String askPasswordCode(String string, String string2) {
        return this.askPassword(o.a().d(string), o.a().d(string2));
    }

    public abstract String askText(String var1, String var2);

    public abstract void askTextAsync(String var1, String var2, String var3, InputResultCallback var4);

    public abstract String askPassword(String var1, String var2);

    public Integer askNumberCode(String string, String string2) {
        return this.askNumber(o.a().d(string), o.a().d(string2));
    }

    public Integer askNumber(String string, String string2) {
        String string3 = this.askText(string, string2);
        if (StringUtils.isNotBlank((CharSequence)string3) && StringUtils.isNumeric((CharSequence)string3)) {
            return Integer.parseInt(string3);
        }
        return null;
    }

    public abstract int askOptionCode(String var1, String var2, String ... var3);

    public abstract void askOptionCodeAsync(AsyncViewCallback var1, String var2, String var3, String ... var4);

    public abstract void askOptionCodeDialogAsync(AsyncViewCallback var1, String var2, String var3, String ... var4);

    public abstract int askOption(String var1, String var2, String ... var3);

    @Deprecated
    public boolean confirm(String string, Object ... objectArray) {
        return this.confirmCode(string, objectArray);
    }

    @Deprecated
    public abstract boolean confirmCode(String var1, Object ... var2);

    public abstract void askCodeWithResultCallback(String var1, OnResultCallback var2);

    public String formatMessage(String string, Object ... objectArray) {
        if (string == null) {
            logger.d("Empty formatstring, returning <Unknown>");
            return "<Unknown>";
        }
        String string2 = o.a().b(string, objectArray);
        if (string2 == null) {
            string2 = string;
        }
        return string2;
    }

    public abstract void setParentView(Object var1);

    public abstract Object parentView();

    public void alertNoticeCodeAsync(String string) {
        this.alertNoticeCodeAsync(string, "title.notice");
    }

    public void alertNoticeAsync(String string) {
        this.alertNoticeAsync(string, "title.notice");
    }

    public void alertNoticeCodeAsync(String string, Object ... objectArray) {
        String string2 = this.formatMessage(string, objectArray);
        this.alertNoticeCodeAsync(string2, "title.notice");
    }

    public void alertNoticeCodeAsync(String string, String string2) {
        String string3 = o.a().d(string);
        this.alertNoticeAsync(string3, string2);
    }

    public abstract void closeAllExternalShells();

    public abstract void showNotificationBadge(int var1);

    public abstract void showNativeLoadingOverlay(String var1);

    public abstract void hideNativeLoadingOverlay();

    public abstract void showBlockingBrowserDialog(String var1, boolean var2, boolean var3, OnResultCallback var4);

    public static interface AsyncViewCallback {
        public void handleResult(int var1);
    }

    public static interface InputResultCallback {
        public void handleResult(String var1);
    }

    public static interface OnResultCallback {
        public void onYes();

        public void onNo();

        public void onCancel();
    }
}

