/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.base.he;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class UnZip {
    private static ILogger logger = ILPLogManager.getLogger(UnZip.class);

    public static void unzip(File file, File file2) throws IOException {
        try (ZipFile zipFile = new ZipFile(file);){
            try {
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                while (enumeration.hasMoreElements()) {
                    InputStream inputStream = null;
                    ZipEntry zipEntry = null;
                    try {
                        try {
                            zipEntry = enumeration.nextElement();
                            String string = zipEntry.getName().replace("\\", "/");
                            File file3 = new File(file2, string);
                            if (zipEntry.isDirectory()) {
                                file3.mkdirs();
                            } else {
                                file3.getParentFile().mkdirs();
                                inputStream = zipFile.getInputStream(zipEntry);
                                UnZip.copy(inputStream, file3);
                            }
                        }
                        catch (Exception exception) {
                            logger.d("Could not unzip entry: " + zipEntry != null ? zipEntry.getName() : "unknown in file: " + file + ". Reason: " + exception.getMessage());
                            if (inputStream == null) continue;
                            inputStream.close();
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        throw throwable;
                    }
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (Exception exception) {
                logger.d("Could not unzip file: " + file.getAbsolutePath() + ". Reason: " + exception);
                zipFile.close();
            }
        }
    }

    private static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n2;
        byte[] byArray = new byte[1024];
        while ((n2 = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n2);
        }
    }

    private static void copy(InputStream inputStream, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            UnZip.copy(inputStream, fileOutputStream);
        }
        finally {
            ((OutputStream)fileOutputStream).close();
            fileOutputStream = null;
        }
    }
}

