/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.base.he;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.co.b;
import ch.ionesoft.ilp.base.co.f;
import ch.ionesoft.ilp.base.co.g;
import ch.ionesoft.ilp.base.co.h;
import ch.ionesoft.ilp.base.co.p;
import ch.ionesoft.ilp.base.fo.j;
import ch.ionesoft.ilp.base.fo.x;
import ch.ionesoft.ilp.base.he.ConverterUtil;
import ch.ionesoft.ilp.base.he.StringHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.net.time.TimeUDPClient;

public class SystemHelper {
    private static final String ISO_TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss zzz";
    private static ILogger logger = ILPLogManager.getLogger(SystemHelper.class);
    public static final String kApplicationConfigBundleIdentifier = "ILPBase.system.application.bundleIdentifier";
    public static final String kApplicationConfigApplicationName = "ILPBase.system.application.name";
    public static final String kApplicationConfigApplicationBaseName = "ILPView.app.basename";
    public static final String kApplicationConfigLog4JConfigFile = "log4j.config.file";
    public static final String kCacheDir = "Caches";
    public static final String kImageCacheDir = "imageCache";
    public static final String kBlobsCacheDir = "blobs";
    private static final String WORKSPACE_DIR = "WORKSPACE_DIR";
    private static StringBuffer logBuffer = new StringBuffer();
    private static long NETWORK_TIME_CHECK_PERIOD_MS = 300000L;
    private static long timeDifferenceMs = 0L;
    private static Date lastNetworkTimeCheck;

    public static void initLogger() {
        logger = ILPLogManager.getLogger(SystemHelper.class);
    }

    public static String libraryPrivateDocumentsDirectory() {
        return SystemHelper.libraryDirectory();
    }

    public static String libraryDirectory() {
        return f.b().z();
    }

    public static String cachesDirectory() {
        return String.valueOf(SystemHelper.libraryDirectory()) + "/" + kCacheDir;
    }

    public static String imageCachesDirectory() {
        return String.valueOf(SystemHelper.cachesDirectory()) + "/" + kImageCacheDir;
    }

    public static String blobsCachesDirectory() {
        return String.valueOf(SystemHelper.cachesDirectory()) + "/" + kBlobsCacheDir;
    }

    public static String documentDirectory() {
        return f.b().z();
    }

    public static String appDataDirectory() {
        String string = System.getenv("APPDATA");
        return string != null ? string : "";
    }

    public static String userProfileDirectory() {
        String string = System.getenv("USERPROFILE");
        return string != null ? string : "";
    }

    public static String homeDirectory() {
        String string = System.getenv("HOMEDRIVE");
        if (string == null) {
            string = SystemHelper.userHomeDirectory();
        }
        return string != null ? string : "";
    }

    public static String userHomeDirectory() {
        return System.getProperty("user.home");
    }

    public static String applicationName() {
        return b.b().s(kApplicationConfigApplicationName);
    }

    public static String applicationBaseName() {
        return b.b().s(kApplicationConfigApplicationBaseName);
    }

    public static String hostname() {
        String string = "";
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            string = SystemUtils.IS_OS_WINDOWS ? System.getenv("COMPUTERNAME") : SystemHelper.getComputerName();
        }
        return string;
    }

    private static String getComputerName() {
        String string = "";
        try {
            int n2;
            Process process = Runtime.getRuntime().exec("scutil --get ComputerName");
            InputStream inputStream = process.getInputStream();
            while ((n2 = inputStream.read()) >= 0) {
                string = String.valueOf(string) + (char)n2;
            }
            inputStream.close();
        }
        catch (IOException iOException) {
            logger.d("Could not get computerName: " + iOException.getLocalizedMessage());
        }
        return StringHelper.trimAll(string);
    }

    public static String replaceEnvironmentPlaceholders(String string) {
        if (string == null) {
            return string;
        }
        string = string.replace("${APPDATA}", SystemHelper.appDataDirectory());
        string = string.replace("${USERPROFILE}", SystemHelper.userProfileDirectory());
        string = string.replace("${HOMEDRIVE}", SystemHelper.homeDirectory());
        string = string.replace("${hostname}", SystemHelper.hostname());
        string = string.replace("${username}", SystemHelper.userName());
        string = string.replace("${appDir}", f.b().H());
        return string;
    }

    public static String tmpDirectory() {
        return String.valueOf(StringHelper.stringByAppendingPathComponent(System.getProperty("java.io.tmpdir"), SystemHelper.applicationBaseName())) + "/";
    }

    public static String tmpDirectoryURLString() throws IOException {
        return new File(SystemHelper.tmpDirectory()).getCanonicalPath();
    }

    public static String workspaceTmpDirectory() {
        return StringHelper.stringByAppendingPathComponent(f.b().z(), "tmp");
    }

    public static void callApplicationURL_installMessageCode_installURL(String string, String string2, String string3) {
    }

    public static String userLanguageCode() {
        String string = System.getProperty("user.language");
        return string;
    }

    public static String userCountryCode() {
        String string = System.getProperty("user.region");
        return string;
    }

    public static String userName() {
        String string = System.getProperty("user.name");
        return string;
    }

    public static String programVersion() {
        return p.a().b("program.version", "");
    }

    public static String programBuild() {
        return b.b().s("ILPBase.application.build.version");
    }

    public static void updateProgramVersion(String string) {
        logger.b(String.format(Locale.ENGLISH, "Program version: %s", string));
        p.a().a(string, "program.version");
        p.a().g();
    }

    public static boolean isUseSimpleUI() {
        return p.a().a("system.simple.ui", false);
    }

    public static j comparePreviousProgramVersionWithVersion(String string) {
        try {
            if (StringUtils.isBlank((CharSequence)SystemHelper.programVersion())) {
                return j.a;
            }
            String[] stringArray = StringUtils.split((String)SystemHelper.programVersion(), (String)".");
            String[] stringArray2 = StringUtils.split((String)string, (String)".");
            int n2 = 0;
            while (n2 < stringArray.length || n2 < stringArray2.length) {
                int n3 = 0;
                int n4 = 0;
                if (n2 < stringArray.length) {
                    n3 = ConverterUtil.convertToInteger_defaultValue(stringArray[n2], 0);
                }
                if (n2 < stringArray2.length) {
                    n4 = ConverterUtil.convertToInteger_defaultValue(stringArray2[n2], 0);
                }
                if (n3 != n4) {
                    if (n3 > n4) {
                        return j.c;
                    }
                    return j.a;
                }
                ++n2;
            }
            return j.b;
        }
        catch (Exception exception) {
            logger.d("Could not compare programVersion: " + SystemHelper.programVersion() + " with new version: " + string + ". Assuming migration is needed", exception);
            return j.a;
        }
    }

    public static boolean isCurrentProgramVersionBehindVersion(String string) {
        return SystemHelper.comparePreviousProgramVersionWithVersion(string) == j.a;
    }

    public static Integer checkAndFormatVersionNumber(String string) throws Exception {
        try {
            String[] stringArray = string.split("\\.");
            if (stringArray.length == 2 || stringArray.length == 3) {
                return Integer.valueOf(String.valueOf(SystemHelper.formatNumberTwoDigit(stringArray[0])) + SystemHelper.formatNumberTwoDigit(stringArray[1]) + (stringArray.length >= 3 ? SystemHelper.formatNumberTwoDigit(stringArray[2]) : "00"));
            }
            throw new Exception("Wrong length for db_version: " + stringArray.length);
        }
        catch (Exception exception) {
            String string2 = "Could not format version: " + string;
            logger.d(string2);
            throw new Exception(string2, exception);
        }
    }

    private static String formatNumberTwoDigit(String string) throws Exception {
        if (!StringUtils.isNumeric((CharSequence)string) || string.length() > 2) {
            String string2 = "Could not format number. wrong format: " + string;
            logger.d(string2);
            throw new Exception(string2);
        }
        return String.format("%02d", Integer.valueOf(string));
    }

    public static float systemVersion() {
        String string = x.a().d();
        try {
            return new Float(string).floatValue();
        }
        catch (Exception exception) {
            logger.c(String.format(Locale.ENGLISH, "Could not detect systemVersion: %s", exception.getMessage()));
            return 5.1f;
        }
    }

    public static String firstInstallationDateAsString() {
        return p.a().c("program.firstInstallationDate");
    }

    public static Date firstInstallationDate() {
        String string = SystemHelper.firstInstallationDateAsString();
        Date date = null;
        try {
            date = ConverterUtil.parseDateISO_timeHHMMSS_zzz(string);
        }
        catch (ParseException parseException) {
            try {
                date = ConverterUtil.parseDateISO(string);
            }
            catch (ParseException parseException2) {
                logger.c("Could not parse firstInstallationDate: " + parseException.getMessage());
            }
        }
        return date;
    }

    public static void setFirstInstallationDateNow() {
        String string = SystemHelper.getISODateNow();
        p.a().a(string, "program.firstInstallationDate");
        p.a().g();
    }

    public static String getISODateNow() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
        simpleDateFormat.applyPattern(ISO_TIMESTAMP_FORMAT);
        String string = simpleDateFormat.format(new Date());
        return string;
    }

    public static boolean isVeryFirstInstallation() {
        return SystemHelper.firstInstallationDateAsString() == null || SystemHelper.firstInstallationDateAsString().length() == 0;
    }

    public static String lastInstallationDateAsString() {
        return p.a().c("program.lastInstallationDate");
    }

    public static Date lastInstallationDate() {
        String string = SystemHelper.lastInstallationDateAsString();
        if (string == null || string.length() == 0) {
            return null;
        }
        Date date = null;
        try {
            date = ConverterUtil.parseDateISO_timeHHMMSS_zzz(string);
        }
        catch (ParseException parseException) {
            try {
                date = ConverterUtil.parseDateISO(string);
            }
            catch (ParseException parseException2) {
                logger.c("Could not parse lastInstallationDate: " + parseException.getMessage());
            }
        }
        return date;
    }

    public static void setLastInstallationDateNow() {
        String string = SystemHelper.getISODateNow();
        p.a().a(string, "program.lastInstallationDate");
        p.a().g();
    }

    public static void updateInstallationDate(boolean bl) {
        if (SystemHelper.isVeryFirstInstallation()) {
            SystemHelper.setFirstInstallationDateNow();
        }
        if (bl) {
            SystemHelper.setLastInstallationDateNow();
        }
    }

    public static int startCount() {
        int n2 = p.a().a("program.startCount", 0);
        return n2;
    }

    public static void addToStartCount(int n2) {
        int n3 = SystemHelper.startCount() + n2;
        p.a().a("program.startCount", (Integer)n3);
        p.a().g();
    }

    public static String createUUID() {
        UUID uUID = UUID.randomUUID();
        return uUID.toString();
    }

    public static String userAgent() {
        String string = x.a().i();
        String string2 = x.a().h();
        String string3 = x.a().c();
        String string4 = x.a().d();
        String string5 = x.a().b();
        String string6 = x.a().e();
        String string7 = String.format(Locale.ENGLISH, "%s/%sb%s (%s; %s; %s; %s) %s/%s", SystemHelper.applicationName(), SystemHelper.programVersion(), SystemHelper.programBuild(), string2, string5, string3, string4, string, string6);
        return string7;
    }

    public static void flushAllLogs() {
        ILPLogManager.getLoggerFactory().a();
    }

    public static void addToLogBuffer(String string, Exception exception) {
        String string2 = exception != null ? ": " + StringHelper.removeURLParams(exception.toString()) : "";
        logBuffer.append(String.valueOf(string) + string2 + "\n");
        System.out.println(String.valueOf(string) + string2);
        logger.c(string, exception);
    }

    public static void addToLogBuffer(String string) {
        SystemHelper.addToLogBuffer(string, null);
    }

    public static void flushStartupLogBuffer() {
        logger.b("Log-Buffer: ");
        logger.b(logBuffer.toString());
        logBuffer.setLength(0);
    }

    public static void logApplicationStart() {
        logger.b("");
        logger.b("*********************************************************");
        logger.b("App start");
        logger.b("*********************************************************");
        SystemHelper.addToStartCount(1);
        SystemHelper.logDeviceSettings();
        SystemHelper.logApplicationSettings();
    }

    public static void logDeviceSettings() {
        logger.b("Device Settings:");
        logger.b(String.format(Locale.ENGLISH, "System Name: %s", x.a().c()));
        logger.b(String.format(Locale.ENGLISH, "System Version: %s", x.a().d()));
        logger.b(String.format(Locale.ENGLISH, "Model: %s", x.a().h()));
        logger.b(String.format(Locale.ENGLISH, "Name: %s", x.a().i()));
        logger.b(String.format(Locale.ENGLISH, "Java Version: %s", x.a().e()));
        logger.b(String.format(Locale.ENGLISH, "Platform: %s %s", x.a().b(), SystemHelper.is32BitSystem() ? "32bit" : "64bit"));
        logger.b(String.format(Locale.ENGLISH, "Total Memory: %d", x.a().f()));
        logger.b(String.format(Locale.ENGLISH, "User Memory: %d", x.a().g()));
        logger.b(String.format(Locale.ENGLISH, "Locale: %s", Locale.getDefault().toString()));
        if (SystemHelper.isAndroidSystem()) {
            logger.b(String.format(Locale.ENGLISH, "Device rooted: %s", x.a().q()));
        }
    }

    public static void logApplicationSettings() {
        logger.b("Application Settings: ");
        try {
            logger.b(String.format(Locale.ENGLISH, "Application name: %s", SystemHelper.applicationName()));
            logger.b(String.format(Locale.ENGLISH, "Application version: %s", f.b().Z()));
            logger.b(String.format(Locale.ENGLISH, "Application build: %s", SystemHelper.programBuild()));
            logger.b(String.format(Locale.ENGLISH, "Application directory: %s", f.b().H()));
            logger.b(String.format(Locale.ENGLISH, "Workspace directory: %s", f.b().z()));
            logger.b(String.format(Locale.ENGLISH, "First installation date: %s", SystemHelper.firstInstallationDateAsString()));
            logger.b(String.format(Locale.ENGLISH, "Last installation date: %s", SystemHelper.lastInstallationDateAsString()));
            logger.b(String.format(Locale.ENGLISH, "Application starts: %d", SystemHelper.startCount()));
            logger.b(String.format(Locale.ENGLISH, "ClusterType: %s", new Object[]{g.a().P()}));
            logger.b(String.format(Locale.ENGLISH, "AssetStage: %s", new Object[]{g.a().Q()}));
            logger.b(String.format(Locale.ENGLISH, "Exam mode: %s", g.a().w() ? "ON" : "OFF"));
        }
        catch (Exception exception) {
            logger.d("Could not log applicationSettings: ", exception);
        }
    }

    public static void logFreeSpace(File file) {
        logger.b(String.format(Locale.ENGLISH, "Diskspace on: %s is %d mb free out of %d mb", file.getParent(), file.getParentFile().getFreeSpace() / 0x100000L, file.getParentFile().getTotalSpace() / 0x100000L));
    }

    public static boolean is32BitSystem() {
        String string = System.getProperty("sun.arch.data.model");
        if (string != null) {
            return string.contains("32");
        }
        return true;
    }

    public static boolean is64BitSystem() {
        String string = System.getProperty("sun.arch.data.model");
        if (string != null) {
            return string.contains("64");
        }
        return false;
    }

    public static boolean isAndroidSystem() {
        return !SystemUtils.IS_OS_MAC && !SystemUtils.IS_OS_WINDOWS;
    }

    public static boolean isVideoFormat(String string) {
        if (string == null) {
            return false;
        }
        if (string.startsWith("video/")) {
            return true;
        }
        if (string.equalsIgnoreCase("application/x-mpegURL")) {
            return true;
        }
        if (string.equalsIgnoreCase("application/mp4")) {
            return true;
        }
        return string.equalsIgnoreCase("application/mpeg");
    }

    public static boolean isAudioFormat(String string) {
        if (string == null) {
            return false;
        }
        return string.startsWith("audio/");
    }

    public static boolean isPictureFormat(String string) {
        if (string == null) {
            return false;
        }
        return string.startsWith("image/");
    }

    public static boolean isPDFFormat(String string) {
        if (string == null) {
            return false;
        }
        return string.startsWith("application/pdf");
    }

    public static boolean isDocxFormat(String string) {
        if (string == null) {
            return false;
        }
        if (string.equalsIgnoreCase("application/msword")) {
            return true;
        }
        if (string.equalsIgnoreCase("application/vnd.openxmlformats-officedocument.wordprocessingml.document")) {
            return true;
        }
        return string.equalsIgnoreCase("application/vnd.openxmlformats-officedocument.wordprocessingml.template");
    }

    public static boolean isExcelFormat(String string) {
        if (string == null) {
            return false;
        }
        if (string.equalsIgnoreCase("application/vnd.ms-excel")) {
            return true;
        }
        if (string.equalsIgnoreCase("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet")) {
            return true;
        }
        return string.equalsIgnoreCase("application/vnd.openxmlformats-officedocument.spreadsheetml.template");
    }

    public static boolean isPowerpointFormat(String string) {
        if (string == null) {
            return false;
        }
        if (string.equalsIgnoreCase("application/vnd.ms-powerpoint")) {
            return true;
        }
        if (string.equalsIgnoreCase("application/vnd.openxmlformats-officedocument.presentationml.presentation")) {
            return true;
        }
        if (string.equalsIgnoreCase("application/vnd.openxmlformats-officedocument.presentationml.template")) {
            return true;
        }
        return string.equalsIgnoreCase("application/vnd.openxmlformats-officedocument.presentationml.slideshow");
    }

    public static String preferencesDirectory() {
        return SystemHelper.libraryDirectory();
    }

    public static String formatCurrentLogfileAsHtml() {
        SystemHelper.flushAllLogs();
        File file = h.i();
        Collection collection = FileUtils.listFiles((File)file, null, (boolean)false);
        if (collection == null || collection.size() == 0) {
            return "No logfiles available";
        }
        ArrayList arrayList = new ArrayList(collection);
        File file2 = (File)arrayList.get(arrayList.size() - 1);
        List list = new ArrayList();
        try {
            list.addAll(FileUtils.readLines((File)file2, (String)"UTF-8"));
        }
        catch (IOException iOException) {
            logger.c("Could not read logfile, reason: " + iOException);
        }
        if (list.size() > 0) {
            int n2 = 1000;
            int n3 = list.size();
            if (n3 > n2) {
                list = list.subList(n3 - n2, n3 - 1);
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(String.format("<html><head></head><body><br/>Log file: %s</br/>", file2));
            String string = "<br><font color=\"${color}\">${text}</font></br>";
            String string2 = "black";
            for (String string3 : list) {
                if ((string3 = string.replace("${text}", string3)).contains("INFO")) {
                    string2 = "#006400";
                } else if (string3.contains("WARN")) {
                    string2 = "#ffa500";
                } else if (string3.contains("ERROR")) {
                    string2 = "red";
                }
                string3 = string3.replace("${color}", string2);
                stringBuffer.append(string3);
            }
            stringBuffer.append("</body></html>");
            return stringBuffer.toString();
        }
        return "Empty log file";
    }

    public static Date currentNetworkOrClockTime() {
        Date date = SystemHelper.currentNetworkTime();
        if (date == null) {
            date = new Date();
        }
        return date;
    }

    /*
     * Loose catch block
     */
    public static Date currentNetworkTime() {
        if (SystemHelper.hasValidLastNetworkTimeCheck()) {
            return SystemHelper.timeByApplyingNetworkDifference();
        }
        if (!x.a().a(false)) {
            return null;
        }
        TimeUDPClient timeUDPClient = null;
        try {
            timeUDPClient = new TimeUDPClient();
            timeUDPClient.setDefaultTimeout(2000);
            timeUDPClient.open();
            try {
                Date date = timeUDPClient.getDate(InetAddress.getByName("time.nist.gov"));
                SystemHelper.updateLastNetworkTimeCheck(date);
                Date date2 = date;
                return date2;
            }
            catch (Exception exception) {
                Date date;
                block19: {
                    Date date3 = timeUDPClient.getDate(InetAddress.getByName("utcnist.colorado.edu"));
                    SystemHelper.updateLastNetworkTimeCheck(date3);
                    date = date3;
                    if (timeUDPClient == null) break block19;
                    try {
                        timeUDPClient.close();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
                return date;
                catch (Exception exception3) {
                    logger.c("Could not get network time: " + exception3);
                    return null;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (timeUDPClient != null) {
                try {
                    timeUDPClient.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static boolean hasValidLastNetworkTimeCheck() {
        Date date = new Date();
        return lastNetworkTimeCheck != null && date.getTime() < lastNetworkTimeCheck.getTime() + NETWORK_TIME_CHECK_PERIOD_MS;
    }

    private static synchronized void updateLastNetworkTimeCheck(Date date) {
        lastNetworkTimeCheck = new Date();
        timeDifferenceMs = date.getTime() - lastNetworkTimeCheck.getTime();
    }

    private static Date timeByApplyingNetworkDifference() {
        Date date = new Date();
        return new Date(date.getTime() + timeDifferenceMs);
    }

    public static String detectMediaType(String string, String string2) {
        if (StringHelper.isEmpty(string) || string.equals("application/octet-stream")) {
            string = ConverterUtil.mimeTypeForFilename(string2);
        }
        return string;
    }

    public static boolean isRunningUnderRosetta() {
        try {
            Process process = new ProcessBuilder("sysctl", "-n", "sysctl.proc_translated").start();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String string = bufferedReader.readLine();
            return "1".equals(string);
        }
        catch (Exception exception) {
            logger.d("Could check if application is running under rosetta", exception);
            return false;
        }
    }

    public static String getMacOSArchitecture() {
        String string = "unknown";
        try {
            Process process = new ProcessBuilder("uname", "-m").start();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            string = bufferedReader.readLine();
        }
        catch (Exception exception) {
            logger.d("Could not get macos architecture", exception);
        }
        logger.b("macOS system architecture: " + string);
        return string;
    }
}

