/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.base.he;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.fo.i;
import ch.ionesoft.ilp.base.fo.p;
import ch.ionesoft.ilp.base.he.ConverterUtil;
import ch.ionesoft.ilp.base.he.ExtendedHashMap;
import ch.ionesoft.ilp.base.he.Helper;
import java.io.File;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;

public class StringHelper {
    private static ILogger logger = ILPLogManager.getLogger(StringHelper.class);
    public static final int INDEX_NOT_FOUND = -1;

    public String sayHello() {
        return "Hello";
    }

    public static String replaceGroupWithNumberAndResetMatcher(String string, String string2, int n2, Matcher matcher) {
        string = n2 == 0 ? new StringBuilder(string).replace(matcher.start(), matcher.end(), string2).toString() : new StringBuilder(string).replace(matcher.start(n2), matcher.end(n2), string2).toString();
        matcher.reset(string);
        return string;
    }

    public static boolean isNumericString(String string) {
        if (string == null) {
            return false;
        }
        if (string.startsWith("-")) {
            string = string.substring(1);
        }
        return StringUtils.isNumeric((CharSequence)string);
    }

    public static boolean isDecimalString(String string) {
        return NumberUtils.isNumber((String)string);
    }

    public static boolean isLowercase(String string) {
        if (StringUtils.isBlank((CharSequence)string)) {
            return false;
        }
        return StringUtils.isAllLowerCase((CharSequence)("" + string.charAt(0)));
    }

    public static Boolean isValidEmail(String string) {
        String string2 = "[A-Z0-9a-z._%+-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,4}";
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string);
        return matcher.matches();
    }

    public static Boolean isValidIsbn(String string) {
        String string2 = "^(?:ISBN(?:-1[03])?:? )?(?=[0-9X]{10}$|(?=(?:[0-9]+[- ]){3})[- 0-9X]{13}$|97[89][0-9]{10}$|(?=(?:[0-9]+[- ]){4})[- 0-9]{17}$)(?:97[89][- ]?)?[0-9]{1,5}[- ]?[0-9]+[- ]?[0-9]+[- ]?[0-9X]$";
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string);
        return matcher.matches();
    }

    public static boolean isNumericCharacter(char c2) {
        return c2 >= '0' && c2 <= '9';
    }

    public static boolean startsNumeric(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        return StringHelper.isNumericCharacter(string.charAt(0));
    }

    public static boolean isWhitespaceCharacter(char c2) {
        return StringUtils.isWhitespace((CharSequence)("" + c2));
    }

    public static String leftPad_length(String string, int n2) {
        return StringUtils.leftPad((String)string, (int)n2);
    }

    public static String rightPad_length(String string, int n2) {
        return StringUtils.rightPad((String)string, (int)n2);
    }

    public static String stringWithCharacter_ofLength(char c2, int n2) {
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n3 = 0;
        while (n3 < n2) {
            stringBuffer.append(c2);
            ++n3;
        }
        return stringBuffer.toString();
    }

    public static String lastPathComponent(String string) {
        if (string == null) {
            return string;
        }
        String string2 = string.replace("\\", "/");
        string2 = StringHelper.extractTrailingString_after(string2, "/");
        return StringHelper.extractStringFrom_until(string2, "?");
    }

    public static ExtendedHashMap<String, String> extractURLParametersFromURL_ifNotFound(String string) {
        String[] stringArray;
        ExtendedHashMap<String, String> extendedHashMap = new ExtendedHashMap<String, String>();
        String string2 = StringHelper.extractString_after_ifNotFound(string, "?", string);
        String[] stringArray2 = stringArray = StringUtils.split((String)string2, (String)"&");
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String string3 = stringArray2[n3];
            String string4 = StringHelper.decodeFromPercentEscapeString(StringHelper.extractStringFrom_until(string3, "="));
            String string5 = StringHelper.decodeFromPercentEscapeString(StringHelper.extractString_after(string3, "="));
            extendedHashMap.put(string4, string5);
            ++n3;
        }
        return extendedHashMap;
    }

    public static ExtendedHashMap<String, String> extractURLParametersFromURL(String string) {
        String[] stringArray;
        ExtendedHashMap<String, String> extendedHashMap = new ExtendedHashMap<String, String>();
        String string2 = StringHelper.extractString_after(string, "?");
        String[] stringArray2 = stringArray = StringUtils.split((String)string2, (String)"&");
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String string3 = stringArray2[n3];
            String string4 = StringHelper.decodeFromPercentEscapeString(StringHelper.extractStringFrom_until(string3, "="));
            String string5 = StringHelper.decodeFromPercentEscapeString(StringHelper.extractString_after(string3, "="));
            extendedHashMap.put(string4, string5);
            ++n3;
        }
        return extendedHashMap;
    }

    public static String createQueryString(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return "";
        }
        String string = "?";
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            string = String.valueOf(string) + entry.getKey() + "=" + entry.getValue() + "&";
        }
        return string;
    }

    public static String createQueryStringFromMapStringString(Map<String, String> map) {
        if (map == null || map.isEmpty()) {
            return "";
        }
        String string = "?";
        for (Map.Entry<String, String> entry : map.entrySet()) {
            string = String.valueOf(string) + entry.getKey() + "=" + entry.getValue() + "&";
        }
        return string;
    }

    public static String extractString_after_ifNotFound(String string, String string2, String string3) {
        if (string == null) {
            return string;
        }
        if (StringUtils.isBlank((CharSequence)string2)) {
            return string;
        }
        String string4 = string3;
        int n2 = string.indexOf(string2);
        if (n2 > -1) {
            string4 = string.substring(n2 + string2.length());
        }
        return string4;
    }

    public static String extractString_after(String string, String string2) {
        return StringHelper.extractString_after_ifNotFound(string, string2, "");
    }

    public static String extractTrailingString_after(String string, String string2) {
        if (string == null) {
            return null;
        }
        int n2 = string.lastIndexOf(string2);
        if (n2 > -1 && string2.length() != 0) {
            return string.substring(n2 + string2.length());
        }
        return string;
    }

    public static String extractLeadingString_beforeLast(String string, String string2) {
        if (string == null) {
            return null;
        }
        int n2 = string.lastIndexOf(string2);
        if (n2 > -1 && string2.length() != 0) {
            return string.substring(0, n2 + string2.length() - 1);
        }
        return string;
    }

    public static String extractStringFrom_untilLast(String string, String string2) {
        if (string == null) {
            return null;
        }
        int n2 = string.lastIndexOf(string2);
        if (n2 > -1) {
            return string.substring(0, n2);
        }
        return string;
    }

    public static String extractStringFrom_until(String string, String string2) {
        if (string == null) {
            return null;
        }
        int n2 = string.indexOf(string2);
        if (n2 > -1) {
            return string.substring(0, n2);
        }
        return string;
    }

    public static String extractStringFrom_after_until(String string, String string2, String string3) {
        if (string == null) {
            return null;
        }
        int n2 = string.indexOf(string2);
        if (n2 > -1) {
            String string4 = string.substring(n2 + string2.length());
            if ((n2 = string4.indexOf(string3)) > -1) {
                return string4.substring(0, n2);
            }
            return string4;
        }
        return "";
    }

    public static String extractStringFrom_after_untilAny(String string, String string2, String string3) {
        if (string == null) {
            return null;
        }
        int n2 = string.indexOf(string2);
        if (n2 > -1) {
            String string4 = string.substring(n2 + string2.length());
            if ((n2 = StringUtils.indexOfAny((CharSequence)string4, (String)string3)) > -1) {
                return string4.substring(0, n2);
            }
            return string4;
        }
        return "";
    }

    public static String extractAndDecodePercentEscapeStringFrom_after_until(String string, String string2, String string3) {
        String string4 = StringHelper.extractStringFrom_after_until(string, string2, string3);
        return StringHelper.decodeFromPercentEscapeString(string4);
    }

    public static String extractStringFrom_after(String string, String string2) {
        return StringHelper.extractString_after(string, string2);
    }

    public static String extractPrefixNumber(String string) {
        String string2 = string.trim();
        StringBuffer stringBuffer = new StringBuffer(4);
        int n2 = 0;
        while (n2 < string2.length()) {
            char c2 = string2.charAt(n2);
            if (!StringUtils.isNumeric((CharSequence)("" + c2)) && c2 != '.') break;
            stringBuffer.append(c2);
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String extractPrefixInteger(String string) {
        String string2 = string.trim();
        StringBuffer stringBuffer = new StringBuffer(4);
        int n2 = 0;
        while (n2 < string2.length()) {
            char c2 = string2.charAt(n2);
            if (!StringUtils.isNumeric((CharSequence)("" + c2))) break;
            stringBuffer.append(c2);
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static Float extractPrefixNumber(String string, Float f2) {
        String string2 = StringHelper.extractPrefixNumber(string);
        return ConverterUtil.convertDecimalStringToFloat_defaultValue(string2, f2);
    }

    public static String extractPrefixNumberWithLetter(String string) {
        String string2 = string.trim();
        StringBuffer stringBuffer = new StringBuffer(4);
        boolean bl = false;
        int n2 = 0;
        while (n2 < string2.length()) {
            char c2 = string2.charAt(n2);
            if (!StringUtils.isNumeric((CharSequence)("" + c2)) && (c2 != '.' || n2 <= 0) && (c2 < 'a' || c2 > 'z' || bl || n2 <= 0)) break;
            if (c2 >= 'a' && c2 <= 'z') {
                bl = true;
            }
            stringBuffer.append(c2);
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String extractPostfixNumber(String string) {
        String string2 = string.trim();
        StringBuffer stringBuffer = new StringBuffer(4);
        int n2 = string2.length() - 1;
        while (n2 >= 0) {
            char c2 = string2.charAt(n2);
            if (!StringUtils.isNumeric((CharSequence)("" + c2)) && c2 != '.') break;
            stringBuffer.append(c2);
            --n2;
        }
        stringBuffer = stringBuffer.reverse();
        return stringBuffer.toString();
    }

    public static String extractPostfixNumber(String string, int n2) {
        String string2 = string.trim();
        StringBuffer stringBuffer = new StringBuffer(4);
        int n3 = string2.length() - 1;
        while (n3 >= 0) {
            char c2 = string2.charAt(n3);
            if (!StringUtils.isNumeric((CharSequence)("" + c2)) && c2 != '.') break;
            stringBuffer.append(c2);
            --n3;
        }
        stringBuffer = stringBuffer.reverse();
        n3 = Math.min(n2, stringBuffer.length());
        return stringBuffer.toString().substring(stringBuffer.length() - n3);
    }

    public static String extractProperty_For_defaultProperty(String string, String string2, String string3, boolean bl) {
        String string4;
        String string5;
        String string6 = "\ufb01";
        if (string == null) {
            string = "";
        }
        if ((string5 = StringHelper.extractStringFrom_after_until(string = string.replace("\\;", "\ufb01"), string4 = String.valueOf(string2) + "=", ";")) == null) {
            return string3;
        }
        string5 = bl ? string5.replace("\ufb01", ";") : string5.replace("\ufb01", "\\;");
        return string5;
    }

    public static String extractCommandFromUrl_after(String string, String string2) {
        String string3 = StringHelper.extractStringFrom_after(string, string2);
        if (string3.contains("?")) {
            string3 = StringHelper.extractStringFrom_until(string3, "?");
        }
        if (string3.contains("/")) {
            string3 = StringHelper.extractStringFrom_until(string3, "/");
        }
        return string3;
    }

    public static String removePostfixAfter(String string, String string2) {
        if (string == null) {
            return string;
        }
        int n2 = string.lastIndexOf(string2);
        if (n2 >= 0) {
            return string.substring(0, n2);
        }
        return string;
    }

    public static String removePrefixNumber(String string) {
        String string2 = StringHelper.extractPrefixNumber(string);
        return StringHelper.trim(StringHelper.extractStringFrom_after(string, string2));
    }

    public static String extractPostfixAfter(String string, String string2) {
        if (string == null) {
            return string;
        }
        int n2 = string.lastIndexOf(string2);
        if (n2 >= 0) {
            return string.substring(string2.length() + n2, string.length());
        }
        return string;
    }

    public static String extractPostfixAfterFirstOccurrence(String string, String string2) {
        if (string == null) {
            return string;
        }
        int n2 = string.indexOf(string2);
        if (n2 >= 0) {
            return string.substring(string2.length() + n2, string.length());
        }
        return string;
    }

    public static String extractPhoneNumberForHref(String string) {
        string = StringHelper.removeAllWhitespaceAndNewlines(string);
        string = string.replace("(", "");
        string = string.replace(")", "");
        string = string.replace("/", "");
        string = string.replace("-", "");
        return string;
    }

    public static String firstMatchingString(String string, String string2) {
        try {
            Pattern pattern = Pattern.compile(string2);
            Matcher matcher = pattern.matcher(string);
            if (matcher.find()) {
                int n2 = matcher.start(1);
                int n3 = matcher.end(1);
                String string3 = StringHelper.substringWithRange(string, n2, n3);
                return string3;
            }
        }
        catch (Exception exception) {
            logger.d("Could not match regex: " + string2, exception);
        }
        return null;
    }

    public static boolean matchesPattern(String string, String string2) {
        try {
            Pattern pattern = Pattern.compile(string2);
            Matcher matcher = pattern.matcher(string);
            return matcher.matches();
        }
        catch (Exception exception) {
            logger.d("Could not match regex: " + string2, exception);
            return false;
        }
    }

    public static String replaceFirstOccurrenceOfString_withString_inString(String string, String string2, String string3) {
        if (string3 != null) {
            return StringUtils.replaceOnce((String)string3, (String)string, (String)string2);
        }
        return string3;
    }

    public static String replaceLastOccurrenceOfString_withString_inString(String string, String string2, String string3) {
        int n2 = string3.lastIndexOf(string);
        if (n2 == -1) {
            return string3;
        }
        return String.valueOf(string3.substring(0, n2)) + string2 + string3.substring(n2 + string.length());
    }

    public static String pruneAllExceptNumbersAndLetters(String string, String string2) {
        return string.replaceAll("[^a-zA-Z0-9]", string2);
    }

    public static String extractFieldFrom_atPosition_delimitedBy(String string, int n2, String string2) {
        String[] stringArray = StringUtils.split((String)string, (String)string2);
        if (n2 > stringArray.length || n2 < -stringArray.length) {
            logger.d("Invalid position: " + n2 + " to extract field delimitted by: " + string2 + " in: " + string);
            return null;
        }
        if (n2 < 0) {
            return stringArray[stringArray.length + n2 + 1];
        }
        return stringArray[n2];
    }

    public static String truncateFrom_atPosition_delimitedBy(String string, int n2, String string2) {
        String[] stringArray = StringUtils.split((String)string, (String)string2);
        if (n2 > stringArray.length - 1 || n2 < -stringArray.length) {
            logger.d("Invalid position: " + n2 + " to truncate field delimitted by: " + string2 + " in: " + string);
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (n2 < 0) {
            int n3 = 0;
            while (n3 < stringArray.length + n2) {
                stringBuffer.append(stringArray[n3]);
                if (n3 != stringArray.length + n2 - 1) {
                    stringBuffer.append(string2);
                }
                ++n3;
            }
        } else {
            int n4 = 0;
            while (n4 <= n2) {
                stringBuffer.append(stringArray[n4]);
                if (n4 != n2) {
                    stringBuffer.append(string2);
                }
                ++n4;
            }
        }
        return stringBuffer.toString();
    }

    public static List<String> stringsMatchingGroup(String string, String string2, int n2) {
        try {
            if (!string2.contains("(") || !string2.contains(")")) {
                logger.d("Regex '" + string2 + "' does not contain group.");
            }
            Pattern pattern = Pattern.compile(string2);
            Matcher matcher = pattern.matcher(string);
            ArrayList<String> arrayList = new ArrayList<String>();
            while (matcher.find()) {
                String string3 = matcher.group(n2);
                arrayList.add(string3);
            }
            return arrayList;
        }
        catch (Exception exception) {
            logger.d("Could not match regex: " + string2, exception);
            return null;
        }
    }

    public static String trailingInteger(String string) {
        String string2 = StringHelper.trim(string);
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = string2.length() - 1;
        while (n2 >= 0) {
            char c2 = string2.charAt(n2);
            if (!StringHelper.isNumericCharacter(c2)) break;
            stringBuilder.append(c2);
            --n2;
        }
        String string3 = stringBuilder.toString();
        string3 = StringHelper.reverseString(string3).trim();
        return string3;
    }

    public static String removeURLParams(URL uRL) {
        if (uRL != null) {
            return StringHelper.removeURLParams(uRL.toString());
        }
        return "";
    }

    public static String removeURLParams(String string) {
        return StringHelper.extractStringFrom_until(string, "?");
    }

    public static String removeProtocol(String string) {
        return string.replaceFirst("\\w*://", "");
    }

    public static String removeBasicAuthCredentials(String string) {
        return string.replaceFirst("(\\w*://)?\\w*:\\w*@", "$1");
    }

    public static String extractTargetURL(String string) {
        String string2 = StringHelper.removeURLParams(string);
        string2 = StringHelper.removeProtocol(string2);
        string2 = StringHelper.removeBasicAuthCredentials(string2);
        return string2;
    }

    public static String normalizeQuotedString(String string) {
        if (string == null || string.length() <= 2) {
            return string;
        }
        if (!(string.charAt(0) != '\"' && string.charAt(0) != '\'' || string.charAt(string.length() - 1) != '\"' && string.charAt(string.length() - 1) != '\'')) {
            return string.substring(1, string.length() - 1);
        }
        if (string.charAt(0) == '\"' || string.charAt(0) == '\'') {
            return string.substring(1, string.length());
        }
        if (string.charAt(string.length() - 1) == '\"' || string.charAt(string.length() - 1) == '\'') {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static String addURLParameterToString(String string, String string2, String string3) {
        if (StringHelper.isEmpty(string) && StringHelper.isEmpty(string2) && StringHelper.isEmpty(string3)) {
            logger.c("Could not add url parameter to string. Empty value. Return given urlString.");
            return string;
        }
        if (string.contains("?")) {
            if (!"?".equals(string.lastIndexOf("?"))) {
                string = String.valueOf(string) + "&";
            }
        } else {
            string = String.valueOf(string) + "?";
        }
        string = String.valueOf(string) + string2 + "=" + string3;
        return string;
    }

    public static String truncateUUIDsFromString(String string) {
        if (string == null) {
            return string;
        }
        try {
            String string2 = "([a-fA-F0-9]{8})-([a-fA-F0-9]{4})-([a-fA-F0-9]{4})-([a-fA-F0-9]{4})-([a-fA-F0-9]{12})";
            Pattern pattern = Pattern.compile(string2);
            Matcher matcher = pattern.matcher(string);
            while (matcher.find()) {
                int n2 = 2;
                while (n2 < 6) {
                    if (matcher.groupCount() > n2 - 1) {
                        int n3 = matcher.start(n2);
                        int n4 = matcher.end(n2);
                        String string3 = StringHelper.stringWithCharacter_ofLength('x', n4 - n3);
                        string = StringHelper.stringByReplacingCharactersInRange_withString(string, n3, n4, string3);
                    }
                    ++n2;
                }
            }
        }
        catch (Exception exception) {
            Helper.logActionText_withException("Could not truncate UUID", exception);
        }
        return string;
    }

    public static String truncateCIIDsFromString(String string) {
        return StringHelper.truncateUUIDsFromString(string);
    }

    public static String normalizeBracketString(String string) {
        if (string == null || string.length() <= 2) {
            return string;
        }
        if (string.charAt(0) == '[' && string.charAt(string.length() - 1) == ']') {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public static String trim(String string) {
        if (string == null) {
            return null;
        }
        return string.trim();
    }

    public static String trimPunctuation(String string) {
        return string.replaceAll("[^A-Za-z0-9]", "");
    }

    public static String trimRepeatingBlanks(String string) {
        String string2;
        if (string == null) {
            return null;
        }
        String string3 = StringHelper.trim(string);
        while ((string2 = string3.replace("  ", " ")).length() != string3.length()) {
            string3 = string2;
        }
        return string3;
    }

    public static String replaceWhitespaceCharactersWithSpace(String string) {
        string = string.replaceAll("[\u2000-\u200a]+", " ");
        string = string.replaceAll("\u2009", " ");
        string = string.replaceAll("\u202f", " ");
        string = string.replaceAll("\u205f", " ");
        string = string.replaceAll("\u3000", " ");
        string = string.replaceAll("\u1680", " ");
        string = string.replaceAll("\u00a0", " ");
        string = string.replaceAll("\t", " ");
        return string;
    }

    public static StringBuilder trim(StringBuilder stringBuilder) {
        if (stringBuilder == null) {
            return null;
        }
        String string = stringBuilder.toString();
        string.trim();
        StringBuilder stringBuilder2 = new StringBuilder(string);
        return stringBuilder2;
    }

    public static String pruneSpecialCharacters(String string) {
        if (string == null) {
            return string;
        }
        String string2 = string;
        string2 = string2.replace("\u00a0", " ");
        string2 = string2.replace("\u2002", " ");
        string2 = string2.replace("\u00ad", "");
        string2 = string2.replace("\ufffc", "");
        string2 = string2.replace("\ufeff", "");
        string2 = string2.replace("\u0003", "");
        return string2;
    }

    public static String trimAll(String string) {
        if (string == null) {
            return string;
        }
        String string2 = string;
        string2 = string2.replace("\u00a0", " ");
        string2 = string2.replace("\u2002", " ");
        string2 = string2.replace("\u00ad", "");
        string2 = string2.replace("\ufeff", "");
        string2 = string2.replaceAll("^\\s+|\\s+$", "");
        string2 = string2.replaceAll("^\u200d|\u200d$", "");
        return string2;
    }

    public static String stringByRemovingNewLinesAndWhitespace(String string) {
        if (string == null) {
            return "";
        }
        p p2 = new p(string);
        p2.a((i)null);
        StringBuffer stringBuffer = new StringBuffer();
        p.c c2 = new p.c();
        i i2 = i.a(String.format(Locale.ENGLISH, " \t\n\r%C%C%C%C%C%C%C", 133, 12, 8232, 8233, 160, 49824, 8205));
        while (!p2.b()) {
            c2.a = null;
            p2.b(i2, c2);
            if (c2.a != null) {
                stringBuffer.append(c2.a);
            }
            if (!p2.a(i2, null) || stringBuffer.length() <= 0 || p2.b()) continue;
            stringBuffer.append(" ");
        }
        String string2 = stringBuffer.toString();
        return string2;
    }

    public static String removeAllNewlines(String string) {
        string = string.replace("\n", "");
        return string;
    }

    public static String removeAllWhitespaceAndNewlines(String string) {
        String string2 = StringHelper.stringByRemovingNewLinesAndWhitespace(string);
        string2 = string2.replace(" ", "");
        return string2;
    }

    public static String prepareStringForJavaScriptExecution(String string) {
        if (string == null) {
            return "";
        }
        string = string.replace("\n", " ");
        string = string.replace("\r", " ");
        string = string.replace("\t", " ");
        string = string.replace("'", "\"");
        return string;
    }

    public static String replaceAposWithAlphaNumValue(String string) {
        if (string == null) {
            return null;
        }
        return string.replace("'", "&#39;");
    }

    public static String replaceAposWithEscapedApos(String string) {
        if (string == null) {
            return null;
        }
        return string.replace("'", "\\'");
    }

    public static String replaceHtmlEncodedAposWithSingleQuote(String string) {
        if (string == null) {
            return null;
        }
        return string.replace("&apos;", "'");
    }

    public static String replaceAposInTextNodesOfHtml(String string) {
        if (StringHelper.isEmpty(string)) {
            return "";
        }
        Document document = Jsoup.parse((String)string);
        List list = document.childNodes();
        string = StringHelper.replaceAposInHtmlFromTextNodes(string, list);
        return string;
    }

    private static String replaceAposInHtmlFromTextNodes(String string, List<Node> list) {
        if (list == null || list.isEmpty()) {
            return string;
        }
        for (Node node : list) {
            List list2 = node.childNodes();
            string = list2.size() > 0 ? StringHelper.replaceAposInHtmlFromTextNodes(string, list2) : StringHelper.replaceAposInHtmlFromTextNode(string, node);
        }
        return string;
    }

    private static String replaceAposInHtmlFromTextNode(String string, Node node) {
        TextNode textNode;
        String string2;
        if (node == null) {
            return string;
        }
        if (node instanceof TextNode && (string2 = (textNode = (TextNode)node).getWholeText()).contains("'")) {
            String string3 = string2.replace("'", "&#39;");
            string = string.replace(string2, string3);
        }
        return string;
    }

    public static boolean isEqualIgnoreCaseAndWhitespace_with(String string, String string2) {
        string = StringHelper.removeAllWhitespaceAndNewlines(string).toLowerCase();
        string2 = StringHelper.removeAllWhitespaceAndNewlines(string2).toLowerCase();
        return string.equals(string2);
    }

    public static String truncate_toLength(String string, int n2) {
        String string2 = string;
        if (string2 == null) {
            return "";
        }
        if (string2.length() > n2) {
            String string3 = "...";
            int n3 = string3.length();
            string2 = string2.substring(0, Math.max(0, n2 - n3));
            string2 = String.format(Locale.ENGLISH, "%s%s", string2, string3);
        }
        return string2;
    }

    public static String truncateToLengthPseudoEllipsis(String string, int n2) {
        String string2 = string;
        if (string2 == null) {
            return "";
        }
        if (string2.length() > n2) {
            String string3 = " . . .";
            int n3 = string3.length();
            string2 = string2.substring(0, Math.max(0, n2 - n3));
            string2 = String.format(Locale.ENGLISH, "%s%s", string2, string3);
        }
        return string2;
    }

    public static String obfuscate_afterLength(String string, int n2) {
        String string2 = string;
        if (string2 == null) {
            return "";
        }
        if (string2.length() > n2) {
            String string3 = "...";
            string2 = string2.substring(0, n2);
            string2 = String.format(Locale.ENGLISH, "%s%s", string2, string3);
        }
        return string2;
    }

    public static String toHex(String string) {
        byte[] byArray = string.getBytes();
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        while (n2 < byArray.length) {
            stringBuilder.append(String.format(Locale.ENGLISH, "%x", byArray[n2]));
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static String fromHex(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        while (n2 < string.length()) {
            stringBuilder.append((char)Integer.parseInt(string.substring(n2, n2 + 2), 16));
            n2 += 2;
        }
        return stringBuilder.toString();
    }

    public static String md5hash(String string) {
        MessageDigest messageDigest;
        if (string == null) {
            return null;
        }
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            logger.e("MD5 algorithm missing in md5hash: " + noSuchAlgorithmException.getLocalizedMessage(), noSuchAlgorithmException);
            return null;
        }
        messageDigest.reset();
        messageDigest.update(string.getBytes());
        byte[] byArray = messageDigest.digest();
        BigInteger bigInteger = new BigInteger(1, byArray);
        String string2 = bigInteger.toString(16);
        while (string2.length() < 32) {
            string2 = "0" + string2;
        }
        return string2;
    }

    public static String trimUnique_toLength(String string, int n2) {
        String string2 = string;
        if (string2.length() > n2) {
            try {
                byte[] byArray = string2.getBytes("UTF-8");
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                byte[] byArray2 = messageDigest.digest(byArray);
                String string3 = new String(byArray2, "UTF-8");
                string3 = StringHelper.toHex(string3);
                int n3 = string3.length();
                string2 = string2.substring(0, Math.max(0, Math.min(n2 - n3, string2.length())));
                string2 = String.format(Locale.ENGLISH, "%s%s", string2, string3);
                if (string2.length() > n2) {
                    string2 = string2.substring(0, n2);
                }
            }
            catch (Exception exception) {
                logger.d("Error trimming unique: " + string, exception);
            }
        }
        return string2;
    }

    public static String fixUrlString(String string) {
        if ((string = StringHelper.trim(string)).length() == 0) {
            return string;
        }
        if (!string.startsWith("http://") && !string.startsWith("https://") && string.indexOf("://") == -1) {
            return String.format(Locale.ENGLISH, "http://%s", string);
        }
        return string;
    }

    public static String capitalizeFirstLetter(String string) {
        return StringUtils.capitalize((String)string);
    }

    public static List<String> convertSeparatedStringToArray_separator(String string, String string2) {
        if (string == null) {
            return new ArrayList<String>();
        }
        String[] stringArray = StringUtils.split((String)string, (String)string2);
        return Arrays.asList(stringArray);
    }

    public static String convertArrayToSeparatedString_separator(List<String> list, String string) {
        if (list == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(50);
        int n2 = 0;
        while (n2 < list.size()) {
            stringBuffer.append(list.get(n2));
            if (n2 < list.size() - 1) {
                stringBuffer.append(string);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String convertArrayToSeparatedString_separator(String[] stringArray, String string) {
        if (stringArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(50);
        int n2 = 0;
        while (n2 < stringArray.length) {
            stringBuffer.append(stringArray[n2]);
            if (n2 < stringArray.length - 1) {
                stringBuffer.append(string);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String removeSimilarPattern_fromString(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string2.trim());
        String string3 = StringHelper.trim(string);
        int n2 = Math.min(string3.length(), stringBuffer.length());
        int n3 = 0;
        while (n3 < n2) {
            char c2 = string3.charAt(n3);
            char c3 = stringBuffer.charAt(n3);
            if ((!StringHelper.isNumericCharacter(c3) || !StringHelper.isNumericCharacter(c2)) && c3 != c2) break;
            stringBuffer.replace(n3, n3 + 1, " ");
            ++n3;
        }
        return stringBuffer.toString().trim();
    }

    public static String stringByDeletingLastPathComponent(String string) {
        int n2 = StringUtils.lastIndexOf((CharSequence)string, (CharSequence)"/");
        if (n2 >= 0) {
            return string.substring(0, n2);
        }
        return string;
    }

    public static String stringByDeletingPathExtension(String string) {
        int n2 = StringUtils.lastIndexOf((CharSequence)string, (CharSequence)".");
        if (n2 >= 0) {
            return string.substring(0, n2);
        }
        return string;
    }

    public static String pathExtension(String string) {
        int n2 = StringUtils.lastIndexOf((CharSequence)string, (CharSequence)".");
        if (n2 >= 0 && n2 < string.length()) {
            return string.substring(n2 + 1);
        }
        return "";
    }

    public static String stringByAppendingPathComponent(String string, String string2) {
        String string3 = string2;
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        string3 = string != null && string.charAt(string.length() - 1) != '/' && string2 != null && string2.charAt(0) != '/' ? String.valueOf(string) + "/" + string2 : String.valueOf(string) + string2;
        return string3;
    }

    public static String stringByAppendingRelativePathComponent(String string, String string2) {
        try {
            String string3 = string2;
            if (string == null) {
                string = "";
            }
            if (string2 == null) {
                string2 = "";
            }
            if (string2.startsWith("./")) {
                string2 = string2.substring(2);
            }
            while (string2.startsWith("../")) {
                string2 = string2.substring(3);
                string = StringHelper.stringByDeletingLastPathComponent(string);
            }
            string3 = StringHelper.stringByAppendingPathComponent(string, string2);
            return string3;
        }
        catch (Exception exception) {
            logger.d("Could not build relative path with currentDir: " + string + ", path: " + string2, exception);
            return StringHelper.stringByAppendingPathComponent(string, string2);
        }
    }

    public static String pruneRelativePath(String string) {
        if (string == null) {
            string = "";
        }
        while (string.startsWith("../")) {
            string = string.substring(3);
        }
        while (string.startsWith("./")) {
            string = string.substring(2);
        }
        return string;
    }

    public static String stringByAppendingPathComponent(File file, File file2) {
        return StringHelper.stringByAppendingPathComponent(file.getAbsolutePath(), file2.getAbsolutePath());
    }

    public static List<String> possibleFollowingAccessPaths(String string) {
        string = StringHelper.trim(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string.length() < 1) {
            return arrayList;
        }
        String string2 = StringHelper.trailingInteger(string);
        String string3 = string.substring(0, string.length() - string2.length());
        if (string3.length() > 0 && string3.charAt(string3.length() - 1) == '.') {
            string3 = string3.substring(0, string3.length() - 1);
        }
        int n2 = 0;
        if (string2.length() > 0) {
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        String string4 = "";
        if (string3.length() == 0) {
            string4 = String.format(Locale.ENGLISH, "%d", n2 + 1);
            arrayList.add(string4);
            string4 = String.format(Locale.ENGLISH, "%d.", n2 + 1);
            arrayList.add(string4);
        } else {
            string4 = String.format(Locale.ENGLISH, "%s.%d", string3, n2 + 1);
            arrayList.add(string4);
            string4 = String.format(Locale.ENGLISH, "%s.%d.", string3, n2 + 1);
            arrayList.add(string4);
        }
        string4 = String.format(Locale.ENGLISH, "%s.1", string);
        arrayList.add(string4);
        string4 = String.format(Locale.ENGLISH, "%s.1.", string);
        arrayList.add(string4);
        string4 = String.format(Locale.ENGLISH, "%s.0", string);
        arrayList.add(string4);
        string4 = String.format(Locale.ENGLISH, "%s.0.", string);
        arrayList.add(string4);
        if (string3.length() > 0) {
            List<String> list = StringHelper.possibleFollowingAccessPaths(string3);
            arrayList.addAll(list);
        }
        return arrayList;
    }

    public static String followingAccessPath(String string, int n2, String string2) {
        string = StringHelper.trim(string);
        boolean bl = false;
        if (string.endsWith(string2)) {
            bl = true;
            string = StringUtils.removeEnd((String)string, (String)string2);
        }
        if (StringUtils.isBlank((CharSequence)string)) {
            return "";
        }
        int n3 = StringUtils.countMatches((CharSequence)string, (CharSequence)string2) + 1;
        String string3 = "";
        if (n3 == n2 && n3 == 1) {
            int n4 = Integer.parseInt(StringHelper.extractFieldFrom_atPosition_delimitedBy(string, 0, string2));
            string3 = "" + (n4 + 1);
        } else if (n3 == n2) {
            int n5 = Integer.parseInt(StringHelper.extractFieldFrom_atPosition_delimitedBy(string, n3 - 1, string2));
            String string4 = StringHelper.truncateFrom_atPosition_delimitedBy(string, n3 - 2, string2);
            string3 = String.valueOf(string4) + string2 + (n5 + 1);
        } else if (n3 < n2) {
            string3 = string;
            int n6 = 0;
            while (n6 < n2 - n3) {
                string3 = String.valueOf(string3) + string2 + "1";
                ++n6;
            }
        } else if (n3 > n2) {
            String string5 = "";
            if (n2 > 1) {
                string5 = StringHelper.truncateFrom_atPosition_delimitedBy(string, n3 - n2 - 1, string2);
            }
            int n7 = Integer.parseInt(StringHelper.extractFieldFrom_atPosition_delimitedBy(string, n2 - 1, string2));
            if (string5.length() > 0) {
                string5 = String.valueOf(string5) + string2;
            }
            string3 = String.valueOf(string5) + (n7 + 1);
        }
        if (bl) {
            string3 = String.valueOf(string3) + string2;
        }
        return string3;
    }

    public static String previousPageNumber(String string) {
        if (string.length() == 0) {
            return null;
        }
        Integer n2 = ConverterUtil.convertToInteger_defaultValue(string, null);
        if (n2 != null && n2 > 1) {
            return String.format("%d", n2 - 1);
        }
        return null;
    }

    public static String reverseString(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n2 = string.length() - 1;
        while (n2 >= 0) {
            char c2 = string.charAt(n2);
            stringBuilder.append(c2);
            --n2;
        }
        return stringBuilder.toString();
    }

    public static String encodeToPercentEscapeString(String string) {
        if (string == null) {
            return "";
        }
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            logger.d("Could not encode url string", unsupportedEncodingException);
            return string;
        }
    }

    public static String decodeFromPercentEscapeString(String string) {
        if (string == null) {
            return "";
        }
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (Exception exception) {
            logger.d("Could not decode url string: " + string);
            return string;
        }
    }

    public static URI encodeURLStringToURI(String string) {
        Serializable serializable;
        if (string == null || string.length() == 0) {
            return null;
        }
        String string2 = StringHelper.extractStringFrom_until(string, "://");
        if (string2.equals(string) && ((File)(serializable = new File(string))).exists()) {
            return ((File)serializable).toURI();
        }
        string = StringHelper.decodeFromPercentEscapeString(string);
        try {
            serializable = null;
            try {
                serializable = new URL(string);
                URI uRI = new URI(((URL)serializable).getProtocol(), ((URL)serializable).getUserInfo(), ((URL)serializable).getHost(), ((URL)serializable).getPort(), ((URL)serializable).getPath(), ((URL)serializable).getQuery(), ((URL)serializable).getRef());
                return uRI;
            }
            catch (Exception exception) {
                if (StringHelper.isAnyApplicationUrlScheme(string)) {
                    try {
                        return new URI(string);
                    }
                    catch (Exception exception2) {
                        String string3 = StringHelper.extractString_after(string, "://");
                        string3 = StringHelper.encodeToPercentEscapeString(string3);
                        return new URI(String.valueOf(string2) + "://" + string3);
                    }
                }
                if (!(string.contains("http://") || string.contains("https://") && !string.contains("://"))) {
                    string = "https://" + string;
                }
                URI uRI = new URI(string);
                return uRI;
            }
        }
        catch (Exception exception) {
            logger.d("Could not encode url string", exception);
            return null;
        }
    }

    public static boolean isAnyApplicationUrlScheme(String string) {
        if (string == null) {
            return false;
        }
        if (string.contains("://")) {
            return !(string = StringHelper.extractStringFrom_until(string, "://")).equals("http") && !string.equals("https") && !string.equals("file");
        }
        return false;
    }

    public static String encodeURLString(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        string = StringHelper.decodeFromPercentEscapeString(string);
        try {
            URL uRL = new URL(string);
            URI uRI = new URI(uRL.getProtocol(), uRL.getUserInfo(), uRL.getHost(), uRL.getPort(), uRL.getPath(), uRL.getQuery(), uRL.getRef());
            return uRI.toString();
        }
        catch (Exception exception) {
            logger.d("Could not encode url string", exception);
            return string;
        }
    }

    public static String stringByAddingPercentEscapesUsingEncoding(String string) {
        return StringHelper.encodeURLString(string);
    }

    public static String stringByEncodingXMLEntitites(String string) {
        string = string.replace("&", "&amp;");
        string = string.replace("<", "&lt;");
        string = string.replace(">", "&gt;");
        string = string.replace("\"", "&quot;");
        string = string.replace("'", "&#039;");
        return string;
    }

    public static String makeFileSystemFriendlyFilename(String string) {
        int n2 = 260;
        String string2 = FilenameUtils.getExtension((String)string);
        String string3 = FilenameUtils.getBaseName((String)string);
        String string4 = FilenameUtils.getFullPath((String)string);
        string3 = StringHelper.replaceUmlautCharacters(string3);
        string3 = string3.replaceAll("[^a-zA-Z0-9_-]", "_");
        string3 = StringHelper.trimUnique_toLength(string3, 260 - string4.length() - string2.length() - 1);
        if (string2.length() > 0) {
            string3 = String.valueOf(string3) + "." + string2;
        }
        if (string4.length() > 0) {
            return FilenameUtils.concat((String)string4, (String)string3);
        }
        return string3;
    }

    public static String normalizeForJQuery(String string) {
        if (string != null) {
            string = string.replaceAll("[^0-9a-zA-Z]", "_");
        }
        return string;
    }

    public static String normalizeForFilePath(String string) {
        return string.replace("\\", "/");
    }

    public static String escapedJSONString(String string) {
        String string2 = string;
        string2 = string2.replace("\\", "\\\\");
        string2 = string2.replace("\"", "\\\"");
        string2 = string2.replace("\b", "\\b");
        string2 = string2.replace("\f", "\\f");
        string2 = string2.replace("\n", "\\n");
        string2 = string2.replace("\r", "\\r");
        string2 = string2.replace("\t", "\\t");
        string2 = string2.replace("'", "\\'");
        return string2;
    }

    public static String stringByReplacingCharactersInRange_withString(String string, String string2, String string3, String string4) {
        int n2 = string.indexOf(string2);
        int n3 = string.indexOf(string3);
        if (n2 < 0 || n3 < 0) {
            return string;
        }
        String string5 = StringHelper.stringByReplacingCharactersInRange_withString(string, n2, n3, string4);
        return string5;
    }

    public static String stringByReplacingCharactersInRange_withString(String string, int n2, int n3, String string2) {
        String string3 = String.valueOf(string.substring(0, n2)) + string2 + string.substring(n3);
        return string3;
    }

    public static String stringByRemovingSubString(String string, String string2) {
        return StringUtils.replace((String)string, (String)string2, (String)"");
    }

    public static String substringWithRange(String string, int n2, int n3) {
        if (n2 < 0) {
            n2 = 0;
        }
        return string.substring(n2, n3);
    }

    public static String removeEndFromString_with(String string, String string2) {
        return StringUtils.removeEnd((String)string, (String)string2);
    }

    public static String replaceUmlautCharacters(String string) {
        String string2 = StringUtils.replace((String)string, (String)"\u00e4", (String)"ae");
        string2 = StringUtils.replace((String)string2, (String)"\u00c4", (String)"Ae");
        string2 = StringUtils.replace((String)string2, (String)"\u00f6", (String)"oe");
        string2 = StringUtils.replace((String)string2, (String)"\u00d6", (String)"Oe");
        string2 = StringUtils.replace((String)string2, (String)"\u00fc", (String)"ue");
        string2 = StringUtils.replace((String)string2, (String)"\u00dc", (String)"Ue");
        string2 = StringUtils.replaceChars((String)string2, (String)"\u00e2", (String)"a");
        string2 = StringUtils.replaceChars((String)string2, (String)"\u00c2", (String)"A");
        string2 = StringUtils.replaceChars((String)string2, (String)"\u00f4", (String)"o");
        string2 = StringUtils.replaceChars((String)string2, (String)"\u00d4", (String)"O");
        string2 = StringUtils.replaceChars((String)string2, (String)"\u00fb", (String)"u");
        string2 = StringUtils.replaceChars((String)string2, (String)"\u00db", (String)"U");
        string2 = StringUtils.replaceChars((String)string2, (String)"\u00e1", (String)"a");
        string2 = StringUtils.replaceChars((String)string2, (String)"\u00c1", (String)"A");
        string2 = StringUtils.replaceChars((String)string2, (String)"\u00e0", (String)"a");
        string2 = StringUtils.replaceChars((String)string2, (String)"\u00c0", (String)"A");
        string2 = StringUtils.replaceChars((String)string2, (String)"\u00e2", (String)"a");
        string2 = StringUtils.replaceChars((String)string2, (String)"\u00c2", (String)"A");
        string2 = StringUtils.replaceChars((String)string2, (String)"\u00e5", (String)"a");
        string2 = StringUtils.replaceChars((String)string2, (String)"\u00c5", (String)"A");
        string2 = StringUtils.replaceChars((String)string2, (String)"\u00e3", (String)"a");
        string2 = StringUtils.replaceChars((String)string2, (String)"\u00c3", (String)"A");
        string2 = StringUtils.replaceChars((String)string2, (String)"\u00e7", (String)"c");
        string2 = StringUtils.replaceChars((String)string2, (String)"\u00c7", (String)"C");
        string2 = StringUtils.replaceChars((String)string2, (String)"\u010d", (String)"c");
        string2 = StringUtils.replaceChars((String)string2, (String)"\u010c", (String)"C");
        string2 = StringUtils.replaceChars((String)string2, (String)"\u00e8", (String)"e");
        string2 = StringUtils.replaceChars((String)string2, (String)"\u00c8", (String)"E");
        string2 = StringUtils.replaceChars((String)string2, (String)"\u00e9", (String)"e");
        string2 = StringUtils.replaceChars((String)string2, (String)"\u00c9", (String)"E");
        string2 = StringUtils.replaceChars((String)string2, (String)"\u00ea", (String)"e");
        string2 = StringUtils.replaceChars((String)string2, (String)"\u00ca", (String)"E");
        string2 = StringUtils.replaceChars((String)string2, (String)"\u00eb", (String)"e");
        string2 = StringUtils.replaceChars((String)string2, (String)"\u00cb", (String)"E");
        string2 = StringUtils.replaceChars((String)string2, (String)"\u00ed", (String)"i");
        string2 = StringUtils.replaceChars((String)string2, (String)"\u00cd", (String)"I");
        string2 = StringUtils.replaceChars((String)string2, (String)"\u00ec", (String)"i");
        string2 = StringUtils.replaceChars((String)string2, (String)"\u00cc", (String)"I");
        string2 = StringUtils.replaceChars((String)string2, (String)"\u00ee", (String)"i");
        string2 = StringUtils.replaceChars((String)string2, (String)"\u00ce", (String)"I");
        string2 = StringUtils.replaceChars((String)string2, (String)"\u00ef", (String)"i");
        string2 = StringUtils.replaceChars((String)string2, (String)"\u00cf", (String)"I");
        string2 = StringUtils.replaceChars((String)string2, (String)"\u00d8", (String)"O");
        string2 = StringUtils.replaceChars((String)string2, (String)"\u00f8", (String)"o");
        string2 = StringUtils.replaceChars((String)string2, (String)"\u00d2", (String)"O");
        string2 = StringUtils.replaceChars((String)string2, (String)"\u00f2", (String)"o");
        string2 = StringUtils.replaceChars((String)string2, (String)"\u0153", (String)"oe");
        string2 = StringUtils.replaceChars((String)string2, (String)"\u00df", (String)"ss");
        string2 = StringUtils.replaceChars((String)string2, (String)"\u00f1", (String)"n");
        string2 = StringUtils.replaceChars((String)string2, (String)"\u00d1", (String)"N");
        string2 = StringUtils.replaceChars((String)string2, (String)"\u0161", (String)"s");
        string2 = StringUtils.replaceChars((String)string2, (String)"\u0160", (String)"S");
        string2 = StringUtils.replaceChars((String)string2, (String)"\u00fb", (String)"u");
        string2 = StringUtils.replaceChars((String)string2, (String)"\u00db", (String)"U");
        string2 = StringUtils.replaceChars((String)string2, (String)"\u00f9", (String)"u");
        string2 = StringUtils.replaceChars((String)string2, (String)"\u00d9", (String)"U");
        string2 = StringUtils.replaceChars((String)string2, (String)"\u00ff", (String)"y");
        string2 = StringUtils.replaceChars((String)string2, (String)"\u0178", (String)"Y");
        string2 = StringUtils.replaceChars((String)string2, (String)"\u00fd", (String)"y");
        string2 = StringUtils.replaceChars((String)string2, (String)"\u00dd", (String)"Y");
        string2 = StringUtils.replaceChars((String)string2, (String)"\u017e", (String)"z");
        string2 = StringUtils.replaceChars((String)string2, (String)"\u017d", (String)"Z");
        return string2;
    }

    public static String fixUmlautCharacters(String string) {
        String string2 = string;
        string2 = StringUtils.replace((String)string2, (String)"a\u0308", (String)"\u00e4");
        string2 = StringUtils.replace((String)string2, (String)"o\u0308", (String)"\u00f6");
        string2 = StringUtils.replace((String)string2, (String)"u\u0308", (String)"\u00fc");
        string2 = StringUtils.replace((String)string2, (String)"A\u0308", (String)"\u00c4");
        string2 = StringUtils.replace((String)string2, (String)"O\u0308", (String)"\u00d6");
        string2 = StringUtils.replace((String)string2, (String)"U\u0308", (String)"\u00dc");
        string2 = StringUtils.replace((String)string2, (String)"a\u0300", (String)"\u00e0");
        string2 = StringUtils.replace((String)string2, (String)"e\u0301", (String)"\u00e9");
        string2 = StringUtils.replace((String)string2, (String)"e\u0300", (String)"\u00e8");
        string2 = StringUtils.replace((String)string2, (String)"A\u0300", (String)"\u00c0");
        string2 = StringUtils.replace((String)string2, (String)"E\u0301", (String)"\u00c9");
        string2 = StringUtils.replace((String)string2, (String)"E\u0300", (String)"\u00c8");
        string2 = StringUtils.replace((String)string2, (String)"c\u0327", (String)"\u00e7");
        string2 = StringUtils.replace((String)string2, (String)"u\u0302", (String)"\u00fb");
        string2 = StringUtils.replace((String)string2, (String)"A\u0302", (String)"\u00c2");
        string2 = StringUtils.replace((String)string2, (String)"O\u0302", (String)"\u00d4");
        string2 = StringUtils.replace((String)string2, (String)"U\u0302", (String)"\u00db");
        string2 = StringUtils.replace((String)string2, (String)"a\u0302", (String)"\u00e2");
        string2 = StringUtils.replace((String)string2, (String)"o\u0302", (String)"\u00f4");
        string2 = StringUtils.replace((String)string2, (String)"u\u0302", (String)"\u00fb");
        string2 = StringUtils.replace((String)string2, (String)"i\u0308", (String)"\u00ef");
        return string2;
    }

    public static int parseInt(String string) {
        if (string == null || string.trim().length() == 0) {
            return 0;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            logger.c("Could not parse integer: " + string);
            return 0;
        }
    }

    public static byte[] convertHexToBytes(String string) {
        if (string.length() % 2 != 0) {
            throw new IllegalArgumentException("Input string must contain an even number of characters: " + string);
        }
        byte[] byArray = new byte[string.length() / 2];
        char[] cArray = string.toCharArray();
        int n2 = 0;
        while (n2 < cArray.length) {
            StringBuilder stringBuilder = new StringBuilder(2);
            stringBuilder.append(cArray[n2]).append(cArray[n2 + 1]);
            byArray[n2 / 2] = (byte)Integer.parseInt(stringBuilder.toString(), 16);
            n2 += 2;
        }
        return byArray;
    }

    public static int indexOfAny(String string, int n2, String string2, boolean bl) {
        if (StringHelper.isEmpty(string) || StringHelper.isEmpty(string2)) {
            return -1;
        }
        return StringHelper.indexOfAny(string, n2, string2.toCharArray(), bl);
    }

    public static int indexOfAny(String string, int n2, char[] cArray, boolean bl) {
        if (StringHelper.isEmpty(string) || ArrayUtils.isEmpty((char[])cArray)) {
            return -1;
        }
        int n3 = string.length();
        int n4 = n3 - 1;
        int n5 = cArray.length;
        int n6 = n5 - 1;
        int n7 = n2;
        while (n7 < n3) {
            char c2 = string.charAt(n7);
            if (bl) {
                c2 = Character.toLowerCase(c2);
            }
            int n8 = 0;
            while (n8 < n5) {
                char c3 = cArray[n8];
                if (bl) {
                    c3 = Character.toLowerCase(c3);
                }
                if (c3 == c2) {
                    if (n7 < n4 && n8 < n6 && StringHelper.isHighSurrogate(c2)) {
                        char c4 = cArray[n8 + 1];
                        char c5 = string.charAt(n7 + 1);
                        if (bl) {
                            c4 = Character.toLowerCase(c4);
                            c5 = Character.toLowerCase(c5);
                        }
                        if (c4 == c5) {
                            return n7 - n2;
                        }
                    } else {
                        return n7 - n2;
                    }
                }
                ++n8;
            }
            ++n7;
        }
        return -1;
    }

    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static boolean isHighSurrogate(char c2) {
        return '\ud800' <= c2 && '\udbff' >= c2;
    }

    public static String escapeUnicode(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        Formatter formatter = new Formatter(stringBuilder);
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        while (n3 < n2) {
            char c2 = cArray[n3];
            if (c2 < '\u0080') {
                stringBuilder.append(c2);
            } else {
                formatter.format("\\u%04x", c2);
            }
            ++n3;
        }
        return stringBuilder.toString();
    }

    public static String[] pathComponents(String string) {
        List<String> list = Arrays.asList(string.split("/"));
        if (string.startsWith("/")) {
            list.add(0, "/");
        }
        return list.toArray(new String[0]);
    }

    public static String escapeStringForRegex(String string) {
        String string2 = string.replaceAll("\\(", "\\\\(");
        string2 = string2.replaceAll("\\)", "\\\\)");
        string2 = string2.replaceAll("\\[", "\\\\[");
        string2 = string2.replaceAll("\\]", "\\\\]");
        string2 = string2.replaceAll("\\{", "\\\\}");
        string2 = string2.replaceAll("\\.", "\\\\.");
        return string2;
    }

    public static boolean isBlank(String string) {
        return StringUtils.isBlank((CharSequence)string);
    }

    public static boolean isNotBlank(String string) {
        return StringUtils.isNotBlank((CharSequence)string);
    }

    public static String join(String string, String ... stringArray) {
        String string2;
        if (stringArray == null || string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            string2 = stringArray2[n3];
            stringBuffer.append(string2);
            stringBuffer.append(string);
            ++n3;
        }
        string2 = stringBuffer.toString();
        string2 = StringUtils.removeEnd((String)string2, (String)string);
        return string2;
    }

    public static boolean isEquals(String string, String string2) {
        if (string == null && string2 == null) {
            return true;
        }
        if (string == null && string2 != null) {
            return false;
        }
        if (string != null && string2 == null) {
            return false;
        }
        return string.equals(string2);
    }

    public static boolean isEquals(Object object, Object object2) {
        if (object == null && object2 == null) {
            return true;
        }
        if (object == null && object2 != null) {
            return false;
        }
        if (object != null && object2 == null) {
            return false;
        }
        return object.equals(object2);
    }

    public static boolean like(String string, String string2) {
        string2 = string2.toLowerCase();
        string2 = string2.replace(".", "\\.");
        string2 = string2.replace("?", ".");
        string2 = string2.replace("*", ".*");
        string = string.toLowerCase();
        return string.matches(string2);
    }

    public static String printStringArray(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (stringArray == null) {
            return "";
        }
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String string = stringArray2[n3];
            if (string != null) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(string);
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    public static String getImagePathFromURL(URL uRL) {
        String string = uRL.toString();
        string = string.replace("file:", "").replace(" ", "");
        return string;
    }

    public static boolean isURLFile(URL uRL) {
        String string = uRL.toString();
        return string.toLowerCase().startsWith("file:");
    }

    public static boolean isBase64Encoded(String string) {
        block4: {
            if (!StringUtils.isEmpty((CharSequence)string)) break block4;
            return false;
        }
        try {
            Pattern pattern = Pattern.compile("^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)?$");
            Matcher matcher = pattern.matcher(string);
            if (matcher.find()) {
                return true;
            }
        }
        catch (Exception exception) {
            logger.d("Could not check if string is base64 encoded. string: " + string, exception);
        }
        return false;
    }

    public static boolean isValidUrl(String string) {
        try {
            new URL(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String stripCDATA(String string) {
        Pattern pattern = Pattern.compile("\\<\\!\\[(.+)\\]\\]\\>");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            return string;
        }
        return matcher.group(1);
    }

    public static String maskEmail(String string) {
        if (string == null || string.equals("")) {
            return string;
        }
        int n2 = string.indexOf(64);
        if (n2 <= 0 || n2 == string.length() - 1) {
            return string;
        }
        String string2 = string.substring(0, n2);
        String string3 = string.substring(n2 + 1);
        char c2 = string2.charAt(0);
        String string4 = String.valueOf(c2) + StringHelper.repeat('*', Math.max(1, string2.length() - 1));
        return String.valueOf(string4) + "@" + string3;
    }

    private static String repeat(char c2, int n2) {
        if (n2 <= 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(n2);
        int n3 = 0;
        while (n3 < n2) {
            stringBuilder.append(c2);
            ++n3;
        }
        return stringBuilder.toString();
    }
}

