/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.base.he;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.co.g;
import ch.ionesoft.ilp.base.he.DESEncrypter;
import ch.ionesoft.ilp.base.he.FileHelper;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public class SecureStore {
    private static final ILogger logger = ILPLogManager.getLogger(SecureStore.class);
    private Map<String, Map<String, String>> store = new ConcurrentHashMap<String, Map<String, String>>();
    private DESEncrypter encryper = null;
    private String masterPassword;
    private File file;

    public static SecureStore configureSecureStore(File file, String string) {
        SecureStore secureStore = null;
        try {
            String string2 = g.a().w(string);
            File file2 = new File(file, string);
            secureStore = new SecureStore(string2, file2);
        }
        catch (Exception exception) {
            logger.d("Could not create SecureStore: " + string, exception);
        }
        return secureStore;
    }

    private SecureStore(String string, File file) throws Exception {
        this.init(string, file);
    }

    private void init(String string, File file) throws Exception {
        this.file = file;
        this.masterPassword = string;
        this.encryper = new DESEncrypter(this.masterPassword, "&fHerdNf");
        logger.b("Load and init SecureStore from file: " + this.file);
        if (this.file.exists()) {
            try (InputStream inputStream = null;){
                logger.b("Load SecureStore from file: " + file + ", size: " + file.length());
                inputStream = new FileInputStream(file);
                inputStream = this.encryper.wrapInputStreamDecrypt(inputStream);
                String string2 = FileHelper.contentsOfFile(inputStream);
                ObjectReader objectReader = new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).readerFor(Map.class);
                this.store = (Map)objectReader.readValue(string2);
            }
        } else {
            logger.b("SecureStore file not found: " + this.file);
        }
    }

    public String getEntry(String string, String string2) {
        if (StringUtils.isBlank((CharSequence)string2)) {
            throw new UnsupportedOperationException("Context is null. Not able to add a entry to an 'null' context. ");
        }
        if (StringUtils.isBlank((CharSequence)string)) {
            throw new UnsupportedOperationException("Key is null. Not able to add a null entry to context: " + string2);
        }
        Map<String, String> map = this.store.get(string2);
        if (map == null) {
            return null;
        }
        return map.get(string);
    }

    public void addEntry(String string, String string2, String string3) {
        if (StringUtils.isBlank((CharSequence)string2)) {
            throw new UnsupportedOperationException("Context is null. Not able to add a entry to an 'null' context. ");
        }
        if (StringUtils.isBlank((CharSequence)string)) {
            throw new UnsupportedOperationException("Key is null. Not able to add a null entry to context: " + string2);
        }
        if (string3 == null) {
            throw new UnsupportedOperationException("Value is null. Not able to add a null value to context: " + string2);
        }
        Map<String, String> map = this.store.get(string2);
        if (map == null) {
            map = new ConcurrentHashMap<String, String>();
            this.store.put(string2, map);
        }
        map.put(string, string3);
        this.store();
    }

    public void removeEntry(String string, String string2) {
        if (StringUtils.isBlank((CharSequence)string2)) {
            throw new UnsupportedOperationException("Context is null. Not able to add a entry to an 'null' context. ");
        }
        if (StringUtils.isBlank((CharSequence)string)) {
            throw new UnsupportedOperationException("Key is null. Not able to add a null entry to context: " + string2);
        }
        Map<String, String> map = this.store.get(string2);
        if (map == null) {
            return;
        }
        map.remove(string);
        this.store();
    }

    private synchronized void store() {
        try {
            if (this.store.isEmpty()) {
                return;
            }
            ObjectWriter objectWriter = new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).writerFor(Map.class);
            String string = objectWriter.writeValueAsString(this.store);
            if (StringUtils.isEmpty((CharSequence)string)) {
                return;
            }
            try (OutputStream outputStream = null;){
                outputStream = new FileOutputStream(this.file);
                outputStream = this.encryper.wrapOutputStreamEncrypt(outputStream);
                outputStream.write(string.toString().getBytes());
            }
        }
        catch (Exception exception) {
            logger.d("Could not write SecureStore file: " + this.file.getAbsolutePath(), exception);
        }
    }
}

