/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.base.he;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorConvertOp;
import java.awt.image.ConvolveOp;
import java.awt.image.ImagingOpException;
import java.awt.image.Kernel;
import java.awt.image.RescaleOp;

public class Scalr {
    public static final String DEBUG_PROPERTY_NAME = "imgscalr.debug";
    public static final String LOG_PREFIX_PROPERTY_NAME = "imgscalr.logPrefix";
    public static final boolean DEBUG = Boolean.getBoolean("imgscalr.debug");
    public static final String LOG_PREFIX = System.getProperty("imgscalr.logPrefix", "[imgscalr] ");
    public static final ConvolveOp OP_ANTIALIAS = new ConvolveOp(new Kernel(3, 3, new float[]{0.0f, 0.08f, 0.0f, 0.08f, 0.68f, 0.08f, 0.0f, 0.08f, 0.0f}), 1, null);
    public static final RescaleOp OP_DARKER = new RescaleOp(0.9f, 0.0f, null);
    public static final RescaleOp OP_BRIGHTER = new RescaleOp(1.1f, 0.0f, null);
    public static final ColorConvertOp OP_GRAYSCALE = new ColorConvertOp(ColorSpace.getInstance(1003), null);
    public static final int THRESHOLD_BALANCED_SPEED = 1600;
    public static final int THRESHOLD_QUALITY_BALANCED = 800;

    static {
        Scalr.log(0, "Debug output ENABLED", new Object[0]);
    }

    public static BufferedImage apply(BufferedImage bufferedImage, BufferedImageOp ... bufferedImageOpArray) throws IllegalArgumentException, ImagingOpException {
        long l2 = -1L;
        if (DEBUG) {
            l2 = System.currentTimeMillis();
        }
        if (bufferedImage == null) {
            throw new IllegalArgumentException("src cannot be null");
        }
        if (bufferedImageOpArray == null || bufferedImageOpArray.length == 0) {
            throw new IllegalArgumentException("ops cannot be null or empty");
        }
        int n2 = bufferedImage.getType();
        if (n2 != 1 && n2 != 2) {
            bufferedImage = Scalr.copyToOptimalImage(bufferedImage);
        }
        if (DEBUG) {
            Scalr.log(0, "Applying %d BufferedImageOps...", bufferedImageOpArray.length);
        }
        boolean bl = false;
        int n3 = 0;
        while (n3 < bufferedImageOpArray.length) {
            BufferedImageOp bufferedImageOp;
            long l3 = -1L;
            if (DEBUG) {
                l3 = System.currentTimeMillis();
            }
            if ((bufferedImageOp = bufferedImageOpArray[n3]) != null) {
                Rectangle2D rectangle2D;
                if (DEBUG) {
                    Scalr.log(1, "Applying BufferedImageOp [class=%s, toString=%s]...", bufferedImageOp.getClass(), bufferedImageOp.toString());
                }
                if ((rectangle2D = bufferedImageOp.getBounds2D(bufferedImage)) == null) {
                    throw new ImagingOpException("BufferedImageOp [" + bufferedImageOp.toString() + "] getBounds2D(src) returned null bounds for the target image; this should not happen and indicates a problem with application of this type of op.");
                }
                BufferedImage bufferedImage2 = Scalr.createOptimalImage(bufferedImage, (int)Math.round(rectangle2D.getWidth()), (int)Math.round(rectangle2D.getHeight()));
                BufferedImage bufferedImage3 = bufferedImageOp.filter(bufferedImage, bufferedImage2);
                if (bl) {
                    bufferedImage.flush();
                }
                bufferedImage = bufferedImage3;
                bl = true;
                if (DEBUG) {
                    Scalr.log(1, "Applied BufferedImageOp in %d ms, result [width=%d, height=%d]", System.currentTimeMillis() - l3, bufferedImage3.getWidth(), bufferedImage3.getHeight());
                }
            }
            ++n3;
        }
        if (DEBUG) {
            Scalr.log(0, "All %d BufferedImageOps applied in %d ms", bufferedImageOpArray.length, System.currentTimeMillis() - l2);
        }
        return bufferedImage;
    }

    public static BufferedImage crop(BufferedImage bufferedImage, int n2, int n3, BufferedImageOp ... bufferedImageOpArray) throws IllegalArgumentException, ImagingOpException {
        return Scalr.crop(bufferedImage, 0, 0, n2, n3, bufferedImageOpArray);
    }

    public static BufferedImage crop(BufferedImage bufferedImage, int n2, int n3, int n4, int n5, BufferedImageOp ... bufferedImageOpArray) throws IllegalArgumentException, ImagingOpException {
        long l2 = -1L;
        if (DEBUG) {
            l2 = System.currentTimeMillis();
        }
        if (bufferedImage == null) {
            throw new IllegalArgumentException("src cannot be null");
        }
        if (n2 < 0 || n3 < 0 || n4 < 0 || n5 < 0) {
            throw new IllegalArgumentException("Invalid crop bounds: x [" + n2 + "], y [" + n3 + "], width [" + n4 + "] and height [" + n5 + "] must all be >= 0");
        }
        int n6 = bufferedImage.getWidth();
        int n7 = bufferedImage.getHeight();
        if (n2 + n4 > n6) {
            throw new IllegalArgumentException("Invalid crop bounds: x + width [" + (n2 + n4) + "] must be <= src.getWidth() [" + n6 + "]");
        }
        if (n3 + n5 > n7) {
            throw new IllegalArgumentException("Invalid crop bounds: y + height [" + (n3 + n5) + "] must be <= src.getHeight() [" + n7 + "]");
        }
        if (DEBUG) {
            Scalr.log(0, "Cropping Image [width=%d, height=%d] to [x=%d, y=%d, width=%d, height=%d]...", n6, n7, n2, n3, n4, n5);
        }
        BufferedImage bufferedImage2 = Scalr.createOptimalImage(bufferedImage, n4, n5);
        Graphics graphics = bufferedImage2.getGraphics();
        graphics.drawImage(bufferedImage, 0, 0, n4, n5, n2, n3, n2 + n4, n3 + n5, null);
        graphics.dispose();
        if (DEBUG) {
            Scalr.log(0, "Cropped Image in %d ms", System.currentTimeMillis() - l2);
        }
        if (bufferedImageOpArray != null && bufferedImageOpArray.length > 0) {
            bufferedImage2 = Scalr.apply(bufferedImage2, bufferedImageOpArray);
        }
        return bufferedImage2;
    }

    public static BufferedImage pad(BufferedImage bufferedImage, int n2, BufferedImageOp ... bufferedImageOpArray) throws IllegalArgumentException, ImagingOpException {
        return Scalr.pad(bufferedImage, n2, Color.BLACK, new BufferedImageOp[0]);
    }

    public static BufferedImage pad(BufferedImage bufferedImage, int n2, Color color, BufferedImageOp ... bufferedImageOpArray) throws IllegalArgumentException, ImagingOpException {
        BufferedImage bufferedImage2;
        boolean bl;
        long l2 = -1L;
        if (DEBUG) {
            l2 = System.currentTimeMillis();
        }
        if (bufferedImage == null) {
            throw new IllegalArgumentException("src cannot be null");
        }
        if (n2 < 1) {
            throw new IllegalArgumentException("padding [" + n2 + "] must be > 0");
        }
        if (color == null) {
            throw new IllegalArgumentException("color cannot be null");
        }
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        int n5 = n2 * 2;
        int n6 = n3 + n5;
        int n7 = n4 + n5;
        if (DEBUG) {
            Scalr.log(0, "Padding Image from [originalWidth=%d, originalHeight=%d, padding=%d] to [newWidth=%d, newHeight=%d]...", n3, n4, n2, n6, n7);
        }
        boolean bl2 = color.getAlpha() != 255;
        boolean bl3 = bl = bufferedImage.getTransparency() != 1;
        if (bl2 || bl) {
            if (DEBUG) {
                Scalr.log(1, "Transparency FOUND in source image or color, using ARGB image type...", new Object[0]);
            }
            bufferedImage2 = new BufferedImage(n6, n7, 2);
        } else {
            if (DEBUG) {
                Scalr.log(1, "Transparency NOT FOUND in source image or color, using RGB image type...", new Object[0]);
            }
            bufferedImage2 = new BufferedImage(n6, n7, 1);
        }
        Graphics graphics = bufferedImage2.getGraphics();
        graphics.setColor(color);
        graphics.fillRect(0, 0, n6, n2);
        graphics.fillRect(0, n2, n2, n7);
        graphics.fillRect(n2, n7 - n2, n6, n7);
        graphics.fillRect(n6 - n2, n2, n6, n7 - n2);
        graphics.drawImage(bufferedImage, n2, n2, null);
        graphics.dispose();
        if (DEBUG) {
            Scalr.log(0, "Padding Applied in %d ms", System.currentTimeMillis() - l2);
        }
        if (bufferedImageOpArray != null && bufferedImageOpArray.length > 0) {
            bufferedImage2 = Scalr.apply(bufferedImage2, bufferedImageOpArray);
        }
        return bufferedImage2;
    }

    public static BufferedImage resize(BufferedImage bufferedImage, int n2, BufferedImageOp ... bufferedImageOpArray) throws IllegalArgumentException, ImagingOpException {
        return Scalr.resize(bufferedImage, Method.AUTOMATIC, Mode.AUTOMATIC, n2, n2, bufferedImageOpArray);
    }

    public static BufferedImage resize(BufferedImage bufferedImage, Method method, int n2, BufferedImageOp ... bufferedImageOpArray) throws IllegalArgumentException, ImagingOpException {
        return Scalr.resize(bufferedImage, method, Mode.AUTOMATIC, n2, n2, bufferedImageOpArray);
    }

    public static BufferedImage resize(BufferedImage bufferedImage, Mode mode, int n2, BufferedImageOp ... bufferedImageOpArray) throws IllegalArgumentException, ImagingOpException {
        return Scalr.resize(bufferedImage, Method.AUTOMATIC, mode, n2, n2, bufferedImageOpArray);
    }

    public static BufferedImage resize(BufferedImage bufferedImage, Method method, Mode mode, int n2, BufferedImageOp ... bufferedImageOpArray) throws IllegalArgumentException, ImagingOpException {
        return Scalr.resize(bufferedImage, method, mode, n2, n2, bufferedImageOpArray);
    }

    public static BufferedImage resize(BufferedImage bufferedImage, int n2, int n3, BufferedImageOp ... bufferedImageOpArray) throws IllegalArgumentException, ImagingOpException {
        return Scalr.resize(bufferedImage, Method.AUTOMATIC, Mode.AUTOMATIC, n2, n3, bufferedImageOpArray);
    }

    public static BufferedImage resize(BufferedImage bufferedImage, Method method, int n2, int n3, BufferedImageOp ... bufferedImageOpArray) {
        return Scalr.resize(bufferedImage, method, Mode.AUTOMATIC, n2, n3, bufferedImageOpArray);
    }

    public static BufferedImage resize(BufferedImage bufferedImage, Mode mode, int n2, int n3, BufferedImageOp ... bufferedImageOpArray) throws IllegalArgumentException, ImagingOpException {
        return Scalr.resize(bufferedImage, Method.AUTOMATIC, mode, n2, n3, bufferedImageOpArray);
    }

    public static BufferedImage resize(BufferedImage bufferedImage, Method method, Mode mode, int n2, int n3, BufferedImageOp ... bufferedImageOpArray) throws IllegalArgumentException, ImagingOpException {
        long l2 = -1L;
        if (DEBUG) {
            l2 = System.currentTimeMillis();
        }
        if (bufferedImage == null) {
            throw new IllegalArgumentException("src cannot be null");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("targetWidth must be >= 0");
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("targetHeight must be >= 0");
        }
        if (method == null) {
            throw new IllegalArgumentException("scalingMethod cannot be null. A good default value is Method.AUTOMATIC.");
        }
        if (mode == null) {
            throw new IllegalArgumentException("resizeMode cannot be null. A good default value is Mode.AUTOMATIC.");
        }
        BufferedImage bufferedImage2 = null;
        int n4 = bufferedImage.getWidth();
        int n5 = bufferedImage.getHeight();
        float f2 = (float)n5 / (float)n4;
        if (DEBUG) {
            Scalr.log(0, "Resizing Image [size=%dx%d, resizeMode=%s, orientation=%s, ratio(H/W)=%f] to [targetSize=%dx%d]", new Object[]{n4, n5, mode, f2 <= 1.0f ? "Landscape/Square" : "Portrait", Float.valueOf(f2), n2, n3});
        }
        if (mode == Mode.FIT_EXACT) {
            if (DEBUG) {
                Scalr.log(1, "Resize Mode FIT_EXACT used, no width/height checking or re-calculation will be done.", new Object[0]);
            }
        } else if (mode == Mode.BEST_FIT_BOTH) {
            float f3 = (float)n3 / (float)n5;
            float f4 = (float)n2 / (float)n4;
            float f5 = Math.min(f3, f4);
            n3 = Math.round((float)n5 * f5);
            n2 = Math.round((float)n4 * f5);
            if (n3 == n5 && n2 == n4) {
                return bufferedImage;
            }
            if (DEBUG) {
                Scalr.log(1, "Auto-Corrected width and height based on scalingRatio %d.", Float.valueOf(f5));
            }
        } else if (f2 <= 1.0f && mode == Mode.AUTOMATIC || mode == Mode.FIT_TO_WIDTH) {
            if (n2 == bufferedImage.getWidth()) {
                return bufferedImage;
            }
            int n6 = n3;
            n3 = (int)Math.ceil((float)n2 * f2);
            if (DEBUG && n6 != n3) {
                Scalr.log(1, "Auto-Corrected targetHeight [from=%d to=%d] to honor image proportions.", n6, n3);
            }
        } else {
            if (n3 == bufferedImage.getHeight()) {
                return bufferedImage;
            }
            int n7 = n2;
            n2 = Math.round((float)n3 / f2);
            if (DEBUG && n7 != n2) {
                Scalr.log(1, "Auto-Corrected targetWidth [from=%d to=%d] to honor image proportions.", n7, n2);
            }
        }
        if (method == Method.AUTOMATIC) {
            method = Scalr.determineScalingMethod(n2, n3, f2);
        }
        if (DEBUG) {
            Scalr.log(1, "Using Scaling Method: %s", new Object[]{method});
        }
        if (method == Method.SPEED) {
            bufferedImage2 = Scalr.scaleImage(bufferedImage, n2, n3, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        } else if (method == Method.BALANCED) {
            bufferedImage2 = Scalr.scaleImage(bufferedImage, n2, n3, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        } else if (method == Method.QUALITY || method == Method.ULTRA_QUALITY) {
            if (n2 > n4 || n3 > n5) {
                if (DEBUG) {
                    Scalr.log(1, "QUALITY scale-up, a single BICUBIC scale operation will be used...", new Object[0]);
                }
                bufferedImage2 = Scalr.scaleImage(bufferedImage, n2, n3, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            } else {
                if (DEBUG) {
                    Scalr.log(1, "QUALITY scale-down, incremental scaling will be used...", new Object[0]);
                }
                bufferedImage2 = Scalr.scaleImageIncrementally(bufferedImage, n2, n3, method, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            }
        }
        if (DEBUG) {
            Scalr.log(0, "Resized Image in %d ms", System.currentTimeMillis() - l2);
        }
        if (bufferedImageOpArray != null && bufferedImageOpArray.length > 0) {
            bufferedImage2 = Scalr.apply(bufferedImage2, bufferedImageOpArray);
        }
        return bufferedImage2;
    }

    public static BufferedImage rotate(BufferedImage bufferedImage, Rotation rotation, BufferedImageOp ... bufferedImageOpArray) throws IllegalArgumentException, ImagingOpException {
        long l2 = -1L;
        if (DEBUG) {
            l2 = System.currentTimeMillis();
        }
        if (bufferedImage == null) {
            throw new IllegalArgumentException("src cannot be null");
        }
        if (rotation == null) {
            throw new IllegalArgumentException("rotation cannot be null");
        }
        if (DEBUG) {
            Scalr.log(0, "Rotating Image [%s]...", new Object[]{rotation});
        }
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        AffineTransform affineTransform = new AffineTransform();
        switch (rotation) {
            case CW_90: {
                n2 = bufferedImage.getHeight();
                n3 = bufferedImage.getWidth();
                affineTransform.translate(n2, 0.0);
                affineTransform.quadrantRotate(1);
                break;
            }
            case CW_270: {
                n2 = bufferedImage.getHeight();
                n3 = bufferedImage.getWidth();
                affineTransform.translate(0.0, n3);
                affineTransform.quadrantRotate(3);
                break;
            }
            case CW_180: {
                affineTransform.translate(n2, n3);
                affineTransform.quadrantRotate(2);
                break;
            }
            case FLIP_HORZ: {
                affineTransform.translate(n2, 0.0);
                affineTransform.scale(-1.0, 1.0);
                break;
            }
            case FLIP_VERT: {
                affineTransform.translate(0.0, n3);
                affineTransform.scale(1.0, -1.0);
            }
        }
        BufferedImage bufferedImage2 = Scalr.createOptimalImage(bufferedImage, n2, n3);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage(bufferedImage, affineTransform, null);
        graphics2D.dispose();
        if (DEBUG) {
            Scalr.log(0, "Rotation Applied in %d ms, result [width=%d, height=%d]", System.currentTimeMillis() - l2, bufferedImage2.getWidth(), bufferedImage2.getHeight());
        }
        if (bufferedImageOpArray != null && bufferedImageOpArray.length > 0) {
            bufferedImage2 = Scalr.apply(bufferedImage2, bufferedImageOpArray);
        }
        return bufferedImage2;
    }

    protected static void log(int n2, String string, Object ... objectArray) {
        if (DEBUG) {
            System.out.print(LOG_PREFIX);
            int n3 = 0;
            while (n3 < n2) {
                System.out.print("\t");
                ++n3;
            }
            System.out.printf(string, objectArray);
            System.out.println();
        }
    }

    protected static BufferedImage createOptimalImage(BufferedImage bufferedImage) {
        return Scalr.createOptimalImage(bufferedImage, bufferedImage.getWidth(), bufferedImage.getHeight());
    }

    protected static BufferedImage createOptimalImage(BufferedImage bufferedImage, int n2, int n3) throws IllegalArgumentException {
        if (n2 <= 0 || n3 <= 0) {
            throw new IllegalArgumentException("width [" + n2 + "] and height [" + n3 + "] must be > 0");
        }
        return new BufferedImage(n2, n3, bufferedImage.getTransparency() == 1 ? 1 : 2);
    }

    protected static BufferedImage copyToOptimalImage(BufferedImage bufferedImage) throws IllegalArgumentException {
        if (bufferedImage == null) {
            throw new IllegalArgumentException("src cannot be null");
        }
        int n2 = bufferedImage.getTransparency() == 1 ? 1 : 2;
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), n2);
        Graphics graphics = bufferedImage2.getGraphics();
        graphics.drawImage(bufferedImage, 0, 0, null);
        graphics.dispose();
        return bufferedImage2;
    }

    protected static Method determineScalingMethod(int n2, int n3, float f2) {
        int n4 = f2 <= 1.0f ? n2 : n3;
        Method method = Method.SPEED;
        if (n4 <= 800) {
            method = Method.QUALITY;
        } else if (n4 <= 1600) {
            method = Method.BALANCED;
        }
        if (DEBUG) {
            Scalr.log(2, "AUTOMATIC scaling method selected: %s", method.name());
        }
        return method;
    }

    protected static BufferedImage scaleImage(BufferedImage bufferedImage, int n2, int n3, Object object) {
        BufferedImage bufferedImage2 = Scalr.createOptimalImage(bufferedImage, n2, n3);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, object);
        graphics2D.drawImage(bufferedImage, 0, 0, n2, n3, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    protected static BufferedImage scaleImageIncrementally(BufferedImage bufferedImage, int n2, int n3, Method method, Object object) {
        boolean bl = false;
        int n4 = 0;
        int n5 = bufferedImage.getWidth();
        int n6 = bufferedImage.getHeight();
        int n7 = method == Method.ULTRA_QUALITY ? 7 : 2;
        do {
            int n8 = n5;
            int n9 = n6;
            if (n5 > n2 && (n5 -= n5 / n7) < n2) {
                n5 = n2;
            }
            if (n6 > n3 && (n6 -= n6 / n7) < n3) {
                n6 = n3;
            }
            if (n8 == n5 && n9 == n6) break;
            if (DEBUG) {
                Scalr.log(2, "Scaling from [%d x %d] to [%d x %d]", n8, n9, n5, n6);
            }
            BufferedImage bufferedImage2 = Scalr.scaleImage(bufferedImage, n5, n6, object);
            if (bl) {
                bufferedImage.flush();
            }
            bufferedImage = bufferedImage2;
            bl = true;
            ++n4;
        } while (n5 != n2 || n6 != n3);
        if (DEBUG) {
            Scalr.log(2, "Incrementally Scaled Image in %d steps.", n4);
        }
        return bufferedImage;
    }

    public static enum Method {
        AUTOMATIC,
        SPEED,
        BALANCED,
        QUALITY,
        ULTRA_QUALITY;

    }

    public static enum Mode {
        AUTOMATIC,
        FIT_EXACT,
        BEST_FIT_BOTH,
        FIT_TO_WIDTH,
        FIT_TO_HEIGHT;

    }

    public static enum Rotation {
        CW_90,
        CW_180,
        CW_270,
        FLIP_HORZ,
        FLIP_VERT;

    }
}

