/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.base.he;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.he.AbstractMailHelper;
import ch.ionesoft.ilp.base.he.MailHelper;
import ch.ionesoft.ilp.base.he.SendMailException;
import org.apache.commons.mail.EmailAttachment;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;

public class SMTPMailHelper
extends AbstractMailHelper {
    private static ILogger logger = ILPLogManager.getLogger(SMTPMailHelper.class);
    private String mailserver;
    private String username;
    private String password;
    private int port;
    private String sender;
    private boolean debug = false;

    public SMTPMailHelper(String string, int n2, String string2, String string3, String string4) {
        this.mailserver = string;
        this.port = n2;
        this.username = string2;
        this.password = string3;
        this.sender = string4;
    }

    @Override
    public void sendMail_subject_toRecipients_ccRecipients_attachmentPath(String string, String string2, String[] stringArray, String[] stringArray2, String string3, boolean bl) throws SendMailException {
        MailHelper.Attachment attachment = new MailHelper.Attachment("", string3);
        this.sendMail_subject_toRecipients_ccRecipients_attachments(string, string2, stringArray, stringArray2, new MailHelper.Attachment[]{attachment});
    }

    @Override
    public void sendMail_subject_toRecipients_ccRecipients_attachmentPath(String string, String string2, String[] stringArray, String[] stringArray2, String string3) throws SendMailException {
        this.sendMail_subject_toRecipients_ccRecipients_attachmentPath(string, string2, stringArray, stringArray2, string3, false);
    }

    @Override
    public void sendMail_subject_toRecipients_ccRecipients_attachments(String string, String string2, String[] stringArray, String[] stringArray2, MailHelper.Attachment[] attachmentArray) throws SendMailException {
        try {
            HtmlEmail htmlEmail = this.createMail(string, string2, stringArray, stringArray2);
            MailHelper.Attachment[] attachmentArray2 = attachmentArray;
            int n2 = attachmentArray.length;
            int n3 = 0;
            while (n3 < n2) {
                MailHelper.Attachment attachment = attachmentArray2[n3];
                EmailAttachment emailAttachment = new EmailAttachment();
                emailAttachment.setName(attachment.getName());
                emailAttachment.setPath(attachment.getPath());
                htmlEmail.attach(emailAttachment);
                ++n3;
            }
            htmlEmail.setDebug(this.debug);
            htmlEmail.send();
        }
        catch (Exception exception) {
            logger.d("Could not send mail: " + exception.getMessage());
            throw new SendMailException("Could not send email with subject: " + string2, exception);
        }
    }

    public HtmlEmail createMail(String string, String string2, String[] stringArray, String[] stringArray2) throws EmailException {
        HtmlEmail htmlEmail = new HtmlEmail();
        htmlEmail.setHostName(this.mailserver);
        htmlEmail.setAuthentication(this.username, this.password);
        htmlEmail.setSmtpPort(this.port);
        htmlEmail.setFrom(this.sender);
        int n2 = 0;
        while (n2 < stringArray.length) {
            htmlEmail.addTo(stringArray[n2]);
            ++n2;
        }
        n2 = 0;
        while (n2 < stringArray2.length) {
            htmlEmail.addCc(stringArray2[n2]);
            ++n2;
        }
        htmlEmail.setSubject(string2);
        htmlEmail.setHtmlMsg(string);
        return htmlEmail;
    }

    @Override
    public void sendMail_subject_toRecipient(String string, String string2, String string3, boolean bl) throws SendMailException {
        this.sendMail_subject_toRecipients_ccRecipients_attachmentPath(string, string2, new String[]{string3}, new String[0], null, bl);
    }

    @Override
    public void sendMail_subject_toRecipient(String string, String string2, String string3) throws SendMailException {
        this.sendMail_subject_toRecipients_ccRecipients_attachmentPath(string, string2, new String[]{string3}, new String[0], null);
    }

    @Override
    public void sendMail_subject(String string, String string2) {
        throw new UnsupportedOperationException("Cannot send Mail without recipient using a mail server");
    }

    @Override
    public void sendMail_subject(String string, String string2, boolean bl) throws SendMailException {
        throw new UnsupportedOperationException("Cannot send SMTPMail with eml yet");
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }
}

