/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.base.he;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.fo.b;
import ch.ionesoft.ilp.base.fo.g;
import ch.ionesoft.ilp.base.fo.z;
import ch.ionesoft.ilp.base.he.ConverterUtil;
import ch.ionesoft.ilp.base.he.ILPFilePickerContext;
import ch.ionesoft.ilp.base.he.StringHelper;
import ch.ionesoft.ilp.base.he.SystemHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Date;

public abstract class ResourceHelper {
    private static ILogger logger = ILPLogManager.getLogger(ResourceHelper.class);
    protected static final int kReadTimeoutSecs = 5;
    protected static final long NETWORKCHECK_GRACE_PERIOD_MS = 10000L;
    protected Date lastNetworkCheck = null;
    protected boolean lastNetworkCheckResult;

    public abstract Object loadBundleImageNamed(String var1);

    public abstract Object loadImageFromPath(String var1);

    public abstract Object loadImageFromData(byte[] var1);

    public abstract z loadFullsizeImageFromPath(String var1);

    public abstract z loadThumbnailImageFromPath(String var1);

    public abstract String platformImageURI(String var1);

    public abstract String platformImageKey(String var1);

    public abstract z loadImageWithUrl(URL var1);

    public abstract boolean copyItemfromBundleUrl_toTargetPath(String var1, File var2);

    public abstract boolean copyItemfromBundle_resourcePath_toTargetPath(String var1, String var2, File var3);

    public abstract URL resolveBundleResource(String var1);

    public abstract URL resolveBundleResource(String var1, String var2);

    public abstract String contentOfBundleResource(String var1);

    public abstract String contentOfBundleResource(String var1, String var2);

    public abstract InputStream streamForBundleResource(String var1) throws IOException;

    public abstract InputStream streamForBundleResource(String var1, String var2) throws IOException;

    public abstract boolean copyResource_toTargetPath(g var1, File var2);

    public abstract boolean openURLExternally(URL var1);

    public abstract boolean openURIExternally(URI var1);

    public boolean openURLStringExternally(String string) {
        if (string == null) {
            return false;
        }
        try {
            if (string.startsWith("http")) {
                URL uRL = new URL(string);
                return this.openURLExternally(uRL);
            }
            File file = new File(string);
            return this.openFileExternally(file);
        }
        catch (Exception exception) {
            logger.d("Could not load urlString externally: " + StringHelper.removeURLParams(string), exception);
            return false;
        }
    }

    public abstract boolean openFileExternally(File var1);

    public abstract void downloadAndOpenUrlOfResource(Object var1);

    public abstract void copyToClipboard(String var1);

    public abstract void copyImageToClipboard(URL var1);

    public abstract void copyImageToClipboard(z var1);

    public abstract void synchExecute(Runnable var1);

    public abstract z createUIImage();

    public abstract void disposeImage(Object var1);

    public abstract b imageSize(Object var1);

    public abstract byte[] resizeFitHeight(byte[] var1, String var2, int var3);

    public abstract String getDeviceSerial();

    public boolean isExternalDocumentLink(String string) {
        String string2 = ConverterUtil.mimeTypeForFilename(string);
        return string.toLowerCase().endsWith("doc") || string.toLowerCase().endsWith("docx") || string.toLowerCase().endsWith("dot") || string.toLowerCase().endsWith("dotx") || string.toLowerCase().endsWith("xls") || string.toLowerCase().endsWith("xlsx") || string.toLowerCase().endsWith("xlt") || string.toLowerCase().endsWith("xltx") || string.toLowerCase().endsWith("ppt") || string.toLowerCase().endsWith("pptx") || string.toLowerCase().endsWith("pdf") || string.toLowerCase().endsWith("pot") || string.toLowerCase().endsWith("pst") || string.toLowerCase().endsWith("properties") || string.toLowerCase().endsWith("strings") || string.toLowerCase().endsWith("odt") || string.toLowerCase().endsWith("ost") || string.toLowerCase().endsWith("ott") || string.toLowerCase().endsWith("mm") || string.toLowerCase().endsWith("xml") || SystemHelper.isAudioFormat(string2) || SystemHelper.isVideoFormat(string2);
    }

    public abstract void pickFileWithFilePickerContext(ILPFilePickerContext var1);

    public abstract void pickFileWithFilePickerContext(String[] var1, String[] var2, ILPFilePickerContext var3);

    public abstract void pickFolderWithFilePickerContext(ILPFilePickerContext var1);

    public abstract String pickFile();

    public abstract boolean networkAvailable(boolean var1);

    public abstract void logSignalStrength();

    public abstract void uploadExchangeFileToUserCloud(File var1, ILPFileExchangeUploadCallback var2);

    public abstract void downloadExchangeFile(URL var1, File var2, Abortable var3);

    public abstract void resizeImage(File var1, File var2, float var3, Float var4) throws IOException;

    public abstract byte[] base64Decode(String var1);

    public abstract String base64EncodeAsString(byte[] var1);

    protected boolean hasValidLastNetworkCheck() {
        Date date = new Date();
        return this.lastNetworkCheck != null && date.getTime() < this.lastNetworkCheck.getTime() + 10000L;
    }

    protected synchronized boolean updateLastNetworkCheck(boolean bl) {
        this.lastNetworkCheck = new Date();
        this.lastNetworkCheckResult = bl;
        return bl;
    }

    public abstract File readImageFromClipboard();

    public abstract String readTextFromClipboard(boolean var1);

    public static interface Abortable {
        public void abort();

        public void failed();

        public void successful();

        public void reset();
    }

    public static interface ILPFileExchangeUploadCallback {
        public void finished();

        public void canceled();
    }
}

