/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.base.he;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.co.g;
import ch.ionesoft.ilp.base.he.Base64Util;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.ProxySelector;
import java.net.URLConnection;
import java.nio.charset.Charset;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.ProxySelectorRoutePlanner;

public class ProxyConfigurator {
    private static ILogger logger = ILPLogManager.getLogger(ProxyConfigurator.class);

    public String getProxyHttpUsername() {
        return g.a().D();
    }

    public String getProxyHttpPassword() {
        return g.a().E();
    }

    public String getProxySocksUsername() {
        return g.a().J();
    }

    public String getProxySocksPassword() {
        return g.a().K();
    }

    public ProxySelector getProxySelector() {
        return ProxySelector.getDefault();
    }

    public void configureSystemProperties() {
        if (g.a().z().booleanValue()) {
            System.setProperty("java.net.useSystemProxies", "true");
            return;
        }
        System.setProperty("java.net.useSystemProxies", "false");
        System.getProperties().put("proxySet", "false");
        if (g.a().A()) {
            try {
                if (g.a().B() != null && !g.a().B().equals(System.getProperty("http.proxyHost")) || g.a().C() != null && !g.a().C().equals(System.getProperty("http.proxyPort"))) {
                    logger.b("Setting proxyHost: " + g.a().B() + ", proxyPort: " + g.a().C() + ", proxyUsername: " + g.a().D());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.getProperties().put("proxySet", "true");
            System.setProperty("jdk.http.auth.tunneling.disabledSchemes", "");
            System.setProperty("http.proxyHost", g.a().B());
            System.setProperty("http.proxyPort", g.a().C());
            System.setProperty("https.proxyHost", g.a().B());
            System.setProperty("https.proxyPort", g.a().C());
            if (g.a().F()) {
                Authenticator.setDefault(new ProxyAuth(g.a().D(), g.a().E()));
            }
        } else {
            System.setProperty("http.proxyHost", "");
            System.setProperty("http.proxyPort", "");
            System.setProperty("https.proxyHost", "");
            System.setProperty("https.proxyPort", "");
        }
        if (g.a().G()) {
            logger.b("Setting socksProxyHost: " + g.a().H() + ", socksProxyPort: " + g.a().I());
            System.getProperties().put("proxySet", "true");
            System.setProperty("socksProxyHost", g.a().H());
            System.setProperty("socksProxyPort", g.a().I());
            if (g.a().L()) {
                System.setProperty("java.net.socks.username", g.a().J());
                System.setProperty("java.net.socks.password", g.a().K());
                Authenticator.setDefault(new ProxyAuth(g.a().J(), g.a().K()));
            }
        } else {
            System.setProperty("socksProxyHost", "");
            System.setProperty("socksProxyPort", "");
            System.setProperty("java.net.socks.username", "");
            System.setProperty("java.net.socks.password", "");
        }
    }

    public void setProxy(URLConnection uRLConnection) {
        this.configureSystemProperties();
        if (g.a().A() && g.a().F()) {
            String string = Base64Util.encodeBase64(String.valueOf(g.a().D()) + ":" + g.a().E(), Charset.forName("US-ASCII"));
            if (uRLConnection != null) {
                uRLConnection.setRequestProperty("Proxy-Authorization", "Basic " + string);
            }
        }
    }

    public void setProxy(DefaultHttpClient defaultHttpClient) {
        this.configureSystemProperties();
        if (g.a().A() || g.a().G()) {
            ProxySelectorRoutePlanner proxySelectorRoutePlanner = new ProxySelectorRoutePlanner(defaultHttpClient.getConnectionManager().getSchemeRegistry(), ProxySelector.getDefault());
            defaultHttpClient.setRoutePlanner((HttpRoutePlanner)proxySelectorRoutePlanner);
        }
    }

    public class ProxyAuth
    extends Authenticator {
        private PasswordAuthentication auth;

        private ProxyAuth(String string, String string2) {
            this.auth = new PasswordAuthentication(string, string2 == null ? new char[]{} : string2.toCharArray());
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return this.auth;
        }
    }
}

