/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.base.he;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.co.f;
import ch.ionesoft.ilp.base.co.g;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.io.FileUtils;

public class Keychain {
    private static final ILogger logger = ILPLogManager.getLogger(Keychain.class);
    private KeyStore store;
    private char[] masterPassword;
    private File file;
    private boolean reinitDone = false;
    private ConcurrentHashMap<String, String> keystoreCache = new ConcurrentHashMap();
    private List<KeyStoreEntry> pendingEntries = Collections.synchronizedList(new ArrayList());

    public Keychain(char[] cArray, File file) throws IOException {
        this.init(cArray, file);
    }

    public Keychain(char[] cArray, InputStream inputStream) throws IOException {
        this.init(cArray, inputStream);
    }

    public static Keychain configureKeychain(File file, String string) {
        char[] cArray = g.a().w(string).toCharArray();
        File file2 = new File(file, string);
        Keychain keychain = null;
        try {
            keychain = new Keychain(cArray, file2);
        }
        catch (IOException iOException) {
            logger.c("Could not open keychain file: " + string + ". Trying to restore backup .... Reason: " + iOException.getMessage());
            Keychain.restoreBackupInto(file2);
            try {
                keychain = new Keychain(cArray, file2);
            }
            catch (IOException iOException2) {
                logger.c("Could not open keychain for file: " + string, iOException2);
                try {
                    logger.b("Reinit of keyStore");
                    file2.delete();
                    keychain = new Keychain(cArray, file2);
                }
                catch (IOException iOException3) {
                    logger.d("Could not reinit keychain for file: " + string, iOException3);
                    f.b().D().displayWarningCode("message.internalError", new Object[0]);
                }
            }
        }
        return keychain;
    }

    private void init(char[] cArray, File file) throws FileNotFoundException, IOException {
        this.file = file;
        logger.b("Init keychain: " + file + ", size: " + file.length());
        FileInputStream fileInputStream = this.openKeystoreFile(file);
        this.init(cArray, fileInputStream);
    }

    /*
     * Exception decompiling
     */
    protected void init(char[] var1_1, InputStream var2_2) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void reinitKeystore() throws FileNotFoundException, IOException {
        logger.b("Reinitializing keystore: " + this.file);
        this.file.delete();
        this.init(this.masterPassword, this.file);
    }

    private static File backupFilePath(File file) {
        return new File(String.valueOf(file.getAbsolutePath()) + ".bak");
    }

    private synchronized void createBackup() {
        File file = Keychain.backupFilePath(this.file);
        logger.a("Creating a backup file of current keychain into: " + file);
        try {
            FileUtils.copyFile((File)this.file, (File)file);
        }
        catch (IOException iOException) {
            logger.d("Could not create a backupFile into: " + file, iOException);
        }
    }

    private static void restoreBackupInto(File file) {
        File file2 = Keychain.backupFilePath(file);
        if (file2.exists()) {
            logger.b("Restoring keychain backup from: " + file2);
            try {
                FileUtils.copyFile((File)file2, (File)file);
            }
            catch (IOException iOException) {
                logger.d("Could not restore keychain backupFile: " + file2, iOException);
            }
        } else {
            logger.c("Could not restore keychain backupfile since it does not exist: " + file2);
        }
    }

    private FileInputStream openKeystoreFile(File file) throws IOException, FileNotFoundException {
        FileInputStream fileInputStream;
        if (!file.exists()) {
            logger.b("Creating new keychain");
            file.getParentFile().mkdirs();
            file.createNewFile();
            fileInputStream = null;
        } else {
            fileInputStream = new FileInputStream(file);
        }
        return fileInputStream;
    }

    public String getPassword(String string, String string2) {
        KeyStore.SecretKeyEntry secretKeyEntry;
        String string3;
        String string4;
        block7: {
            string4 = this.keyForUserService(string, string2);
            string3 = this.keystoreCache.get(string4);
            if (string3 != null) {
                return string3;
            }
            KeyStore.PasswordProtection passwordProtection = new KeyStore.PasswordProtection(this.masterPassword);
            secretKeyEntry = (KeyStore.SecretKeyEntry)this.store.getEntry(string4, passwordProtection);
            if (secretKeyEntry != null) break block7;
            return null;
        }
        try {
            string3 = new String(secretKeyEntry.getSecretKey().getEncoded());
            if (string4 != null && string3 != null) {
                this.keystoreCache.put(string4, string3);
            }
            return string3;
        }
        catch (KeyStoreException keyStoreException) {
            logger.c("Cannot read entry in KeyStore at " + this.file + ": " + keyStoreException.getMessage());
        }
        catch (UnrecoverableEntryException unrecoverableEntryException) {
            logger.c("Cannot recover entry in KeyStore: " + unrecoverableEntryException.getLocalizedMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            logger.c("Cannot decrypt KeyStore: " + noSuchAlgorithmException.getMessage());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPassword(String string, String string2, char[] cArray) {
        if (cArray.length == 0) {
            logger.c("Empty key to add for user: " + string + ". Ignoring.");
            return;
        }
        List<KeyStoreEntry> list = this.pendingEntries;
        synchronized (list) {
            String string3 = this.keyForUserService(string, string2);
            this.keystoreCache.put(string3, String.valueOf(cArray));
            this.pendingEntries.add(new KeyStoreEntry(string2, string, cArray));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePassword(String string, String string2) {
        String string3 = this.keyForUserService(string, string2);
        List<KeyStoreEntry> list = this.pendingEntries;
        synchronized (list) {
            this.keystoreCache.remove(string3);
            this.pendingEntries.remove(new KeyStoreEntry(string2, string, null));
            try {
                if (this.store.isKeyEntry(string3)) {
                    this.store.deleteEntry(string3);
                }
            }
            catch (KeyStoreException keyStoreException) {
                logger.c("Cannot remove entry (User: " + string + ", service: " + string2 + ") in KeyStore: " + this.file, keyStoreException);
            }
        }
    }

    protected String keyForUserService(String string, String string2) {
        return String.valueOf(string) + "@" + string2;
    }

    private void store(OutputStream outputStream) throws IOException {
        try {
            this.store.store(outputStream, this.masterPassword);
        }
        catch (KeyStoreException keyStoreException) {
            logger.c("Cannot store KeyStore: " + keyStoreException);
            this.reinitKeystore();
        }
        catch (CertificateException certificateException) {
            logger.c("Error in certificate to write KeyStore: " + certificateException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            logger.c("Cannot encrypt KeyStore: " + noSuchAlgorithmException);
        }
    }

    public KeyStore getStore() {
        return this.store;
    }

    public void store() throws IOException {
        if (this.file == null) {
            throw new IOException("No file defined");
        }
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List list = Keychain.this.pendingEntries;
                synchronized (list) {
                    Object object;
                    logger.a("Start storing " + Keychain.this.pendingEntries.size() + " entries into keystore");
                    Iterator iterator = Keychain.this.pendingEntries.iterator();
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    while (iterator.hasNext()) {
                        object = (KeyStoreEntry)iterator.next();
                        char[] cArray = ((KeyStoreEntry)object).password;
                        String string = ((KeyStoreEntry)object).user;
                        String string2 = ((KeyStoreEntry)object).service;
                        String string3 = Keychain.this.keyForUserService(string, string2);
                        try {
                            Object object2;
                            Object object3;
                            try {
                                String string4 = new String(cArray);
                                object3 = new SecretKeySpec(string4.getBytes(), "JCEKS");
                                object2 = new KeyStore.SecretKeyEntry((SecretKey)object3);
                                Keychain.this.store.setEntry(string3, (KeyStore.Entry)object2, new KeyStore.PasswordProtection(Keychain.this.masterPassword));
                            }
                            catch (KeyStoreException keyStoreException) {
                                logger.c("Cannot create entry (User: " + string + ", service: " + string2 + ") in KeyStore: " + keyStoreException);
                                try {
                                    if (!Keychain.this.reinitDone) {
                                        Keychain.this.reinitDone = true;
                                        Keychain.this.reinitKeystore();
                                        object3 = new String(cArray);
                                        object2 = new SecretKeySpec(((String)object3).getBytes(), "JCEKS");
                                        KeyStore.SecretKeyEntry secretKeyEntry = new KeyStore.SecretKeyEntry((SecretKey)object2);
                                        Keychain.this.store.setEntry(string3, secretKeyEntry, new KeyStore.PasswordProtection(Keychain.this.masterPassword));
                                    }
                                }
                                catch (Exception exception) {
                                    logger.d("Could not reinit keystore", exception);
                                }
                                arrayList.add(object);
                                continue;
                            }
                        }
                        catch (Throwable throwable) {
                            arrayList.add(object);
                            throw throwable;
                        }
                        arrayList.add(object);
                    }
                    Keychain.this.pendingEntries.removeAll(arrayList);
                    try {
                        object = new FileOutputStream(Keychain.this.file);
                        Keychain.this.store((OutputStream)object);
                        ((OutputStream)object).close();
                        logger.a("Keychain stored");
                        Keychain.this.createBackup();
                    }
                    catch (Exception exception) {
                        logger.d("Could not store keystore, reason: " + exception);
                    }
                }
            }
        });
        thread.start();
    }

    private class KeyStoreEntry {
        public String service;
        public String user;
        public char[] password;

        public KeyStoreEntry(String string, String string2, char[] cArray) {
            this.service = string;
            this.user = string2;
            this.password = cArray;
        }

        public int hashCode() {
            int n2 = 31;
            int n3 = 1;
            n3 = 31 * n3 + this.getOuterType().hashCode();
            n3 = 31 * n3 + (this.service == null ? 0 : this.service.hashCode());
            n3 = 31 * n3 + (this.user == null ? 0 : this.user.hashCode());
            return n3;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            KeyStoreEntry keyStoreEntry = (KeyStoreEntry)object;
            if (!this.getOuterType().equals(keyStoreEntry.getOuterType())) {
                return false;
            }
            if (this.service == null ? keyStoreEntry.service != null : !this.service.equals(keyStoreEntry.service)) {
                return false;
            }
            return !(this.user == null ? keyStoreEntry.user != null : !this.user.equals(keyStoreEntry.user));
        }

        private Keychain getOuterType() {
            return Keychain.this;
        }
    }
}

