/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.base.he;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.SystemUtils;

public class JustOneLock {
    private static ILogger logger = ILPLogManager.getLogger(JustOneLock.class);
    private File file;
    private FileChannel channel;
    private FileLock lock;

    public JustOneLock(File file) {
        this.file = file;
    }

    public boolean isAppActive() {
        block11: {
            try {
                File file = this.file.getParentFile();
                if (!file.exists()) {
                    file.mkdirs();
                }
                try {
                    if (SystemUtils.IS_OS_WINDOWS && this.file.exists()) {
                        logger.b("Lock file exists, deleting");
                        FileUtils.deleteQuietly((File)this.file);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.channel = new RandomAccessFile(this.file, "rw").getChannel();
                try {
                    logger.b("Created lock file: " + this.channel.isOpen() + ", trying to aquire lock ...");
                    this.lock = this.channel.tryLock();
                    logger.b("Lock aquired, workspace is unused");
                }
                catch (Throwable throwable) {
                    logger.c("Could not lock workspace: " + throwable.getMessage());
                    this.closeLock();
                    this.deleteFile();
                    return true;
                }
            }
            catch (Exception exception) {
                logger.c("Could not lock workspace: " + exception.getMessage(), exception);
                this.closeLock();
                this.deleteFile();
                return true;
            }
            if (this.lock != null) break block11;
            logger.c("Could not lock workspace, lock is null");
            this.closeLock();
            if (SystemUtils.IS_OS_WINDOWS) {
                this.deleteFile();
            }
            return true;
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                JustOneLock.this.closeLock();
                JustOneLock.this.deleteFile();
            }
        });
        return false;
    }

    private void closeLock() {
        try {
            this.lock.release();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.channel.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void deleteFile() {
        try {
            this.file.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

